FUNCTION ValFile
PARAMETERS pcName, pnErrNo
*----------------------------------------------------------------------------
* NAME
*   ValFile() - Vaidate a file name
*
* PARAMETERS
*   pcName     = Name of the file
*   pnErrNo    = Return the error number, 0 if OK, 1 - doesn't exist, ...
*
*----------------------------------------------------------------------------
    PRIVATE lOk, fh, cErrMsg, lVoid

    lOk = .T.
    IF AT( " ", LTRIM( TRIM( pcName ) ) ) > 0
        lOk = .F.
        pnErrNo = 1049
        RETURN ( lOk )
    ENDIF
    fh = 0   
    ON ERROR lOk = .F.
    fh = FOPEN( pcName )
    cErrMsg = MESSAGE()
    pnErrNo = ERROR()
    ON ERROR
    IF fh > 0
        lVoid = FCLOSE( fh )
    ENDIF
    IF pnErrNo = 1                      && File not found!
        *----------------------------
        *-- Check for real file names
        *----------------------------
        DO CASE
            CASE SPACE(1) $ LTRIM( TRIM( pcName ) )
                pnErrNo = 1049

            CASE ISBLANK( FileRoot( pcName ) )
                pnErrNo = 1049

            CASE pcName = [<Empty>]
                pnErrNo = 1049

            OTHERWISE
                *-----------------------------------------
                *-- Check to see if we can create the file
                *-- If not, the file name is bogus
                *-----------------------------------------
                lOk = .T.
                ON ERROR lOk = .F.
                fh = FCREATE( pcName )
                cErrMsg = MESSAGE()
                pnErrNo = ERROR()
                ON ERROR
                IF fh > 0
                    lVoid = FCLOSE( fh )
                    ERASE ( pcName )
                    pnErrNo = 1
                    lOk = .F.
                ELSE
                    pnErrNo = 1049
                ENDIF
        ENDCASE
    ELSE
        IF pnErrNo > 1
            lOk = .F.
        ENDIF
    ENDIF


RETURN ( lOk )

*-- EOF: ValFile( pcName )

