*.............................................................................
*
*   Program Name: PUZZLE.PRG          Copyright: Borland International
*   Date Created: 04/29/94            Language: dBASE 5.0
*   Time Created: 10:45:31
*.............................................................................

#define ALLTRIM(kStr) LTRIM(RTRIM(kStr))

#define kbDown  20480
#define kbLeft  19200
#define kbRight 19712
#define kbUp    18432

#define kBell CHR(7)

*.................................................
* Procedure Name:   Puzzle
* Parameters:       None
* Ext Memvars:      None
* Description:      Main procedure for program
*.................................................
PROCEDURE Puzzle
    PRIVATE lVoid

    SET TALK OFF

    IF TYPE("Puzzle.ClassName") # "C"
        DO InitPuzz
    ENDIF

    IF TYPE("aTile[16,4]") # "N"
        RELEASE aTile
        PUBLIC ARRAY aTile[16,4]
        DO InitAray
    ENDIF

    lVoid = Puzzle.Open()
RETURN


*............................................................................
* Procedure Name:   PrKey
* Parameters:       None
* Ext Memvars:      Puzzle
* Description:      Checks to see if a valid arrow key was pressed.  If so,
*                   calls procedure to move the tile.
*............................................................................
PROCEDURE PrKey
    PRIVATE nKey, nEmp

    nKey  = event.KeyValue
    nEmp  = GetEmpty()

    IF Puzzle.lPlay
        DO CASE
            CASE nKey = kbUp
                IF nEmp < 13
                    DO MoveTile WITH nEmp + 4, nEmp
                ELSE
                    ?? kBell
                ENDIF
            CASE nKey = kbDown
                IF nEmp > 4
                    DO MoveTile WITH nEmp - 4, nEmp
                ELSE
                    ?? kBell
                ENDIF
            CASE nKey = kbRight
                IF (nEmp # 1) .AND. (nEmp # 5) .AND. (nEmp # 9) .AND. (nEmp # 13)
                    DO MoveTile WITH nEmp - 1, nEmp
                ELSE
                    ?? kBell
                ENDIF
            CASE nKey = kbLeft
                IF (nEmp # 4) .AND. (nEmp # 8) .AND. (nEmp # 12) .AND. (nEmp # 16)
                    DO MoveTile WITH nEmp + 1, nEmp
                ELSE
                    ?? kBell
                ENDIF
        ENDCASE
    ENDIF
RETURN


*............................................................................
* Procedure Name:   PrClick
* Parameters:       None
* Ext Memvars:      Puzzle
* Return Value:     .F.
* Description:      Checks to see if mouse click was made on a valid tile.
*                   If so, calls procedure to move the tile.
*............................................................................
PROCEDURE PrClick
    PRIVATE nEmp, nCol, nRow, nTile

    nCol = event.MouseColumn
    nRow = event.MouseRow

    nTile = 0
    nEmp  = GetEmpty()

    IF Puzzle.lPlay
        DO CASE
            CASE (nRow >= 2) .AND. (nRow <= 4)
                DO CASE
                    CASE (nCol >=  2) .AND. (nCol <=  7)
                        nTile = 1
                    CASE (nCol >=  8) .AND. (nCol <= 13)
                        nTile = 2
                    CASE (nCol >= 14) .AND. (nCol <= 19)
                        nTile = 3
                    CASE (nCol >= 20) .AND. (nCol <= 25)
                        nTile = 4
                ENDCASE
            CASE (nRow >= 5) .AND. (nRow <= 7)
                DO CASE
                    CASE (nCol >=  2) .AND. (nCol <=  7)
                        nTile = 5
                    CASE (nCol >=  8) .AND. (nCol <= 13)
                        nTile = 6
                    CASE (nCol >= 14) .AND. (nCol <= 19)
                        nTile = 7
                    CASE (nCol >= 20) .AND. (nCol <= 25)
                        nTile = 8
                ENDCASE
            CASE (nRow >= 8) .AND. (nRow <= 10)
                DO CASE
                    CASE (nCol >=  2) .AND. (nCol <=  7)
                        nTile = 9
                    CASE (nCol >=  8) .AND. (nCol <= 13)
                        nTile = 10
                    CASE (nCol >= 14) .AND. (nCol <= 19)
                        nTile = 11
                    CASE (nCol >= 20) .AND. (nCol <= 25)
                        nTile = 12
                ENDCASE
            CASE (nRow >= 11) .AND. (nRow <= 13)
                DO CASE
                    CASE (nCol >=  2) .AND. (nCol <=  7)
                        nTile = 13
                    CASE (nCol >=  8) .AND. (nCol <= 13)
                        nTile = 14
                    CASE (nCol >= 14) .AND. (nCol <= 19)
                        nTile = 15
                    CASE (nCol >= 20) .AND. (nCol <= 25)
                        nTile = 16
                ENDCASE
        ENDCASE

        IF nEmp > 0
            IF (nEmp = nTile - 1) .OR. (nEmp = nTile + 1) .OR. (nEmp = nTile - 4) .OR. (nEmp = nTile + 4)
                DO MoveTile WITH nTile, nEmp
            ENDIF
        ENDIF
    ENDIF

    event.eventType = 0     && always eat the mouse event

RETURN


*............................................................
* Procedure Name:   MoveTile
* Parameters:       Tile to move, Empty tile
* Ext Memvars:      Puzzle
* Description:      Moves the <Tile to move> to <Empty tile>
*............................................................
PROCEDURE MoveTile
PARAMETERS n, nEmp
    PRIVATE oRef

    IF TYPE("aTile[n,1]") = "O"
        aTile[nEmp,1] = aTile[n,1]
        aTile[nEmp,2] = aTile[n,2]
        aTile[n,1] = .F.
        aTile[n,2] = .F.

        Puzzle.Draw = .F.

        oRef      = aTile[nEmp,1]
        oRef.Left = aTile[nEmp,3]
        oRef.Top  = aTile[nEmp,4]

        oRef      = aTile[nEmp,2]
        oRef.Left = aTile[nEmp,3] + 2
        oRef.Top  = aTile[nEmp,4] + 1

        Puzzle.Draw = .T.

        Puzzle.nMoves = Puzzle.nMoves + 1
        Puzzle.Tc.Text = TRANSFORM(Puzzle.nMoves, "9,999")

        IF ChkDone()
            DO UWon
            SET TALK OFF
        ENDIF
    ENDIF
RETURN


*............................................................................
* Function Name:    ChkDone
* Parameters:       None
* Ext Memvars:      None
* Return Value:     logical, .T. if puzzle complete, .F. otherwise
* Description:      checks to see if all tiles are in the right order
*............................................................................
FUNCTION ChkDone
    PRIVATE lRet, i, cStr, oRef

    lRet = .T.

    FOR i = 1 TO 16
        oRef = aTile[i,1]
        IF TYPE("oRef.ClassName") = "C"
            cStr = ALLTRIM(oRef.Name) + ""
            cStr = RIGHT(cStr, LEN(cStr) - 1)
            IF VAL(cStr) # i
                lRet = .F.
                EXIT
            ENDIF
        ENDIF
    ENDFOR
RETURN lRet


*.................................................
* Procedure Name:   UWon
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays a winning message
*.................................................
PROCEDURE UWon
    PRIVATE lVoid

    SET TALK OFF

    DEFINE FORM UWon;
        PROPERTY ;
            HEIGHT   9,;
            LEFT    22,;
            TEXT   "Winner",;
            TOP      6,;
            WIDTH   28

    DEFINE TEXT T1 OF UWon;
        PROPERTY ;
            LABEL .F.,;
            LEFT   5,;
            TEXT  "Congratulations!",;
            TOP    1

    DEFINE TEXT T2 OF UWon;
        PROPERTY ;
            LABEL .F.,;
            LEFT   1,;
            TEXT  "You completed the puzzle",;
            TOP    3

    DEFINE PUSHBUTTON B OF UWON;
        PROPERTY ;
            DEFAULT .T.,;
            LEFT      8,;
            ONCLICK  PrOK,;
            TEXT    "&OK",;
            TOP       5,;
            WIDTH    10

    lVoid = UWon.ReadModal()
    lVoid = UWon.Release()
    RELEASE UWon

    Puzzle.lPlay = .F.
RETURN


*.................................................
* Procedure Name:   PrOK
* Parameters:       None
* Ext Memvars:      None
* Description:      Button handler for UWon
*.................................................
PROCEDURE PrOK
    PRIVATE lVoid

    lVoid = UWon.Close()
RETURN


*.................................................
* Procedure Name:   Shuffle
* Parameters:       None
* Ext Memvars:      Puzzle
* Description:      Shuffles tiles on Puzzle
*.................................................
PROCEDURE Shuffle
    PRIVATE cRnd, i, n, nLen, nEmp, oRef, lVoid

    cRnd = ALLTRIM(STR(INT(RAND() * 10000000000000000), 16, 0))

    nLen = LEN(cRnd)

    FOR i = 1 TO nLen
        n = VAL(SUBSTR(cRnd, i, 1))
        IF n = 0
            IF (i/2) = (INT(i/2))
                n = 10
            ELSE
                n = 14
            ENDIF
        ENDIF

        nEmp = GetEmpty()
        IF nEmp > 0
            IF TYPE("aTile[n,1]") = "O"
                aTile[nEmp,1] = aTile[n,1]
                aTile[nEmp,2] = aTile[n,2]
                aTile[n,1] = .F.
                aTile[n,2] = .F.
            ENDIF
        ENDIF
    ENDFOR

    Puzzle.Draw = .F.

    FOR i = 1 TO 16
        IF TYPE("aTile[i,1]") = "O"
            oRef      = aTile[i,1]
            oRef.Left = aTile[i,3]
            oRef.Top  = aTile[i,4]

            oRef      = aTile[i,2]
            oRef.Left = aTile[i,3] + 2
            oRef.Top  = aTile[i,4] + 1
        ENDIF
    ENDFOR

    Puzzle.Draw  = .T.
    Puzzle.lPlay = .T.

    Puzzle.nMoves = 0
    Puzzle.Tc.Text = TRANSFORM(0, "9,999")
RETURN


*............................................................................
* Function Name:    GetEmpty
* Parameters:       None
* Ext Memvars:      None
* Return Value:     numeric, number of tile that is currently empty
* Description:      determines which tile is currently empty
*............................................................................
FUNCTION GetEmpty
    PRIVATE nRet, i

    nRet = 0

    FOR i = 1 TO 16
        IF TYPE("aTile[i,1]") = "L"
            nRet = i
            EXIT
        ENDIF
    ENDFOR
RETURN nRet


*...............................................................
* Procedure Name:   InitAray
* Parameters:       None
* Ext Memvars:      None
* Description:      Initializes the global array used by Puzzle
*...............................................................
PROCEDURE InitAray
    PRIVATE i

    aTile[1,1]  = Puzzle.R1
    aTile[2,1]  = Puzzle.R2
    aTile[3,1]  = Puzzle.R3
    aTile[4,1]  = Puzzle.R4
    aTile[5,1]  = Puzzle.R5
    aTile[6,1]  = Puzzle.R6
    aTile[7,1]  = Puzzle.R7
    aTile[8,1]  = Puzzle.R8
    aTile[9,1]  = Puzzle.R9
    aTile[10,1] = Puzzle.R10
    aTile[11,1] = Puzzle.R11
    aTile[12,1] = Puzzle.R12
    aTile[13,1] = Puzzle.R13
    aTile[14,1] = Puzzle.R14
    aTile[15,1] = Puzzle.R15
    aTile[16,1] = .F.

    aTile[1,2]  = Puzzle.T1
    aTile[2,2]  = Puzzle.T2
    aTile[3,2]  = Puzzle.T3
    aTile[4,2]  = Puzzle.T4
    aTile[5,2]  = Puzzle.T5
    aTile[6,2]  = Puzzle.T6
    aTile[7,2]  = Puzzle.T7
    aTile[8,2]  = Puzzle.T8
    aTile[9,2]  = Puzzle.T9
    aTile[10,2] = Puzzle.T10
    aTile[11,2] = Puzzle.T11
    aTile[12,2] = Puzzle.T12
    aTile[13,2] = Puzzle.T13
    aTile[14,2] = Puzzle.T14
    aTile[15,2] = Puzzle.T15
    aTile[16,2] = .F.

    aTile[1,3]  = Puzzle.R1.Left
    aTile[2,3]  = Puzzle.R2.Left
    aTile[3,3]  = Puzzle.R3.Left
    aTile[4,3]  = Puzzle.R4.Left
    aTile[5,3]  = Puzzle.R5.Left
    aTile[6,3]  = Puzzle.R6.Left
    aTile[7,3]  = Puzzle.R7.Left
    aTile[8,3]  = Puzzle.R8.Left
    aTile[9,3]  = Puzzle.R9.Left
    aTile[10,3] = Puzzle.R10.Left
    aTile[11,3] = Puzzle.R11.Left
    aTile[12,3] = Puzzle.R12.Left
    aTile[13,3] = Puzzle.R13.Left
    aTile[14,3] = Puzzle.R14.Left
    aTile[15,3] = Puzzle.R15.Left
    aTile[16,3] = Puzzle.R15.Left + 6

    aTile[1,4]  = Puzzle.R1.Top
    aTile[2,4]  = Puzzle.R2.Top
    aTile[3,4]  = Puzzle.R3.Top
    aTile[4,4]  = Puzzle.R4.Top
    aTile[5,4]  = Puzzle.R5.Top
    aTile[6,4]  = Puzzle.R6.Top
    aTile[7,4]  = Puzzle.R7.Top
    aTile[8,4]  = Puzzle.R8.Top
    aTile[9,4]  = Puzzle.R9.Top
    aTile[10,4] = Puzzle.R10.Top
    aTile[11,4] = Puzzle.R11.Top
    aTile[12,4] = Puzzle.R12.Top
    aTile[13,4] = Puzzle.R13.Top
    aTile[14,4] = Puzzle.R14.Top
    aTile[15,4] = Puzzle.R15.Top
    aTile[16,4] = Puzzle.R15.Top
RETURN


*...................................................................
* Procedure Name:   PuzCls
* Parameters:       None
* Ext Memvars:      Puzzle
* Description:      OnClose handler for Puzzle, releases everything
*...................................................................
PROCEDURE PuzCls
    PRIVATE lVoid

    lVoid = Puzzle.Release()
    RELEASE aTile, Puzzle
RETURN


*........................................................
* Procedure Name:   InitPuzz
* Parameters:       None
* Ext Memvars:      None
* Description:      Defines the puzzle and its resources
*........................................................
PROCEDURE InitPuzz
    DEFINE FORM Puzzle;
        PROPERTY ;
            HEIGHT        19,;
            KEY           PrKey,;
            LEFT           1,;
            ONMOUSEDBLCLK PrClick,;
            ONCLOSE       PuzCls,;
            TOP            1,;
            WIDTH         28;
            CUSTOM ;
                nMoves  0,;
                lPlay  .F.

    DEFINE RECTANGLE RBorder OF Puzzle;
        PROPERTY ;
            BORDERSTYLE   1,;
            LEFT          0,;
            HEIGHT       14,;
            TOP           0,;
            WIDTH        26

    DEFINE RECTANGLE R1 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE         1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT              3,;
            LEFT                1,;
            TOP                 1,;
            WIDTH               6

    DEFINE RECTANGLE R2 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE         1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT              3,;
            LEFT                7,;
            TOP                 1,;
            WIDTH               6

    DEFINE RECTANGLE R3 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                13,;
            TOP                  1,;
            WIDTH                6

    DEFINE RECTANGLE R4 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                19,;
            TOP                  1,;
            WIDTH                6

    DEFINE RECTANGLE R5 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE         1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT              3,;
            LEFT                1,;
            TOP                 4,;
            WIDTH               6

    DEFINE RECTANGLE R6 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE         1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT              3,;
            LEFT                7,;
            TOP                 4,;
            WIDTH               6

    DEFINE RECTANGLE R7 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                13,;
            TOP                  4,;
            WIDTH                6

    DEFINE RECTANGLE R8 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                19,;
            TOP                  4,;
            WIDTH                6

    DEFINE RECTANGLE R9 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE         1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT              3,;
            LEFT                1,;
            TOP                 7,;
            WIDTH               6

    DEFINE RECTANGLE R10 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE         1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT              3,;
            LEFT                7,;
            TOP                 7,;
            WIDTH               6

    DEFINE RECTANGLE R11 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                13,;
            TOP                  7,;
            WIDTH                6

    DEFINE RECTANGLE R12 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                19,;
            TOP                  7,;
            WIDTH                6

    DEFINE RECTANGLE R13 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                 1,;
            TOP                 10,;
            WIDTH                6

    DEFINE RECTANGLE R14 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                 7,;
            TOP                 10,;
            WIDTH                6

    DEFINE RECTANGLE R15 OF Puzzle;
        PROPERTY ;
            BORDERSTYLE          1,;
            COLORBORDERLOWERED "N/BG",;
            COLORBORDERRAISED  "W+/BG",;
            COLORNORMAL        "BG/BG",;
            HEIGHT               3,;
            LEFT                13,;
            TOP                 10,;
            WIDTH                6

    DEFINE TEXT T1 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         3,;
            TEXT        " 1",;
            TOP          2

    DEFINE TEXT T2 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         9,;
            TEXT        " 2",;
            TOP          2

    DEFINE TEXT T3 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         15,;
            TEXT        " 3",;
            TOP           2

    DEFINE TEXT T4 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         21,;
            TEXT        " 4",;
            TOP           2

    DEFINE TEXT T5 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         3,;
            TEXT        " 5",;
            TOP          5

    DEFINE TEXT T6 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         9,;
            TEXT        " 6",;
            TOP          5

    DEFINE TEXT T7 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         15,;
            TEXT        " 7",;
            TOP           5

    DEFINE TEXT T8 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         21,;
            TEXT        " 8",;
            TOP           5

    DEFINE TEXT T9 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         3,;
            TEXT        " 9",;
            TOP          8

    DEFINE TEXT T10 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         9,;
            TEXT        "10",;
            TOP          8

    DEFINE TEXT T11 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         15,;
            TEXT        "11",;
            TOP           8

    DEFINE TEXT T12 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         21,;
            TEXT        "12",;
            TOP           8

    DEFINE TEXT T13 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         3,;
            TEXT        "13",;
            TOP          11

    DEFINE TEXT T14 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         9,;
            TEXT        "14",;
            TOP          11

    DEFINE TEXT T15 OF Puzzle;
        PROPERTY ;
            COLORNORMAL "GR+/BG",;
            LABEL       .F.,;
            LEFT         15,;
            TEXT        "15",;
            TOP          11

    DEFINE PUSHBUTTON BShuf OF Puzzle;
        PROPERTY ;
            DEFAULT   .F.,;
            GRABFOCUS .F.,;
            LEFT        6,;
            ONCLICK    Shuffle,;
            TABSTOP   .F.,;
            TEXT      "&Shuffle",;
            TOP        14,;
            WIDTH      13

    DEFINE TEXT Tm OF Puzzle;
        PROPERTY ;
            LABEL .F.,;
            LEFT   13,;
            TEXT  "Moves:",;
            TOP    16

    DEFINE TEXT Tc OF Puzzle;
        PROPERTY ;
            LABEL .F.,;
            LEFT   20,;
            TEXT   TRANSFORM(0, "9,999"),;
            TOP    16
RETURN

