PROCEDURE OpenFile
PARAMETER poReturn
*----------------------------------------------------------------------
* DESCRIPTION
*   Driver program for: OpenFile.DFM
*   
*   Returns an object that contains the file name, and
*   the action to take.
*   poReturn.FileSpec   - To start.
*           .ShowRadio  - Show the radio buttons
*           .ModText    - Start text for Modify radio button
*           .DoText     - Start text for Do It radio button
*           .TypeArray  - Array with file types in it
*           .TypeStart  - Value of type to start
*           .FormTitle  - Title for the form
*           .FileName   - Name of file selected, <blank> if cancelled
*           .FileMod    - Modify radiobutton selected
*           .DoIt       - Do radiobutton selected
*           .NewName    - Set to .T. if file name doesn't exist already
*           .StrtName   - Default filename, only used if TYPE() = "C"
*           .HelpVal    - HelpID to display when help is selected
*
*----------------------------------------------------------------------
#define cSlash  "\"

    PRIVATE cStartSpec, cTypeValue, cArray, nLenMod, nLenDo, nWidth, ;
            lVoid, cDirPath, cFileName
            
    #include "TALKOFF.HDB"            

#define FN_FULLPATH  0
#define FN_PATH      1
#define FN_FILEROOT  2
#define FN_FILETYPE  3
#define FN_FILENAME  4
#define FN_VALIDFILE 5


    cStartSpec = poReturn.FileSpec
    cTypeValue = poReturn.TypeStart

#include  "OpenFile.DFM"

    OpenFile.Text = poReturn.FormTitle

    *------------------------------
    *-- Build the file list listbox
    *------------------------------
    DO BldFile WITH poReturn.FileSpec, OpenFile.lbName3

    *--------------------------------------
    *-- Set up the items for the File Types
    *--------------------------------------
    cArray = poReturn.TypeArray
	cAName = m->cArray + "[1]"
	IF TYPE( m->cAName ) = "C"
    	OpenFile.cbName5.DataSource = "ARRAY " + m->cArray
	ELSE
		OpenFile.cbName5.DataSource = "STRING " + m->cArray
	ENDIF


    OpenFile.efName2.Value = LEFT( m->cStartSpec + SPACE(80), 80 )

    *--------------------------------------------------
    *-- Start the current directory for reset on return
    *--------------------------------------------------
    cDirStash = SET( "DIRECTORY" )
    OpenFile.txName7.Text = m->cDirStash
    OpenFile.txName7.Width = OpenFile.Width - OpenFile.txName7.Left - 2
    OpenFile.txName7.Height = 1

    *------------------------------------------------------------
    *-- Make sure the first item in the list matches the wildcard
    *------------------------------------------------------------
    lExact = SET( "EXACT" ) = "ON"
    SET EXACT OFF
	IF TYPE( m->cAName ) = "C"
        nCurSel = ASCAN( &cArray, m->cTypeValue )
        nCurSel = MAX( 1, m->nCurSel )
        OpenFile.cbName5.CurSel  = m->nCurSel
    ENDIF
    OpenFile.ActiveType = m->cTypeValue

    IF m->lExact
        SET EXACT ON
    ENDIF

    *---------------------------------------
    *-- Make sure current drive item matches
    *---------------------------------------
    nCurSel = 1
    cLastBar = OpenFile.lbDrives.Value
    cCurDrive = LEFT( SET("DIRECTORY"), 2 )
    DO WHILE .T.
        cThisBar = TRIM( OpenFile.lbDrives.Value )
        IF m->cThisBar == m->cCurDrive
            EXIT
        ENDIF

        nCurSel = m->nCurSel + 1
        OpenFile.lbDrives.CurSel = m->nCurSel
        IF OpenFile.lbDrives.Value = m->cLastBar
            EXIT
        ENDIF
    ENDDO


    *---------------------------
    *-- Build the directory list
    *---------------------------
    DO BldDirs WITH OpenFile.lbName8

    IF poReturn.ShowRadio
        OpenFile.rbModify.Text      = poReturn.ModText
        OpenFile.rbDoIt.Text        = poReturn.DoText

        nLenMod = poReturn.ModText
        nLenMod = LEN( m->nLenMod )
        nLenDo  = poReturn.DoText
        nLenDo  = LEN( m->nLenDo )
        nWidth  = MAX( m->nLenMod, m->nLenDo ) + 6

        OpenFile.rbModify.Width     = m->nWidth
        OpenFile.rbDoIt.Width       = m->nWidth

        OpenFile.rbModify.Visible   = .T.
        OpenFile.rbDoIt.Visible     = .T.

    ELSE
        OpenFile.rbModify.Enabled   = .F.
        OpenFile.rbDoIt.Enabled     = .F.
    ENDIF

    IF TYPE("poReturn.StrtName") = "C"
        OpenFile.efName2.Value = poReturn.StrtName + SPACE(80 - LEN(poReturn.StrtName))
    ENDIF

    *---------------------------------------------
    *-- Adjust the HelpId value if .HelpVal is set
    *---------------------------------------------
    IF TYPE( "poReturn.HelpVal" ) = "C"
        OpenFile.pbName13.HelpId = poReturn.HelpVal
        OpenFile.HelpId = poReturn.HelpVal
    ENDIF
        
    lVoid = OpenFile.efName2.SetFocus()
    OpenFile.efName2.SelectAll = .T.
    lVoid = OpenFile.ReadModal()

    IF OpenFile.Action
        *-------------------------------------------------
        *-- Make sure the file has a full path designation
        *-------------------------------------------------
        cFileName = LTRIM( TRIM( UPPER( OpenFile.efName2.Value ) ) )
        cFileName = FNAME( m->cFileName, FN_FULLPATH )

        poReturn.FileName = m->cFileName
        IF FILE( m->cFileName )
            poReturn.NewName = .F.
        ELSE
            poReturn.NewName = .T.
        ENDIF


        IF poReturn.ShowRadio

            poReturn.FileMod    = OpenFile.rbModify.Value
            poReturn.DoIt       = OpenFile.rbDoIt.Value

        ENDIF

    ELSE
        poReturn.FileName = ""
    ENDIF

    RELEASE albName3, acbName5, albName8, acbName10, lb, lb8

    SET DIRECTORY TO &cDirStash

    lVoid = OpenFile.Release()
    RELEASE OpenFile

RETURN
*-- EOP: OpenFile.prg


PROCEDURE Valid_OK
*----------------------------------------------------------------------------
* NAME
*   Valid_OK - On Click handler efName2 for File Name prompt
*
*----------------------------------------------------------------------------
    PRIVATE cEditFld, lOk, cTypeFile, cTemp, cFileExt, nDotPos, lExact, ;
            cError, cDirSave

    oActive = OpenFile.ActiveControl()
    DO CASE
        CASE m->oActive = OpenFile.lbName8

            cNewPath = OpenFile.lbName8.Value
            IF UPPER( m->cNewPath ) = "<EMPTY>"
                RETURN
            ENDIF

            *-----------------------------------------------
            *-- User selected bar in the Directory list box.
            *-----------------------------------------------
            lExact = SET( "EXACT" ) = "ON"
            SET EXACT ON

            cError = ""
            cDirSave = SET( "DIRECTORY" )

            DO CASE
                CASE m->cNewPath = "\"
                    cPath = LEFT( SET( "DIRECTORY" ), 2 ) + "\"
                    ON ERROR cError = MESSAGE()
                    SET DIRECTORY TO &cPath
                    ON ERROR

                CASE m->cNewPath = ".."
                    ON ERROR cError = MESSAGE()
                    SET DIRECTORY TO ..
                    ON ERROR

                OTHERWISE
                    cPath = SET( "DIRECTORY" )
                    IF RIGHT( m->cPath, 1 ) <> "\"
                        cPath = m->cPath + "\"
                    ENDIF
                    cPath = m->cPath + TRIM( m->cNewPath )
                    ON ERROR cError = MESSAGE()
                    SET DIRECTORY TO &cPath
                    ON ERROR
            ENDCASE

            IF .NOT. ISBLANK( m->cError )
                DO ErrorMsg WITH m->cError
                SET DIRECTORY TO &cDirSave
            ELSE
                DO UpPostDir
            ENDIF

            IF .NOT. m->lExact
                SET EXACT OFF
            ENDIF

        CASE m->oActive = OpenFile.cbName5
            *--------------------------------------------
            *-- User selected bar in the file types list.
            *--------------------------------------------
            cValue = OpenFile.cbName5.Value
            nSpace = AT( " ", m->cValue )
            cFileSpec = LEFT( m->cValue, m->nSpace - 1 )
            OpenFile.ActiveType = m->cFileSpec
        
            OpenFile.efName2.Value = LEFT( m->cFileSpec + SPACE(80), 80 )
            DO BldFile WITH cFileSpec, OpenFile.lbName3
            OpenFile.lbName3.firstTime = .T.

            *------------------------------------------------------
            *-- Update the radio button text based on the file type
            *------------------------------------------------------
            IF poReturn.ShowRadio
                DO UpRadio WITH m->cFileSpec
            ENDIF

        CASE oActive = OpenFile.lbDrives
            *-------------------------------
            *-- User selected bar in Drives.
            *-------------------------------
            cCurrent = OpenFile.lbDrives.Value
            cDirSave = SET( "DIRECTORY" )
            lOk = .T.
            ON ERROR lOk = .F.
            SET DIRECTORY TO &cCurrent
            ON ERROR
            IF m->lOk
                DO UpPostDir
            ELSE
                SET DIRECTORY TO &cDirSave
            ENDIF

        OTHERWISE
            lOk = .F.
            cEditFld = LTRIM( TRIM( UPPER( OpenFile.efName2.Value ) ) )
            cEditFld = TRIM( m->cEditFld ) + ""
            cDirSave = SET( "DIRECTORY" )

            *-----------------------------------
            *-- Is there a wild card in the name
            *-----------------------------------
            IF "*" $ m->cEditFld .OR. "?" $ m->cEditFld

                *--------------------------------------
                *-- Adjust the file extension as needed
                *--------------------------------------
                nDot = RAT( ".", m->cEditFld )
                IF nDot > RAT( "\", m->cEditFld )
                    *---------------------------------
                    *-- There is a file extension here
                    *---------------------------------
                    cWildExt = "*." + SUBSTR( m->cEditFld + "   ", m->nDot + 1, 3 )
                    cWildExt = TRIM( UPPER( m->cWildExt ) )
                    IF OpenFile.ActiveType # m->cWildExt
                        *--------------------------------------------------
                        *-- A type change occured.  Scan the File Types for
                        *-- a match.
                        *--------------------------------------------------
                        lExact = SET( "EXACT" ) = "ON"
                        SET EXACT OFF
                        nCurSave = OpenFile.cbName5.CurSel
                        nRow = 1
                        OpenFile.cbName5.CurSel = m->nRow
                        DO WHILE .T.
                            IF OpenFile.cbName5.Value = m->cWildExt
                                OpenFile.cbName5.CurSel = m->nRow
                                EXIT
                            ENDIF
                            OpenFile.cbName5.CurSel = m->nRow + 1
                            IF OpenFile.cbName5.CurSel = m->nRow
                                *----------------------------------------
                                *-- Restore listbox highlight to original
                                *----------------------------------------
                                OpenFile.cbName5.CurSel = m->nCurSave
                                EXIT
                            ENDIF
                            nRow = m->nRow + 1
                        ENDDO
                        IF m->lExact
                            SET EXACT ON
                        ENDIF

                        OpenFile.ActiveType = m->cWildExt
                    ENDIF
                ENDIF


                *----------------------------------------------------
                *-- If a directory change is in the wild card, try to
                *-- reposition the directory.
                *----------------------------------------------------
                IF "\" $ m->cEditFld
                    cError = ""
                    DO VerifyDir
                    IF ISBLANK( m->cError )
                        DO UpPostDir
                    ELSE
                        *----------------------------------------------------
                        *-- Display the error message and reset the directory
                        *----------------------------------------------------
                        DO ErrorMsg WITH m->cError
                        SET DIRECTORY TO &cDirSave
                    ENDIF

                ELSE
                    *------------------------------------------------------
                    *-- Build a new file list for the wild card if possible
                    *------------------------------------------------------
                    DO BldFile WITH m->cEditFld, OpenFile.lbName3
                    OpenFile.lbName3.firstTime = .T.

                ENDIF

            ELSE

                *-----------------------------------------------
                *-- Make sure we have a valid file to start with
                *-----------------------------------------------
                IF .NOT. ISBLANK( m->cEditFld )
                    lOk = FNAME( m->cEditFld, FN_VALIDFILE )
                ELSE
                    lOk = .F.
                ENDIF

                IF lOk
                    *---------------------------
                    *-- Normal file name is here
                    *---------------------------
                    cEditFld = FNAME( m->cEditFld, FN_FULLPATH )
                    cFileExt = FNAME( m->cEditFld, FN_FILETYPE )

                    *--------------------------------------------
                    *-- Add on the file extension if not supplied
                    *--------------------------------------------
                    cTypeFile = m->cFileExt
                    nDotPos = RAT( ".", m->cEditFld )
                    IF ISBLANK( m->cFileExt ) .AND.  m->nDotPos # LEN( m->cEditFld )

                        *--------------------------
                        *-- Add file extension here
                        *--------------------------
                        cTypeFile = OpenFile.cbName5.Value
                        cTypeFile = TRIM( SUBSTR( m->cTypeFile, 3, 3 ) )

                        *----------------------------------------------------
                        *-- If current File Type is not *.*, pull in the type
                        *----------------------------------------------------
                        IF m->cTypeFile <> "*"
                            cTemp = TRIM( m->cEditFld ) + "." + m->cTypeFile
                            cEditFld = m->cTemp
                            OpenFile.efName2.Value = ;
                                              LEFT( m->cEditFld + SPACE(80), 80 )
                        ENDIF
                    ENDIF
                ENDIF

                *---------------------------------------------------------
                *-- Set NewName .T. if this is a valid file name that
                *-- does not exist.
                *---------------------------------------------------------
                DO CASE
                    CASE m->lOk .AND.  FILE( m->cEditFld ) 
                        poReturn.NewName = .F.
                    CASE m->lOk .AND. .NOT.  FILE( m->cEditFld ) 
                        *------------------------------------------------
                        *-- Make sure the directory exists before setting
                        *------------------------------------------------
                        cError = ""
                        DO VerifyDir
                        IF .NOT. ISBLANK( m->cError )
                            *----------------------------------------
                            *-- Directory doesn't exist, so set error
                            *----------------------------------------
                            DO ErrorMsg WITH m->cError
                            poReturn.NewName = .F.
                            lOk = .F.
                        ELSE
                            poReturn.NewName = .T.
                        ENDIF
                        *------------------------
                        *-- Restore the directory
                        *------------------------
                        SET DIRECTORY TO &cDirSave

                    CASE .NOT. m->lOk .AND.  FILE( m->cEditFld ) 
                        DO ErrorMsg WITH [Invalid file name: ] + m->cEditFld
                    CASE .NOT. m->lOk .AND. .NOT.  FILE( m->cEditFld ) 
                        DO ErrorMsg WITH [Invalid file name: ] + m->cEditFld
                ENDCASE

            ENDIF

            IF m->lOk
                OpenFile.Action = .T.
                lVoid = OpenFile.Close()
            ENDIF
    ENDCASE

RETURN
*-- EOP: Valid_OK

PROCEDURE VerifyDir
*----------------------------------------------------------------------------
* NAME
*   VerifyDir - Validate the directory path for the file.  This is a support
*               routine for Valid_OK.  This routine leaves the directory
*               set to the specified one if valid.
*
* VARIABLES
*   cEditFld    = Name of file with path to verify
*   cError      = Set to error message if any
*   cDirSave    = Starting directory
*
*----------------------------------------------------------------------------
    PRIVATE cPath, nPathLen
    *-------------------------------------------
    *-- In case of an error, display the message
    *-------------------------------------------
    cPath = SET( "DIRECTORY" )

    ON ERROR cError = MESSAGE()
    cPath = FName( m->cEditFld, 1 ) 
    ON ERROR

    IF .NOT. ISBLANK( cError )
        *-----------------------
        *-- Try the hard way now
        *-----------------------
        cDrv = FileDrv( m->cEditFld )
        cPat = FilePath( m->cEditFld )
        IF .NOT. ISBLANK( cDrv )
            cNewPath = cDrv + ":" + cPat + "n.txt"
        ELSE
            cNewPath = cPat + "n.txt"
        ENDIF
        cError = ""
        ON ERROR cError = MESSAGE()
        cPath = FName( m->cNewPath, 1 )
        ON ERROR
    ENDIF

    IF ISBLANK( cError )
        *--------------------------------------
        *-- Chop off the last slash in the path
        *--------------------------------------
        nPathLen = LEN( m->cPath )
        IF m->nPathLen > 1
            cPath = LEFT( m->cPath, m->nPathLen - 1 )
        ENDIF

        *---------------------------------------------
        *-- Now, take a shot at changing the directory
        *---------------------------------------------
        cError = ""
        ON ERROR cError = MESSAGE()
        SET DIRECTORY TO &cPath
        ON ERROR
    ENDIF


RETURN
*-- EOP: VerifyDir


PROCEDURE UpFile
*----------------------------------------------------------------------------
* NAME
*   UpFile - 
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
    PRIVATE cValue, nWidth

    IF UPPER( This.Value ) # "<EMPTY>"
        cValue = This.Value
        nWidth = This.Width

        OpenFile.efName2.Value = LEFT( m->cValue + SPACE(80), 80 )
        OpenFile.efName2.Width = m->nWidth
    ENDIF

RETURN
*-- EOP: UpFile


PROCEDURE ModUpFil
*----------------------------------------------------------------------------
* NAME
*   ModUpFil - OnGotFocus for File list box.
*
*----------------------------------------------------------------------------
    PRIVATE cValue, nWidth

    IF This.firstTime .AND. UPPER( This.Value ) # "<EMPTY>"
        cValue = This.Value
        nWidth = This.Width
        OpenFile.efName2.Value = LEFT( m->cValue + SPACE(80), 80 )
        OpenFile.efName2.Width = m->nWidth
        This.firstTime = .F.
    ENDIF

RETURN
*-- EOP: ModUpFil

PROCEDURE TypeLost
*----------------------------------------------------------------------------
* NAME
*   OnLType - 
*
* DESCRIPTION
*
*----------------------------------------------------------------------------

    cCurrent = This.Value
    cSave    = OpenFile.cWildCard

    IF LEFT( m->cCurrent, 5 ) <> LEFT( m->cSave, 5 )
        cValue = This.Value
        nSpace = AT( " ", m->cValue )
        cFileSpec = LEFT( m->cValue, m->nSpace - 1 )
    
        OpenFile.efName2.Value = LEFT( m->cFileSpec + SPACE(80), 80 )
        DO BldFile WITH cFileSpec, OpenFile.lbName3
        OpenFile.lbName3.firstTime = .T.

        *------------------------------------------------------
        *-- Update the radio button text based on the file type
        *------------------------------------------------------
        IF poReturn.ShowRadio
            DO UpRadio WITH m->cFileSpec
        ENDIF
    ENDIF
    OpenFile.cWildCard = This.Value

RETURN
*-- EOP: TypeLost

PROCEDURE TypeGot
*----------------------------------------------------------------------------
* NAME
*   OnGType - 
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
    OpenFile.cWildCard = This.Value

RETURN
*-- EOP: GotType

PROCEDURE ChngType
*----------------------------------------------------------------------------
* NAME
*   ChngType - 
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
    cValue = This.Value
    nSpace = AT( " ", m->cValue )
    cFileSpec = LEFT( m->cValue, m->nSpace - 1 )

    OpenFile.efName2.Value = LEFT( m->cFileSpec + SPACE(80), 80 )
    DO BldFile WITH cFileSpec, OpenFile.lbName3

    *------------------------------------------------------
    *-- Update the radio button text based on the file type
    *------------------------------------------------------
    IF poReturn.ShowRadio
        DO UpRadio WITH m->cFileSpec
    ENDIF

RETURN
*-- EOP: ChngType

PROCEDURE UpRadio
PARAMETERS poFileSpec
*----------------------------------------------------------------------------
* NAME
*   UpRadio - Update the radio buttons after a change in file spec.
*
* PARAMETERS
*   poFileSpec = Wild card selected.
*
*----------------------------------------------------------------------------
    OpenFile.Draw = .F.
    OpenFile.rbModify.Visible   = .T.
    OpenFile.rbDoIt.Visible     = .T.
    DO CASE
        CASE poFileSpec = "*.PRG"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .T.
            OpenFile.rbDoIt.Text    = [~D~o]
            OpenFile.rbDoIt.Value   = .F.
        CASE poFileSpec = "*.DBF"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .F.
            OpenFile.rbDoIt.Text    = [~B~rowse]
            OpenFile.rbDoIt.Value   = .T.
        CASE poFileSpec = "*.FMT"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .T.
            OpenFile.rbDoIt.Text    = [~S~et]
            OpenFile.rbDoIt.Value   = .F.
        CASE poFileSpec = "*.QBE"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .F.
            OpenFile.rbDoIt.Text    = [~B~rowse]
            OpenFile.rbDoIt.Value   = .T.
        CASE poFileSpec = "*.SCR"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .T.
            OpenFile.rbDoIt.Text    = [~S~et]
            OpenFile.rbDoIt.Value   = .F.
        CASE poFileSpec = "*.FRM"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .T.
            OpenFile.rbDoIt.Text    = [~D~o]
            OpenFile.rbDoIt.Value   = .F.
        CASE poFileSpec = "*.LBL"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .T.
            OpenFile.rbDoIt.Text    = [~D~o]
            OpenFile.rbDoIt.Value   = .F.
        CASE poFileSpec = "*.DFM"
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .T.
            OpenFile.rbDoIt.Text    = [~D~o]
            OpenFile.rbDoIt.Value   = .F.
        CASE poFileSpec = "*.PRJ"
            OpenFile.rbModify.Visible   = .F.
            OpenFile.rbModify.Value     = .T.
            OpenFile.rbDoIt.Visible     = .F.
        OTHERWISE
            OpenFile.rbModify.Text  = [~M~odify]
            OpenFile.rbModify.Value = .T.
            OpenFile.rbDoIt.Text    = [~D~o]
            OpenFile.rbDoIt.Value   = .F.
    ENDCASE

    OpenFile.Draw = .T.
    lVoid = OpenFile.efName2.SetFocus()

RETURN
*-- EOP: UpRadio WITH poFileSpec

PROCEDURE DriveGot
*----------------------------------------------------------------------------
* NAME
*   DriveGot - OnGotFocus handler for lbDrives
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
    OpenFile.cDrive = This.Value


RETURN
*-- EOP: DriveGot

PROCEDURE DriveLost
*----------------------------------------------------------------------------
* NAME
*   DriveLost - OnLostFocus handler for lbDrives
*
* DESCRIPTION
*
*----------------------------------------------------------------------------
    cCurrent = TRIM( This.Value )
    cSave    = TRIM( OpenFile.cDrive )
    IF m->cCurrent <> m->cSave
        cDirSave = SET( "DIRECTORY" )
        lOk = .T.
        ON ERROR lOk = .F.
        SET DIRECTORY TO &cCurrent
        ON ERROR
        IF m->lOk
            DO UpPostDir
        ELSE
            SET DIRECTORY TO &cDirSave
        ENDIF
    ENDIF
    OpenFile.cDrive = m->cCurrent

RETURN
*-- EOP: DriveLost

PROCEDURE UpPostDir
*----------------------------------------------------------------------------
* NAME
*   UpPostDir - Update lists after a change in directory
*
*----------------------------------------------------------------------------
    OpenFile.txName7.Text = SET( "DIRECTORY" )
    OpenFile.txName7.Width = OpenFile.Width - OpenFile.txName7.Left - 2
    OpenFile.txName7.Height = 1

    DO BldDirs WITH OpenFile.lbName8

    cFileSpec = OpenFile.ActiveType

    OpenFile.efName2.Value = LEFT( m->cFileSpec + SPACE(80), 80 )
    DO BldFile WITH cFileSpec, OpenFile.lbName3

RETURN
*-- EOP: UpPostDir




