PROCEDURE LookRef
PARAMETERS pcAlias, poLookup
*----------------------------------------------------------------------------
* NAME
*   LookRef - Refresh fields in the lookup table after a record movement
*
* PARAMETERS
*   pcAlias     = Alias name to look for using DataLink
*   poLookFld   = oRef to lookup field
*
*----------------------------------------------------------------------------
    PRIVATE oParent, oFirst, oCurrent, cDataLink, cData
    *------------------------------------------
    *-- For each modified field with a datalink
    *------------------------------------------
    oParent = poLookup.Parent
    oFirst = oParent.First
    oCurrent = oFirst
    DO WHILE .T.

        IF TYPE( "oCurrent.DataLink" ) = "C"

            *------------------------------------------
            *-- Check to see if the fields was modified
            *------------------------------------------
            IF oCurrent.Modified()

                *--------------------------------------------
                *-- Save the modified value to a holding area
                *--------------------------------------------
                oCurrent.HoldValue = oCurrent.Value

            ENDIF

        ENDIF

        oCurrent = oCurrent.After

        IF oCurrent = oFirst
            EXIT
        ENDIF
    ENDDO

    *--------------------------------------------------------------------
    *-- How issue a Refresh().  This moves the values from the new record
    *-- into the entryfields, but it also resets the values in the master
    *-- file.  That's why we stashed them above.
    *--------------------------------------------------------------------
    SELECT( oParent.CurrMast )

    lVoid = oParent.Refresh()

    SELECT( pcAlias )

    *-------------------------------------------------------------
    *-- For each of the fields with stashed values, move them back
    *-------------------------------------------------------------
    oCurrent = oFirst
    DO WHILE .T.

        IF TYPE( "oCurrent.HoldValue" ) # "U"

            *--------------------------------------------------------
            *-- Copy the HoldValue to Value and release the HoldValue
            *--------------------------------------------------------
            oCurrent.Value = oCurrent.HoldValue
            RELEASE oCurrent.HoldValue

        ENDIF

        oCurrent = oCurrent.After
        IF oCurrent = oFirst
            EXIT
        ENDIF
    ENDDO


RETURN
*-- EOP: LookRef WITH pcAlias, poLookup




