PROCEDURE Goods
    PRIVATE Openar, mFormOpen, lVoid, mDesk, mActive, mClass, mFormName

    IF TYPE("Goods.ClassName") # "C"    && If form does not exist
        Openar=.F.
*        IF SUBSTR(DBF(),3)="GOODS.DBF"
*             Openar=.T.
*             USE
*        ENDIF

        mFormOpen=.F.
        DEFINE FORM mTemp PROPERTY VISIBLE .F.
        lVoid = mTemp.OPEN()
        mDesk = mTemp.PARENT
        lVoid = mTemp.CLOSE()

        mFormName=SPACE(8)
        mActive=mDesk.ActiveControl()
        IF TYPE("mActive.ClassName")="C"
            mClass=mActive.ClassName
            IF mClass="FORM"
                mFormName=mActive.Name
                mFormOpen=.T.
            ENDIF
        ENDIF

        #include "Goods.dfm"
        PUBLIC VendId, NewRecord

        NewRecord = .F.       && Initialize Global to form

        Goods.Action = .F.
        lVoid = Goods.Open()
    ELSE
        lVoid = Goods.SetFocus()    && if exists, make current
    ENDIF
RETURN

PROCEDURE OpenGoods
    PRIVATE lOpen

    lOpen = .T.

    IF SUBSTR(DBF(),3)<>"GOODS.DBF"
       SELECT SELECT()
       USE Vendors ORDER Vendor_ID ALIAS GoodsVend AGAIN
       SELECT SELECT()
       USE Goods ORDER Part_ID ALIAS Goods AGAIN
    ELSE
       SELECT SELECT()
       USE Vendors ORDER Vendor_ID ALIAS GoodsVend AGAIN
    ENDIF
    This.lOpen = lOpen
    lVoid = This.Refresh()

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.V.Frm.Enabled=.F.
        Main.F1.Bac.Enabled=.F.
        Main.App.Ord.Enabled=.F.
        Main.App.Vend.Enabled=.F.
        Main.App.Inv.Enabled=.F.
        Main.App.Are.Enabled=.F.
    ENDIF
    Main.App.Gds.Enabled=.F.

    IF Openar
        DEFINE BROWSE brwse ;
            PROPERTY ;
                MOVEABLE .T.,;
                SIZEABLE .T.
                lVoid = brwse.Open()
    ENDIF

    lVoid = Goods.SetFocus()
RETURN
******************
PROCEDURE PrevHand
       IF Form.Modified()
        lVoid = Form.Submit()
       ENDIF
    IF .NOT. BOF()
        SKIP -1
        IF BOF()
           DO ErrorMsg WITH "Top of file!"
        ENDIF
        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif

        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "Top of file!"
    ENDIF
    Form.Action = .F.
RETURN
*******************
PROCEDURE SkipHand
    IF Form.Modified()
        lVoid = Form.Submit()
    ENDIF
    IF .NOT. EOF()
        SKIP
        IF PART_ID=' '
         SKIP -1
         DO ERRORMSG WITH "End of file encountered!"
        ENDIF
        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif

        lVoid = Form.refresh()
    ELSE
        DO ErrorMsg WITH "End of file encountered!"
    ENDIF
    Form.Action = .F.
RETURN
******************
PROCEDURE CloseGds
    IF This.Action
        lVoid = This.Submit()
    ELSE
       IF This.Modified()
            DO ErrorMsg WITH "Exit goods without saving ..."
       ENDIF
    ENDIF

    USE IN Goods
    USE IN GoodsVend
    lVoid = This.Release()


    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()

    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.T.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.V.Frm.Enabled=.F.
        Main.F1.Bac.Enabled=.T.
        Main.App.Ord.Enabled=.T.
        Main.App.Vend.Enabled=.T.
        Main.App.Inv.Enabled=.T.
        Main.App.Are.Enabled=.T.
    ENDIF
    Main.App.Gds.Enabled=.T.

******************
FUNCTION DupCheck
    If NewRecord
        ? "Checking for Duplicates ..."
        SEEK(Goods.Part_Id.Value)       && index is on Part_ID
        IF FOUND()
            DO ErrorMsg WITH "Duplicate Found, Enter Another ..."+Goods.Part_ID.Value
            RETURN .F.
        ELSE
            Newrecord = .f.
        ENDIF
    Endif
RETURN .T.

******************
FUNCTION FindPart
    * Generate a form that will can be used by other procedures
    DO GenForm

    * Make the user select Ok before moving on, Give focus
    lVoid = Search.sValue.Setfocus()
    lVoid = Search.ReadModal()
RETURN .T.
**********************
PROCEDURE GenForm
    * Define a search form
    DEFINE FORM Search FROM 5,10 TO 11,45 ;
        PROPERTY ;
            Text "Search"

    DEFINE TEXT sVal OF Search AT 1,5 ;
        PROPERTY ;
            Text "Part No :"
    DEFINE ENTRYFIELD Svalue OF Search AT 1,14 ;
        PROPERTY ;
            Width 11,;
            PICTURE "!-999-9999"

    DEFINE PUSHBUTTON sOk OF Search AT 3,12 ;
        PROPERTY ;
            Text "OK",;
            Width 10  ,;
            Default .T. ,;
            OnClick "CloseMe"


RETURN
***********************
PROCEDURE CloseMe

    CLEAR
    * Get value user entered before closing form
    SearchFor = Search.Svalue.value
    SearchWidth = Search.Width  && See if size is Less than 50

    lVoid = Search.Close()
    * remove from memory
    lVoid = Search.Release()

    * Note : If you place this code in the FindLast routine you will
    * have a timing problem where the variable SearchFor has not been
    * Defined before there is a call referencing it.

    IF SearchWidth < 50   && FindLast called this procedure
        * Now Search for value given - Exact match
        IF LEN(SearchFor) > 0
            SEEK(TRIM(SearchFor))
            IF FOUND()
                Goods.StatusMessage = "Found ID  = "+SearchFor
                * repaint the form with the current record
                lVoid = Goods.Refresh()
            ELSE
                DO Errormsg WITH "Part Number Not Found ..."+SearchFor
            ENDIF
        ENDIF

    ENDIF

RETURN
******************
PROCEDURE Add_new
    NewRecord = .T.

    *Write data to disk
    lvoid = Form.submit()

    * Append a record
    APPEND BLANK

    *Refresh Screen Data
    lvoid = Form.refresh()
    Form.cStatus.Text=""
RETURN
******************
PROCEDURE DelIt && Marks record for deletion
    IF DELETED()
      Form.cStatus.Text = ""
      RECALL
    ELSE
      Form.cStatus.Text = "DELETED"
      DELETE
    ENDIF

RETURN
******************
FUNCTION LookupId
    PRIVATE oRef, lReturn           &&   declare memvars!

    oRef = This                     &&   assign this to a memvar so it doesn't get lost

    *
    * Validates user input, by bringing up a browse if we can't find
    *


    lReturn = .F.
    SELECT (oRef.ALIASNAME)  && Custom Property
    IF SEEK( oRef.Value )    && Value of the current object
    lReturn = .T.
    ELSE
    DEFINE BROWSE LookUp
    Lookup.Top           =  oRef.Top + 2
    Lookup.Left          =  oRef.Left
    Lookup.Key           =  "KeyHand"       && Key handlers for user
    Lookup.OnMouseDblClk =  "KeyHand"       && selection in browse
    Lookup.Sizeable      =  .T.
    Lookup.Moveable      =  .T.
    Lookup.MDI           =  .F.
    Lookup.Width         =  77 - oRef.Left
    Lookup.Alias         =  oRef.ALIASNAME
    Lookup.StatusMessage =  [Select the desired value and ] + ;
                [press Enter to choose it] ;

    Lookup.Action        = .F.

    lVoid = LookUp.ReadModal()
    IF LookUp.Action
        * Stuff value Field from browse into form, selected by user
        oRef.Value = GoodsVend->Vendor_ID
        lReturn = .T.
    ELSE
        DO ErrorMsg WITH [Lookup failed: ] + LTRIM( STR( This.Value ) )
    ENDIF

    ENDIF

    * Bring back main dbf file
    SELECT Goods

RETURN lReturn

FUNCTION KeyHand
*----------------------------------------------------------------------------
* NAME
*   KeyHand() -
*
*----------------------------------------------------------------------------
*    PRIVATE Form, This
*#define evMouseDown       1
*#define evKeyDown        16
*#define kbEnter          13

    IF Event.EventType = 16
    IF Event.KeyValue = 13
        Lookup.Action = .T.
        lVoid = Lookup.Close()
    ENDIF
    ELSE
    IF Event.EventType = 1
        Lookup.Action = .T.
        lVoid = Lookup.Close()
    ENDIF
    ENDIF

RETURN .T.

*****************
PROCEDURE CanHand
    Form.Action = .F.
    lVoid = Form.Close()
RETURN
*****************
PROCEDURE RePaint
    SELE Goods
    lVoid = Goods.Refresh()
RETURN
******************
PROCEDURE PrintForm

DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"

DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"

DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORNORMAL "N+/W",;
        WIDTH 15,;
        ENABLED .F.,;
        TABSTOP .F.

DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15

DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10

DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CanHand",;
        Width 10

lVoid = Prt.Open()

******************
PROCEDURE Runrep

* Check for Labels or Reports
DO CASE
    CASE Form.Rep.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         REPORT FORM Goods TO PRINTER

ENDCASE
lVoid = Form.Close()
lVoid = Form.Release()
RETURN

