*.............................................................................
*
*   Program Name: FLDTRIM.PRG         Copyright: Borland International
*   Date Created: 02/17/94             Language: dBASE 5.0
*   Time Created: 19:29:40               Author: Borland dBASE R&D                                    
*   /brief/library.src
*.............................................................................

FUNCTION FldTrim
PARAMETERS pcFldStr
*----------------------------------------------------------------------------
* NAME
*   FldTrim() - Convert a field string created with FldStr() to a field name
*
* DESCRIPTION
*   FldTrim() removed the square bracket type and returns the field name
*
* PARAMETERS
*   pcFldStr   = field name followed by [<type>]
*
* LIMITATIONS
*   pcFldStr must be a string
*
*----------------------------------------------------------------------------
  PRIVATE cFieldName, nBracket
  cFieldName = pcFldStr

  nBracket = AT( '[', cFieldName )
  IF nBracket > 0
    cFieldName = LTRIM( TRIM( LEFT( cFieldName, nBracket-1 ) ) )
  ELSE
    cFieldName = LTRIM( TRIM( cFieldName ) )
  ENDIF

RETURN( cFieldName )
*-- EOF: FldTrim( pcFldStr )

