*.............................................................................
*
*   Program Name: FLDSTR.PRG          Copyright: Borland International
*   Date Created: 02/17/94             Language: dBASE 5.0
*   Time Created: 19:47:49               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................


FUNCTION FldStr
PARAMETERS pcField
*----------------------------------------------------------------------------
* NAME
*   FldStr() - Return a field string with type
*
* DESCRIPTION
*   FldStr() appends the field type and length for character and
*   numeric fields in square brackets.
*
* PARAMETERS
*   pcField    = field name as a string
*
* DEPENDENCIES
*   DBF for the field must be active.  If not, field is returned intact.
*
*----------------------------------------------------------------------------
  PRIVATE cType, cField, cNumber, cLen, cExp, cFieldName

  cType = TYPE( pcField )
  cFieldName = TRIM( pcField )
  DO CASE
    CASE cType = "C"
      cLen = LTRIM( STR( LEN( &cFieldName ) ) )
      cExp = ' [C' + cLen + ']'
    CASE cType $ "NF"
      cNumber = TRANSFORM( &cFieldName, "@L" )
      cLen = LTRIM( STR( LEN( cNumber ) ) )
      cExp = ' [' + cType + cLen + ']'
    CASE cType = "D"
      cExp = ' [D]'
    CASE cType = "M"
      cExp = ' [M]'
    CASE cType = "L"
      cExp = ' [L]'
    OTHERWISE
      cExp = ''
  ENDCASE

RETURN( cFieldName + cExp )
*-- EOF: FldStr( pcField )



