******************************************************************************
******************************************************************************
* PROGRAM NAME: BUSINESS.PRG
*
*               SAMPLE CUA BUSINESS APPLICATION SYSTEM
* LAST CHANGED: 06/20/94 08:00AM
* WRITTEN BY:   Borland International Inc.
*
******************************************************************************
PROCEDURE Business
    _cmdWindow.visible = .F.  && Get rid of command window
    SET TALK OFF

    CLEAR ALL                   && Close open files and clear memvars

    SET STATUS OFF

    DEFINE FORM dB5___XXX PROPERTY VISIBLE .F.   && create an object
    lVoid = dB5___XXX.Open()                     && reference variable
    _CmdWindow.oDesk = dB5___XXX.Parent          && to point to _Desktop
    lVoid = dB5___XXX.Close()                    && and store it in
    lVoid = dB5___XXX.Release()                  && _CmdWindow
    RELEASE dB5___XXX

    *
    * Define the Menu Object as the Top most object and Open
    *
    DEFINE MENUBAR Main

    DEFINE MENU F1 OF Main ;
        PROPERTY ;
            Text "&File"

    *
    * Define Menu Items under the FILE Option
    *
    DEFINE MENUITEM Open OF Main.F1 ;
        PROPERTY ;
            Text "&Open",;
            StatusMessage "Browse a database file",;
            OnClick OpenFile

    DEFINE MENUITEM CloseAll OF Main.F1 ;
        PROPERTY ;
            Text "&Close ALL" ,;
            StatusMessage "Close all open database files",;
            OnClick CloseAll

    DEFINE MENUITEM Sep1 OF Main.F1 ;
        PROPERTY ;
            Separator .T.


    DEFINE MENUITEM Bac OF Main.F1 ;
        PROPERTY ;
            Text "&Back Up/Restore",;
            OnClick "Back_Res" ,;
            ProcFile "Back_res.prg"

    DEFINE MENUITEM Sep2 OF Main.F1 ;
        PROPERTY ;
            Separator .T.

    DEFINE MENUITEM Edbase OF Main.F1 ;
        PROPERTY ;
            Text "Exit to &dBASE",;
            SHORTCUT "ALT-F4",;
            StatusMessage "Exit to dBASE Command Window",;
            OnClick cl_bus

    DEFINE MENUITEM Exit OF Main.F1 ;
        PROPERTY ;
            Text "E&xit to DOS",;
            StatusMessage "Exit Business and return to the DOS Prompt",;
            OnClick Leave

    *
    * Define the second CUA Option EDIT
    *
    DEFINE MENU E OF Main ;
        PROPERTY ;
            Text "&Edit"

    *
    * Define Menu Items under the EDIT Option
    *
    DEFINE MENUITEM Undo OF Main.E ;
        PROPERTY ;
            TEXT "&Undo",;
            Enabled .F.,;
            SHORTCUT "ALT-BACKSPACE",;
            StatusMessage "Undo last change to the record",;
            OnClick UndoIt

    DEFINE MENUITEM Save OF Main.E ;
        PROPERTY ;
            TEXT "&Save",;
            Enabled .F.,;
            StatusMessage "Save all changes to the current record",;
            OnClick SubmitIt

    DEFINE MENUITEM Sep1 OF Main.E ;
        PROPERTY ;
            Separator .T.

    DEFINE MENUITEM Copy Of Main.E ;
        PROPERTY ;
            Text "&Copy",;
            SHORTCUT "CTRL-INS",;
            StatusMessage "This Option Not Implemented",;
            OnClick NotReady

    DEFINE MENUITEM Paste OF Main.E ;
        PROPERTY ;
            Text "&Paste",;
            SHORTCUT "SHIFT-INS",;
            StatusMessage "This Option Not Implemented",;
            OnClick NotReady

    *
    * Define Menu VIEW of Main
    *
    DEFINE MENU V OF Main ;
        PROPERTY ;
            Text    "&View",;
            ONCLICK  ChkObj

    DEFINE MENUITEM brws OF Main.V ;
        PROPERTY ;
            Text "&Browse",;
            StatusMessage "Browse the currently open table",;
            OnClick "AddBrowse"

    DEFINE MENUITEM Frm OF Main.V ;
        PROPERTY ;
            Text "&Form",;
            StatusMessage "Display the Form for the currently open table",;
            OnClick "AddForm"

    *
    * Define the fourth CUA item Table
    *
    DEFINE MENU S OF Main ;
        PROPERTY ;
            Text "&Table",;
            OnClick "CheckOpen"

    DEFINE MENUITEM Srch OF Main.S;
        PROPERTY ;
            Text "&Search",;
            Enabled .F. ,;
            StatusMessage "Search for records (based on currently open form)",;
            OnClick "Srchr"

    DEFINE MENUITEM Sep1 OF Main.S ;
        PROPERTY ;
            Separator .T.

    DEFINE MENUITEM tp OF Main.S ;
        PROPERTY ;
            Text "&Top",;
            Enabled .F. ,;
            StatusMessage "Go to the top of the table",;
            OnClick "GoTop"

    DEFINE MENUITEM btm OF Main.S ;
        PROPERTY ;
            Text "&Bottom",;
            Enabled .F. ,;
            StatusMessage "Go to the bottom of the table",;
            OnClick "GoBott"

    DEFINE MENUITEM Sep2 OF Main.S ;
        PROPERTY ;
            Separator .T.

    DEFINE MENUITEM pck OF Main.S ;
        PROPERTY ;
            Text "&Pack",;
            StatusMessage "Remove all records marked for deletion in all tables",;
            OnClick "PackTabl"

    DEFINE MENUITEM Indx OF Main.S ;
        PROPERTY ;
            TEXT "&ReIndex",;
            StatusMessage "Reindex all tables",;
            OnClick "inddbf"

    *
    * Define the fifth CUA item Application
    *
    DEFINE MENU App OF Main PROPERTY Text "&Application"

    DEFINE MENUITEM cust OF Main.App ;
        PROPERTY ;
            Text "&Customers",;
            OnClick Cust,;
            ProcFile "Cust.prg"

    DEFINE MENUITEM Ord OF Main.App ;
        PROPERTY ;
            Text "&Orders",;
            OnClick Orders,;
            ProcFile "Orders.prg"

    DEFINE MENUITEM Sep1 OF Main.App ;
        PROPERTY ;
            Separator .T.

    DEFINE MENUITEM Vend OF Main.App ;
        PROPERTY ;
            Text "&Vendors",;
            OnClick Vendors,;
            ProcFile "Vendors.prg"

    DEFINE MENUITEM Gds OF Main.App ;
        PROPERTY ;
            Text "&Goods",;
            OnClick Goods,;
            ProcFile "Goods.prg"

    DEFINE MENUITEM Sep2 OF Main.App ;
        PROPERTY ;
            Separator .T.

    DEFINE MENUITEM Acc OF Main.App ;
        PROPERTY ;
            Text "&Acct Recv",;
            OnClick "Acct_rec" ,;
            Procfile "Acct_rec.prg"

    DEFINE MENUITEM Inv OF Main.App ;
        PROPERTY ;
            Text "&Print Invoices",;
            Onclick "Invoices",;
            ProcFile "Invoices.prg"

    DEFINE MENUITEM Sep3 OF Main.App ;
        PROPERTY ;
            Separator .T.

    DEFINE MENUITEM emp OF Main.App ;
        PROPERTY ;
            Text "&Employee",;
            OnClick Employee,;
            ProcFile "Employee.prg"

    DEFINE MENUITEM Are OF Main.App;
        PROPERTY ;
            Text "A&rea Codes",;
            OnClick "AreaCode",;
            ProcFile "AreaCode.prg"
    *
    * Define the sixth CUA item HELP
    *
    DEFINE MENU H OF Main ;
        PROPERTY ;
            Text "&Help"
    DEFINE MENUITEM keyb OF Main.H ;
        PROPERTY ;
            Text "&Keyboard",;
            OnClick NotReady
    DEFINE MENUITEM Indx OF Main.H ;
        PROPERTY ;
            Text "&Index",;
            OnClick NotReady
    DEFINE MENUITEM Abt OF Main.H ;
        PROPERTY ;
            Text "&About",;
            OnClick "About"

    * Define the FORM for HELP|ABOUT
    DEFINE FORM Abt_box FROM 1,3 TO 18,73 ;
        PROPERTY ;
            Text "About the Business Application",;
            Sizeable .F.

    * Define the text to go in the form for HELP|ABOUT
    DEFINE TEXT T1_abt OF Abt_box AT 1,2 ;
        PROPERTY ;
            TEXT "This version of BUSINESS was written specifically for dBASE for"
    DEFINE TEXT T2_abt OF Abt_box AT 2,2 ;
        PROPERTY ;
            TEXT "DOS version 5.0.  It was originally known as the A-T FURNITURE"
    DEFINE TEXT T3_abt OF Abt_box AT 3,2 ;
        PROPERTY ;
            TEXT "Application.  This version was rewritten to demonstrate the new"
    DEFINE TEXT T4_abt OF Abt_box AT 4,2 ;
        PROPERTY ;
            TEXT "Event Handling Model and Object Model of dBASE for DOS v5.0."
    DEFINE TEXT T5_abt OF Abt_box AT 6,2 ;
        PROPERTY ;
            TEXT "The Main Module is BUSINESS.PRG which calls subroutines named"
    DEFINE TEXT T6_abt OF Abt_box AT 7,2 ;
        PROPERTY ;
            TEXT "after the tables (ie, EMPLOYEE, VENDORS, etc.)  Each Subroutine"
    DEFINE TEXT T7_abt OF Abt_box AT 8,2 ;
        PROPERTY ;
            TEXT "also has a .DFM (FORM Source Code File) associated with it."
    DEFINE TEXT T8_abt OF Abt_box AT 10,2 ;
        PROPERTY ;
            TEXT "Studying the source code (found in <d>:\<dbasedir>\CUA_SAMP will,"
    DEFINE TEXT T9_abt OF Abt_box AT 11,2 ;
        PROPERTY ;
            TEXT "along with the product documentation, aid your understanding of"
    DEFINE TEXT T10_abt OF Abt_box AT 12,2 ;
        PROPERTY ;
            TEXT "these new and very powerful dBASE language tools.",;
            LABEL .F.

    * Define the PushButton for closing the form Abt_box
    DEFINE PUSH okab OF Abt_box AT 14,30 ;
        PROPERTY ;
            TEXT "OK",;
            WIDTH 10,;
            DEFAULT .T.,;
            OnClick CloseAbt

    CLEAR

    *
    * Open the Menu Object as the top most object
    *
    lVoid = Main.open()
    DO About
RETURN
****************************
PROCEDURE Inddbf                              && Indexing tables
    IF LEN(DBF()) > 0                          && There is a table open
        DO ErrorMsg WITH "You must exit all Forms to run this procedure .."
    ELSE
        DO Gauge
        Status.Gauge.WIDTH = 5
        Status.T3.Text = "Employee ..."
        USE Employee EXCL
        REINDEX
        Status.Gauge.WIDTH = 10
        Status.T3.Text = "Vendors ... "
        USE Vendors EXCL
        REINDEX
        Status.Gauge.WIDTH = 15
        Status.T3.Text = "Goods ...   "
        USE GOODS EXCL
        REINDEX
        Status.Gauge.WIDTH = 20
        Status.T3.Text = "Customer ..."
        USE CUST EXCL
        REINDEX
        Status.Gauge.WIDTH = 25
        Status.T3.Text = "Orders ...  "
        USE ORDERS EXCL
        REINDEX
        Status.Gauge.WIDTH = 30
        Status.T3.Text = "Acct Rec ..."
        USE ACCT_REC EXCL
        REINDEX
        Status.Gauge.WIDTH = 35
        Status.T3.Text = "Area Codes..."
        USE CODES EXCL
        REINDEX
        USE
        CLEA
        lVoid = Status.Release()
    ENDIF
RETURN
****************************
PROCEDURE PackTabl                         && Packing Tables
    CLOSE ALL
    DO Gauge
    * Check to see if there are any tables open
    IF LEN(DBF()) > 0
        DO ErrorMsg WITH "You must exit all Forms to run this procedure .."
    ELSE
        Status.Gauge.WIDTH = 5
        Status.T3.Text = "Employee ..."
        USE Employee EXCL
        PACK
        Status.Gauge.WIDTH = 10
        Status.T3.Text = "Vendors ... "
        USE Vendors EXCL
        PACK
        Status.Gauge.WIDTH = 15
        Status.T3.Text = "Goods ...   "
        USE GOODS EXCL
        PACK
        Status.Gauge.WIDTH = 20
        Status.T3.Text = "Customer ..."
        USE CUST EXCL
        PACK
        Status.Gauge.WIDTH = 25
        Status.T3.Text = "Orders ...  "
        USE ORDERS EXCL
        PACK
        Status.Gauge.WIDTH = 30
        Status.T3.Text = "Acct Rec ..."
        USE ACCT_REC EXCL
        PACK
        USE
        Status.Gauge.Width = 35
        Status.T3.Text = "Area Code ..."
        USE CODES EXCL
        PACK
        USE
        CLEA
        lVoid = Status.Release()
    ENDIF
    RETURN
****************************
PROCEDURE Gauge
    DEFINE FORM Status FROM 5,25 TO 10,65 ;
        PROPERTY ;
            Text "Status" ,;
            COLORNORMAL "W/B"

    DEFINE TEXT t1 OF Status AT 0,1 ;
        PROPERTY ;
            TEXT "0%",;
            COLORNORMAL "B/W"

    DEFINE TEXT t2 OF Status AT 0,34 ;
        PROPERTY ;
            Text "100%",;
            COLORNORMAL "B/W"

    DEFINE TEXT t3 OF Status AT 3,1 ;
        PROPERTY ;
            Text "",;
            COLORNORMAL "B/W"

    DEFINE RECTANGLE Gauge OF Status AT 4,1  ;
        PROPERTY ;
            TOP 1,;
            LEFT 1,;
            HEIGHT 2,;
            Width 1,;
            COLORNORMAL "R/W"

    lVoid = Status.Open()
    RETURN
****************************
PROCEDURE GOTOP                      && Going to top record in table
    * Need to see if a form is on the desktop
    * Use the _Clipboard reference (its always alive)
    CurrObj = _ClipBoard.Parent.ActiveControl()
    * Check to see if there is a form on the desktop
    IF TYPE("CurrObj") = "L"
        DO ErrorMsg WITH "A Form must be Open to Go Top ..."
    ELSE
       IF CurrObj.ClassName = "FORM"
          lVoid = CurrObj.Submit()        && Check if Form before Submit()
       ENDIF
       GO TOP
       IF CurrObj.ClassName = "FORM"       && Check if Form before Refresh()
          lVoid = CurrObj.Refresh()
       ENDIF
*      IF CurrObj.ClassName = "BROWSE"     && If Browse, RefreshRecord()
*         lVoid = CurrObj.RefreshRecord()
*      ENDIF
    ENDIF
    RETURN
****************************
PROCEDURE GOBOTT                  && Going to Bottom Record in table
    * Need to see if a form is on the desktop
    * Use the _Clipboard reference (its always alive)
    CurrObj = _ClipBoard.Parent.ActiveControl()
    * Check to see if there is a Form on the desktop
    IF TYPE("CurrObj") = "L"
        DO ErrorMsg WITH "A Form must be Open to Go Bottom ..."
    ELSE
    IF CurrObj.ClassName = "FORM"       && Check if Form before Submit()
        lVoid = CurrObj.Submit()
    ENDIF
    GO BOTTOM
    IF CurrObj.ClassName = "FORM"       && Check if Form before Refresh()
        lVoid = CurrObj.Refresh()
    ENDIF
    IF CurrObj.ClassName = "BROWSE"     && If Browse, RefreshRecord()
        lVoid = CurrObj.RefreshRecord()
    ENDIF
    ENDIF
    RETURN
****************************
PROCEDURE SubmitIt             && Writing Record info to dis
    * Need to see if a form is on the desktop
    * Use the _Clipboard reference (its always alive)
    CurrObj = _ClipBoard.Parent.ActiveControl()
    * check to see if a form is active

    IF TYPE("CurrObj.ClassName") = "C"
        IF CurrObj.ClassName = "FORM"
            lVoid = CurrObj.Submit()
        ELSE
            DO ErrorMsg WITH "A Form must be Open to Save ..."
        ENDIF
    ELSE
        DO ErrorMsg WITH "A Form must be Open to Save ..."
    ENDIF

*    If TYPE("CurrObj") = "L"    && Implies no form on desktop
*        DO ErrorMsg WITH "A Form must be Open to Save ..."
*    ELSE
*        lVoid = CurrObj.Submit()
*    ENDIF

    RETURN
***************************
PROCEDURE UndoIt
    * Need to see if a form is on the desktop
    * Use the _Clipboard reference (its always alive)
    CurrObj = _ClipBoard.Parent.ActiveControl()
    * check to see if a form is active, if no form on the desktop
    * the type of Currobj is logical .F.
    IF TYPE("CurrObj") = "L"
        DO ErrorMsg WITH "A Form must be Open to Undo ..."
    ELSE
        lVoid = CurrObj.Refresh()
    ENDIF
    RETURN
***************************
PROCEDURE AddBrowse
    IF LEN(DBF()) > 0
       DEFINE BROWSE brwse ;
            PROPERTY ;
                APPEND   .F.,;
                MOVEABLE .T.,;
                SIZEABLE .T.,;
                OnClose MnuEnable
       lVoid = brwse.Open()
       Main.V.Brws.Enabled=.F.
    ELSE
        DO ErrorMsg WITH "Need to have an active form or table first..."
    ENDIF
****************************
PROCEDURE AddForm
    IF LEN(DBF()) > 0
        STORE SUBSTR(DBF(),3) TO Fname
        DO CASE
            CASE SUBSTR(DBF(),3)="EMPLOYEE.DBF"
                DO EMPLOYEE
            CASE SUBSTR(DBF(),3)="VENDORS.DBF"
                DO VENDORS
            CASE SUBSTR(DBF(),3)="GOODS.DBF"
                DO GOODS
            CASE SUBSTR(DBF(),3)="CUST.DBF"
                DO CUST
            CASE SUBSTR(DBF(),3)="ACCT_REC.DBF"
                DO ACCT_REC
            CASE SUBSTR(DBF(),3)="CODES.DBF"
                DO AREACODE
            OTHERWISE
                DO ErrorMsg WITH "There is no FORM for "+Fname
        ENDCASE
    ENDIF
    RETURN
****************************
PROCEDURE Srchr
    IF LEN(DBF()) = 0
        DO ErrorMsg WITH "A table must be open to SEARCH"
        RETURN
    ENDIF
    STORE SUBSTR(DBF(),3) TO Fname1
    DO CASE
        CASE SUBSTR(DBF(),3)="EMPLOYEE.DBF"
            Procr="EMPLOYEE"
            Funcr="FINDLAST()"
        CASE SUBSTR(DBF(),3)="GOODS.DBF"
            Procr="GOODS"
            Funcr="FINDPART()"
        CASE SUBSTR(DBF(),3)="CUST.DBF"
            Procr="CUST"
            Funcr="FINDID()"
        CASE SUBSTR(DBF(),3)="ACCT_REC.DBF"
            Procr="ACCT_REC"
            Funcr="FINDPART()"
        CASE SUBSTR(DBF(),3)="CODES.DBF"
            Procr="AREACODE"
            Funcr="FINDCODE()"
        OTHERWISE
            DO ErrorMsg WITH "There is no SEARCH for "+Fname1
        RETURN
    ENDCASE
    SET PROCEDURE TO &Procr
    ? &Funcr
******************************
PROCEDURE LEAVE
    CLOSE ALL
    RELEASE ALL
    QUIT
    RETURN
******************************
PROCEDURE Cl_Bus
    PRIVATE oRef, oRefP, lVoid
    * close any open forms
    _CmdWindow.Visible = .T.
    oRef  = _CmdWindow.Before
    oRefP = _CmdWindow
    DO WHILE oRef # _CmdWindow
        IF oRef.ClassName = "FORM"
            lVoid = oRef.Close()
            IF TYPE("oRef.ClassName") = "C"
                lVoid = oRef.Release()
            ENDIF
            oRef = oRefP.Before
        ELSE
            oRefP = oRef
            oRef  = oRefP.Before
        ENDIF
    ENDDO
    IF TYPE("Main.ClassName") = "C"
        lVoid = Main.Close()
        lVoid = Main.Release()
    ENDIF

    CLEAR ALL

    SET STATUS ON
    RETURN
******************************
PROCEDURE NotReady
    DO Errormsg WITH "Feature is not ready yet ..."
    RETURN
*******************************
PROCEDURE About
    Lvoid=Abt_box.readmodal()
    RETURN
*******************************
PROCEDURE CloseAbt
    Lvoid=Abt_box.CLOSE()
    RETURN
*******************************
PROCEDURE CloseAll
    PRIVATE oRef, oRefP, lVoid
    * close any open forms
    oRef  = _CmdWindow.Before
    oRefP = _CmdWindow
    DO WHILE oRef # _CmdWindow
        IF oRef.ClassName = "FORM"
            lVoid = oRef.Close()
            IF TYPE("oRef.ClassName") = "C"
                lVoid = oRef.Release()
            ENDIF
            oRef = oRefP.Before
        ELSE
            oRefP = oRef
            oRef  = oRefP.Before
        ENDIF
    ENDDO

    CLOSE ALL
    RETURN
*******************************
PROCEDURE OpenFile
    DEFINE FORM OpenFile;
        PROPERTY;
            AUTOSIZE    .F.,;
            HEIGHT      15,;
            LEFT        8,;
            MDI         .T.,;
            MOVEABLE    .T.,;
            SIZEABLE    .F.,;
            SYSMENU     .T.,;
            TEXT        "Open File",;
            TOP         1,;
            WIDTH       45

    DEFINE TEXT T1 OF OpenFile AT 2,2 ;
        PROPERTY ;
            TEXT "Table List :", ;
            COLORNORMAL "R/W"

    DEFINE LISTBOX DbfList OF OpenFile;
        PROPERTY;
            HEIGHT      7,;
            LEFT        2,;
            TOP         4,;
            DataSource  "FILEMASK *.dbf",;
            WIDTH       20

    DEFINE CHECKBOX Excl OF OpenFile AT 10,25 ;
        PROPERTY ;
            Text "&Exclusive"  ,;
            COLORNORMAL "N/W" ,;
            WIDTH 15

    DEFINE PUSHBUTTON pbName11 OF OpenFile;
        PROPERTY;
            HEIGHT 2,;
            LEFT 25,;
            TEXT [&Ok],;
            TOP 4,;
            WIDTH 10, ;
            OnClick     OpenIt, ;
            Default     .T.

    DEFINE PUSHBUTTON pbName12 OF OpenFile;
        PROPERTY;
            HEIGHT      2,;
            LEFT        25,;
            TEXT        [Cancel],;
            TOP         7,;
            WIDTH       10, ;
            OnClick     CanHand

    OpenFile.pbName12.PROCFILE = "CanHand.prg"

    lVoid = OpenFile.Open()
******************************
PROCEDURE OpenIt

    FileName = OpenFile.DbfList.Value
    IF OpenFile.Excl.Value
        IF FileName="CODES.DBF"
            USE CODES ORDER CITY ALIAS AreaCode EXCL
        ELSE
           USE &FileName EXCL
        ENDIF
    ELSE
        IF Filename="CODES.DBF"
            USE CODES ORDER CITY ALIAS AreaCode AGAIN
         ELSE
            USE &FileName
        ENDIF
    ENDIF
    lVoid = OpenFile.Release()

    DO AddBrowse
    Main.S.Srch.Enabled=.T.
    Main.S.Tp.Enabled=.T.
    Main.S.Btm.Enabled=.T.
    Main.E.Undo.Enabled=.F.
    Main.E.Save.Enabled=.F.

RETURN
*******************************
PROCEDURE MnuEnable
    IF TYPE("Main.ClassName") = "C"
        Main.S.Srch.Enabled=.F.
        Main.S.Tp.Enabled=.F.
        Main.S.Btm.Enabled=.F.
        Main.E.Undo.Enabled=.F.
        Main.E.Save.Enabled=.F.
    ENDIF
*   USE IN Brwse.Alias
    lVoid=Brwse.Release()
RETURN
*******************************
PROCEDURE CheckOpen
    IF ChkOpen()
        Main.S.pck.Enabled  = .F.
        Main.S.Indx.Enabled = .F.
    ELSE
        Main.S.pck.Enabled  = .T.
        Main.S.Indx.Enabled = .T.
    ENDIF

    IF ISBLANK(ORDER())
        Main.S.Srch.Enabled = .F.
    ELSE
        Main.S.Srch.Enabled = .T.
    ENDIF
RETURN
*******************************
FUNCTION ChkOpen
    PRIVATE nWA, lRet, nOld

    SET TALK OFF

    IF .NOT. ISBLANK(ALIAS())
        nOld = SELECT(ALIAS())
    ELSE
        nOld = SELECT()
    ENDIF

    lRet = .F.

    FOR nWA = 1 TO 40
        SELECT (nWA)
        IF .NOT. ISBLANK(DBF())
            lRet = .T.
            EXIT
        ENDIF
    ENDFOR

    SELECT (nOld)
RETURN lRet
********************************
PROCEDURE ChkObj
    PRIVATE oRef

    oRef = _CmdWindow.oDesk.ActiveControl()

    IF TYPE("oRef.ClassName") = "C"
        IF oRef.Name # "_CMDWINDOW"
            IF oRef.ClassName = "FORM"
                Main.V.Brws.Enabled = .T.
                Main.V.Frm.Enabled  = .F.
            ENDIF
            IF oRef.ClassName = "BROWSE"
                Main.V.Brws.Enabled = .F.
                Main.V.Frm.Enabled  = .T.
            ENDIF
        ELSE
            IF .NOT. ISBLANK(ALIAS())
                Main.V.Brws.Enabled = .T.
                Main.V.Frm.Enabled  = .T.
            ELSE
                Main.V.Brws.Enabled = .F.
                Main.V.Frm.Enabled  = .F.
            ENDIF
        ENDIF
    ELSE
        IF .NOT. ISBLANK(ALIAS())
            Main.V.Brws.Enabled = .T.
            Main.V.Frm.Enabled  = .T.
        ELSE
            Main.V.Brws.Enabled = .F.
            Main.V.Frm.Enabled  = .F.
        ENDIF
    ENDIF
RETURN



*** END BUSINESS.PRG *******************************************************

