******************************************************************************
* PROGRAM NAME: CUST.PRG
*               CUSTOMER DATABASE SCREEN
*               SAMPLE BUSINESS APPLICATION PROGRAM
* LAST CHANGED: 09/25/89 09:26AM
* WRITTEN BY:   Borland International Inc.
******************************************************************************
*       FILES USED:
*       Database file =  Cust.dbf   (Customer file)
*       Index file    =  Cust.mdx
*           TAG: Cust =  cust_id  <= Master index
*       External procedure file = Library.prg
******************************************************************************
* Main procedure
PROCEDURE Cust

   * Link to external procedure file of "tool" procedures
   SET PROCEDURE TO Library

   * Set up database environment
   DO Set_env

   SET COLOR TO &c_standard.

   * Declare variables used:
   * Database memory variables
   STORE "" TO cust_id, category, customer, address1, address2, city, state
   STORE "" TO zip, phone, contact, phone_cont, phone_ext, date_last, terms
   STORE "" TO comments

   * Miscellaneous variables - used to pass parameters to Library
   STORE "CUST" TO dbf, mlist         && Standard report & mail list available
   STORE "N/A"  TO cust_rpt           && No custom reports available
   STORE "m->cust_id" TO key, key1
   STORE "NONE" TO key2, key3
   keyname1 = "Customer #:"
   STORE "" TO keyname2, keyname3, mcategory, mcity, mstate,mzip,mterms
   list_flds = "CUST_ID, CONTACT, PHONE_CONT, PHONE_EXT"

   * Open database files and choose active indexes
   SELECT 1
   USE Cust ORDER Cust_id
   GO TOP
   * Used for area code lookup
   USE Codes ORDER City IN 2

   record_num = RECNO()
   * Load initial record from database into memory variables
   DO Load_fld

   * Show data screen
   CLEAR
   DO Dstatus
   DO Backgrnd
   DO Show_data

   DO Bar_def            && Define popup menus

   * Activate main popup menu - execute user choices
   SET COLOR TO &c_popup.
   ACTIVATE POPUP main_mnu
   DO Sub_ret
   *
RETURN


*  UTILITY PROCEDURES (Proprietary to Cust.prg)

PROCEDURE Filter
  * Filter (group) data into subset
  * Select subset to set up filter condition  (Y=turn on, N=abort selection, 
  * T=turn off) If filter is already on, set default choice to T, show 
  * window. If filter is not on, set default choice to Y, show window. 
  choice = IIF(filters_on,"T","Y")
  DO Filt_ans
  IF choice = "Y"
     * Start process of choosing filter condition
     mcategory = SPACE(15)
     mcity     = SPACE(20)
     mstate    = SPACE(2)
     STORE SPACE(10) TO mzip, mterms
     ACTIVATE WINDOW alert
        * Get user's filter condition selection(s)
        @  0, 0 SAY "--------- ENTER FILTER CONDITION --------"
        @  1, 0 SAY "CATEGORY:" GET mcategory FUNCTION "!" ;
           MESSAGE "Enter a customer category"
        @  2, 0 SAY "CITY:    " GET mcity     PICTURE "!XXXXXXXXXXXXXXXXXXX"
        @  3, 0 SAY "STATE:   " GET mstate    PICTURE  "!!"
        @  3,15 SAY "ZIP: "     GET mzip
        @  4, 0 SAY "TERMS:   " GET mterms    FUNCTION "!"
        @  5, 0 SAY "Enter one or more filter conditions"
        READ
    DEACTIVATE WINDOW alert
    subset = " "          && Initialize filter condition variable to null
    * Process user's entries to build filter condition
    mcategory = TRIM(mcategory)
    mcity   = UPPER(TRIM(mcity))
    mstate  = TRIM(mstate)
    mzip    = TRIM(mzip)
    mterms  = TRIM(mterms)
    subset  = subset + IIF("" <> mcategory, ;
              [category = mcategory .AND. ], "")
    subset  = subset + IIF("" <> mcity, ;
              [UPPER(TRIM(city)) = mcity .AND. ], "")
    subset  = subset + IIF("" <> mstate, ;
              [state = mstate .AND. ], "")
    subset  = subset + IIF("" <> mzip, ;
              [zip = mzip .AND. ], "")
    subset  = subset + IIF("" <> mterms, ;
              [terms = mterms .AND. ], "")
    *
    IF "" = TRIM(subset)    && Check whether data entered into subset string
       DO Warnbell
       filters_on = .F.
    ELSE
       * If string is not empty, truncate the .AND. from end of subset string
       subset = SUBSTR(subset,1,LEN(subset)-6)
       SET FILTER TO &subset.     && Filter on entered filter string condition
       GO TOP                     && Activate filter by moving record pointer
       * Check whether filter condition matches any records (no match=EOF)
       filters_on = .NOT. EOF()   && Filter is turned on if .T. 
       IF .NOT. filters_on        && Turn off filter if no matches found
          DO Warnbell
          DO Show_msg WITH "No Customer records match the filter condition"
          SET FILTER TO
          GO record_num
       ENDIF
    ENDIF
  ELSE
      IF choice = "T"
         * If user selects "T", turn off filter
         SET FILTER TO
         filters_on = .F.
      ENDIF
  ENDIF
RETURN

PROCEDURE Indexer
   * Create/rebuild index
   INDEX ON cust_id TAG Cust_id
   GO TOP
RETURN

PROCEDURE Init_fld
   * Initialize memory variable values for data entry
   STORE SPACE(30) TO customer, address1
   STORE SPACE(20) TO city, contact, comments
   STORE SPACE(10) TO zip, terms
   STORE SPACE(13) TO phone, phone_cont
   state     = "TX"                     && Could be any state or blank
   cust_id   = SPACE(6)
   category  = SPACE(15)
   address2  = SPACE(25)
   phone_ext = SPACE(4)
   date_last = { / / }
RETURN

PROCEDURE Load_fld
   * Load field values from Cust database record into memory variables
   cust_id    = cust_id
   category   = category
   customer   = customer
   address1   = address1
   address2   = address2
   city       = city
   state      = state
   zip        = zip
   phone      = phone
   contact    = contact
   phone_cont = phone_cont
   phone_ext  = phone_ext
   date_last  = date_last
   terms      = terms
   comments   = comments
RETURN

PROCEDURE Repl_fld
   * Replace database fields with values of current memory variables
   REPLACE cust_id WITH m->cust_id, category WITH m->category, ;
           customer WITH m->customer,address1 WITH m->address1, ;
           address2 WITH m->address2,city WITH m->city, state WITH m->state
   REPLACE zip WITH m->zip, phone WITH m->phone,;
           contact WITH m->contact,phone_cont WITH m->phone_cont,;
           phone_ext WITH m->phone_ext,date_last WITH m->date_last, ;
           terms WITH m->terms,comments WITH m->comments
RETURN

PROCEDURE Backgrnd
   * Display background screen
   * Draw and fill in boxes
   @  1,18 TO  3,41 DOUBLE COLOR &c_blue.
   @  5, 2 TO  7,56 DOUBLE COLOR &c_red.
   @  2,19 FILL TO  2,40   COLOR &c_blue.
   @  6, 3 FILL TO  6,55   COLOR &c_red.
   @  9, 3 FILL TO 19,55   COLOR &c_red.
   @ 15, 2 TO 15,56        COLOR &c_red.
   @  8, 2 TO 20,56        COLOR &c_red.
   SET COLOR TO &c_data.
   @  2,20 SAY "CUSTOMER  DATABASE"
   @  6, 4 SAY "CUSTOMER NO:"
   @  6,30 SAY "CATEGORY:"
   @  9, 4 SAY "NAME:"
   @ 10, 4 SAY "ADDRESS:"
   @ 12, 4 SAY "CITY:"
   @ 13, 4 SAY "STATE:"
   @ 13,16 SAY "ZIP:"
   @ 14, 4 SAY "PHONE:"
   @ 16, 4 SAY "CONTACT:"
   @ 17, 4 SAY "PHONE:"
   @ 17,27 SAY "EXTENSION:"
   @ 18, 4 SAY "LAST CONTACT DATE:"
   @ 19, 4 SAY "TERMS:"
   @ 19,27 SAY "COMMENT:"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Show_data
   * Display data for entry
   SET COLOR TO &c_fields.
   @  6,17 SAY cust_id
   @  6,40 SAY category
   @  9,13 SAY customer
   @ 10,13 SAY address1
   @ 11,13 SAY address2
   @ 12,13 SAY city
   @ 13,13 SAY state
   @ 13,21 SAY zip
   @ 14,13 SAY phone
   @ 16,13 SAY contact
   @ 17,13 SAY phone_cont
   @ 17,38 SAY phone_ext
   @ 18,23 SAY date_last
   @ 19,13 SAY terms
   @ 19,36 SAY comments
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Get_data
   * Display data for entry
   SET COLOR TO &c_data.
   @  6,17 GET m->cust_id   PICTURE  "!99999" ;
           VALID Duplicat(&key.) ;
           ERROR "Invalid customer ID number; please re-enter" ;
           MESSAGE "Enter a six digit customer ID beginning " + ;
                   "with a letter, or Esc to quit"
   @  6,40 GET m->category ;
           PICTURE "@M ARCHITECTS, CONSULTANTS, CONTRACTORS, LEGAL" ;
           MESSAGE "Press spacebar for Category choices"
   @  9,13 GET m->customer  FUNCTION "!" ;
           MESSAGE "Enter name of customer"
   @ 10,13 GET m->address1
   @ 11,13 GET m->address2
   @ 12,13 GET m->city       PICTURE "!XXXXXXXXXXXXX"
   @ 13,13 GET m->state      PICTURE  "!!"
   @ 13,21 GET m->zip
   @ 14,13 GET m->phone      PICTURE  "(999)999-9999"
   @ 16,13 GET m->contact    FUNCTION "!" ;
           MESSAGE "Enter name of contact"
   @ 17,13 GET m->phone_cont PICTURE "(999)999-9999"
   @ 17,38 GET m->phone_ext  PICTURE "9999" ;
           MESSAGE "Enter phone extension"
   @ 18,23 GET m->date_last  FUNCTION "D" ;
           MESSAGE "Enter date that customer was last contacted"
   @ 19,13 GET m->terms      PICTURE "@M CASH, NET 30, NET 45" ;
           MESSAGE "Press spacebar to see Terms choices"
   @ 19,36 GET m->comments   FUNCTION "!" ;
           MESSAGE "Enter any comments"
   SET COLOR TO &c_standard.
   ON KEY LABEL F9 DO Findcode WITH m->city
RETURN
********************************  END OF CUST.PRG ****************************
