* Program............: cust.FRG
* Date...............: 6-22-94
* Versions...........: dBASE 5.0, Report
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap, ll_heading, ll_temp, ll_toprint
ll_heading = .F.
ll_toprint = (SET("PRINTER") = "ON")

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < (_pspacing * 3 + 1) + (_pspacing + 1) + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing

*-- Initialize group footer field variables
r_foot1=.F.


*-- Set up procedure for page break
gn_atline=_plength - (_pspacing + 1)
ON PAGE AT LINE gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

*-- Initialize group break vars.
r_mvar4=CATEGORY

*-- Initialize summary variables.
cust_cnt=0
r_msum1=0

IF gl_plain
   ON PAGE AT LINE gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE gn_atline DO Pgfoot
ENDIF

DO Pghead

gl_fandl=.T.        && first physical page started

DO Rintro

DO Grphead

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. gl_prntflg
   DO CASE
   CASE CATEGORY <> r_mvar4
      gn_level=4
   OTHERWISE
      gn_level=0
   ENDCASE
   *-- test whether an expression didn't match
   IF gn_level <> 0
      DO Grpfoot WITH 100-gn_level
      DO Grpinit
   ENDIF
   *-- Repeat group intros
   IF gn_level <> 0
      DO Grphead
   ENDIF
   gn_level=0
   *-- Detail lines
   IF gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF gl_prntflg
   gn_level=3
   DO Grpfoot WITH 97
   DO Rsumm
   IF _plineno <= gn_atline
      EJECT PAGE
   ENDIF
ELSE
   gn_level=3
   DO Rsumm
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: cust.FRG

*-- Determine height of group bands and detail band for widow checking
FUNCTION Gheight
PARAMETER Group_Band
retval=0              && return value
IF Group_Band <= 4
   retval = retval + 2 * gn_pspace
ENDIF
*-- add height of detail band
retval = retval + 8 * gn_pspace
RETURN retval
* EOP: Gheight

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
r_foot1=Category
*-- Count
cust_cnt=cust_cnt+1
*-- Count
r_msum1=r_msum1+1
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort

*-- Reset group break variables.  Reinit summary
*-- fields with reset set to a particular group band.
PROCEDURE Grpinit
IF gn_level <= 4
   cust_cnt=0
ENDIF
IF gn_level <= 4
   r_mvar4=CATEGORY
ENDIF
RETURN
* EOP: Grpinit

*-- Process Group Intro bands during group breaks
PROCEDURE Grphead
IF EOF()
   RETURN
ENDIF
PRIVATE _pspacing
_pspacing=gn_pspace
IF gn_level = 0
   gn_level=50
ENDIF
IF gn_level = 4
   IF 2 * gn_pspace  < gn_atline
      IF (gl_widow .AND. _plineno+Gheight(4) > gn_atline + 1) ;
      .OR. (gl_widow .AND. _plineno+2 * gn_pspace > gn_atline)
         EJECT PAGE
      ENDIF
   ENDIF
ENDIF
IF gn_level <= 4
   DO Head4
ENDIF
gn_level=0
RETURN
* EOP: Grphead.PRG

*-- Process Group Summary bands during group breaks
PROCEDURE Grpfoot
PARAMETER ln_level
IF ln_level >= 96
   DO Foot96
ENDIF
RETURN
* EOP: Grpfoot.PRG

PROCEDURE Pghead
?? IIF(gl_plain,'',gd_date) AT 0,;
 IIF(gl_plain,'' , "PAGE " ) AT 71,;
 IIF(gl_plain,'',_pageno) PICTURE "999" 
?
?
?
RETURN
* EOP: Pghead

PROCEDURE Rintro
?
DEFINE BOX FROM 26 TO 55 HEIGHT 4 DOUBLE
?
?? "A-T FURNITURE INDUSTRIES" STYLE "B" AT 29
?
?? "CUSTOMER REPORT" STYLE "B" AT 33
?
?
?
?
RETURN
* EOP: Rintro

PROCEDURE Head4
IF gn_level=1
   RETURN
ENDIF
?? ;
"";
+ "";
AT 0
?
?? "CATEGORY:" STYLE "BU" AT 0,;
 Category FUNCTION "T" STYLE "BU" AT 10
?
RETURN

PROCEDURE __Detail
IF 8 * gn_pspace < gn_atline - (_pspacing * 3 + 1)
   IF gl_widow .AND. _plineno+8 * gn_pspace > gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?? "I.D.: " AT 0,;
 Cust_id FUNCTION "T" PICTURE "!XXXXX" 
?
?? Customer FUNCTION "T" AT 0,;
 Phone FUNCTION "T" PICTURE "(XXX)XXX-XXXX" AT 46
?
?? Address1 FUNCTION "T" AT 0,;
 " " ,;
 Address2 FUNCTION "T" 
?
?? City FUNCTION "T" AT 0,;
 ", " ,;
 State FUNCTION "T" ,;
 " " ,;
 Zip FUNCTION "T" 
?
?? "CONTACT:" AT 0,;
 Contact FUNCTION "T" AT 9,;
 Phone_cont FUNCTION "T" PICTURE "(XXX)XXX-XXXX" AT 46,;
 "EXT." AT 62,;
 Phone_ext FUNCTION "T" AT 67
?
?? "DATE OF LAST CONTACT: " AT 0,;
 Date_last 
?
?? Comments FUNCTION "T" AT 0
?
?
RETURN
* EOP: __Detail

PROCEDURE Foot96
?? "NUMBER OF CUSTOMERS IN " AT 0,;
 r_foot1 FUNCTION "T" ,;
 ": " ,;
 cust_cnt PICTURE "9999" 
?
?
RETURN

PROCEDURE Rsumm
?
?? ;
"";
+ "";
AT 0
?
?? "TOTAL NUMBER OF CUSTOMERS: " AT 0,;
 r_msum1 PICTURE "9999" 
?
?? ;
"";
+ "";
AT 0
gl_fandl=.F.        && last page finished
?
RETURN
* EOP: Rsumm

PROCEDURE Pgfoot
PRIVATE _box, _pspacing
gl_widow=.F.         && disable widow checking
_pspacing=1
?
IF .NOT. gl_plain
   _pspacing=gn_pspace
   ?? " PREPARED BY SALES DEPARTMENT" AT 25
ENDIF
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
IF .NOT. gl_plain .AND. gl_fandl
   _pspacing=gn_pspace
   DO Pghead
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset

