******************************************************************************
* PROGRAM NAME: ACCT_REC.PRG
*               ACCOUNTS RECEIVABLE DATABASE SCREEN
*               SAMPLE BUSINESS APPLICATION PROGRAM
* LAST CHANGED: 09/25/89 09:25AM
* WRITTEN BY:   Borland International Inc.
******************************************************************************
*
*       FILES USED:
*       Database file       =  Acct_rec.dbf  (Accounts receivable file)
*       Index file          =  Acct_rec.mdx
*          TAGS: Invoice_no =  invoice_no  <= Master index
*                Oldbalance =  oldbalance
*                Cust_id    =  cust_id
*       External procedure file = Library.prg
******************************************************************************

* Main procedure
PROCEDURE Acct_rec

   * Link to external procedure file of "tool" procedures
   SET PROCEDURE TO Library

   * Set up database environment
   DO Set_env

   SET COLOR TO &c_standard.

   * Declare variables used:
   * Database memory variables
   STORE "" TO invoice_no, cust_id, comments, notes, invoice_no, invoic_old
   STORE 0  TO amt_of_cur, amt_cur_pd, amt_of_bil, amt_lstbil
   STORE 0  TO amt_lst_pd, oldbalance
   STORE {} TO dat_of_bil, dat_lstbil

   * Miscellaneous variables - used to pass parameters to Library
   dbf      = "ACCT_REC"                 && Standard report is available
   mlist    = "NOT AVAILABLE"            && No mailing list available
   cust_rpt = "N/A"                      && No custom reports available
   STORE "m->invoice_no" TO key, key1
   STORE "NONE" TO key2, key3
   keyname1 = "Invoice #:"
   STORE "" TO keyname2, keyname3
   list_flds = "INVOICE_NO, CUST_ID, DAT_OF_BIL, AMT_OF_BIL, OLDBALANCE"
   STORE 0 TO balance, age

   * Open database files and choose active indexes
   SELECT 1
   USE Acct_rec ORDER Invoice_no
   USE Cust     ORDER Cust_id IN 2
   SET RELATION TO cust_id INTO Cust
   GO TOP

   record_num = RECNO()
   * Load initial record from database into memory variables
   DO Load_fld

   * Show data screen
   CLEAR
   DO Dstatus
   DO Backgrnd
   DO Show_data

   * Define popup menus
   DO Bar_def

   * Activate main popup menu - execute user choices
   SET COLOR TO &c_popup.
   ACTIVATE POPUP main_mnu
   DO Sub_ret
   *
RETURN
*** END MAIN PROCEDURE ****************************************************

*  UTILITY PROCEDURES (Proprietary to Acct_rec.prg)

PROCEDURE Indexer
   * Create/rebuild indexes
   INDEX ON oldbalance TAG Oldbalance
   INDEX ON cust_id    TAG Cust_id
   INDEX ON invoice_no TAG Invoice_no
   GO TOP
RETURN

PROCEDURE Init_fld
   * Initialize memory variable values for data entry
   STORE SPACE(10) TO invoice_no, invoic_old
   cust_id = SPACE(6)
   STORE 0 TO amt_of_cur, amt_of_bil, amt_lstbil, amt_lst_pd
   STORE SPACE(30) TO comments, notes
   STORE {  /  /  } TO dat_of_bil, dat_lstbil
RETURN

PROCEDURE Load_fld
   * Load field values from Acct_rec database record into memory variables
   invoice_no = invoice_no
   cust_id    = cust_id
   amt_of_cur = amt_of_cur
   amt_cur_pd = amt_cur_pd
   dat_of_bil = dat_of_bil
   amt_of_bil = amt_of_bil
   comments   = comments
   notes      = notes
   dat_lstbil = dat_lstbil
   amt_lstbil = amt_lstbil
   amt_lst_pd = amt_lst_pd
   oldbalance = oldbalance
   invoic_old = invoic_old
RETURN

PROCEDURE Repl_fld
   * Replace database fields with values of current memory variables
   REPLACE invoice_no WITH m->invoice_no, cust_id WITH m->cust_id,;
           amt_of_cur WITH m->amt_of_cur, dat_of_bil WITH m->dat_of_bil,;
           amt_of_bil WITH m->amt_of_bil, comments WITH m->comments
   REPLACE notes WITH m->notes, dat_lstbil WITH m->dat_lstbil,;
           amt_lstbil WITH m->amt_lstbil, amt_lst_pd WITH m->amt_lst_pd,;
           invoic_old WITH m->invoic_old, oldbalance WITH m->oldbalance,;
           amt_cur_pd WITH m->amt_cur_pd
RETURN

PROCEDURE Backgrnd
   * Show background screen
   * Draw and fill in boxes
   @  1,18 TO  3,41 DOUBLE COLOR &c_blue.
   @  5, 1 TO  7,56 DOUBLE COLOR &c_red.
   @  2,19 FILL TO  2,40   COLOR &c_red.
   @  6, 2 FILL TO  6,55   COLOR &c_red.
   @  9, 2 FILL TO 20,55   COLOR &c_red.
   @ 10, 1 TO 10,56        COLOR &c_red.
   @ 18, 1 TO 18,56        COLOR &c_red.
   @  8, 1 TO 21,56        COLOR &c_red.
   SET COLOR TO &c_data.
   @  2,20 SAY "ACCT. REC. DATABASE"
   @  6, 3 SAY "INVOICE NO.:"
   @  6,28 SAY "BILLING DATE:"
   @  9, 3 SAY "CUSTOMER NO.:"
   @ 11, 3 SAY "-- LAST INVOICE --"
   @ 12, 3 SAY "NUMBER:"
   @ 13, 3 SAY "DATE:"
   @ 14, 3 SAY "AGE:"
   @ 11,28 SAY "--------- AMOUNTS ---------"
   @ 12,28 SAY "LAST BILL      $"
   @ 14,16 SAY "days"
   @ 13,28 SAY "LAST PAID      $"
   @ 14,28 SAY "OLD  BALANCE   $"
   @ 15,28 SAY "CURRENT ORDERS $"
   @ 16,45 SAY "=========="
   @ 17, 3 SAY "CURRENT PMT.$"
   @ 17,28 SAY "CURRENT BILL$"
   @ 19, 3 SAY "COMMENT:"
   @ 20, 3 SAY "NOTE:"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Show_data
   * Show screen for data entry
   * Calculate temporary data
   * Old balance = amount last billed less amount last paid
   oldbalance = amt_lstbil - amt_lst_pd
   * Amount of this bill is oldbalance plus amount of current purchases
   amt_of_bil = oldbalance + amt_of_cur
   * Aging if a balance is outstanding: today's date less date of last bill
   age = IIF(oldbalance > 0, DATE() - dat_lstbil, 0)
   *
   SET COLOR TO &c_fields.
   @  6,16 SAY invoice_no
   @  6,42 SAY dat_of_bil
   @  9,17 SAY cust_id
   @  9,24 SAY Cust->customer COLOR &c_yelowhit.
   @ 12,11 SAY invoic_old
   @ 13,11 SAY dat_lstbil
   * Set colors to show levels of aging of old balance
   age_color = "W"                     && Monochrome monitor
   IF ISCOLOR()                        && Color monitor
      DO CASE
         CASE m->age >= 60
            age_color = c_red          && Red for danger
         CASE m->age >= 45
            age_color = c_yellow       && Yellow for caution
         OTHERWISE
            age_color = c_green        && Green - OK
      ENDCASE
   ENDIF
   @ 12,45 SAY amt_lstbil PICTURE "999,999.99"
   @ 14,12 SAY m->age PICTURE "999" COLOR &age_color.
   @ 13,45 SAY amt_lst_pd PICTURE "999,999.99"
   bal_color = "W"                     && Monochrome monitor
   IF ISCOLOR()                        && Color monitor
      DO CASE
         * Set color to show level of balance due from last bill
         CASE oldbalance >= 1000
            bal_color = c_red          && Red for danger
         CASE oldbalance >= 100
            bal_color = c_yelowhit     && Yellow for caution
         OTHERWISE
            bal_color = c_green        && Green - OK
      ENDCASE
   ENDIF
   @ 14,45 SAY m->oldbalance      PICTURE "999,999.99" COLOR &bal_color.
   @ 15,45 SAY amt_of_cur PICTURE "999,999.99"
   @ 17,17 SAY amt_cur_pd PICTURE "999,999.99"
   @ 17,45 SAY  m->amt_of_bil     PICTURE "999,999.99" COLOR &c_yelowhit.
   @ 19,12 SAY comments
   @ 20,12 SAY notes
   IF ISCOLOR()
      @ 22,1 SAY "Yellow text/numbers from related database file or calc. " ;
             COLOR &c_yelowhit.
   ELSE
      @ 22,1 SAY "Dim text/numbers from related database or calc." ;
             COLOR &c_red.
   ENDIF
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Get_data
   SET COLOR TO &c_data.
   @  6,16 GET m->invoice_no ;
               VALID Duplicat(m->invoice_no) ;
               ERROR "Duplicate invoice number; please re-enter" ;
               MESSAGE "Enter a valid invoice number " + ;
                       "(customer ID + year + month)"
   @  6,42 GET m->dat_of_bil
   @  9,17 GET m->cust_id PICTURE  "!XXXXX" ;
               VALID Lookupid((m->cust_id), "Cust", "Customer", 2) ;
               ERROR "Invalid customer ID number, please re-enter" ;
               MESSAGE "Enter a customer ID number (starting with a " + ;
                       "letter), or Esc to quit"
   IF .NOT. PROMPT() = " Add record"
      @ 9,24 SAY Cust->customer COLOR &c_yelowhit.
   ELSE
      @ 9,24 SAY SPACE(30)             && Erase customer name when in Add mode
   ENDIF
   @ 12,11 GET m->invoic_old
   @ 13,11 GET m->dat_lstbil FUNCTION "D"
   @ 12,45 GET m->amt_lstbil PICTURE "999,999.99"
   @ 13,45 GET m->amt_lst_pd PICTURE "999,999.99"
   @ 15,45 GET m->amt_of_cur PICTURE "999,999.99"
   @ 17,17 GET m->amt_cur_pd PICTURE "999,999.99"
   @ 19,12 GET m->comments   FUNCTION "!"
   @ 20,12 GET m->notes      FUNCTION "!"
   IF ISCOLOR()
      @ 22,1 SAY "Yellow text/numbers from related database file or calc. " ;
             COLOR &c_yelowhit.
   ELSE
      @ 22,1 SAY "Dim text/numbers from related database or calc." ;
             COLOR &c_red.
   ENDIF
   SET COLOR TO &c_standard.
   ON KEY LABEL F9 DO Findcust WITH m->cust_id
RETURN

*** END ACCT_REC.PRG *********************************************************

