;             This file is part of the ZRDX 0.50 project
;                     (C) 1998, Sergey Belyakov

LXHeader STRUC
LXSign          DW ?
LXBOrd          DB ?
LXWOrd          DB ?
LXFormatLevel   DD ?
LXCPUType       DW ?
LXOsType        DW ?
LXModuleVersion DD ?
LXModuleFlags   DD ?
LXModuleNPages  DD ?
LXEIPObjectN    DD ?
LXEIP           DD ?
LXESPObjectN    DD ?
LXESP           DD ?
LXPageSize      DD ?
LXPageOffShift  DD ?
LXFixupSize     DD ?
LXFixupCHS      DD ?
LXLoaderSize    DD ?
LXLoaderCHS     DD ?
LXObjTblOff     DD ?
LXObjN          DD ?
LXObjPageTblOff DD ?
LXObjIterPageOff DD ?
LXResTableOff   DD ?
LXResTableN     DD ?
LXResidTblOff   DD ?
LX???           DD ?
LXModDirectOff  DD ?
LXModDirectN    DD ?
LXFixPageTblOff DD ?
LXFixRecTblOff  DD ?
LXImportModOff  DD ?
LXImportModN    DD ?
LXImportProcOff DD ?
LXPageCHSOff    DD ?
LXDataPagesOff  DD ?
LXPreloadPagesN DD ?
LXNonResNameOff DD ?
LXNonResNameLen DD ?
LXNonResNameCHS DD ?
LXAutoDSObjN    DD ?
LXDebugOff      DD ?
LXDebugLen      DD ?
LXInstPreloadN  DD ?
LXInstDemandN   DD ?
LXHeapSize      DD ?
LXStackSize     DD ?
        ENDS
;local object table, generated by loader
ObjExtTableS Struc
LOTBase      DD ?
LOTSelector  DW ?
LOTRes       DW ?      ;reserved for aligment
             Ends
ObjTableS Struc
OTSize   DD ?
OTReloc  DD ?
OTFlags  DD ?
OTPage   DD ?
OTNPages DD ?
OTReserv DD ?
         Ends

VSegm IEBSS
DFD LoaderStack, 400
DFL LoaderStackEnd
DFB Header, 0C0h

DFD ObjectsTable
DFD PageTable
DFD FixupPageTable
DFD FixupTable
DFD DataSize
DFD MemHandler
DFD ObjTable
DFD ObjPageTable
DFD FixupRecordTable
DFD ObjectsExtTable
DFD LinAddress      ;DD Header
;DFD LinAddress1
DFD NextPageFixup   ;Pointer to fixup for next page - limit for current page
DFD PageIndex       ;absolute index of current page
DFD MaxPageIndex    ;page index limit for current object
DFD HeaderAddress
DFD TaskSize
DFD LoaderMemHandle
DFD PageLoadAddress
DFD LocalTablePtr
DFD ObjTablePtr
DFD SrcBase
DFD PageCount
DFD FixPageTablePtr
DFD NextPagePtr
EVseg IEBSS
Segm IEData
LDWord lSavedPSP
       DD 0
;LDWord LoaderCodeMemHandle
;       DD 0
;LDWord ExtenderSel
;       DD 0
DefaultFlatSelectors DW 16 dup(0)
ESeg IEData
Segm IEText
assume ds:nothing, cs:IETextG, ss:LGroup
;assume ds:nothing, cs:IETextG, ss:nothing
DPMICall PROC C
        USES ecx, edi
        mov  ecx, ebx
        shr  ebx, 16
        mov  edi, esi
        shr  esi, 16
        int  31h
        $ifnot jc
          shl  ebx, 16
          mov  bx, cx
          shl  esi, 16
          or   si, di   ;this instruction clear CF instead of "mov si, di"
          ;clc
        $endif
        ret
        ENDP
Loader PROC

@@DefLDErr MACRO ErrLabel, ErrMsg, NoJmp
      Segm IEData
      @@LDErrM = $
LLabel ErrLabel&EM
      DB ErrMsg
      ESeg IEData
      ErrLabel:
      mov edi, offset LGroup:@@LDErrM
      jmp short @@DispLDError
      ENDM
      @@DefLDErr  ErrNoDPMIMemory,'out of DPMI memory$'
      @@DefLDErr  @@ErrFile        ,"can't read EXE file$"
      @@DefLDErr  @@ErrEXE         ,'bad EXE format$'
      @@DefLDErr  @@ErrUnsupportedFixup,'unsupported fixup record$'
      @@DefLDErr  ErrAllocSel      ,"can't allocate selector$"
      @@DefLDErr  ErrLock          ,"can't lock extender$"
      @@DefLDErr  @@ErrTransferBuf,"can't allocate transfer buffer$"
Segm IEData
LLabel LoadErrMsg
        DB 'ZRDX loader error: $'
LoadErrMsg1 DB 13, 10, '$'
ESeg IEData
@@DispLDError:
        push ss
        pop  ds
        mov  ah, 9
        mov  edx, offset LGroup:LoadErrMsg
        int  21h
        mov  edx, edi
        int  21h
        mov  edx, offset LGroup:LoadErrMsg1
        int  21h
        mov  ax, 4CFFh
        int  21h

DOSINT MACRO TT
        int 21h
        ;pushfd
        ;call far ptr int21entry
        ENDM
LoaderEntry:
        mov  edi, esp
        push ss
        pop  es
        and  dword ptr es:[edi].DC_SP, 0
        mov  byte ptr es:[edi].DC_EAX[1], 4Ah
        mov  ax, seg dgroup16
        sub  eax, 10h
        mov  word ptr es:[edi].DC_ES, ax
        mov  word ptr es:[edi].DC_EBX, MouseRHandlerPSize+10h
        org  $-2
LLabel MemBlock0Size
        DW   MouseRHandlerPSize+10h
        pushfd
        pop  eax
        mov  word ptr es:[edi].DC_Flags, ax
        mov  bx, 21h
        mov  ax, 300h
        int  31h
        mov  bx, 0
        org  $-2
;LLabel  TransferBufferPSize
        DW   0
LLabel PatchPointTStSz
        mov  ax, 100h
        int  31h
        $ifnot jnc
          cmp  bx, 100h
          jb   @@ErrTransferBuf
          mov  ax, 100h
          int  31h
          jc   @@ErrTransferBuf
        $endif
        movzx ebx, bx
        shl  ebx, 4
        add  ds:TransferStack, ebx
        add  ds:TransferDTA, ebx
        mov  ds:TransferSelector, dx
        mov  gs, edx
        mov  ds:TransferSegment, ax
        mov  dx, offset OffDefaultDTA
        mov  ah, 1Ah
        int  21h

        ;int 3

        ;---- setup exception handlers -------
        mov  ecx, ebp                ;extender code selector
        mov  dx, OffExc3Handler
        mov  bl, 3
        mov  ax, 203h
        int  31h
        mov  dx, OffExc0Handler
        mov  bl, 0
        mov  ax, 203h
        int  31h
        mov  dx, offset EGroup:ExceptionHandler
        mov  di, 10111111b
        $do
          shr  edi, 1
          $ifnot jc
            mov  ax, 203h
            int  31h
            add  edx, 4
          $endif
          inc  ebx
          cmp  bl, 16
        $enddo jb
        push ds
        push fs
        pop  ds
        pop  fs
IFNDEF Release
        ;jmp $
ENDIF
LoaderDbgEntry:
        mov  ebp, OffHeader
        push ss
        push ebp
        push 0
        push 040h                 ; size of Header
        call FileRead             ;read LE header to IEBSS
        cmp  al, 040h
        jne  @@ErrFile
        mov  eax, dword ptr [ebp][3Ch]
HeaderBase EQU ss:[ebp]
        mov  ss:FileDisp, eax
        push ss
        push ebp
        push 0
        push 0C0h  ; size Header
        call FileRead             ;read LE header to IEBSS
        cmp  al, 0C0h
        jne  @@ErrFile
        cmp  word ptr HeaderBase, 'EL'
        jne  @@ErrEXE
        imul  ebx, HeaderBase.LXObjN, size ObjTableS
        push ebx                      ;calculate size of internal object table
        mov  ax, 501h
        call DPMICall            ;allocate space for object table;
        jc   ErrNoDPMIMemory
        pop  edx
        ;ca
        push ds ;ss:lFlatSelector
        push ebx
        push HeaderBase.LXObjTblOff
        push edx
        call FileRead            ;read object table from file
        cmp  eax, edx
        jne  @@ErrFile
        ;call XX
        mov  ecx, HeaderBase.LXObjN
        xor  edi, edi
        mov  edx, edi
;뢠 騩 ꥬ     樠஢ 墮, 
; 
;edx -  
;esi - 樠஢ 墮
        $do
          mov  eax, [ebx].OTSize
          add  eax, 4095
          shr  eax, 12                ; ꥪ  ࠭
          cmp  [ebx].OTNPages, 0      ;ꥪ  ᮤন 樠஢  ࠭
                                      ;     楫  ?
          $ifnot je
            mov  edi, [ebx].OTNPages
            neg  edi
          $endif
          add  edi, eax
          add  edx, eax
          add  ebx, size ObjTableS
        $enddo loop
        shl  edx, 12                 ;convert size in pages to bytes
        mov  ss:TaskSize, edx        ;save it for future use

        mov  ebx, edx
        mov  ax, 503h

        call DPMICall             ;reallocate all memory for application
        jc   ErrNoDPMIMemory
        mov  fs:ImageBaseAddr, ebx ;save it linear address for future
        push ebx

        ;--------------clear all memory------------------
        mov edi, ebx
        mov ecx, ss:TaskSize
        shr ecx, 2
        xor eax, eax
        push es
        push ds
        pop  es
        rep stosd
        pop  es
        mov  ebx, HeaderBase.LXObjN
        mov  edi, HeaderBase.LXFixPageTblOff
        add  edi, HeaderBase.LXFixupSize
        lea  ebx, [edi+ebx*8]         ;loader + local ot
        mov  ax, 501h
        call DPMICall                 ;allocate memory for header
        jc   ErrNoDPMIMemory
        mov  ss:LoaderMemHandle, esi  ;save handle for free
        mov  ss:ObjTablePtr, ebx      ;object table shall be first
        push ds ;ss:lFlatSelector
        push ebx
        push HeaderBase.LXObjTblOff
        xchg eax, edi                ;loader size -> eax
        push eax
        add  eax, ebx
        mov  ss:LocalTablePtr, eax
        sub  ebx, HeaderBase.LXObjTblOff
        mov  ss:HeaderAddress, ebx  ;virtual address of header start in memory
        call FileRead               ;read loader
        @@RelocReg     EQU esi
        pop  @@RelocReg     ;fs:ImageBaseAddr
        push -1       ;ObjectIndex
        $do jmp
          push eax
          @@PageTblReg   EQU edx
          @@ObjectPtrReg EQU eax
          @@PageLoadAddress EQU edi
          mov  edx, ss:LocalTablePtr
          mov  ds:[edx+eax*8].LOTBase, @@RelocReg
          mov  ds:[edx+eax*8].LOTSelector, 0  ;selector is undefined
          mov  @@PageLoadAddress, @@RelocReg ;address to object load
          imul eax, size ObjTableS
          add  eax, HeaderBase.LXObjTblOff
          add  eax, ss:HeaderAddress
          mov  edx, [eax].OTSize    ;load full object size
          add  edx, 0FFFh           ;align it on page boundary
          and  dx,  0F000h
          add  @@RelocReg, edx
          mov  ecx, [@@ObjectPtrReg].OTNPages ;number of initialized pages in file
          mov  @@PageTblReg, [@@ObjectPtrReg].OTPage
          dec  @@PageTblReg
          shl  @@PageTblReg, 2
          add  @@PageTblReg, HeaderBase.LXObjPageTblOff
          add  @@PageTblReg, ss:HeaderAddress
          $ifnot jecxz
          $do
            movzx eax, byte ptr [@@PageTblReg].2
            mov  ah, [@@PageTblReg].1
            dec  eax
            js   @@ErrEXE ;XXX
            shl  eax, 12
            add  eax, HeaderBase.LXDataPagesOff
            push @@PageLoadAddress
            add  @@PageLoadAddress, 1000h
            push eax
            push 1000h
            call PreRead
            add  @@PageTblReg, 4
          $enddo loop
          $endif
        $while
          pop  eax
          inc  eax
          cmp  eax, HeaderBase.LXObjN
        $loop jb
        $enddo
        call ReadFlush
;ProceedFixups PROC

@@BaseTableReg   EQU ebx
@@FixupPtrReg    EQU esi
;FixupEnd
@@FlagsReg       EQU eax
@@FlagsWReg      EQU ax
@@FlagsLoReg     EQU al
@@FlagsHiReg     EQU ah
@@ObjIndexReg    EQU edx
@@ObjIndexHiReg  EQU dh
@@SrcOffReg      EQU ecx
@@SrcTagReg      EQU eax
@@SrcTagWReg     EQU ax
@@SrcTagBReg     EQU al
@@FixJmpReg      EQU edi

        ;Proceed fixups
        ;mov edx, offset LGroup:FixMsg
        ;DOSMSG
        mov  @@BaseTableReg, ss:LocalTablePtr
        xor  @@ObjIndexReg, @@ObjIndexReg
;Prepare to object loop
        $do
          cmp  @@ObjIndexReg, HeaderBase.LXObjN ;all objects complete ?
          $break jae                           ;break if yes
          ;mov  eax, [@@ObjIndexReg*8+@@BaseTableReg].LOTBase
          ;mov  ss:SrcBase, eax               ;save linear address of current object
          push @@ObjIndexReg
          push [@@ObjIndexReg*8+@@BaseTableReg].LOTBase    ;SrcBase
          F = 0
          imul @@ObjIndexReg, size ObjTableS
          add  @@ObjIndexReg, ss:ObjTablePtr
          mov  eax, [@@ObjIndexReg].OTNPages
          inc  eax
          push eax
          ;mov  ss:PageCount, eax
          mov  eax, [@@ObjIndexReg].OTPage
          dec  eax
          shl  eax, 2
          add  eax, HeaderBase.LXFixPageTblOff
          add  eax, ss:HeaderAddress
          ;mov  ss:FixPageTablePtr, eax
          ;push eax
          $do  jmp
    ;Prepare to page loop
            ;mov  eax, ss:FixPageTablePtr
            push @@FixupPtrReg    ;PageCount
            push eax              ;FixPageTablePtr
            F = F + 8
            mov  @@FixupPtrReg, [eax]
            mov  @@SrcOffReg, ss:HeaderAddress
            add  @@SrcOffReg, HeaderBase.LXFixRecTblOff
            add  @@FixupPtrReg, @@SrcOffReg
            mov  eax, [eax].4
            add  eax, @@SrcOffReg
            ;mov  ss:NextPagePtr, eax
            push eax
            F = F + 4
            $do
    BeginFixup:
            cmp  @@FixupPtrReg, ss:[esp] ; ss:NextPagePtr
            $break jae    ;  @@ToNextPage
            mov  @@FlagsWReg, word ptr [@@FixupPtrReg]
            test @@FlagsHiReg, 3             ;fixup type must be 0
            jne  @@ErrUnsupportedFixup
            test @@FlagsLoReg, 20h           ;Source list not supported
            jne  @@ErrUnsupportedFixup
            movsx @@SrcOffReg,   word ptr [@@FixupPtrReg].2 ;get offset of source
            add   @@SrcOffReg, ss:[esp+F] ;SrcBase
                                          ;calc linear address of source
            movzx @@ObjIndexReg, byte ptr [@@FixupPtrReg].4
            test  @@FlagsHiReg, 40h     ;Object index is 16 bit or 8 ?
            $ifnot jz
              mov  @@ObjIndexHiReg, byte ptr [@@FixupPtrReg].5
              inc  @@FixupPtrReg
            $endif
            dec @@ObjIndexReg
                    ;eax - Obj Index
            mov  @@FixJmpReg, @@FlagsReg
            and  @@FixJmpReg, 0Fh
            cmp  @@FixJmpReg, 2
            je   FixSeg
            test @@FlagsHiReg, 10h     ;Target offset is 32 bit ?
            $ifnot jz
            mov  @@SrcTagReg , dword ptr [@@FixupPtrReg].5
            add  @@FixupPtrReg, 9
            jmp  ss:FixJmpTable[@@FixJmpReg*4]
            $endif
            movzx @@SrcTagReg, word ptr [@@FixupPtrReg].5
            add  @@FixupPtrReg, 7
            jmp  ss:FixJmpTable[@@FixJmpReg*4]
            $enddo
            pop  eax            ;drop next_page_ptr
            F = F - 4
    ;To Next Page Increments
            add  dword ptr ss:[esp+F], 1000h  ;Update src_base for next page
            ;add  ss:FixPageTablePtr, 4
            pop  eax
            add  eax, 4     ;FixPageTablePtr
            $while
            pop  @@FixupPtrReg
            dec  @@FixupPtrReg           ;PageCount

          $enddo JNE
  ;To next object increments
          pop  @@ObjIndexReg               ;drop SrcBase
          pop  @@ObjIndexReg
          inc  @@ObjIndexReg
        $enddo Jmp
        ;End Fixup loops

        mov ebx, ss:FileHandle       ;close EXE file
        mov ah, 3Eh
        DOSINT
        mov  edx, ss:LocalTablePtr
        mov  eax, HeaderBase.LXESPObjectN
        dec  eax
        call CreateSelector1
        mov  eax, [eax*8+edx].LOTBase
        add  eax, HeaderBase.LXESP
        push ebx
        push eax
        mov  eax, HeaderBase.LXEIPObjectN
        dec  eax
        call CreateSelector1
        lss  esp, ss:[esp]
        push ebx                     ;cs
        mov  eax, [eax*8+edx].LOTBase
        add  eax, es:Header.LXEIP
        push eax
        mov  ax, 502h    ;free memory
        mov  esi, es:LoaderMemHandle
        call DPMICall
        mov  edi, 0
        org $-4
LDWord LoaderCodeMemHandle
        DD  0
        shld esi, edi, 16
        push 0FFFFh
        org $-4
LDWord ExtenderSel
        DD 0
        push OffStarter
        mov  es,  es:lSavedPSP
        mov  ax, 502h
        xor  ebx, ebx
        mov  ecx, ebx
        mov  edx, ebx
        mov  ebp, ebx
        mov  fs, bx
        push ss
        pop  ds
        retf

CreateSelector01:
        call CreateSelForObject
        jz   ErrAllocSel
CreateSelector1:
        movzx ebx, [eax*8+edx].LOTSelector
        or   ebx,ebx
        jz CreateSelector01
        ret

Segm IEData
FixJmpTable DD Fix8                     ;0
            DD @@ErrUnsupportedFixup    ;1
            DD FixSeg                   ;2
            DD Fix1616                  ;3
            DD @@ErrUnsupportedFixup    ;4
            DD Fix16                    ;5
            DD Fix48                    ;6
            DD Fix32                    ;7
            DD Fix32SR                  ;8
            DD 7 dup(@@ErrUnsupportedFixup) ;9-15
ESeg IEData
Fix8:
        add  @@SrcTagReg, [@@BaseTableReg+@@ObjIndexReg*8].LOTBase
        mov  byte ptr[@@SrcOffReg], @@SrcTagBReg
        jmp  BeginFixup
Fix16:
        add  @@SrcTagReg, [@@BaseTableReg+@@ObjIndexReg*8].LOTBase
        mov  word ptr[@@SrcOffReg], @@SrcTagWReg
        jmp  BeginFixup
Fix48:
        add  @@SrcTagReg, [@@BaseTableReg+@@ObjIndexReg*8].LOTBase
        mov  [@@SrcOffReg], @@SrcTagReg
        add  @@SrcOffReg, 4
        jmp  FixSeg1
Fix1616:
        add  @@SrcTagReg, [@@BaseTableReg+@@ObjIndexReg*8].LOTBase
        mov  [@@SrcOffReg], @@SrcTagWReg
        inc  @@SrcOffReg
        inc  @@SrcOffReg
        jmp  FixSeg1
Fix32:
        add  @@SrcTagReg, [@@BaseTableReg+@@ObjIndexReg*8].LOTBase
        mov  dword ptr[@@SrcOffReg], @@SrcTagReg
        jmp  BeginFixup
Fix32SR:
        add  @@SrcTagReg, [@@BaseTableReg+@@ObjIndexReg*8].LOTBase
        sub  @@SrcTagReg, @@SrcOffReg
        sub  @@SrcTagReg, 4
        mov  dword ptr[@@SrcOffReg], @@SrcTagReg
        jmp  BeginFixup
FixSeg:
        add  @@FixupPtrReg, 5
FixSeg1:
        movzx  @@SrcTagReg, [@@BaseTableReg+@@ObjIndexReg*8].LOTSelector
        or  @@SrcTagReg, @@SrcTagReg
        $ifnot jnz
        mov  eax, @@ObjIndexReg
        call CreateSelForObject
        ;XXX need Error handler!!
        jmp FixSeg1
        $endif
        mov [@@SrcOffReg], @@SrcTagWReg
        jmp  BeginFixup

;ENDP
Loader ENDP

Segm IEData
ReadPos      dd 0;size Header
ReadPos0     dd 0
ReadMPos     dd 0; size Header+offset LGroup:Header
;BufferOffset dd Header
FileDisp     DD 0 ; 60928   ;length of the stub
IFNDEF Release
;DumpHandle DD 0
DumpName DB 'dump.bin', 0
ENDIF

LDWord   FileHandle
             dd 0
ESeg IEData
FileRead PROC PASCAL
         push ebx ecx edx
@@MemSel  EQU DWORD PTR ss:[esp+12].16
@@MemPtr  EQU DWORD PTR ss:[esp+12].12
@@FilePtr EQU DWORD PTR SS:[esp+12].8
@@Size    EQU DWORD PTR SS:[esp+12].4
         mov  edx, @@FilePtr
         add  edx, FileDisp
         mov  ecx, edx
         shr  ecx, 16
         mov  ebx, ss:FileHandle
         mov  ax, 4200h
         ;call XX
         DOSINT 42
         ;int  21h
         $ifnot jc
         ;call EnableTrace
         push ds
         lds  edx, fword ptr @@MemPtr[4]
         mov  ecx, @@Size[4]
         mov  ah, 3Fh
         DOSINT
         ;push eax       ;write dump
         ;mov ebx, DumpHandle
         ;mov ah, 40h
         ;DOSINT
         ;pop eax
         pop ds
         ;call DisableTrace
        ;push ecx
        ;push 8
        ;call PrintN
        ;push eax
        ;push 8
        ;call PrintN
         $endif
         pop edx ecx ebx
         retn 16
         ENDP
ReadFlush PROC C
        mov  edx, ReadPos0
        cmp  edx, ReadPos
        $ifnot je
        mov  ecx, edx
        shr  ecx, 16
        mov  ebx, ss:FileHandle
        mov  ax, 4200h
        DOSINT 42
        jc   @@SeekErr
        mov  ecx, ReadPos
        sub  ecx, ReadPos0
        add  ReadPos0, ecx
        mov  edx, ReadMPos
        sub  edx, ecx
        mov  ah, 3Fh
        DOSINT
        $endif
@@SeekErr:
        ret
        ENDP

PreRead PROC PASCAL
        push eax ebx ecx edx
@@MPos EQU DWORD PTR ss:[esp+16].12
@@FPos EQU DWORD PTR ss:[esp+16].8
@@Size EQU DWORD PTR ss:[esp+16].4
        mov eax, @@FPos
        cmp eax, ReadPos
        jne @@ReadLast
        mov edx, @@MPos
        cmp edx, ReadMPos
        je  @@Ret
@@ReadLast:
        call ReadFlush
        mov eax, @@FPos
        mov ReadPos0, eax
        mov edx, @@MPos
@@Ret:
        add eax, @@Size
        add edx, @@Size
        mov ReadPos, eax
        mov ReadMPos, edx
        pop edx ecx ebx eax
        retn 12
        ENDP
NOWARN RES
;DGROUP group STACK

;ᮧ ᥫ  ꥪ   ꥪ
;᫨ ꥪ 16 -   =  ꥪ,  -  ꥪ
;  = 0,  = 4G

;ebx-base, ecx-size, dx-attrs
;return selector in ebx
;ax destroyed
CreateSelector PROC PASCAL
               push edi
               sub esp, 8        ;alloc space for descriptor
Cache EQU ss:[esp]
               cmp ecx, 100000h  ;may use byte limit ?
               $ifnot jb
               or  dh, 80h
               add ecx, 0FFFh
               shr ecx, 12
               $endif
               mov ax, cs
               and eax, 3
               shl eax, 5         ;setup privelegy level
               or  dl, al
               or  dl, 1
               mov dword ptr Cache, ecx
               shr ecx, 16
               or  dh, cl
               mov dword ptr Cache[2], ebx
               shr ebx, 24
               mov Cache[7], bl
               mov word ptr Cache[5], dx
               mov cx, 1
               xor eax, eax
               int 31h
               jc  ErrAllocSel
               ;$ifnot jc
               movzx ebx, ax
               mov ax, 0Ch
               mov edi, esp
               push es
               push ss
               pop  es
               int 31h
               pop  es
               jc  ErrAllocSel
               ;$endif
               ;mov ebx, bx
               add esp, 8
               pop edi
               retn
               ENDP
;eax - ObjIndex
CreateSelForObject PROC PASCAL
Segm IEData
@@AttrTranslateTable DB 0   ;0    all flags zero               ?
                     DB 0   ;1    conformed but not executable ?
                     DB 90h ;10   readable data
                     DB 0   ;11   conformed but not executable ?
                     DB 0   ;100  writable but not readable    ?
                     DB 0   ;101  conformed but not executable ?
                     DB 92h ;110  readable & writable data
                     DB 0   ;111  conformed but not executable ?
                     DB 98h ;1000 executable only
                     DB 9Ch ;1001 conformed executable
                     DB 9Ah ;1010 readable & executable
                     DB 9Eh ;1011 conformed readable & executable
                     DB 0   ;1100 executable but writable ?
                     DB 0   ;1101 executable but writable ?
                     DB 0   ;1110 executable but writable ?
                     DB 0   ;1111 executable but writable ?
ESeg IEData
               pushad
               mov  edi, ss:LocalTablePtr
               imul esi, eax, size ObjTableS
               add  esi, ss:ObjTablePtr
               mov  ecx, [esi].OTFlags
               mov  edx, ecx
               shl  ch, 2
               rcl  cl, 1
               and  ecx, 1111b
               mov  dl, ss:@@AttrTranslateTable[ecx]
               mov  ebx, [eax*8+edi].LOTBase
               lea  edi, [eax*8+edi].LOTSelector
               or   dl, dl
               jz   @@InvalidFlags
               shl  dh, 1
               and  dh, 40h
               $ifnot jz        ;32bit selector(flat) ?
                 lea esi, DefaultFlatSelectors[ecx*2]
                 movzx  ebx, word ptr ss:[esi]
                 or   ebx, ebx
                 $ifnot jnz           ;all flat segments with same attributes
                   ;xor  ebx, ebx       ;may share one flat selector
                   mov  ecx, 0FFFFF000h
                   call CreateSelector
                 $endif
                 mov  ss:[esi], bx
               $else jmp
                 mov  ecx, [esi].OTSize
                 call CreateSelector
               $endif
@@Ret:         mov  [edi], bx
               popad
               ret
@@InvalidFlags:xor ebx, ebx
               stc
               jmp @@Ret
               ENDP
ifndef Release
Print8L  PROC PASCAL ;@@DW:DWORD
        push dword ptr [esp+4]
        push 8
        call PrintNL
        pushad
        mov ax, 0E00h+' '
        int 10h
        popad
        retn 4
        ENDP
PrintNL  PROC PASCAL;, @@Digit:DWORD, @@N:DWORD
        push eax ecx
@@Digit EQU DWORD PTR ss:[esp+8].8
@@N     EQU DWORD PTR ss:[esp+8].4
        mov eax, @@Digit
        mov cl, 8
        sub cl, byte ptr @@N
        shl cl, 2
        rol eax, cl
        mov ecx, @@N
        $do
        rol eax, 4
        pushad
        and al, 1111b
        add al, '0'
        cmp al, '9'
        $ifnot jbe
        add al, 'A'-'9'-1
        $endif
        mov ah, 0Eh
        mov bx, 07h
        int 10h
        popad
        $enddo loop
        pop ecx eax
        retn 8
        ENDP
endif
ESeg IEText
