/* 
 *  whois.c for Baylor College of Medicine.
 *  written by Stan Barber, Director, Networking & Systems Support
 *  Copyright 1991, Baylor College of Medicine
 *  All Rights Reserved.
 *
 *  Modified by G.Vanem 1997 <giva@bgnett.no>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <netdb.h>
#include <tcp.h>

#define NICHOST     "whois.bcm.tmc.edu"
#define WHOIS_PORT  43

#if (defined(__SMALL__) && !defined(DOS386)) || defined(__LARGE__)
  #define SAVE_SPACE
#endif    

void usage (void)
{
  puts ("usage: whois [-vd] [-h host] name");
  puts ("       try  `whois help'");
  exit (0);
}

int main (int argc, char **argv)
{
  int    ch;
  char  *host     = NICHOST;
  char  *query    = "help";
  int    status   = 0;
  DWORD  ip_addr  = 0;
  WORD   port     = WHOIS_PORT;
  char  *env      = getenv ("WHOIS");
  static tcp_Socket sock;

  if (env)
     host = strdup (env);

  while ((ch = getopt(argc, argv, "?vdh:")) != EOF)
     switch (ch)
     {
       case 'v': puts (wattcpVersion());
                 puts ("WHOIS for Waterloo TCP/IP,  Copyright 1991 Baylor College of Medicine");
                 puts ("For information, send email to `whois-bugs@bcm.tmc.edu'\n");
                 return (0);

       case 'h': host = optarg;
                 break;

       case 'd': tcp_set_debug_state (2);
                 dbug_init();
                 break;

       default:  usage();
     }

  argc -= optind;
  argv += optind;

  if (argc-- < 1 || (query = *argv++) == NULL)
     usage();

  sock_init();

  if ((ip_addr = lookup_host(host,NULL)) == 0L)
  {
    printf (dom_strerror(dom_errno));
    return (1);
  }

#ifndef SAVE_SPACE
  {
    struct servent *sp = getservbyname ("whois","tcp");
    if (sp)
       port = intel16 (sp->s_port);
  }
#endif

  if (!tcp_open(&sock,0,ip_addr,port,NULL))
  {
    puts ("Unable to connect to that machine");
    return (3);
  }

  printf ("waiting...");
  fflush (stdout);
  sock_wait_established (&sock, sock_delay, NULL, &status);

  printf ("\rquerying");
  sock_puts (&sock, query);

  while (!kbhit() && sock_sselect(&sock,SOCKESTABLISHED) == SOCKESTABLISHED)
  {
    tcp_tick (&sock);
    if (sock_dataready(&sock))
    {
      int ch;
      sock_read (&sock, (char*)&ch, 1);
      putchar (ch);
    }
  }
  sock_close (&sock);
  return (0);

sock_err:
  printf ("Connection failed: %s\n", sockerr(&sock));
  return (5);
}
