#
#  Makefile for Waterloo TCP sample applications
#
#  Microsoft Visual-C / PharLap executables.
#  Using Pharlap's linker 386link (not finished!)
#

CC     = cl
CFLAGS = -nologo -Os -W1 -Zi -Gy -Gs -I..\inc

EXE_PROGS = popdump.exe rexec.exe   tcpinfo.exe cookie.exe  \
            daytime.exe dayserv.exe finger.exe  host.exe    \
            lpq.exe     lpr.exe     ntime.exe   ph.exe      \
            stat.exe    htget.exe   revip.exe   tracert.exe \
            uname.exe   vlsm.exe    whois.exe   blather.exe \
            lister.exe  ping.exe

EXP_PROGS = $(PROGS:.exe=.exp)

all:  $(EXE_PROGS)
      @echo Visual-C binaries done

.c.exe:
      $(CC) -c $(CFLAGS) $*.c
      link @<<
        $*.obj ..\lib\wattcpvc.lib
        $(PHARLAP)\cofflib\dosx32.lib
        -out:$*.exe
        -map:$*.map
        -entry:mainCRTStartup
        -subsystem:console
        -machine:i386
        -align:4096
        -base:65536
        -stack:32768,32768
        -stub:$(PHARLAP)\bin\gotnt.exe
        -nodefaultlib
        -defaultlib:libc.lib
        -defaultlib:kernel32.lib
        -defaultlib:oldnames.lib
        -warn:2
<<

.c.exp:
      $(CC) -c $(CFLAGS) $*.c
      386link @<<
        $*.obj -exe $*.exp
        -start _mainCRTStartup
        -stack 32768
        -maxdata 200000h
        -offset 1000h
        -define __acrtused=0
        -exeformat pe
        -subsystem dosstyle
        -markphar
        -defstubname gotnt
        -pebias 2000h
        -twocase
        -lib ..\lib\wattcpvc
        -lib exc_vc
        -lib dosx32.lib
        -lib dos32.lib errno.lib
        -386
        -stripcoffsymbols
        -order class CODE
        -order class DATA
        -order class CONST
        -order class SPECIAL
        -order class STACK
        -order class FAR_DATA
        -order class BSS
        -pack
        -publist both
        -purge none *
        -mapnames 30
        -mapwidth 132
<<

clean:
      @del *.exe
      @del *.obj

