/* 
 * Copyright (c) 1994, 1995, 1997
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "tftp.h"

void log (int pri, char *fmt,...)
{
  char   *cp;
  char   *cp2;
  va_list ap;
  char    tfmt[BUFSIZ];

  va_start (ap, fmt);

  if (debug)
  {
    cp2 = fmt;
    cp = tfmt;
    while (*cp2 != '\0')
    {
      if (*cp2 == '%' && cp2[1] == '%')
      {
	*cp++ = *cp2++;
	*cp++ = *cp2++;
      }
      else if (*cp2 == '%' && cp2[1] == 'm')
      {
	cp2 += 2;
        strcpy (cp, strerror (errno));
	cp += strlen (cp);
      }
      else
	*cp++ = *cp2++;
    }
    *cp = '\0';
    vfprintf (stderr, tfmt, ap);
    putc ('\n', stderr);
  }
  else
    vsyslog (pri, fmt, ap);

  va_end (ap);
}


