.\" This is an -*- nroff -*- file
.\"
.\" syslogd -- system logging daemon
.\" Copyright (c) 1998 Douglas K. Rand   <rand@aero.und.edu>
.\" All Rights Reserved.
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program; see the file COPYING.  If not, write to
.\" the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
.\" Boston, MA 02111-1307, USA.
.\"
.\"
.TH syslogd 8 "11/20/1998"
.SH NAME
syslogd - system logging daemon

.SH SYNOPSIS
\fBsyslogd\fR [\fB-f\fR \fIconfig-file\fR] [\fB-d\fR \fIdebug-spec\fR] 

.SH DESCRIPTION
\fBsyslogd\fR reads log messages from both local sources and listens
on the syslog/udp port. Depending on the flavor of UNIX being used
local messages are received on named pipes (FIFOs), System V Streams,
UNIX sockets, or kernel devices.  For each message a set of actions
are executed based on the facility, priority, and program name of the
message. Actions can forward the message to another host or write the
message to a file or named pipe (FIFO). The configuration file
.BR syslogd.conf (5)
controls the behavior of \fBsyslogd\fR.

.LP
All of the configuration for \fBsyslogd\fR is done via the
.BR syslogd.conf (5)
file, not with command line arguments. The syntax of the
.BR syslogd.conf (5)
file is radically different from the "standard"
.BR syslog.conf (5)
file, the new syntax based on the configuration file style from the
Internet Software Consortium.
Also, the default configuration file is named
.BR syslogd.conf (5)
since the configuration file is for
.BR syslogd (8),
and not
.BR syslog (3).

.LP
This \fBsyslogd\fR implementation supports all popular facilities,
including the newer \fIauthpriv\fR and \fIftp\fR and both the
\fIbsdcron\fR and \fIsysvcron\fR .  \fBsyslogd\fR implementations
derived from the Berkeley distributions use a facility number of 9
while Solaris implementations use 15. Sigh.

.LP
The number of actions is not fixed by any particular data structure,
which allows administrators to separate their
.BR syslog (3)
traffic into a larger number of smaller, more manageable files.

.LP
In addition to being able to select actions based on facilities and
priorities, actions can be based on the tag of the message. The tag is
virtually always the name of the program logging the message, and will
be called program for this document. The program is the first word
(terminated by a space, colon, or open bracket) after the host
name. The standard message form is:

.nf
.B Nov 20 19:07:43 hostname tag[pid]: message
.fi

.B syslogd
has options for including the facility and priority of the message
being logged. The facility and priority can be written in either the
numeric form that is used when forwarding messages from one syslogd to
another, or in symbolic form such as "[daemon.notice]". When logging
the numeric facility and priority it is prepended to the message in
the form "<%d>". When logging the symbolic form it is appended to the
host name in the form "hostname[facility.priority]". We have found
that having the priority of the log message has greatly simplified our
post-processing scripts.

.SH OPTIONS
.TP
.BI -d \ debug-spec
Turns on debugging. The \fIdebug-spec\fR specifies individual
debugging facilities and thresholds.

.TP
.BI -f \ config-file
Specify an alternate configuration file.

.SH DEBUGGING 
Instead of a simple scalar debug level for everything, a debug
facility and threshold similar to that of
.BR sendmail(8)
is used. Facilities are numbered, and the threshold details that
debugging at and below the threshold are shown. The higher the
threshold the more debugging output that is generated.

.LP
For example, to enable debugging of facility 6 a threshold of 100 use
6.100 for the \fIdebug-spec\fR.  Multiple \fIdebug-spec\fR may be
separated by commas (i.e. 3.100,5.10) and a range of facilities may be
set to the same threshold by separating the facilities with a
dash. (i.e. 4-9.250) If the threshold is not specified, it is set to
\fBINT_MAX\fR.  If facility 0 is set, then all facilities not set by
the \fIdebug-spec\fR will be set to the threshold of facility 0. For
example, a \fIdebug-spec\fR of 0.10,5-10.100,3.1000 sets the threshold
of facility 3 to 1000, the thresholds of facilities 5 through 10 to
100, and the threshold of all other facilities to 10.

.LP
For debugging to work you must have use the \fB--enable-debug\fR to
configure. If the \fB-d\fR switch is on the command line syslogd will
not fork and a list of debugging facilities and their thresholds will
be printed to stderr. The source code is the best source of the
facilities and thresholds. A \fIdebug-spec\fR of "0" will
unintuitively sets all debugging facilities to INT_MAX and produces on
the order of 50-100 lines of debugging per message.

.SH SIGNALS
\fBsyslogd\fR reacts to the following signals:

.TP
.B SIGHUP
Any pending duplicate messages are flushed to their actions and all
open files and named pipes are closed and reopened. Please note that
the config file is \fBnot\fR reread.

.TP
.B SIGUSR1
Some statistics about the number of messages and number of bytes
received from the different sources are logged at syslogd.info.

.TP
.B SIGUSR1
Resets the counters for message statistics.

.SH FILES
.TP
\fI@ETCDIR@/syslogd.conf\fR Configuration file for
.BR syslogd (8).

.SH SEE ALSO
.LP
.BR syslog (3)
.BR syslogd.conf (5)

.SH BUGS
The notify action is missing. I've never used it, and I believe that
this should be implemented by a separate process getting syslog
messages either on a named pipe or via forwarding to a user space
port. (See client.tk for a really simple user client.)

.LP
Instead of simply throwing away the entire cache, we should probably
only throw away the least used entries once the cache reaches a
particular size.

.LP
It would be nice to be able to have at least minimal regular
expression (or maybe simple wild cards) support for program names. 

.SH COPYRIGHT
Copyright (c) 1998 Douglas Rand.
All Rights Reserved.

Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permis- sion notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.

.SH AUTHOR
Douglas Rand <rand@aero.und.edu>

.SH CREDITS
.TP
.B Eric Allman
Authored the original syslogd

.TP
.B Peter da Silva
Original patches to FreeBSD's syslogd for actions based on program
names. 

.TP
.B Dr. Greg Wettstein and Martin Schulze
Maintainers of Linux's sysklog package with many features limiting
host access and forwarding of messages.
