/*
 *  Reverse IP lookup: given a set of IP addresses, resolves
 *  the hostnames
 *
 *  G.Vanem <giva@bgnett.no>. Created 13-Sep-96
 */

#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <tcp.h>
#include <netdb.h>

#if (defined(__SMALL__) && !defined(DOS386)) || defined(__LARGE__)
  #define SAVE_SPACE
#endif    

int main (int argc, char **argv)
{
#ifndef SAVE_SPACE
  int i = 1;

  if (argc < 2)
  {
    printf ("Usage: %s [-d] ip-address(es) ..\n", argv[0]);
    return (0);
  }

  if (!strnicmp(argv[i],"-d",2))
  {
    i++;
    tcp_set_debug_state(2);
    dbug_init();
  }
  sock_init();

  while (i < argc)
  {
    struct hostent *h;
    struct in_addr  addr;
    char  *ip = argv[i++];

    if (!inet_aton (ip, &addr))
    {
      printf ("`%s' is not a valid IP-address\n", ip);
      continue;
    }
    printf ("Looking up %s..", ip);
    fflush (stdout);

    h = gethostbyaddr ((char*)&addr.s_addr, sizeof(addr.s_addr), AF_INET);
    printf ("\r%-15.15s: hostname is `%s'\n",
            ip, h ? h->h_name : "* unknown *");
  }
#endif
  return (0);
}
