#
#  Makefile for Waterloo TCP sample applications
#
#  Microsoft Quick-C / large-model executables.
#  Tested with v6.0, v7.0 and Visual C v1.52
#

MODEL  = L
CC     = cl
CFLAGS = -A$(MODEL) -nologo -O -Os -W1 -Zi -Zd -Gy -Gs -Gr -I..\inc
LFLAGS = /batch /map:full /noi /stack:25000 /codeview

#
# Compiling ping.c with Quick-C 7.0 produces "internal compiler error" !
#
PROGS = popdump.exe rexec.exe   tcpinfo.exe cookie.exe  \
        daytime.exe dayserv.exe finger.exe  host.exe    \
        lpq.exe     lpr.exe     ntime.exe   ph.exe      \
        stat.exe    htget.exe   revip.exe   tracert.exe \
        uname.exe   vlsm.exe    whois.exe   blather.exe \
        lister.exe  ping.exe


all:  $(PROGS)
      @echo Microsoft binaries done

.c.exe:
      $(CC) -c $(CFLAGS) $*.c
      link $(LFLAGS) @<<
        $*.obj, $*.exe, $*.map, ..\lib\wattcpM$(MODEL).lib;
<<

clean:
      @del *.exe
      @del *.obj
