#
#  Makefile for Waterloo TCP sample applications
#
#  Pharlap/DLL version for Metaware High-C.
#
#  NB! Preliminary, not working
#

PROGS = ping.exe    popdump.exe  popmail.exe  rexec.exe   \
        tcpinfo.exe cookie.exe   daytime.exe  dayserv.exe \
        finger.exe  host.exe     lpq.exe      lpr.exe     \
        ntime.exe   ph.exe       stat.exe     htget.exe   \
        revip.exe   tracert.exe


COMMON_LNK_FLAGS = -exeformat pe -markphar     \
                   -subsystem dosstyle         \
                   -defstubname gotnt -386     \
                   -libpath $(LIBPATH)         \
                   -fullsym -mapwidth 90       \
                   -fullseg -publist both      \
                   -purge none * -mapnames 20
                  

SEG_ATTRIBUTES   = -attributes class CODE   er \
                   -attributes group CGROUP er \
                   -attributes class DATA   rw \
                   -attributes class CONST  rw \
                   -attributes class BSS    rw \
                   -attributes class STACK  rw \
                   -attributes group DGROUP rw


all:   export.def $(PROGS)
       @echo PharLap/DLL binaries done

.c.exe:
            hc386 -g -c -w3 -I..\inc $*.c
            386link -twocase @export.def @&&|
              $*.obj
              $(COMMON_LNK_FLAGS)
              $(SEG_ATTRIBUTES)
              -exe $*.exe
              -lib hc386,hc387,dosx32
              -stack 8000h
              -pebias 5000h
              -import _sock_init=wattcp._sock_init
              -import _getopt=wattcp._getopt
              -import __arp_resolve=wattcp.__arp_resolve
              -import __chk_ping=wattcp.__chk_ping
              -import __ping=wattcp.__ping
              -import _chk_timeout=wattcp._chk_timeout
              -import _dbug_init=wattcp._dbug_init
              -import _inet_ntoa=wattcp._inet_ntoa
              -import _isaddr=wattcp._isaddr
              -import _optarg=wattcp._optarg
              -import _optind=wattcp._optind
              -import _resolve=wattcp._resolve
              -import _tcp_set_debug_state=wattcp._tcp_set_debug_state
              -import _tcp_tick=wattcp._tcp_tick
              -import _wattcpVersion=wattcp._wattcpVersion
|

export.def: makefile
            @copy &&|
              -export FillRealMem
              -export PokeRealWord
              -export PeekRealByte
              -export ReadRealMem
              -export ReadFarMem
              -export WriteFarMem
              -export WriteRealMem
              -export _close
              -export _creat
              -export _ctype_
              -export PeekRealDWord
              -export _dx_apmiv_set
              -export _dx_cmem_usage
              -export _dx_pmiv_get
              -export _dx_pmiv_set
              -export _dx_real_above
              -export _dx_real_free
              -export _dx_real_int
              -export _dx_rmiv_get
              -export _dx_rmiv_set
              -export _dx_rmlink_get
              -export _dx_config_inf
              -export _dx_excep_get
              -export _dx_excep_set
              -export _dx_sysregs_get
              -export _dx_lock_pgs
              -export _dx_lock_pgsn
              -export _dx_ldt_rd
              -export __dx_ldt_rd
              -export __dx_hdroff_get
              -export _iob
              -export errno
              -export fflush
              -export qsort
              -export _inp
              -export _itoa
              -export _kbhit
              -export _open
              -export _write
              -export _outp
              -export _read
              -export _strdup
              -export _stricmp
              -export _strupr
              -export _mwargp
              -export _mwstack_limit
              -export _mwargstack
              -export _mwgoc
              -export _lseek
              -export atexit
              -export atoi
              -export calloc
              -export exit
              -export fclose
              -export fgets
              -export fopen
              -export free
              -export getenv
              -export malloc
              -export memchr
              -export memcmp
              -export memmove
              -export rand
              -export signal
              -export strcat
              -export strtol
              -export strcmp
              -export strcpy
              -export strncmp
              -export strncpy
              -export strrchr
              -export strstr
              -export strtok
              -export vsprintf
              -export printf
              -export puts
              -export strchr
| $<

