#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <conio.h>
#include <tcp.h>
#include <netdb.h>

#if (defined(__SMALL__) && !defined(DOS386)) || defined(__LARGE__)
  #define SAVE_SPACE
#endif    

extern int _w32_Random (unsigned a, unsigned b);

int ident (DWORD host, WORD client_port, WORD server_port)
{
  static tcp_Socket sock;
  int    status    = 0;
  WORD   localport = _w32_Random (1100, 5555);
  WORD   identport = 113;
  char   buf[512];
  int    len;

#ifndef SAVE_SPACE
  struct servent *serv;

  if ((serv = getservbyname("auth", "tcp")) != NULL ||
      (serv = getservbyname("ident","tcp")) != NULL)
     identport = intel16 (serv->s_port);
#endif

  if (!tcp_open(&sock,localport,host,identport,NULL))
  {
    printf ("Unable to connect; %s", sockerr(&sock));
    return (-1);
  }

  printf ("waiting...");
  fflush (stdout);
  sock_wait_established (&sock, sock_delay, NULL, &status);

  sock_printf (&sock, "%d,%d\r\n", server_port, client_port);

  sock_wait_input (&sock, 10, NULL, &status);
  len = sock_fastread (&sock, buf, sizeof(buf)-1);

  printf ("\n%.*s\n", len, buf);

  printf ("closing...");
  fflush (stdout);
  sock_close (&sock);
  sock_wait_closed (&sock, 0, (UserHandler)kbhit, &status);
  return (0);

sock_err:
  switch (status)
  {
    case 1:
         puts ("\nHost closed");
         status = 0;
         break;
    case -1:
         printf ("\n%s\n", sockerr(&sock));
         break;
  }
  sock_abort (&sock);
  return (status);
}

/*---------------------------------------------------------------*/

void usage (void)
{
  puts ("Simple RFC-1413 ident client\n"
        "Usage: ident [-v] [-d] server <server-client-port-pair>\n"
        "E.g \"ident host 23,1030\" queries telnet connection at port 1030");
  exit (3);
}

int main (int argc, char **argv)
{
  char  *server = "localhost";
  DWORD  host;
  WORD   cli_port = 0;
  WORD   srv_port = 0;
  int    ch;

  while ((ch = getopt(argc,argv,"?vd")) != EOF)
     switch(ch)
     {
       case 'v': puts (wattcpVersion());
                 break;
       case 'd': dbug_init();
                 break;
       case '?':
       default : usage();
     }

  argc -= optind;
  argv += optind;

  if (argc < 1 || (server = *argv) == NULL)
     usage();

  if (argc > 1)
     sscanf (argv[1], "%hu,%hu", &srv_port, &cli_port);

  sock_init();

  if ((host = lookup_host(server,NULL)) == 0L)
  {
    printf (dom_strerror(dom_errno));
    return (3);
  }
  return ident (host, cli_port, srv_port);
}


