NAME
      ftp - file transfer program

SYNOPSIS
      ftp [-c | -C] [dgintv] [hostname | url]

DESCRIPTION
      The ftp command is the user interface to the ARPANET standard
      File Transfer Protocol (FTP).  ftp allows a user to transfer
      files to and from a remote network site.

USAGE
     Options may be specified at the command line, or to the
     command interpreter.

     -c    Suppress the SYST message.  This option is used to avoid
           crashing a remote server which does not process this
           message and can't deal with unknown messages.  If the
           first command after FTP login results in the message
           remote server has closed connection, you should add the
           -c option to the ftp command line and retry the request.

     -C    Force ftp to send the SYST message.  By default, the
           SYST message is not sent.

     -d    Enable debugging.

     -g    Disable file name globbing.

     -i    Turn off interactive prompting during multiple file
           transfers.

     -n    Restrain ftp from attempting ``auto-login'' upon initial
           connection.  If auto-login is enabled, ftp will check
           the .netrc file (see below) in the user's home directory
           for an entry describing an account on the remote
           machine.  If no entry exists, ftp will prompt for the
           remote machine login name (default is the user identity
           on the local machine), and, if necessary, prompt for a
           password and an account with which to login.

     -t    Enable packet tracing.

     -v    Verbose on.  Forces ftp to show all responses from the
           remote server, as well as report on data transfer
           statistics.  Normally, this is on by default, unless the
           standard input is not a terminal.

     The client host with which ftp is to communicate may be specified
     on the command line.  If this is done, ftp will immediately attempt
     to establish a connection to an FTP server on that host; otherwise,
     ftp will enter its command interpreter and await instructions from
     the user.  When ftp is awaiting commands from the user the prompt
     "ftp> " is provided to the user.

  Commands
     The following commands are recognized by ftp.  Command
     arguments which have embedded spaces may be quoted with quote
     (") marks.

     ! [ command [ args ] ]
           Invoke an interactive shell on the local machine.  If
           there are arguments, the first is taken to be a command
           to execute directly, with the rest of the arguments as
           its arguments.

     ? [ command ]
           A synonym for help.

     $ macro-name [ args ]
           Execute the macro macro-name that was defined with the
           macdef command.  Arguments are passed to the macro
           unglobbed.

     account [ passwd ]
           Supply a supplemental password required by a remote
           system for access to resources once a login has been
           successfully completed.  If no argument is included, the
           user will be prompted for an account password in a non-
           echoing input mode.

     append local-file [ remote-file ]
           Append a local file to a file on the remote machine.  If
           remote-file is left unspecified, the local file name is
           used in naming the remote file after being altered by
           any ntrans or nmap setting.  File transfer uses the
           current settings for type, format, mode, and structure.

     ascii Set the file transfer type to network ASCII.  This is
           the default type.

     bell  Arrange that a bell be sounded after each file transfer
           command is completed.

     binary
           Set the file transfer type to support binary image
           transfer.

     bye   Terminate the FTP session with the remote server and
           exit ftp.  An end of file will also terminate the
           session and exit.

     case  Toggle remote computer file name case mapping during
           mget commands.  When case is on (default is off), remote
           computer file names with all letters in upper case are
           written in the local directory with the letters mapped
           to lower case.

     cd remote-directory
           Change the current directory on the remote machine to
           remote-directory.

     cdup  Change the remote machine current directory to the
           parent of the current remote machine current directory.

     chmod [ mode ] [ remote-file ]
           Change file permissions of remote file.

     close Terminate the FTP session with the remote server, and
           return to the command interpreter.  Any defined macros
           are erased.

     cr    Toggle carriage return stripping during ascii type file
           retrieval.  Records are denoted by a carriage
           return/linefeed sequence during ascii type file
           transfer.  When cr is on (the default), carriage returns
           are stripped from this sequence to conform with the UNIX
           single linefeed record delimiter.  Records on non-UNIX
           remote systems may contain single linefeeds; when an
           ascii type transfer is made, these linefeeds may be
           distinguished from a record delimiter only when cr is
           off.

     delete remote-file
           Delete the file remote-file on the remote machine.

     debug [ debug-value ]
           Toggle debugging mode.  If an optional debug-value is
           specified it is used to set the debugging level.  When
           debugging is on, ftp prints each command sent to the
           remote machine, preceded by the string ``-->''.

     dir [ remote-directory [ local-file ] ]
           Print a listing of the directory contents in the
           directory, remote-directory, and, optionally, placing
           the output in local-file.  If interactive prompting is
           on, ftp will prompt the user to verify that the last
           argument is indeed the target local file for receiving
           dir output.  If no directory is specified, the current
           directory on the remote machine is used.  If no local
           file is specified, or local-file is -, output comes to
           the terminal.

     disconnect
           A synonym for close.

     form format
           Set the file transfer form to format.  The default
           format is file.

     get remote-file [ local-file ]
           Retrieve the remote-file and store it on the local
           machine.  If the local file name is not specified, it is
           given the same name it has on the remote machine,
           subject to alteration by the current case, ntrans, and
           nmap settings.  The current settings for type, form,
           mode, and structure are used while transferring the
           file.

     glob  Toggle filename expansion for mdelete, mget and mput.
           If globbing is turned off with glob, the file name
           arguments are taken literally and not expanded.
           Globbing for mput is done as in sh(1).  For mdelete and
           mget, each remote file name is expanded separately on
           the remote machine and the lists are not merged.
           Expansion of a directory name is likely to be different
           from expansion of the name of an ordinary file: the
           exact result depends on the foreign operating system and
           ftp server, and can be previewed by doing `mls remote-
           files -'.  Note that mget and mput are not meant to
           transfer entire directory subtrees of files.  That can
           be done by transferring a tar(1) archive of the subtree
           (in binary mode).

     hash  Toggle hash-sign (``#'') printing for each data block
           transferred.  The size of a data block is 1024 bytes.

     help [ command ]
           Print an informative message about the meaning of
           command.  If no argument is given, ftp prints a list of
           the known commands.

     idle  Get/set idle timer on the remote machine.

     image Same as binary.

     lcd [ directory ]
           Change the current directory on the local machine.  If
           no directory is specified, the user's home directory is
           used.

     ls [ remote-directory [ local-file ] ]
           Print an abbreviated listing of the contents of a
           directory on the remote machine.  The listing includes
           any system-dependent information that the server chooses
           to include; for example, most UNIX systems will produce
           output from the command ls -l (see also nlist).  If
           remote-directory is left unspecified, the current
           directory is used.  If interactive prompting is on, ftp
           will prompt the user to verify that the last argument is
           indeed the target local file for receiving ls output.
           If no local file is specified, or if local-file is -,
           the output is sent to the terminal.  Additional options
           may be specified by quoting the arguments.  For example,
           ls "-rt dir", will cause a time sorted listing of
           directory dir to be displayed if the remote operating
           system is UNIX.

     macdef macro-name
           Define a macro.  Subsequent lines are stored as the
           macro macro-name; a null line (consecutive newline
           characters in a file or carriage returns from the
           terminal) terminates macro input mode.  There is a limit
           of 16 macros and 4096 total characters in all defined
           macros.  Macros remain defined until a close command is
           executed.  The macro processor interprets '$' and '\' as
           special characters.  A '$' followed by a number (or
           numbers) is replaced by the corresponding argument on
           the macro invocation command line.  A '$' followed by an
           'i' signals that macro processor that the executing
           macro is to be looped. On the first pass '$i' is
           replaced by the first argument on the macro invocation
           command line, on the second pass it is replaced by the
           second argument, and so on.  A '\' followed by any
           character is replaced by that character.  Use the '\' to
           prevent special treatment of the '$'.

     mdelete [ remote-files ]
           Delete the remote-files on the remote machine.

     mdir remote-files local-file
           Like dir, except multiple remote files may be specified.
           If interactive prompting is on, ftp will prompt the user
           to verify that the last argument is indeed the target
           local file for receiving mdir output.

     mget remote-files
           Expand the remote-files on the remote machine and do a
           get for each file name thus produced.  See glob for
           details on the filename expansion.  Resulting file names
           will then be processed according to case, ntrans, and
           nmap settings.  Files are transferred into the local
           current directory, which can be changed with
           lcd directory; new local directories can be created with
           ! mkdir directory.

     mkdir directory-name
           Make a directory on the remote machine.

     mls remote-files local-file
           Like nlist, except multiple remote files may be
           specified, and the local-file must be specified.  If
           interactive prompting is on, ftp will prompt the user to
           verify that the last argument is indeed the target local
           file for receiving mls output.

     mode [ mode-name ]
           Set the file transfer mode to mode-name.  The default
           mode is stream mode.

     modtime file-name
           Show the last modification time of the file on the
           remote machine.

     mput local-files
           Expand wild cards in the list of local files given as
           arguments and do a put for each file in the resulting
           list.  See glob for details of filename expansion.
           Resulting file names will then be processed according to
           ntrans and nmap settings.  The mput command does not
           allow specifying remote file names.

     newer remote-file [ local-file ]
           Get file if remote-file is newer than local-file.

     nlist [ remote-directory [ local-file ] ]
           Print a list of the files of a directory on the remote
           machine.  If remote-directory is left unspecified, the
           current directory is used.  If interactive prompting is
           on, ftp will prompt the user to verify that the last
           argument is indeed the target local file for receiving
           nlist output.  If no local file is specified, or if
           local-file is -, the output is sent to the terminal.

           Additional options may be specified by quoting the
           arguments.  For example, nlist "-rt dir" will cause a
           time sorted listing of directory dir to be displayed.

     nmap [ inpattern outpattern ]
           Set or unset the filename mapping mechanism.  If no
           arguments are specified, the filename mapping mechanism
           is unset.  If arguments are specified, remote filenames
           are mapped during mput commands and put commands issued
           without a specified remote target filename.  If
           arguments are specified, local filenames are mapped
           during mget commands and get commands issued without a
           specified local target filename.  This command is useful
           when connecting to a non-UNIX remote computer with
           different file naming conventions or practices.  The
           mapping follows the pattern set by inpattern and
           outpattern.  Inpattern is a template for incoming
           filenames (which may have already been processed
           according to the ntrans and case settings).  Variable
           templating is accomplished by including the sequences
           $1, $2, ..., $9 in inpattern.  Use `\' to prevent this
           special treatment of the '$' character.  All other
           characters are treated literally, and are used to
           determine the nmap inpattern variable values.  For
           example, given inpattern $1.$2 and the remote file name
           mydata.data $1 would have the value mydata, and $2 would
           have the value data.  The outpattern determines the
           resulting mapped filename.  The sequences $1, $2, ....,
           $9 are replaced by any value resulting from the
           inpattern template.  The sequence '$0' is replaced by
           the original filename.  Additionally, the sequence
           [seq1,seq4] is replaced by seq1 if seq1 is not a null
           string; otherwise it is replaced by seq2.  For example,
           the command nmap $1.$2.$3 [$1,$2].[$2,file] would yield
           the output filename myfile.data for input filenames
           myfile.data and myfile.data.old myfile.file for the
           input filename myfile and myfile.myfile for the input
           filename .myfile.  Spaces may be included in outpattern,
           as in the example: nmap $1 |sed "s/  *$//" > $1 .  Use
           the '\' character to prevent special treatment of the
           '$', '[', ']', and ',' characters.

     ntrans [ inchars [ outchars ] ]
           Set or unset the filename character translation
           mechanism.  If no arguments are specified, the filename
           character translation mechanism is unset.  If arguments
           are specified, characters in remote filenames are
           translated during mput commands and put commands issued
           without a specified remote target filename.  If
           arguments are specified, characters in local filenames
           are translated during mget commands and get commands
           issued without a specified local target filename.  This
           command is useful when connecting to a non-UNIX remote
           computer with different file naming conventions or
           practices.  Characters in a filename matching a
           character in inchars are replaced with the corresponding
           character in outchars.  If the character's position in
           inchars is longer than the length of outchars, the
           character is deleted from the file name.

     open host [ port ]
           Establish a connection to the specified host FTP server.
           An optional port number may be supplied, in which case,
           ftp will attempt to contact an FTP server at that port.
           If the auto-login option is on (default), ftp will also
           attempt to automatically log the user in to the FTP
           server (see below).

     prompt
           Toggle interactive prompting.  Interactive prompting
           occurs during multiple file transfers to allow the user
           to selectively retrieve or store files.  If prompting is
           turned off (default is on), any mget or mput will
           transfer all files, and any mdelete will delete all
           files.

     proxy ftp-command
           Execute an ftp command on a secondary control
           connection.  This command allows simultaneous connection
           to two remote FTP servers for transferring files between
           the two servers.  The first proxy command should be an
           open, to establish the secondary control connection.
           Enter the command proxy ? to see other ftp commands
           executable on the secondary connection.  The following
           commands behave differently when prefaced by proxy: open
           will not define new macros during the auto-login
           process, close will not erase existing macro
           definitions, get and mget transfer files from the host
           on the primary control connection to the host on the
           secondary control connection, and put, mput, and append
           transfer files from the host on the secondary control
           connection to the host on the primary control
           connection.  Third party file transfers depend upon
           support of the ftp protocol PASV command by the server
           on the secondary control connection.

     put local-file [ remote-file ]
           Store a local file on the remote machine.  If remote-
           file is left unspecified, the local file name is used
           after processing according to any ntrans or nmap
           settings in naming the remote file.  File transfer uses
           the current settings for type, format, mode, and
           structure.

     pwd   Print the name of the current directory on the remote
           machine.

     quit  A synonym for bye.

     quote arg1 arg2 . . .
           The arguments specified are sent, verbatim, to the
           remote FTP server.

     recv remote-file [ local-file ]
           A synonym for get.

     reget Retrieve a file restarting at the end of the local-file.

     restart
           Restart the transfer of a file from a particular byte-
           count.

     rhelp [ command-name ]
           Request help from the remote FTP server.  If a command-
           name is specified it is supplied to the server as well.

     rstatus [ file-name ]
           With no arguments, show status of remote-machine.  If
           file-name is specified, show status of file-name on
           remote machine.

     rename [ from ] [ to ]
           Rename the file from on the remote machine, to the file
           to.

     reset Clear reply queue.  This command re-synchronizes
           command/reply sequencing with the remote ftp server.
           Resynchronization may be necessary following a violation
           of the ftp protocol by the remote server.

     rmdir directory-name
           Delete a directory on the remote machine.

     runique
           Toggle storing of files on the local system with unique
           filenames.  If a file already exists with a name equal
           to the target local filename for a get or mget command,
           a .1 is appended to the name.  If the resulting name
           matches another existing file, a .2 is appended to the
           original name.  If this process continues up to .99, an
           error message is printed, and the transfer does not take
           place.  The generated unique filename will be reported.
           Note that runique will not affect local files generated
           from a shell command (see below).  The default value is
           off.

     send local-file [ remote-file ]
           A synonym for put.

     sendport
           Toggle the use of PORT commands.  By default, ftp will
           attempt to use a PORT command when establishing a
           connection for each data transfer.  The use of PORT
           commands can prevent delays when performing multiple
           file transfers. If the PORT command fails, ftp will use
           the default data port.  When the use of PORT commands is
           disabled, no attempt will be made to use PORT commands
           for each data transfer.  This is useful for certain FTP
           implementations which do ignore PORT commands but,
           incorrectly, indicate they've been accepted.

     size file-name
           Return size of file-name on remote machine.

     status
           Show the current status of ftp.

     site [ command ]
           Get/set site specific information from/on remote
           machine.

     struct [ struct-name ]
           Set the file transfer structure to struct-name.  By
           default stream structure is used.

     sunique
           Toggle storing of files on remote machine under unique
           file names.  The remote FTP server must support the FTP
           protocol command STOU for successful completion.  The
           remote server will report unique name.  Default value is
           off.

     system
           Show the type of operating system running on the remote
           machine.

     tenex Set the file transfer type to that needed to talk to
           TENEX machines.

     trace Toggle packet tracing.

     type [ type-name ]
           Set the file transfer type to type-name.  If no type is
           specified, the current type is printed.  The default
           type is network ASCII.

     umask [ mask ]
           Set user file-creation mode mask on the remote site.  If
           mask is omitted, the current value of the mask is
           printed.

     user user-name [ password ] [ account ]
           Identify yourself to the remote FTP server.  If the
           password is not specified and the server requires it,
           ftp will prompt the user for it (after disabling local
           echo).  If an account field is not specified, and the
           FTP server requires it, the user will be prompted for
           it.  If an account field is specified, an account
           command will be relayed to the remote server after the
           login sequence is completed if the remote server did not
           require it for logging in.  Unless ftp is invoked with
           ``auto-login'' disabled, this process is done
           automatically on initial connection to the FTP server.

     verbose
           Toggle verbose mode.  In verbose mode, all responses
           from the FTP server are displayed to the user.  In
           addition, if verbose is on, when a file transfer
           completes, statistics regarding the efficiency of the
           transfer are reported.  By default, verbose is on.

  Aborting a File Transfer
     To abort a file transfer, use the terminal interrupt key
     (usually Delete or Ctrl-C).  Sending transfers will be
     immediately halted.  Receiving transfers will be halted by
     sending a ftp protocol ABORT command to the remote server, and
     discarding any further data received.  The speed at which this
     is accomplished depends upon the remote server's support for
     ABORT processing.  If the remote server does not support the
     ABORT command, an ftp> prompt will not appear until the remote
     server has completed sending the requested file.

     The terminal interrupt key sequence will be ignored when ftp
     has completed any local processing and is awaiting a reply
     from the remote server.  A long delay in this mode may result
     from the ABORT processing described above, or from unexpected
     behavior by the remote server, including violations of the ftp
     protocol.  If the delay results from unexpected remote server
     behavior, the local ftp program must be killed by hand.


   File Naming Conventions
      Files specified as arguments to ftp commands are processed
      according to the following rules.

      1)    If the file name `-' is specified, the stdin (for
            reading) or stdout (for writing) is used.

      2)    If the first character of the file name is `|' the
            remainder of the argument is interpreted as a shell
            command.  ftp then forks a shell, using popen(3S) with
            the argument supplied, and reads (writes) from the
            stdout (stdin).  If the shell command includes spaces,
            the argument must be quoted.  A particularly useful
            example of this mechanism is: "dir . | pg".

      3)    Failing the above checks, if ``globbing'' is enabled,
            local file names are expanded according to the rules
            used in the sh(1); c.f. the glob command. If the ftp
            command expects a single local file (e.g., put), only
            the first filename generated by the ``globbing''
            operation is used.

      4)    For mget commands and get commands with unspecified
            local file names, the local filename is the remote
            filename, which may be altered by a case, ntrans, or
            nmap setting.  The resulting filename may then be
            altered if runique is on.

      5)    For mput commands and put commands with unspecified
            remote file names, the remote filename is the local
            filename, which may be altered by a ntrans or nmap
            setting.  The resulting filename may then be altered by
            the remote server if sunique is on.

   File Transfer Parameters
      FTP specifies many parameters which may affect a file
      transfer.  The type may be one of ascii, image (binary),
      ebcdic, and local byte size.  ftp supports the ascii and image
      types of file transfer, plus local byte size 8 for tenex mode
      transfers.

      ftp supports only the default values for the remaining file
      transfer parameters: mode, form, and struct.


   The .netrc File
     The .netrc file contains login and initialization information
     used by the auto-login process.  It resides in the user's home
     directory.  The following tokens are recognized; they may be
     separated by spaces, tabs, or new-lines:

     machine name
           Identify a remote machine name.  The auto-login process
           searches the .netrc file for a machine token that
           matches the remote machine specified on the ftp command
           line or as an open command argument.  Once a match is
           made, the subsequent .netrc tokens are processed,
           stopping when the end of file is reached or another
           machine token is encountered.

     default
           This is the same as machine name except that default
           matches any name.  There can be only one default token,
           and it must be after all machine tokens.  This is
           normally used as default login anonymous password
           user@site thereby giving the user automatic anonymous
           ftp login to machines not specified in .netrc.  This can
           be overridden by using the -n flag to disable auto-
           login.

     login name
           Identify a user on the remote machine.  If this token is
           present, the auto-login process will initiate a login
           using the specified name.

     password string
           Supply a password.  If this token is present, the auto-
           login process will supply the specified string if the
           remote server requires a password as part of the login
           process.  Note that if this token is present in the
           .netrc file, ftp will abort the auto-login process if
           the .netrc is readable by anyone besides the user.

     account string
           Supply an additional account password.  If this token is
           present, the auto-login process will supply the
           specified string if the remote server requires an
           additional account password, or the auto-login process
           will initiate an ACCT command if it does not.

     macdef name
           Define a macro.  This token functions like the ftp
           macdef command functions.  A macro is defined with the
           specified name; its contents begin with the next .netrc
           line and continue until a null line (consecutive new-
           line characters) is encountered.  If a macro named init
           is defined, it is automatically executed as the last
           step in the auto-login process.

  Warnings
     Correct execution of many commands depends upon proper
     behavior by the remote server.

     An error in the treatment of carriage returns in the 4.2BSD
     ascii-mode transfer code has been corrected.  This correction
     may result in incorrect transfers of binary files to and from
     4.2BSD servers using the ascii type.  Avoid this problem by
     using the binary file transfer type.

=============================================================================

USAGE: ftp [-c | -C] [-d] [-v] [-t] [-i] [-n] [-g] [hostname]

Commands may be abbreviated.  Commands are:

!               debug           mget            pwd             status
$               dir             mkdir           quit            struct
account         disconnect      mls             quote           system
append          form            mode            recv            sunique
ascii           get             modtime         reget           tenex
bell            glob            mput            rstatus         trace
binary          hash            newer           rhelp           type
bye             help            nmap            rename          user
case            idle            nlist           reset           umask
cd              image           ntrans          restart         verbose
cdup            lcd             open            rmdir           ?
chmod           ls              prompt          runique
close           macdef          proxy           send
cr              mdelete         sendport        site
delete          mdir            put             size


