
/******************************************************************************
  DAYTIME - read and print time of day string from internet

  Copyright (C) 1991, University of Waterloo
  Portions Copyright (C) 1990, National Center for Supercomputer Applications

  This program is free software; you can redistribute it and/or modify
  it, but you may not sell it.

  This program is distributed in the hope that it will be useful,
  but without any warranty; without even the implied warranty of
  merchantability or fitness for a particular purpose.

      Erick Engelke                   or via E-Mail
      Faculty of Engineering
      University of Waterloo          Erick@development.watstar.uwaterloo.ca
      200 University Ave.,
      Waterloo, Ont., Canada
      N2L 3G1

  Returns:
      0   - success

      2   - some failure in the connection (port unavailable,
              no response, etc.)
      3   - unable to reach it - local host or first router is down

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcp.h>

#define DAYTIME_PORT 13

#if !defined(__SMALL__) || defined(DOS386) /* 32-bit dmc defines __SMALL__ */
#define TCP_DAYTIME
#endif

int daytime (DWORD host)
{
  static tcp_Socket sock;
  tcp_Socket *s = &sock;
  char buffer [513];
  int  retcode = 3;
  int  status  = 0;
  int  total   = 0;

#ifdef TCP_DAYTIME
  if (!tcp_open(s,0,host,DAYTIME_PORT,NULL))
  {
    outs ("Sorry, unable to connect to that machine right now!\n");
    return (3);
  }
  outs ("waiting...\r");
  sock_wait_established (s,sock_delay,NULL,&status);
  outsnl ("connected ");

#else
  int   udpretries = 3;
  DWORD udpretrytime;

  udp_open (s,0,host,DAYTIME_PORT,NULL);
  sock_write (s,"\n",1);
  udpretrytime = set_timeout (2000);
#endif

  while (1)
  {
    sock_tick (s,&status);

#ifndef TCP_DAYTIME
    if (chk_timeout(udpretrytime))
    {
      if (udpretries-- == 0)
         break;
      udpretrytime = set_timeout (2000);
      sock_write(s,"\n",1);
    }
#endif
    while (sock_dataready(s))
    {
      int len = sock_gets (s,buffer,sizeof(buffer));

      outsnl (buffer);
      retcode = 0;
      total  += len;
      break;
    }
    if (total > 0)
       break;
  }
  sock_close (s);
  sock_wait_closed (s,sock_delay,NULL,&status);

sock_err:
  switch (status)
  {
    case 1 : /* foreign host closed */
             return (retcode);
    case -1: /* timeout/abort       */
             outsnl (sockerr(s));
             return (2);
    default: outs ("\nAborting\n");
             return (2);
  }
}

void Usage (void)
{
  outsnl ("DAYTIME [-dv] server");
  exit (1);
}

int main (int argc, char **argv)
{
  DWORD host;
  int   ch;
  const char *name = NULL;

  while ((ch = getopt(argc, argv, "?vd")) != EOF)
     switch (ch)
     {
       case 'v': puts (wattcpVersion());
                 break;
       case 'd': tcp_set_debug_state (2);
                 dbug_init();
                 break;
       case '?':
       default:  Usage();
     }

  argc -= optind;
  argv += optind;
  if (argc-- < 1 || (name = *argv++) == NULL)
     Usage();

  sock_init();

  host = lookup_host (name, NULL);
  if (!host)
  {
    printf (dom_strerror(dom_errno));
    return (3);
  }
  return daytime (host);
}
