*******************************************************************************
*  PROGRAM:      Music.prg
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         4/94
*
*  UPDATED:      5/95
*
*  REVISION:     $Revision:   1.37  $
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This program is an illustration of how a record store,
*                Musical Methods, displays its music collection information.
*                This program will allow you to view the available music
*                in various orders, look at separate tables of music categories,
*                sales rankings, and media types available.  You can search for
*                information, and look at the available data in various
*                formats.  This file is both the starting program and the
*                procedure file for all forms called in the application.
*
*  PARAMETERS:   None
*
*  CALLS:        Musiview.wfm    (main music form)
*
*  USAGE:        DO Music
*
*******************************************************************************
#include "Music.h"
#include <Messdlg.h>
#include <Enum.h>

*** Basic Environment
create session
set talk off

*** Procedure Files
set procedure to program(1) additive    && Make procedures in this file available

*** Public Variables
* trackWindows -- window tracking and environment storage variable
public trackWindows

trackWindows = new TrackWindowsClass()  && Set up window tracking, and
                                        && application environment
*** Show Music
do Musiview.wfm


******************************* Classes ***************************************

*******************************************************************************
*******************************************************************************
CLASS TrackWindowsClass

* This class keeps track of open and closed view windows.  It stores
* references to those windows in an array, windowAr, and deletes those
* references when the window is closed.  Each window gets assigned
* a windowNum property -- its index in the array.
*******************************************************************************
   *** Constructor

   * Save Environment
   shell(.F., .T.)                         && Close Visual dBASE desktop windows
   this.saveFrameText = _app.frameWin.text && Save previous frame title
   this.saveHelp = setto("help")           && Save help file

   * Set Environment
   _app.framewin.text = "Musical Methods"  && Application title
   set help to music.hlp                   && Help file for the program

   * Window tracking properties
   this.windowAr = new array(0)            && Array for storing windows
   this.windowCnt = 0                      && Count of open windows


   ****************************************************************************
   procedure AddWindow(f)

   * Routine called whenever a new window is opened
   ***************************************************************************

   this.windowAr.Add(f)
   f.windowNum = this.windowAr.size
   this.windowCnt = this.windowCnt + 1          && Increase count of open wind



   ***************************************************************************
   procedure DeleteWindow(f)

   * Routine called whenever a window is closed
   ***************************************************************************

   this.windowAr[f.windowNum] = .F.
   this.windowCnt = this.windowCnt - 1          && Decrease count of open wind
   if this.windowCnt = 0                        && If no more windows,
      this.RestoreEnvironment()                 && restore environment
   endif


   ***************************************************************************
   procedure DeleteAllWindows

   * Routine to close all open windows
   ***************************************************************************
   private i, windowArSize

   windowArSize = this.windowAr.size
   for i = 1 to windowArSize
      if type("this.windowAr[i]") <> "L"
         this.windowAr[i].OnClose = .F.
         this.windowAr[i].Close()
      endif
   next i


   ***************************************************************************
   procedure RestoreEnvironment

   * Restore previous environment
   ***************************************************************************
   private saveFrameText, saveHelp

   saveFrameText = this.saveFrameText           && Assign properties to vars
   saveHelp = this.saveHelp

   _app.framewin.text = saveFrameText           && Restore frame text
   set help to &saveHelp                        && Restore help file

   shell(.T.)                                   && Restore Visual dBASE shell


ENDCLASS


*************************** Views Procedures **********************************

******************************************************************************
procedure EnableViews(f)

* This is called when a the full Music application is run (this file)
* to enable viewing of all types of forms.  By default these menus
* are disabled, so you cannot call other forms when you run just one
* of the view forms on its own -- i.e. do Musiview.wfm
******************************************************************************

f.root.view.music.enabled = .T.
f.root.view.categories.enabled = .T.
f.root.view.rankings.enabled = .T.
f.root.view.media_types.enabled = .T.


*******************************************************************************
procedure DefineCorrespondingItems(form)

* Define items corresponding to current selection in
* Categories/Rankings/Media Types forms.  Items are initially not visible
*******************************************************************************

DEFINE RECTANGLE DIVIDERRECT OF FORM;
    PROPERTY;
      ColorNormal form.colorNormal,;
      Text "",;
      Height         form.height,;
      Width          0.34,;
      Top          0.00,;
      Left         form.width,;
      Border .T.,;
      Visible .F.

DEFINE BROWSE ITEMSBROWSE OF FORM;
    PROPERTY;
      ShowRecNo .F.,;
      Modify .F.,;
      Toggle .F.,;
      Width         MAX_FORM_WIDTH - form.dividerRect.left,;
      Top           1.01,;
      Left          form.dividerRect.left + .5,;
      Height        form.height - 3,;
      Alias "Music",;
      Fields "Music->Artist, Music->Title, Music->Rank",;
      ColorNormal "r/w",;
      FontSize          8.00,;
      FontName "MS Sans Serif",;
      FontBold .F.,;
      Delete .F.,;
      Visible .F.






*******************************************************************************
procedure CorrespondingItems

* Expand window to show items corresponding to current selection
*******************************************************************************
private key

if .not. form.MusicIsOpen              && Check if browse is already open
   form.MusicIsOpen = .T.
endif

* Make corresponding items controls visible
form.dividerRect.visible = .T.
form.itemsBrowse.visible = .T.

this.text     = "No &Items"
this.helpId   = "No Items"
this.OnClick  = NoCorrespItems
this.StatusMessage = "Remove displayed browse of items.  Press F1 for Help."
form.width    = MAX_FORM_WIDTH
form.left     = 0.00
go recno()


*******************************************************************************
procedure NoCorrespItems

* Shrink window to not show items corresponding to current selection
*******************************************************************************

this.text          = "&Items..."
this.helpId        = "Items"
this.OnClick       = CorrespondingItems
this.statusMessage = "Show available items that match the current selection.  Press F1 for Help."
form.width         = form.dividerRect.left - 1
form.left          = 27.03

* Make corresponding items controls invisible
form.dividerRect.visible = .F.
form.itemsBrowse.visible = .F.



*******************************************************************************
procedure SizeForm(nType, width, newHeight)

* Resize form controls as the form gets resized.
******************************************************************************

height = max(MIN_FORM_HEIGHT, newHeight)
if form.windowState <> WINDOWSTATE_MINIMIZED          && if not minimized
   if .not. form.MusicIsOpen         && If only have a listbox
      form.descriptList.height = height - 9
   endif

   form.itemsButton.top          = PB_ROW(height)
   form.closeFormButton.top      = PB_ROW(height)
   form.logoImage.top            = height - 4.53
   form.listRect.height          = height - 6
   form.descriptList.height      = height - 8
   if form.itemsButton.text = "No &Items"
      form.dividerRect.height = height
      form.itemsBrowse.height = height - 2
      form.width = form.itemsBrowse.left + form.itemsBrowse.width + 1
   else
      form.width = form.descriptList.left + form.descriptList.width + 3
   endif
endif

********************** Menu and Popup Procedures *****************************

*******************************************************************************

procedure CallShowRankView(form)

* Display form in Rank order
*******************************************************************************

form.ShowRankView(form.root.view.organization.rank,;
                  form.popupMenu.organization.rank)


*******************************************************************************

procedure CallShowArtistsView(form)

* Display form in Artists Order
*******************************************************************************

* WORKAROUND -- "This" as a parameter to another object will translate to
*               that other object, not the current one
form.ShowArtistsView(form.root.view.organization.artist,;
                     form.popupMenu.organization.artist)


*******************************************************************************

procedure CallShowTitlesView(form)

* Display form in Titles  Order
*******************************************************************************

form.ShowTitlesView(form.root.view.organization.title,;
                    form.popupMenu.organization.title)


*******************************************************************************

procedure BrowseEdit(form)

* Display form in Browse format
*******************************************************************************

form.BrowseView()  && In the current form's file


*******************************************************************************

procedure FilterView(form)

* Set up filter form
*******************************************************************************
private filterForm, selected, tempFilt, curTable, saveCentury

curTable = alias()
if .not. empty(form.filter)
   if ConfirmationMessage(FormatStr(;
                                    "Current filter is\n %1.\n" +;
                                    "Do you want to turn it off?",;
                                    form.filter),;
                          "Confirmation") = YES
      select music
      set filter to
      go top
      select &curTable
      set filter to
      go top
      form.filter = ""
      SetTopBotRecs(form)
   endif
else
   saveCentury = set("century")         && Allow specification of full year
   set century on
   set procedure to Filter.wfm additive
   filterForm = new FilterForm()
   filterForm.mdi = .F.
   filterForm.viewForm = form
   selected = filterForm.ReadModal()
   set century &saveCentury
   if type("selected") = "O" .and. selected.id <> 0
                                                 && If Cancel wasn't pressed
      SetTopBotRecs(form)
   endif
   filterForm.Release()
   form.SetFocus()
   if alias() = "MUSIC"     && If in Musiview form view, call its OnNavigate
      form.OnNavigate()
   endif
endif



*******************************************************************************

procedure SearchItems(form)

* Search for an item.  Brings up a dialog for specifying an item to searh for.
*******************************************************************************
private searchForm, searchResult, saveFields, field2

if .not. empty(form.filter)          && If a filter has been set up
   if ConfirmationMessage(FormatStr(;
                                    "Current filter is\n %1.\n" +;
                                    "Do you want to turn it off?",;
                                    form.filter),;
                          "Confirmation") = YES
      set filter to                  && Clear filter
      form.filter = ""
   endif
endif
saveFields = setto("fields")
if alias() <> "MUSIC"    && Make only the Descript field available.
   field2 = field(2)
   set fields to
   set fields to &field2
else
   set fields to
endif

set procedure to Search.wfm additive
searchForm = new SearchForm()
searchForm.mdi = .F.
searchResult = searchForm.Readmodal()
searchForm.Release()
set fields to &saveFields
if alias() = "MUSIC"     && If in Musiview form, call its OnNavigate
   form.OnNavigate()
endif


*******************************************************************************

procedure SkipItems(form)

* Skip to a specified record.  Brings up a dialog for specifying how far
* to skip.
*******************************************************************************
local skipForm

set procedure to Skip.wfm additive
skipForm = new SkipForm()
skipForm.mdi = .F.       && Do this here so can use Form Designer on form
skipForm.ReadModal()
skipForm.Release()
if alias() = "MUSIC"     && If in Musiview form view, call its OnNavigate
   form.OnNavigate()
endif





*************************** Utility Procedures *******************************

******************************************************************************
procedure SetTopBotRecs(f)

* Stores the first and last records for the current display order.
******************************************************************************

go top
f.firstRec = recno()
go bottom
f.lastRec = recno()
go f.firstRec



******************************************************************************
function FormatStr(string)

* Could have 0 or more parameters.
* This function will replace occurrences of "%<n>" with the corresponding
* parameter string.  It will also replace all occurrences of "\n" with a
* Carriage Return, and all occurrences of "\t" with a Tab.
*
* Example: x = FormatStr("Hello \n %1", "World") && prints Hello World on 2
*                                                && lines
******************************************************************************
#define ENTER  chr(13)
#define TAB    chr(9)
local i, strPos, strCnt, tmpStr

tmpStr = string
for i = 2 to argc()    && while have something to search for
   tmpStr = StrTran(tmpStr, "%" + ltrim(str(i - 1)), argv(i))
next
tmpStr = StrTran(tmpStr, "\n", ENTER)
tmpStr = StrTran(tmpStr, "\t", TAB)

return tmpStr


******************************************************************************
function StrTran(string,curStr,repStr)

* Replaces all occurrences of curStr in string with repStr
******************************************************************************
local strPos, lenCurStr, tmpStr

tmpStr = string
lenCurStr = len(curStr)
strPos = at(curStr,tmpStr)
do while strPos > 0
   tmpStr = stuff(tmpStr, strPos, lenCurStr, repStr)
   strPos = at(curStr,tmpStr)
enddo

return tmpStr




