************************************************************************************
*  PROGRAM:      Music.cc
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         2/94
*
*  UPDATED:      5/95
*
*  REVISION:     $Revision:   1.15  $
*
*  VERSION:      Visual dBASE
*
*
*  DESCRIPTION:  This is a procedure file containing class definitions for
*                text, entryfields, and buttons used in the Musical Methods
*                application.
*
*                Current Classes:
*                   EmphasizedText
*                   EmphasizedEntry
*                   NormalText
*                   NormalEntry
*                   NextMButton
*                   PrevMButton
*                   OkMButton
*                   CancelMButton
*                   CloseMButton
*                   MusicButton
*
*
*
*  PARAMETERS:   Each custom button control in this file requires 2 arguments:
*                F    -- Object -- Reference to the parent form
*                Name -- String -- Name of the control being created
*                Example:
*                   f = new form()
*                   p = new OkButton(f,"myOkButton")
*
*  CALLS:        None
*
*  USAGE:        SET PROCEDURE TO Music.cc, then use these classes with:
*                NEW syntax:  x = new OkButton(f),
*                DEFINE syntax: define OkButton x of f
*                FORMS DESIGNER: select the classes from the DBW Custom Classes
*                                inspector when adding controls to your form.
*
*******************************************************************************
*******************************************************************************
*******************************************************************************
class EmphasizedText(f,name) of Text(f,name) custom
*******************************************************************************

   this.Alignment   = 5
   this.ColorNormal = "N/W"
   this.Border      = .F.
   this.Text        = "Artist"
   this.Width       = 13.52
   this.Height      = 2.02
   this.FontSize    = 10.00
   this.FontName    = "MS Sans Serif"
   this.FontBold    = .F.

endclass



*******************************************************************************
*******************************************************************************
class EmphasizedEntry(f,name) of Entryfield(f,name) custom
*******************************************************************************

   this.Alignment      = 3
   this.Enabled        = .F.
   this.ColorNormal    = "R/W"
   this.ColorHighlight = "W+/R"
   this.Height         = 1.26
   this.FontSize       = 10.00
   this.FontName       = "MS Sans Serif"
   this.Border         = .T.
   this.FontBold       = .T.
   this.Width          = 70.28

endclass


*******************************************************************************
*******************************************************************************
class NormalText(f,name) of Text(f,name) custom
*******************************************************************************

   this.Alignment   = 5
   this.ColorNormal = "N/W"
   this.Width       = 10.81
   this.Height      = 1.26
   this.FontSize    = 8.00
   this.FontName    = "MS Sans Serif"
   this.FontBold    = .F.

endclass

*******************************************************************************
*******************************************************************************
class NormalEntry(f,name) of Entryfield(f,name) custom
*******************************************************************************

   this.Alignment      = 3
   this.Enabled        = .F.
   this.ColorNormal    = "R/W"
   this.ColorHighlight = "R/W+"
   this.Width          = 13.52
   this.Height         = 1.26
   this.FontSize       = 8.00
   this.FontName       = "MS Sans Serif"
   this.Border         = .T.
   this.FontBold       = .T.

endclass

*******************************************************************************
*******************************************************************************
class NextMButton(f,name) of MusicButton(f,name) custom
*******************************************************************************

   this.upbitmap      = "Resource #100"
   this.SpeedTip      = "Next item in current order"
   this.text          = "&Next"
   this.StatusMessage = "Go to the next item in the current order."
   this.FontSize      = 8.00
   this.FontName      = "MS Sans Serif"

endclass

*******************************************************************************
*******************************************************************************
class PrevMButton(f,name) of MusicButton(f,name) custom
*******************************************************************************

   this.upbitmap      = "Resource #104"
   this.SpeedTip      = "Previous item in current order"
   this.text          = "&Previous"
   this.StatusMessage = "Go to the previous item in the current order."
   this.FontSize      = 8.00
   this.FontName      = "MS Sans Serif"

endclass



*******************************************************************************
*******************************************************************************
class OkMButton(f,n) of MusicButton(f,n) custom
*******************************************************************************


   this.text           = "OK"
   this.upbitmap       = "Resource #20"
   this.disabledbitmap = "Resource #21"
   this.FontSize       = 8.00
   this.FontName       = "MS Sans Serif"
   this.SpeedTip       = "Execute selection and close form"

endclass


*******************************************************************************
*******************************************************************************
class CancelMButton(f,n) of MusicButton(f,n) custom
*******************************************************************************

   this.text           = "Cancel"
   this.OnClick        = {;form.Close()}
   this.upBitmap       = "Resource #28"
   this.disabledBitmap = "Resource #29"
   this.StatusMessage  = "Cancel this form."
   this.FontSize       = 8.00
   this.FontName       = "MS Sans Serif"
   this.SpeedTip       = "Cancel selection and close form"

endclass

*******************************************************************************
*******************************************************************************
class CloseMButton(f,n) of MusicButton(f,n) custom
*******************************************************************************

   this.text           = "C&lose"
   this.OnClick        = {;form.Close()}
   this.upBitmap       = "Resource #1005"
   this.disabledBitmap = "Resource #1006"
   this.StatusMessage  = "Close this form."
   this.FontSize       = 8.00
   this.FontName       = "MS Sans Serif"
   this.SpeedTip       = "Close form"

endclass

*******************************************************************************
*******************************************************************************
class MusicButton(f,name) of Pushbutton(f,name) custom
*******************************************************************************

   this.colornormal = "n/w"
   this.height      = 1.50
   this.width       = 14.11
   this.FontSize    = 8.00
   this.FontName    = "MS Sans Serif"

endclass
