*******************************************************************************
*  PROGRAM:      Linklist.prg
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         6/93
*
*  UPDATED:      5/95
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This program creates a simple linked list of integers
*                from 1 to 10.  Each link in the chain is an instance of the
*                MyList class, which has 2 properties -- value, and next.
*                After the list is created, the function ShowList steps
*                through the list and shows all the links that have been
*                created.
*
*  PARAMETERS:   None
*
*  CALLS:        None
*
*  USAGE:        DO Linklist
*
*******************************************************************************

* environment
private saveTalk, saveLdCheck

if set("talk") = "ON"
   set talk off
   saveTalk = "ON"
else
   saveTalk = "OFF"
endif

saveLdCheck = set("ldCheck")
set ldCheck off

* a simple xbase linked-list:
private startList, link, i

* beginning of the list
startList = new MyList()     && Instantiation
link = startList             && Link is a temporary reference for
                             && stepping through the list
for i = 1 to 10
   link.val = i
   if i < 10   && don't need an extra instance of the class
      link.next = new MyList() && create a new link
      link = link.next
   endif
next

do ShowList

* restore environment
set ldCheck &saveLdCheck
set talk &saveTalk


* class definition for MyList
*******************************************************************************
*******************************************************************************
class MyList
*******************************************************************************

   this.val = 0
   this.next = 0

endclass




*******************************************************************************
function ShowList

*   Displays the linked list created in the main program
*******************************************************************************

link = startList  && start at the beginning of the list
do while (.not. empty(link))  && Go until no next link in list
   ? link.val
   link = link.next
enddo


