*******************************************************************************
*  PROGRAM:      dbsysdrv.prg
*
*  WRITTEN BY:   Borland Samples Group.
*
*  DATE:         1/94
*
*  UPDATED:      5/95
*
*  REVISION:     $Revision:   2.5  $
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  Small example that uses the dbfile.dll.
*                It searches system.ini for .drv drivers loaded.
*
*  PARAMETERS:   None
*
*  CALLS:        To dbfile.dll
*
*  USAGE:        do dbsysdrv
*
*******************************************************************************

 * Be quiet
set talk off

 * Check that the windows\system.ini file can be found
filename = "c:\windows\system.ini"
if .not. file( filename )
   filename = space( 145 )
   EXTERN CWORD GetWindowsDirectory( CSTRING, CINT ) krnl386.exe
   namelength = GetWindowsDirectory( filename, 144 )
   if namelength == 0
       ? "Can't find the Windows root directory."
       return
   endif
   filename = substr( filename, 1, namelength ) + "\system.ini"
   if .not. file( filename )
       ? "Can't find the windows\system.ini file."
       return
   endif
endif

 * Initialize dbfile.dll
set procedure to dbfile additive
do dbfile

 * Open up and set the filter to the string wanted.
f = new textfile()
if .not. f.open( filename )
   ? "Can't open " + filename
   return
endif
f.fieldseparator( "." )
f.filter( "drv" )

 * Find the lines with .drv at the end.
do while .not. (f.eof() .or. f.error())
    * Get the field count. Then get the last field.
   fields = f.getrec()
   str = lower( f.getfield( fields ) )

    * Is it drv? If so concatenate the rec into a line and print it.
   if str = "drv" .and. "drv" = str
       count = 1
       line = ""
       do while count <= fields
           line = line + f.getfield( count )
           if count < fields
               line = line + "."
           endif
           count = count + 1
       enddo
       ? line
   endif
enddo

 * Close up.
f.close()
f.release()

