*******************************************************************************
*  PROGRAM:      dbgrep.prg
*
*  WRITTEN BY:   Borland Samples Group.
*
*  DATE:         1/94
*
*  UPDATED:      5/95
*
*  REVISION:     $Revision:   2.4  $
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  Small example that uses dbfile.dll.  It implements
*                a grep to search for a literal string in a file.
*
*  PARAMETERS:   String to search for, filename.
*
*  CALLS:        To dbfile.dll
*
*  USAGE:        do dbgrep with "string", "filename"
*
*******************************************************************************

parameters str, name

set talk off

 * Check parameters.
tellusage = 1

 * Enough parameters?
if pcount() = 2
    * Of the right type?
   if type( "str" ) = "C" .AND. type( "name" ) = "C"
       tellusage = 0
   endif
endif

if tellusage = 1
   ? "Usage: do dbgrep with 'string', 'filename'"
   return
endif

 * Check for valid file.
if .not. file( name )
   ? "No such file: " + name
   return
endif

 * Initialize dbfile.dll
set procedure to dbfile additive
do dbfile

 * Open up and set the filter to the string wanted.
f = new textfile()
f.filter( str )
f.open( name )

 * Go till something happens.
do while .not. (f.eof() .or. f.error())
str = f.getline()
? str
enddo

 * Close up.
f.close()
f.release()
