#******************************************************************************
#
# FILE:        DBFile.mak
#
# WRITTEN BY:  Keimpe
#
# DATE:        1/94
#
# UPDATED:     5/95
#
# REVISION:    $Revision:   2.4  $
#
# VERSION:     Visual dBASE
#
# DESCRIPTION:
#
# Part of dbfile, a Visual dBASE example.
#
# makefile to build dbfile.dll
#
# wants CHOME or MAKEDIR to be defined.
#
# make -B -fdbfile.mak            builds dbfile.dll with debug info.
# make -B -DNDEBUG -fdbfile.mak   builds dbfile.dll without debug info.
#
# Dbfile.cpp uses some exception handling.  If you want to use
# no exception handling, define NO_EXCEPTIONS:
# make -B -fdbfile.mak -DNO_EXCEPTIONS
#
# This DLL HAS to run in large model.
#
#******************************************************************************

!if !$d(CHOME) && !$d(MAKEDIR)
   !error Need to set CHOME or MAKEDIR.
!endif

!if $d(NO_EXCEPTIONS)
EH=-DNO_EXCEPTIONS
!else
EH=
!endif

!if $d(CHOME)
ROOT=$(CHOME)
!else
ROOT=$(MAKEDIR)\..
!endif

!ifdef NDEBUG
CCDEBUG=
LINKDEBUG=
!else
CCDEBUG=-v
LINKDEBUG=/v
!endif

BCLIB=$(ROOT)\lib
BCINCLUDE=$(ROOT)\include;..\..\include

CC=BCC -WD -ml -c -M -I$(BCINCLUDE) $(CCDEBUG) $(EH)
LINK=tlink /L$(BCLIB) /Twd /n /m $(LINKDEBUG) $(BCLIB)\c0dl.obj

.cpp.obj:
   $(CC) $(@R).cpp

dbfile.dll: dbfile.obj
   $(LINK) dbfile, dbfile,, import mathwl cwl, dbfile.def

dbfile.obj: dbfile.cpp dbasevar.h

