//****************************************************************************
//
// FILE:        DBFile.h
//
// WRITTEN BY:  Keimpe
//
// DATE:        1/94
//
// UPDATED:     5/95
//
// REVISION:    $Revision:   2.10  $
//
// VERSION:     Visual dBASE
//
// DESCRIPTION:
//
//              TextFile header file that describes the TextFile class.
//              Part of dbfile, a Visual dBASE example.
//              See dbfile.cpp for a description of the example.
//
//****************************************************************************

#ifndef DBFILE_H

   // Get the DBaseVar and DVar stuff.
#include "dbasevar.h"

   // C++ TextFile Class.
class TextFile {

private:

   // BUFFERLENGTH indicates how many char's are read in at the same
   // time with a call to read.
#define BUFFERLENGTH 16000

   char         Buffer[ BUFFERLENGTH + 1 ]; // Holds a buffer of text.
   char        *BufPtr;              // Points into the Buffer..
   char        *CopyPtr;             // Start of Bufferpart to copy.
   char         ErrorString[50];     // Room for errormessages.
   char         FieldSeparator;      // Field separator char.
   char        *Filter;              // Holds the filter.
   long         FilterLen;           // How long is the filter.
   int          Handle;              // To hold the filehandle.
   char         LineSeparator;       // Line separator char.
   unsigned int MaxTextLen;          // Maximum length of Text.
   int          NumberOfFields;      // # of fields in a rec.
   char         PlusLineSeparator;   // Do we want any number of this one.
   char        *SaveFieldEndPtr;     // Marks the end of a field in Text.
   char        *Text;                // Text send over to Visual dBASE.
   unsigned int TextLen;             // Length of Text.

public:
      // Default constructor.
   TextFile() {
       Handle = 0;
       Text = new char[2];           // Room for a fieldseparator.
       Text[0] = 0x0;
       Text[1] = 0;
       TextLen = 0;
       MaxTextLen = 1;
       Filter = new char[1];
       Filter[0] = 0x0;
       FilterLen = 0;
       FieldSeparator = ' ';
       LineSeparator = '\n';
       PlusLineSeparator = 0;        // Default is one EOL.
   }

      // Destructor
   ~TextFile() {
      if( Handle != 0 )
         close( Handle );
      delete [] Text;
      delete [] Filter;
   }

      // Routines.
   BOOL  AddToText( char *, char * );
   BOOL  Close();
   BOOL  Eof()                         { return *BufPtr == 0x0 &&
                                                eof( Handle ); }
   BOOL  Error()                       { return ErrorString[0] != 0x0; }
   char *GetErrorString()              { return ErrorString; }
   char *GetField( int );
   int   GetNumberOfFields()           { return NumberOfFields; }
   BOOL  Open( char *FileToOpen );
   char *ReadNextItem( char );
   BOOL  SetFieldSeparator( char * );
   BOOL  SetFilter( char * );
   BOOL  SetLineSeparator( char * );
};

#define DBFILE_H
#endif

