#******************************************************************************
#
# FILE:        DBExtern.mak
#
# WRITTEN BY:  Keimpe
#
# DATE:        1/94
#
# UPDATED:     5/95
#
# REVISION:    $Revision:   2.5  $
#
# VERSION:     Visual dBASE
#
# DESCRIPTION:
#
# Part of dbextern, a Visual dBASE example.
#
# makefile to build dbextern.dll
#
# wants CHOME or MAKEDIR to be defined.
#
# make -B -fdbextern.mak            builds dbextern.dll with debug info.
# make -B -DNDEBUG -fdbextern.mak   builds dbextern.dll without debug info.
#
# Dbextern.cpp uses some exception handling.  If you want to use
# no exception handling, define NO_EXCEPTIONS:
# make -B -fdbextern.mak -DNO_EXCEPTIONS
#
# This DLL HAS to run in large model.
#
#******************************************************************************

!if !$d(CHOME) && !$d(MAKEDIR)
   !error Need to set CHOME or MAKEDIR.
!endif

!if $d(NO_EXCEPTIONS)
EH=-DNO_EXCEPTIONS
!else
EH=
!endif

!if $d(CHOME)
ROOT=$(CHOME)
!else
ROOT=$(MAKEDIR)\..
!endif

!ifdef NDEBUG
CCDEBUG=
LINKDEBUG=
!else
CCDEBUG=-v
LINKDEBUG=/v
!endif

BCLIB=$(ROOT)\lib
BCINCLUDE=$(ROOT)\include;..\..\include

CC=BCC -WD -ml -c -M -I$(BCINCLUDE) $(CCDEBUG) $(EH)
LINK=tlink /L$(BCLIB) /Twd /n /m $(LINKDEBUG) $(BCLIB)\c0dl.obj

.cpp.obj:
   $(CC) $(@R).cpp

dbextern.dll: dbextern.obj
   $(LINK) dbextern, dbextern,, import mathwl cwl, dbextern.def

dbextern.obj: dbextern.cpp dbasevar.h

