*******************************************************************************
*  PROGRAM:      Event.prg
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         6/93
*
*  UPDATED:      5/95
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This program uses the Visual dBASE object model to create
*                forms with event handlers that manipulate the properties of the
*                form and its controls.
*                The ButtonForm class creates a form which manipulates its
*                pushbuttons.
*                When you left click anywhere in that form, the pushbutton
*                will move to that point, and its caption will change to show
*                the current coordinates. You can also Ctrl-Click to
*                make another button, and Shift-Click to align all the buttons.
*
*                The SizeForm class creates another type of form.  When
*                you click and move in this form, its size will change
*                as you move the mouse.
*
*                Indicator messages are attached to events that don't
*                have any actions attached to them.  These messages will
*                display in the Command Results window when the corresponding
*                events occur.  Messages display both for button events and
*                form events.
*
*                All properties are changed using event handling
*                functions that are assigned to these forms.
*
*  PARAMETERS:   None
*
*  CALLS:        Buttons.cc    (Custom Controls file)
*                SetCapture()  (Windows API function)
*
*  USAGE:        DO Event
*
*******************************************************************************
#include <Utils.h>

create session
set talk off
set ldCheck off

set procedure to program(1) additive
set procedure to &_dbwinhome.samples\Buttons.cc additive

extern CWORD SetCapture(CWORD) USER && for sizeForm

local bForm, sForm

bForm = new ButtonForm("Button Form","Click anywhere in the form to move button")
sForm = new SizeForm("Size Form","Click in the form and move mouse to resize form")
sForm.Open()
bForm.Open()


*******************************************************************************
*******************************************************************************
class EventForm(name, titleText) of Form

* Basic form with a pushbutton in the center
*******************************************************************************

   this.top = 0.00
   this.left = 1.35
   this.height = 11.22
   this.width = 51.43
   this.name = name
   this.text = name + ": " + titleText
   this.titleText = titleText

   * custom properties
   this.buttonCnt = 1                 && Button count on this form

   this.buttonHeight = 3.06           && Initial height and width for buttons
   this.buttonWidth = 10.81
   this.curHeight = this.height       && Initial height and width for form
   this.curWidth  = this.width
   this.totalRows = floor(this.height/this.buttonHeight)  && Total allowed
   this.totalCols = floor(this.width/this.buttonWidth)    && rows, columns

   * a button
   this[1] = new EventButton(this)

   * Events
   * These are just some of the events you can detect in a form

   this.OnOpen          = {;ShowEvent(this.name,"OnOpen")}
   this.OnGotFocus      = {;ShowEvent(this.name,"OnGotFocus")}
   this.OnSize          = CLASS::OnSize
   this.OnLeftMouseDown = {;ShowEvent(this.name,"OnLeftMouseDown")}
   this.OnMove          = {;ShowEvent(this.name,"OnMove")}
   this.OnLostFocus     = {;ShowEvent(this.name,"OnLostFocus")}
   this.OnClose         = {;ShowEvent(this.name,"OnClose")}

   * Add sampleInfoButton -- defined in Buttons.cc

   define sampleInfoButton eventInfoButton of this;
      property;
         top 0,;
         left this.width - 3.5;
      custom;
         sampleName "Event.prg"


   ****************************************************************************
   procedure OnSize
   ****************************************************************************

   form.eventInfoButton.left = form.width - 3.5
   ShowEvent(form.name,"OnSize")





endclass   && EventForm






*******************************************************************************
*******************************************************************************
class EventButton(f) of PushButton(f)
*******************************************************************************

   this.height = form.buttonHeight
   this.width = form.buttonWidth
   this.top = (f.height - this.height)/2
   this.left = (f.width - this.width)/2
   this.text = ""
   this.fontname = "MS Sans Serif"
   this.fontsize = 15
   this.fontbold = .T.

   * Events
   * These are all the events you can detect in a pushbutton

   this.OnMouseMove       = {;ShowEvent(form.className+"."+this.name,"OnMouseMove")}
   this.OnRightMouseUp    = {;ShowEvent(form.className+"."+this.name,"OnRightMouseUp")}
   this.OnRightMouseDown  = {;ShowEvent(form.className+"."+this.name,"OnRightMouseDown")}
   this.OnRightDblClick   = {;ShowEvent(form.className+"."+this.name,"OnRightDblClick")}
   this.OnMiddleMouseUp   = {;ShowEvent(form.className+"."+this.name,"OnMiddleMouseUp")}
   this.OnMiddleMouseDown = {;ShowEvent(form.className+"."+this.name,"OnMiddleMouseDown")}
   this.OnMiddleDblClick  = {;ShowEvent(form.className+"."+this.name,"OnMiddleDblClick")}
   this.OnLeftMouseUp     = {;ShowEvent(form.className+"."+this.name,"OnLeftMouseUp")}
   this.OnLeftMouseDown   = {;ShowEvent(form.className+"."+this.name,"OnLeftMouseDown")}
   this.OnLeftDblClick    = {;ShowEvent(form.className+"."+this.name,"OnLeftDblClick")}
   this.OnLostFocus       = {;ShowEvent(form.className+"."+this.name,"OnLostFocus")}
   this.OnGotFocus        = {;ShowEvent(form.className+"."+this.name,"OnGotFocus")}
   this.OnOpen            = {;ShowEvent(form.className+"."+this.name,"OnOpen")}
   this.When              = {||ShowEvent(form.className+"."+this.name,"When")}
   this.OnHelp            = {;ShowEvent(form.className+"."+this.name,"OnHelp")}
   this.OnClick           = {;ShowEvent(form.className+"."+this.name,"OnClick")}

endclass   && EventButton


*******************************************************************************
*******************************************************************************
class ButtonForm(name, titleText) of EventForm(name, titleText)

* Create a form with a button that will move to new coordinates inside
* the form when the left mouse button is clicked (and some other funcky stuff).
*******************************************************************************

this.statusmessage = "Click - move button, Ctrl+Click - copy button,;
   Shift+Click - allign buttons."


   *******************************************************************************
   procedure OnSize (nType,width,height)
   *******************************************************************************
   local i, r, c, newBHeight, newBWidth, button, hRatio, wRatio

   if height <> form.curHeight .or. width <> form.curWidth
      form.OnLeftMouseDown(MK_SHIFT,0,0)       && Align all buttons
      hRatio = height/form.curHeight
      wRatio = width/form.curWidth
      newBHeight = form.buttonHeight * hRatio  && Proportional
      newBWidth  = form.buttonWidth  * wRatio  && button height
      r = 0                                    && and width
      c = 0
      for i = 1 to form.buttonCnt
         button = form[i]
         button.top     = r * newBHeight
         button.left    = c * newBWidth
         button.height  = newBHeight
         button.width   = newBWidth
         button.text    = TRIMSTR(button.top) + "," + TRIMSTR(button.left)
         button.fontSize = button.fontSize * (hRatio + wRatio)/2
         button.visible = .T.
         r = r + 1
         if (r = form.totalRows)
            r = 0
            c = c + 1
         endif
      next i
      form.curHeight    = height               && Reset base height, width
      form.curWidth     = width                && for buttons and current
      form.buttonHeight = newBHeight           && height, width for form
      form.buttonWidth  = newBWidth
      ShowEvent(this.name,"OnSize")
   endif


   *******************************************************************************
   procedure OnOpen


   * Give button its location and font
   ********************************************************************************

   this.OnLeftMouseDown(0,this[1].left,this[1].top)


   *******************************************************************************
   procedure OnLeftMouseDown(flags, col, row)

   * OnLeftMouseDown event handler for buttonForm
   *
   * Click                -- moves last button to current location
   * Shift + click        -- aligns buttons in form
   * Ctrl + click         -- adds a new button at current location
   *
   *******************************************************************************
   private f, i, r, c, button, maxCol, maxRow, bHeight, bWidth, bCnt

   bHeight   = form[1].height
   bWidth    = form[1].width
   if bitand(flags,MK_SHIFT) = MK_SHIFT  && SHIFT key was pressed
      r = 0
      c = 0
      for i = 1 to form.buttonCnt
         button      = form[i]
         button.top  = r * bHeight
         button.left = c * bWidth
         button.text = TRIMSTR(button.top) + "," + TRIMSTR(button.left)
         r = r + 1
         if (r = form.totalRows)
            r = 0
            c = c + 1
         endif
      next i
   else
      if bitand(flags,MK_CONTROL) = MK_CONTROL  && Create another button
         *** create another button
         this.buttonCnt = form.buttonCnt + 1    && Increase button count
         form[form.buttonCnt] = new EventButton(form)
         form[form.buttonCnt].visible = .F.
      endif
      button = form[form.buttonCnt]   && temporary reference, for easier reading
      button.text = TRIMSTR(row) + "," + TRIMSTR(col)
      button.left = col
      button.top  = row
      button.visible = .T.                 && Make button visible only
                                           && after all changes to it have been
                                           && made.
   endif
   button.setFocus()    && So the status message would appear

endclass   && ButtonForm


*******************************************************************************
*******************************************************************************
class SizeForm(name, titleText) of EventForm(name, titleText)

* Create  a form that will get resized as you click
* the left mouse button and move.
*******************************************************************************

   this.top = 12.86
   this.width = 51.43
   this.height = 8.08
   this.OnSize = CLASS::SizeButton  && Resize the button when form is resized
   this.OnSize()
   this[1].text = "Button"

   *******************************************************************************
   procedure OnLeftMouseDown(flags, x, y)

   *  Event handler for sizeForm.
   *  Makes the size of the form change depending on the location of the mouse
   *  while the mouse is pressed.
   *******************************************************************************

   this.OnSize = .F.
   SetCapture(this.hwnd)           && Current window receives all mouse messages
                                   && Resize form and button as mouse moves
   this.OnMouseMove = CLASS::SizeTheForm


   *******************************************************************************
   procedure OnLeftMouseUp

   *  Event handler for sizeForm.
   *  Stop resizing the form while mouse is pressed and moving.  Now assign the
   *  Button resizing to the OnSize event.
   *******************************************************************************

   SetCapture(0)
   this.OnMouseMove = .F.
   this.OnSize = CLASS::SizeButton      && Resize button when form changes size


   *******************************************************************************
   procedure SizeTheForm(flags, col, row)

   * Changes the size of the form to reflect the current mouse position.
   *******************************************************************************

   this.height = iif(row < 1, 1, row)   && Make sure numbers not negative
   this.width = iif(col < 1, 1, col)
   this.SizeButton()


   *******************************************************************************
   function SizeButton

   * Changes button to always be in the center of the form, and the same size
   * relative to the size of the form.
   *******************************************************************************
   local button

   button = this[1]
   button.fontName = "Serif"
   button.height = this.height/3
   button.width = this.width/3
   button.top = this.height/3.03
   button.left = this.width/2.55

   return .T.

endclass   && SizeForm


*******************************************************************************
function ShowEvent(name, eventName)

* Display the object name in proper case, and the event that happened.
*******************************************************************************

?proper(name), " -- ", eventName
return .T.


