*******************************************************************************
*  PROGRAM:      DBClock.prg
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         12/93
*
*  UPDATED:      5/95
*
*  REVISION:     $Revision:   1.32  $
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This is a digital non-mdi clock that you can modify to your
*                liking. It can run in the background while other
*                Visual dBASE programs are running.
*                This program uses the DBTimer VBX control to update the clock.
*                You can modify the way this clock looks by selecting
*                desired options from the options menu.
*                You can modify the font, color, and time display.
*                The size of the time characters will change as you resize
*                the clock form, but the time display should always be
*                centered in the form.
*
*                WARNING:
*                   If something goes awry, the timer might continue
*                   running, and the Visual dBASE Alert window will come up
*                   with each clock tick.  This could cause problems.
*
*  PARAMETERS:   None
*
*  CALLS:        DBTimer.vbx   (time VBX control)
*                Buttons.cc    (custom controls file)
*
*  USAGE:        Do DBClock
*
*******************************************************************************
create session
set talk off
set ldCheck off
set design off

set procedure to program(1) additive
set procedure to &_dbwinhome.samples\Buttons.cc additive
local f
f = new ClockForm()
f.open()

*******************************************************************************
*******************************************************************************
class ClockForm of Form
*******************************************************************************

   this.top = 0
   this.left = 65.38
   this.height = 4.08
   this.width = 11.22
   this.mdi = .F.
   this.minimize = .T.
   this.text = "Clock"
   this.sizeable = .T.
   this.moveable = .T.
   this.sysMenu = .T.
   this.colorNormal = "bg+/n"

   define text timeText of this;
      property;
         text time(),;
         alignment 4,;
         colornormal "bg+/n",;
         height 6.12,;
         width 11.22,;
         fontName "Sans Serif",;
         fontBold .F.

   load dll dbtimer.vbx
   define dbtimer timer of this;
      property;
         Width          4.62,;
         Height          2.37,;
         Top          300.06,;
         Left         300.12,;
         OnTimer {;form.timeText.text = form.GetTime()}
   define sampleInfoButton dbClockInfoButton of this;
      property;
         Width        3.5,;
         Height       1.2,;
         Top          .1,;
         Left         13.9;
      custom;
         sampleName "Dbclock.prg"

   this.TimeProperty = CLASS::TimeProperty
   this.DefineMenu()


   *******************************************************************************
   procedure OnOpen
   *******************************************************************************
   private optionsRef

   public formatMenuChecked, colorNormalMenuChecked, fontNameMenuChecked,;
      fontBoldMenuChecked, fontItalicMenuChecked


   this.menuReleased = .F.             && -- Indicates that form has no menu
   this.timeFormat = 0                 && -- Format of the time text
   this.GetTime = Get24Time            && -- Function called to display the time.
                                       && GetTime will be set to Get24Time or
                                       && Get12Time depending on the format
                                       && menu option selected.

   optionsRef = this.MainMenu.Options  && So don't have to access reference
                                       && each time

   formatMenuChecked      = optionsRef.Formats.TwentyFourHrFormat
   colorNormalMenuChecked = optionsRef.Colors.CyanColor
   fontNameMenuChecked    = optionsRef.Fonts.SansSerifFont
   fontBoldMenuChecked    = optionsRef.Bold.BoldOff
   fontItalicMenuChecked  = optionsRef.Italic.ItalicOff
   this.OnSize(.F.,this.width,this.height)  && initial sizing
   this.timer.enabled     = .T.


   *******************************************************************************
   procedure OnClose

   * Release all public variables.  This will be unnecessary when they
   * will be properties.
   *******************************************************************************

   set design on
   release formatMenuChecked,colorNormalMenuChecked,fontNameMenuChecked,;
      fontBoldMenuChecked,fontItalicMenuChecked
   close procedure program(1)


   *******************************************************************************
   procedure OnGotFocus
   *******************************************************************************

   set design off


   *******************************************************************************
   procedure OnLostFocus
   *******************************************************************************

   set design on


   *******************************************************************************
   procedure OnSize (nType, width, height)

   * Resize the text to the form.
   *******************************************************************************
   local timeText

   timeText = form.timeText
   timeText.width = width
   timeText.height = height
   timeText.fontSize = (height + width)/2
   form.dbClockInfoButton.left = width - form.dbClockInfoButton.width


   *******************************************************************************
   procedure TwelveHour

   * Set up the time display to use 12 hour representation.
   *******************************************************************************

   if this.timeFormat <> 12
      this.timeFormat = 12
      this.GetTime = Get12Time
   endif


   ********************************************************************************
   procedure TwentyFourHour

   * Set up the time display to use 24 hour representation
   ********************************************************************************

   if this.timeFormat <> 24
      this.timeFormat = 24
      this.GetTime = Get24Time
   endif


   ****************************************************************************
   procedure TimeProperty

   * check the current menu item, and uncheck the previously checked item
   * in that group.  Set the corresponding property of the text control.
   ****************************************************************************
   private propRef, propName, timeText, menuVar, proc

   propName = this.parent.value
   menuVar = propName + "MenuChecked"
   &menuVar..checked = .F.         && Uncheck group's checked menu
   this.Checked = .T.
   &menuVar = this    && This is now the checked menu.
   if propName <> "Format"         && Change a property of the text control
      timeText = form.timeText
      propRef = "timeText." + propName
      &propRef = this.value
   else                            && Change the format of the text
      proc = "form." + this.procName
      &proc()
   endif


   *******************************************************************************
   procedure DefineMenu

   * Create a menu for the clock
   *******************************************************************************

   define menu MainMenu of this

   define menu Options of this.MainMenu;
      property;
         text "&Options"

   define menu ExitMenu of this.MainMenu.Options;
      property;
         text "&Exit",;
         onclick {;form.Close()}
   define menu Separator1 of this.MainMenu.Options;
      property;
         separator .T.

   define menu Colors of this.MainMenu.Options ;
      property;
         text "&Colors";
      custom;
         value "ColorNormal"
   define menu CyanColor of this.MainMenu.Options.Colors;
      property;
         text "&Cyan",;
         onclick this.TimeProperty,;
         checked .T.;
      custom;
         value "bg+/n"
   define menu YellowColor of this.MainMenu.Options.Colors;
      property;
         text "&Yellow",;
         OnClick this.timeProperty;
      custom;
         value "gr+/n"
   define menu MagentaColor of this.MainMenu.Options.Colors;
      property;
         text "&Magenta",;
         OnClick this.timeProperty;
      custom;
         value "rb+/n"
   define menu RedColor of this.MainMenu.Options.Colors;
      property;
         text "&Red",;
         onclick this.timeProperty;
      custom;
         value "r+/n"

   define menu Separator2 of this.MainMenu.Options;
      property;
         separator .T.
   define menu Formats of this.MainMenu.Options;
      property;
         text "&Formats";
      custom;
         value "Format"
   define menu TwentyFourHrFormat of this.MainMenu.Options.Formats;
      property;
         text "Twenty Four Hour",;
         onclick this.TimeProperty,;
         checked .T.;
      custom;
         procName "TwentyFourHour"
   define menu TwelveHrFormat of this.MainMenu.Options.Formats;
      property;
         text "Twelve Hour",;
         onclick this.TimeProperty;
      custom;
         procName "TwelveHour"

   define menu Separator3 of this.MainMenu.Options;
      property;
         separator .T.
   define menu Fonts of this.MainMenu.Options;
      property;
         text "&Fonts";
      custom;
         value "FontName"
   define menu ArialFont of this.MainMenu.Options.Fonts;
      property;
         text "&Arial",;
         onclick this.timeProperty;
      custom;
         value "Arial"
   define menu ScriptFont of this.MainMenu.Options.Fonts;
      property;
         text "&Script",;
         onclick this.timeProperty;
      custom;
         value "Script"
   define menu RomanFont of this.MainMenu.Options.Fonts;
      property;
         text "&Roman",;
         onclick this.timeProperty;
      custom;
         value "Roman"
   define menu SerifFont of this.MainMenu.Options.Fonts;
      property;
         text "S&erif",;
         onclick this.timeProperty;
      custom;
         value "Serif"
   define menu SansSerifFont of this.MainMenu.Options.Fonts;
      property;
         text "Sa&ns Serif",;
         onclick this.timeProperty,;
         checked .T.;
      custom;
         value "Sans Serif"
   define menu Bold of this.MainMenu.Options;
      property;
         text "&Bold Fonts";
      custom;
         value "FontBold"
   define menu BoldOff of this.MainMenu.Options.Bold;
      property;
         text "O&ff",;
         onclick this.timeProperty,;
         checked .T.;
      custom;
         value .F.
   define menu BoldOn of this.MainMenu.Options.Bold;
      property;
         text "&On",;
         onclick this.timeProperty;
      custom;
         value .T.
   define menu Italic of this.MainMenu.Options;
      property;
         text "&Italic Fonts";
      custom;
         value "FontItalic"
   define menu ItalicOff of this.MainMenu.Options.Italic;
      property;
         text "O&ff",;
         onclick this.timeProperty,;
         checked .T.;
      custom;
         value .F.
   define menu ItalicOn of this.MainMenu.Options.Italic;
      property;
         text "&On",;
         onclick this.timeProperty;
      custom;
         value .T.


endclass


*******************************************************************************
function Get12Time

* Create the string representing 12 hour time representation
*******************************************************************************
local time, hours

time = time()
hours = val(time)
return ltrim(str(mod(hours-1,12)+1)) + ;
         substr(time,3) + ;
         iif(hours < 12," AM"," PM")


*******************************************************************************
function Get24Time

* Create the string representing 24 hour time representation
*******************************************************************************

return time()       && Time in Visual dBASE is in 24 hour format by default
                    && (create session in beginning)




