*******************************************************************************
*  PROGRAM:      Changdir.prg
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         11/93
*
*  UPDATED:      6/95
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This is a tool for changing directories.  It brings up a
*                listbox of the current subdirectories, and lets you traverse
*                your directory tree.  Double clicking in the listbox will
*                select that directory.  Selecting the OK button makes your
*                selected directory the current directory, and the CANCEL
*                button cancels the program.
*
*  PARAMETERS:   None
*
*  CALLS:        Buttons.cc  (Custom Controls file)
*
*  USAGE:        Do Changdir/Changdir()
*
*  NOTE:         Visual dBASE has a function, GetDirectory(), which accomplishes
*                the same task as this program.
*
*******************************************************************************

#include <Messdlg.h>
#include <Utils.h>
#define DIRECTORY_ATTRIBUTE   "....D"

*** Environment  (alternative to CREATE SESSION)
private saveTalk, saveLdCheck, savePath, saveExact

if set("talk" ) = "ON"
   set talk off
   saveTalk = "ON"
else
   saveTalk = "OFF"
endif
saveLdCheck = set("ldCheck")
savePath = setto("path")           && Save current path because it will change
saveExact = set("exact")

set ldCheck off
set path to &_dbwinhome.samples
set exact on


set procedure to program(1) additive
set procedure to &_dbwinhome.samples\Buttons.cc additive

local f
f = new ChangDir()
f.ReadModal()

*******************************************************************************
*******************************************************************************
class ChangDir of Form
*******************************************************************************

   this.top = 5.30
   this.left = 6.76
   this.height = 15.00
   this.width = 54.06
   this.mdi = .F.
   this.sysmenu = .T.
   this.text = "Change Directory"
   this.sizeable = .T.
   this.OnOpen = CLASS::Form_OnOpen
   this.OnClose = CLASS::Form_OnClose
   this.OnSelection = CLASS::OkOnClick

   define listbox directList of this;
      property;
         OnLeftDblClick CLASS::SetNewDir,;
         top 3.18,;
         left 1.35,;
         height 11.5,;
         width 36.49,;
         colornormal "b/w",;
         statusmessage "Click on a directory to display it, double click to select it.";
      custom;
         dir set("directory")

   define entryfield curDirEntry of this;
      property;
         top 1.06,;
         left 0.00,;
         width 54.06,;
         value space(78),;
         colornormal "b/bg",;
         colorhighlight "b/w",;
         picture "@S78!",;
         statusmessage "Currently selected directory.",;
         OnGotFocus CLASS::CurDirEntry_OnGotFocus,;
         OnLostFocus CLASS::CheckDirExists

   define OkButton okToChange of this;
      property;
         OnClick CLASS::OkOnClick,;
         top 3.18,;
         left 39.19,;
         statusmessage "Change directory to the one selected."

   define CancelButton cancelChange of this;
      property;
         OnClick CLASS::CancelOnClick,;
         top 5.05,;
         left 39.19,;
         statusmessage "Forget it."

   define SampleInfoButton ChangdirInfoButton of this;
      property;
         top 13.5,;
         left 50;
      custom;
         sampleName "Changdir.prg"


   ******************************************************************************
   procedure Form_OnOpen
   ******************************************************************************

   form.saveDir  = set("directory") && save current dir in case Cancel selected

   form.curDir = setto("directory") && current directory
   form.CreateDirArray()            && Create array of current subdirectories

   form.directList.dataSource = "array form.dirAr"
   form.curDirEntry.dataLink = "form.curDir"
   show object form.directList
   show object form.curDirEntry


   ******************************************************************************
   procedure Form_OnClose

   * Clean up.
   ******************************************************************************

   set path to &savePath
   set exact &saveExact
   set ldCheck &saveLdCheck
   close procedure &_dbwinhome.samples\Buttons.cc,;
      program(1)

   cd
   set talk &saveTalk              && Private variable




   ******************************************************************************
   procedure OkOnClick

   * If selected directory exists, change to it, and leave, otherwise,
   * just leave.
   ******************************************************************************
   private curDir       && Macrosubstituted variables cannot be local.

   form.curDirEntry.OnLostFocus = .F.   && This would call CheckDirExists again,
   if CLASS::CheckDirExists()           && so turn it off until entryfield gets
      curDir = form.curDir              && focus.
      cd &curDir
      form.Close()
   endif


   ******************************************************************************
   procedure CancelOnClick

   * Restore original directory, and close form.
   ******************************************************************************
   private saveDir      && Macrosubstituted variables cannot be local.

   saveDir = form.saveDir
   cd &saveDir
   form.Close()


   ******************************************************************************
   procedure CurDirEntry_OnGotFocus

   * Make sure correct sequence of events gets executed.
   ******************************************************************************

   form.prevDir = this.value            && Save current dir just in case
                                        && Assign OnLostFocus now, so no
   this.OnLostFocus = CLASS::CheckDirExists     && confusion between OnSelection
                                                && and OnLostFocus routines


   ******************************************************************************
   procedure SetNewDir

   * Change to selected directory.
   ******************************************************************************
   private newDir, divideChar, showDir, lastSlashLoc, trimCurDir, curDir

   newDir = ALLTRIM(form.directList.value)
   trimCurDir = ALLTRIM(form.curDir)
   lastSlashLoc = rat("\",trimCurDir)
   if .not. empty(newDir) .and. newDir <> "."
      divideChar = iif(right(trimCurDir,1) = "\","","\")
                                    && if last char of
                                    && form.curDir is '\', don't need
                                    && to add it
      if newDir = ".."              && Go back a directory
         && ?more than one branch off the root
         form.curDir = substr(trimCurDir,1,lastSlashLoc - ;
            iif(lastSlashLoc > 3,1,0))
      else
         form.curDir = trimCurDir + iif(.not. empty(newDir),divideChar,"");
            + newDir
      endif
      curDir = form.curDir
      cd &curDir
      form.dirAr = new Array(0)
      form.CreateDirArray()
      show object form.curDirEntry
      show object form.directList
      redefine listbox directList of form;
         property;
           top 3.18,;
           left 1.35,;
           height 11.5,;
           width 36.49,;
           dataSource "array form.dirAr",;
           colornormal "b/w";
         custom;
           dir form.curDir
   endif

   ******************************************************************************
   procedure CreateDirArray

   * Create array for holding subdirs of current directory.
   ******************************************************************************
   private i, j, tempAr, tempArSize

   tempAr = new Array(0)
   tempArSize = tempAr.Dir("*.*",DIRECTORY_ATTRIBUTE)
   j = 0
   form.dirAr = new Array(0)
   for i = 1 to tempArSize
      if tempAr[i,5] = DIRECTORY_ATTRIBUTE   && if directory, add it to form.dirAr
         j = j + 1
         form.dirAr.Grow(1)
         form.dirAr[j] = tempAr[i,1]
      endif
   next i
   form.dirAr.Sort()


   ******************************************************************************
   function CheckDirExists

   * If selected directory exists, change to it.
   ******************************************************************************
   local ratSlash, lenCurDir, exit
   private dirExists, curDir

   ratSlash = rat("\", form.curDir)
   lenCurDir = len(rtrim(form.curDir))
   dirExists = .T.
   exit = .F.

   do case
      case .not. CLASS::DirExists(form.curDir)
         if ConfirmationMessage(ALLTRIM(form.curDir) + chr(13) +;
            "Doesn't exist. Continue?","Confirmation") = YES
            form.curDir = form.prevDir
            show object form.curDirEntry
         else
            exit = .T.
         endif
         dirExists = .F.
      case form.curDir <> form.directList.dir
         * can't use RIGHT() because  string doesn't necessarily fill value
         if ratSlash = lenCurDir .and. lenCurDir > 3  && get rid of last \
            form.curDir = stuff(form.curDir, ratSlash, 1, "")
         endif
         curDir = form.curDir
         cd &curDir
         show object form.curDirEntry        && Update entryfield display
         form.CreateDirArray()
         redefine listbox directList of form;
            property;
            top 3.18,;
            left 1.35,;
            height 11.5,;
            width 36.49,;
            dataSource "array form.dirAr",;
            colornormal "b/w";
         custom;
            dir form.curDir
         show object form.directList
   endcase

   if exit
      form.cancelChange.OnClick()
   endif

   return dirExists



   ******************************************************************************
   function DirExists(dir)

   * Check if dir exists.
   * Use adir() to create an array of subdirectories of the dir in question.
   * If any subdirectories exist (including ..\.), then dir exists.
   ******************************************************************************
   private d, retVal, lastSlashLoc, returnValue

   d = rtrim(dir)
   do case
      case at("\\", d) > 0                         && Double slash
         returnValue = .F.
      case at("::", d) > 0                         && Double colon
         returnValue = .F.
      otherwise
         declare checkAr[1]
         lastChar = right(d, 1)
         if .not. right(d, 1) $ ":\"               && If not drive and has no last\
            d =  d + "\"                           && make dir end with \
         endif
         if file(d + "nul")
            returnValue = .T.                      && Dir exists
         else
            returnValue = .F.                      && Dir doesn't exist
         endif
   endcase

   return returnValue


endclass

