*******************************************************************************
*  PROGRAM:      Bintree.prg
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         5/93
*
*  UPDATED:      5/95
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This program illustrates the creation and traversal of a
*                binary tree using the Visual dBASE object() class.  It creates
*                a binary tree of client names in increasing alphabetical order,
*                left to right.  It then traverses the tree in that order.
*
*  PARAMETERS:   None
*
*  CALLS:        None
*
*  USAGE:        Do Bintree
*
*******************************************************************************
create session
set talk off
set ldCheck off
clear

use clients

private t
t = new Tree(contact,client_Id)
? "Scanning Clients table and building binary tree..."
?

skip
scan rest
  ?? '.'
  t.AddTree(contact,client_Id)
endscan

wait "Press any key to begin in-order traversal of binary tree..."

t.InOrder()

wait


*******************************************************************************
*******************************************************************************
class Tree(newKey,newValue)

* Creates binary tree.
*******************************************************************************

* Constructor

this.key = newKey
this.val = newValue
this.left = .F.
this.right = .F.


   ****************************************************************************
   procedure InOrder

   * Orders binary tree from left to right.
   ****************************************************************************

   * left
   if .not. empty(this.left)
      this.left.InOrder()
   endif

   * itself
   ?  this.key, this.val

   * right
   if .not. empty(this.right)
      this.right.InOrder()
   endif


   ****************************************************************************
   procedure AddTree(newKey,newValue)

   * Adds a new node to the tree.
   ****************************************************************************

   this.Insert(new Tree(newKey, newValue))


   ****************************************************************************
   procedure Insert(o)

   * Inserts a node into an ordered tree.
   ****************************************************************************

   if o.key < this.key
      if (empty(this.left))
         this.left = o
         return(o)
      else
         return(this.left.Insert(o))
      endif
   else
      if (empty(this.right))
         this.right = o
         return(o)
      else
         return(this.right.Insert(o))
      endif
   endif


endclass


