*******************************************************************************
*  FILE:         Winapi.h
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         7/15/93
*
*  UPDATED:      7/95
*
*  REVISION:     $Revision:   2.31  $
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This file contains Windows API function declarations
*                for calls to the Windows API from Visual dBASE.
*
*  USAGE:        (in a file)
*                #include <Winapi.h>
*
*******************************************************************************

#ifndef WINAPI_H
#define WINAPI_H

#define FALSE       0
#define TRUE        1
#define CBYTE       CWORD    && because a minimum of a CWORD is read anyway
#define RGB(r,g,b)  (r + g*256 + b*65536)

*** Constants for pixel screen dimensions

#define PIXELROWS     GetSystemMetrics(1)    && Screen Rows in pixels
#define PIXELCOLS     GetSystemMetrics(0)    && Screen Columns in pixels


*** External Function Declarations

***************** Drawing and Windowing functions

extern  CLOGICAL  AnyPopup ( CVOID ) USER
extern  CLOGICAL  Arc ( CHANDLE,CINT,CINT,CINT,CINT,CINT,CINT,CINT,CINT )  GDI
extern  CINT      ArrangeIconicWindows ( CHANDLE ) USER
extern  CLOGICAL  BitBlt ( CHANDLE,CINT,CINT,CINT,CINT,CHANDLE,CINT,CINT,CLONG )  GDI
extern  CVOID     BringWindowToTop ( CHANDLE ) USER
extern  CWORD     CascadeChildWindows ( CWORD,CWORD ) USER
extern  CLOGICAL  Chord ( CHANDLE,CINT,CINT,CINT,CINT,CINT,CINT,CINT,CINT )  GDI
extern  CVOID     ClipCursor (CPTR) USER
extern  CVOID     CloseWindow ( CHANDLE ) USER
extern  CINT      CombineRgn ( CHANDLE,CHANDLE,CHANDLE,CINT )  GDI
extern  CHANDLE   CopyCursor ( CHANDLE,CHANDLE )  USER
extern  CHANDLE   CreateCompatibleDC ( CHANDLE ) GDI
extern  CHANDLE   CreateCursor ( CHANDLE,CINT,CINT,CINT,CINT,CSTRING,CSTRING) USER
extern  CHANDLE   CreateDc ( CSTRING,CSTRING,CSTRING,CPTR) GDI
extern  CHANDLE   CreateEllipticRgn ( CINT,CINT,CINT,CINT )  GDI
extern  CHANDLE   CreateHatchBrush ( CINT,CLONG )  GDI
extern  CHANDLE   CreatePatternBrush ( CHANDLE )  GDI
extern  CHANDLE   CreatePen ( CINT,CINT,CLONG)  GDI
extern  CHANDLE   CreateRectRgn ( CINT,CINT,CINT,CINT )  GDI
extern  CHANDLE   CreateRoundRectRgn ( CINT,CINT,CINT,CINT,CINT,CINT )  GDI
extern  CHANDLE   CreateSolidBrush ( CLONG )  GDI
extern  CHANDLE   CreateWindow ( CSTRING,CSTRING,CLONG,CINT,CINT,CINT,CINT,;
                                    CHANDLE,CHANDLE,CHANDLE,CLONG ) USER
extern  CLOGICAL  DeleteDc ( CHANDLE )  GDI
extern  CLOGICAL  DeleteObject ( CHANDLE )  GDI
extern  CLOGICAL  DestroyCursor ( CHANDLE )  USER
extern  CLOGICAL  DestroyIcon ( CHANDLE )  USER
extern  CLOGICAL  DestroyWindow ( CHANDLE ) USER
extern  CLOGICAL  DrawIcon ( CHANDLE,CINT,CINT,CHANDLE )  USER
extern  CINT      DrawText ( CHANDLE,CSTRING,CINT,CPTR,CINT )  USER
extern  CHANDLE   Ellipse ( CHANDLE,CINT,CINT,CINT,CINT )  GDI
extern  CLOGICAL  EqualRgn ( CHANDLE,CHANDLE )  GDI
extern  CINT      Escape ( CHANDLE,CINT,CINT,CSTRING,CPTR )  GDI
extern  CINT      ExcludeClipRect ( CHANDLE,CINT,CINT,CINT,CINT )  GDI
extern  CINT      ExcludeUpdateRgn ( CHANDLE,CHANDLE )  USER
extern  CLOGICAL  ExtFloodFill ( CHANDLE,CINT,CINT,CLONG,CINT )  GDI
extern  CLOGICAL  FillRgn ( CHANDLE,CHANDLE,CHANDLE )  GDI
extern  CHANDLE   FindWindow ( CSTRING,CSTRING ) USER
extern  CLOGICAL  FlashWindow ( CHANDLE,CLOGICAL )  USER
extern  CLOGICAL  FloodFill ( CHANDLE,CINT,CINT,CLONG )  GDI
extern  CLOGICAL  FrameRgn ( CHANDLE,CHANDLE,CHANDLE,CINT,CINT )  GDI
extern  CHANDLE   GetActiveWindow (CVOID) USER
extern  CDOUBLE   GetBitmapDIMENSION ( CHANDLE )  GDI
extern  CLONG     GetBkColor ( CHANDLE )  GDI
extern  CINT      GetBkMode ( CHANDLE )  GDI
extern  CLONG     GetBrushORG ( CHANDLE )  GDI
extern  CLOGICAL  GetCharWidth ( CHANDLE,CINT,CINT,CSTRING )  GDI
extern  CVOID     GetClientRect ( CHANDLE,CPTR ) USER
extern  CDOUBLE   GetCurrentPosition ( CHANDLE )  GDI
extern  CHANDLE   GetCursor ( CVOID )  USER
extern  CVOID     GetCursorPos ( CPTR )  USER
extern  CHANDLE   GetDc ( CHANDLE )  USER
extern  CLONG     GetDcOrg ( CHANDLE )  GDI
extern  CHANDLE   BeginPaint ( CHANDLE, CPTR ) USER
extern  CVOID     EndPaint ( CPTR ) USER
extern  CHANDLE   GetDeskTopWindow ( CVOID )  USER
extern  CLONG     GetDialogBaseUnits ( CVOID ) USER
extern  CHANDLE   GetFocus ( CVOID )  USER
extern  CHANDLE   GetNextWindow ( CHANDLE,CINT )  USER
extern  CHANDLE   GetParent ( CHANDLE )  USER
extern  CLONG     GetPixel ( CHANDLE,CINT,CINT )  GDI
extern  CINT      GetPolyFillMode ( CHANDLE )  GDI
extern  CHANDLE   GetStockObject ( CINT )  GDI
extern  CINT      GetStretchBltMode ( CHANDLE )  GDI
extern  CLONG     GetSysColor ( CINT )  USER
extern  CHANDLE   GetSysModalWindow ( CVOID )  USER
extern  CINT      GetSystemPaletteEntries ( CHANDLE,CINT,CINT,CPTR )  GDI
extern  CINT      GetSystemPaletteUse ( CHANDLE )  GDI
extern  CLONG     GetTabbedTextExtent ( CHANDLE,CSTRING,CINT,CINT,CPTR )  USER
extern  CINT      GetTextAlign ( CHANDLE )  GDI
extern  CINT      GetTextCharacterExtra ( CHANDLE )  GDI
extern  CLONG     GetTextColor ( CHANDLE )  GDI
extern  CLONG     GetTextExtent ( CHANDLE,CSTRING,CINT )  GDI
extern  CLOGICAL  GetTextExtentPoint ( CHANDLE,CSTRING,CINT,CPTR )  GDI
extern  CINT      GetTextFace ( CHANDLE,CINT,CSTRING )  GDI
extern  CLOGICAL  GetTextMetrics ( CHANDLE,CPTR )  GDI
extern  CHANDLE   GetTopWindow ( CHANDLE )  USER
extern  CINT      GetUpdateRgn ( CHANDLE,CHANDLE,CLOGICAL )  USER
extern  CHANDLE   GetWindow ( CHANDLE,CINT )  USER
extern  CHANDLE   GetWindowDc ( CHANDLE )  USER
extern  CLONG     GetWindowExt ( CHANDLE )  GDI
extern  CLONG     GetWindowOrg ( CHANDLE )  GDI
extern  CVOID     GetWindowRect ( CHANDLE,CPTR ) USER
extern  CHANDLE   GetWindowTask( CHANDLE ) USER
extern  CINT      GetWindowText ( CHANDLE,CSTRING,CINT ) USER
extern  CINT      GetWindowTextLength ( CHANDLE ) USER
extern  CINT      IntersectClipRect ( CHANDLE,CINT,CINT,CINT,CINT )  GDI
extern  CVOID     InvalidateRect ( CHANDLE,CPTR,CLOGICAL ) USER
extern  CVOID     InvalidateRgn ( CHANDLE,CHANDLE,CLOGICAL )  USER
extern  CLOGICAL  InvertRgn ( CHANDLE,CHANDLE )  GDI
extern  CLOGICAL  IsChild ( CHANDLE,CHANDLE )  USER
extern  CLOGICAL  IsIconIC ( CHANDLE )  USER
extern  CLOGICAL  IsWindowVisible ( CHANDLE ) USER
extern  CLOGICAL  LineTo ( CHANDLE,CINT,CINT )  GDI
extern  CHANDLE   LoadBitmap ( CHANDLE,CSTRING )  USER
extern  CHANDLE   LoadCursor ( CSTRING,CHANDLE )  USER
extern  CHANDLE   LoadIcon ( CHANDLE,CSTRING )  USER
extern  CVOID     MessageBeep ( CINT )  USER
extern  CINT      MessageBox ( CHANDLE,CSTRING,CSTRING,CINT )  USER
extern  CLONG     MoveTo ( CHANDLE,CINT,CINT )  GDI
extern  CLOGICAL  MoveWindow ( CHANDLE, CINT, CINT, CINT, CINT,CLOGICAL ) USER
extern  CHANDLE   OffsetClipRgn ( CHANDLE,CINT,CINT )  GDI
extern  CINT      OffsetRgn ( CHANDLE,CINT,CINT )  GDI
extern  CLONG     OffSetWindowOrg ( CHANDLE,CINT,CINT )  GDI
extern  CLOGICAL  OpenIcon ( CHANDLE )  USER
extern  CLOGICAL  PaintRgn ( CHANDLE,CHANDLE )  GDI
extern  CLOGICAL  PatBlt ( CHANDLE,CINT,CINT,CINT,CINT,CLONG )  GDI
extern  CLOGICAL  Pie ( CHANDLE,CINT,CINT,CINT,CINT,CINT,CINT,CINT,CINT )  GDI
extern  CLOGICAL  PtInRegion ( CHANDLE,CINT,CINT )  GDI
extern  CLOGICAL  PtVisible ( CHANDLE,CINT,CINT )  GDI
extern  CLOGICAL  Rectangle ( CHANDLE,CINT,CINT,CINT,CINT )  GDI
extern  CVOID     ReleaseCapture ( CVOID )  USER
extern  CINT      ReleaseDc ( CHANDLE,CHANDLE )  USER
extern  CLOGICAL  RestoreDc ( CHANDLE,CINT ) GDI
extern  CLOGICAL  RoundRect ( CHANDLE,CINT,CINT,CINT,CINT,CINT,CINT )  GDI
extern  CINT      SaveDc ( CHANDLE ) GDI
extern  CVOID     ScreenToClient ( CHANDLE,CPTR) USER
extern  CINT      SelectClipRgn ( CHANDLE,CHANDLE )  GDI
extern  CHANDLE   SelectObject ( CHANDLE,CHANDLE )  GDI
extern  CHANDLE   SetActiveWindow(CHANDLE) USER
extern  CLONG     SetBitmapDimension ( CHANDLE,CINT,CINT )  GDI
extern  CLONG     SetBkColor ( CHANDLE,CLONG )  GDI
extern  CINT      SetBkMode ( CHANDLE,CINT )  GDI
extern  CLONG     SetBrushOrg ( CHANDLE,CINT,CINT )  GDI
extern  CHANDLE   SetCapture ( CHANDLE )  USER
extern  CWORD     SetClassWord (CHANDLE, CINT, CWORD) USER
extern  CHANDLE   SetCursor ( CHANDLE )  USER
extern  CVOID     SetCursorPos ( CINT,CINT )  USER
extern  CHANDLE   SetFocus ( CHANDLE ) USER
extern  CHANDLE   SetParent ( CHANDLE,CHANDLE )  USER
extern  CLONG     SetPixel ( CHANDLE,CINT,CINT,CLONG )  GDI
extern  CINT      SetPolyFillMode ( CHANDLE,CINT )  GDI
extern  CVOID     SetRectRgn ( CHANDLE,CINT,CINT,CINT,CINT )  GDI
extern  CINT      SetStretchBltMode ( CHANDLE,CINT )  GDI
extern  CHANDLE   SetSysModalWindow ( CHANDLE )  USER
extern  CINT      SetTextAlign ( CHANDLE,CINT ) GDI
extern  CLONG     SetTextColor ( CHANDLE,CLONG ) GDI
extern  CLONG     SetWindowOrg ( CHANDLE,CINT,CINT ) GDI
extern  CWORD     SetWindowPos ( CHANDLE,CHANDLE,CINT,CINT,CINT,CINT,CINT ) USER
extern  CVOID     SetWindowText ( CHANDLE,CSTRING ) USER
extern  CINT      ShowCursor ( CLOGICAL )  USER
extern  CVOID     ShowScrollBar ( CHANDLE,CINT,CLOGICAL ) USER
extern  CLOGICAL  ShowWindow ( CHANDLE,CINT ) USER
extern  CLOGICAL  StretchBlt ( CHANDLE,CINT,CINT,CINT,CINT,CHANDLE,CINT,CINT,CINT,CINT,CLONG )  GDI
extern  CWORD     TileChildWindows ( CWORD,CWORD ) USER
extern  CVOID     UpdateWindow ( CHANDLE )  USER
extern  CVOID     ValidateRgn ( CHANDLE,CHANDLE )  USER


*** Constant Graphing and Windowing Function Parameters
*******************************************************************************


********************** BitBlt() Raster Operation Types ************************

#define BLACKNESS           htoi("00000042")  &&* Turns all output black
#define DSTINVERT           htoi("00550009")  &&* Inverts destination
                                              &&  bitmap
#define MERGECOPY           htoi("00C000CA")  &&* Combines pattern and source
                                              &&  bitmap using Boolean AND
#define MERGEPAINT          htoi("00BB0226")  &&* Combines inverted source
                                              &&  with destination using
                                              &&  Boolean OR
#define NOTSRCCOPY          htoi("00330008")  &&* Copies inverted source
                                              &&  to destination
#define NOTSRCERASE         htoi("001100A6")  &&* Inverts result of combining
                                              &&  destination and source
                                              &&  bitmaps using Boolean OR
#define PATCOPY             htoi("00F00021")  &&* Copies pattern to
                                              &&  destination bitmap
#define PATINVERT           htoi("005A0049")  &&* Combines destination
                                              &&  bitmap with pattern using
                                              &&  Boolean XOR
#define PATPAINT            htoi("00FB0A09")  &&* Combines inverted source
                                              &&  with pattern using Boolean
                                              &&  OR.  Combines result of this
                                              &&  operation with destination
                                              &&  using Boolean OR.
#define SRCAND              htoi("008800C6")  &&* Combines pixels of
                                              &&  destination and source
                                              &&  bitmaps using Boolean AND
#define SRCCOPY             htoi("00CC0020")  &&* Copies source bitmap to
                                              &&  destination bitmap
#define SRCERASE            htoi("00440328")  &&* Inverts destination bitmap
                                              &&  and combines result with
                                              &&  source bitmap using Boolean
                                              &&  AND
#define SRCINVERT           htoi("00660046")  &&* Combines pixels of
                                              &&  destination and source
                                              &&  bitmaps using Boolean XOR
#define SRCPAINT            htoi("00EE0086")  &&* Combines pixels of
                                              &&  destination and source
                                              &&  bitmaps using Boolean OR
#define WHITENESS           htoi("00FF0062")  &&* Turns all output white


************************* CombineRgn() command values *************************

#define RGN_AND             1
#define RGN_OR              2
#define RGN_XOR             3
#define RGN_DIFF            4
#define RGN_COPY            5

************************* CreateHatchBrush() hatch styles *********************

#define HS_BDIAGONAL        3
#define HS_CROSS            4
#define HS_DIAGCROSS        5
#define HS_FDIAGONAL        2
#define HS_HORIZONTAL       0
#define HS_VERTICAL         1


****************************** CreatePen() pen styles *************************

#define PS_DASH             1
#define PS_DASHDOT          3
#define PS_DASHDOTDOT       4
#define PS_DOT              2
#define PS_INSIDEFRAME      6
#define PS_NULL             5
#define PS_SOLID            0



************************* CreateWindow() window styles ************************
*** These can be combined using Visual dBASE boolean functions

*** Clipping styles

#define WS_CLIPSIBLINGS      htoi("04000000")
#define WS_CLIPCHILDREN      htoi("02000000")

#define WS_CHILD             htoi("40000000")
#define WS_OVERLAPPED        htoi("00000000")
#define WS_POPUP             htoi("80000000")


*** Generic window states
#define WS_DISABLED          htoi("08000000")
#define WS_VISIBLE           htoi("10000000")

*** Main window states
#define WS_MAXIMIZE          htoi("01000000")
#define WS_MINIMIZE          htoi("20000000")

*** Main window styles

#define WS_BORDER            htoi("00800000")
#define WS_CAPTION           htoi("00C00000")    && bitor(WS_BORDER,WS_DLGFRAME)
#define WS_DLGFRAME          htoi("00400000")
#define WS_HSCROLL           htoi("00100000")
#define WS_MAXIMIZEBOX       htoi("00010000")
#define WS_MINIMIZEBOX       htoi("00020000")
#define WS_SYSMENU           htoi("00080000")
#define WS_THICKFRAME        htoi("00040000")
#define WS_VSCROLL           htoi("00200000")

*** Control window styles

#define WS_GROUP             htoi("00020000")
#define WS_TABSTOP           htoi("00010000")

*** Common Window Styles

#define WS_CHILDWINDOW       WS_CHILD
#define WS_OVERLAPPEDWINDOW  bitor(WS_OVERLAPPED,WS_CAPTION,WS_SYSMENU,;
                                      WS_THICKFRAME,WS_MINIMIZEBOX,;
                                      WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW       bitor(WS_POPUP,WS_BORDER,WS_SYSMENU)

*** Extended Window Styles

#define WS_EX_ACCEPTFILES    htoi("00000010")
#define WS_EX_DLGMODALFRAME  htoi("00000001")
#define WS_EX_NOPARENTNOTIFY htoi("00000004")
#define WS_EX_TOPMOST        htoi("00000008")
#define WS_EX_TRANSPARENT    htoi("00000020")

*** Obsolete style names

#define WS_ICONIC            WS_MINIMIZE
#define WS_SIZEBOX           WS_THICKFRAME
#define WS_TILED             WS_OVERLAPPED
#define WS_TILEDWINDOW       WS_OVERLAPPEDWINDOW







************************** DrawText() drawing flags ***************************

#define DT_TOP               0
#define DT_LEFT              0
#define DT_CENTER            1
#define DT_RIGHT             2
#define DT_VCENTER           4
#define DT_BOTTOM            8
#define DT_WORDBREAK         16
#define DT_SINGLELINE        32
#define DT_EXPANDTABS        64
#define DT_TABSTOP           128
#define DT_NOCLIP            256
#define DT_EXTERNALLEADING   512
#define DT_CALCRECT          1024
#define DT_NOPREFIX          2048
#define DT_INTERNAL          4096


************************* Escape() error codes ********************************

#define SP_ERROR            -1
#define SP_APPABORT         -2
#define SP_USERABORT        -3
#define SP_OUTOFDISK        -4
#define SP_OUTOFMEMORY      -5

******************** GetClientRect() specifications ***************************

#define GCR_WIDTH            5       && Client area width
#define GCR_HEIGHT           7       && Client area height


******************** GetDcEx() device context creation options ****************

#define DCX_CACHE            htoi("00000002")
#define DCX_CLIPCHILDREN     htoi("00000008")
#define DCX_CLIPSIBLINGS     htoi("00000010")
#define DCX_EXCLUDERGN       htoi("00000040")
#define DCX_INTERSECTRGN     htoi("00000080")
#define DCX_LOCKWINDOWUPDATE htoi("00000400")
#define DCX_PARENTCLIP       htoi("00000020")
#define DCX_USESTYLE         htoi("00010000")
#define DCX_WINDOW           htoi("00000001")

************************ GetWindowRect() coordinate constants *****************

#define GWR_LEFT             1       && Window left in pixels
#define GWR_TOP              3       && Window top in pixels
#define GWR_RIGHT            5       && Window right in pixels
#define GWR_BOT              7       && Window bottom in pixels

************************ GetStockObject() stock object types ******************

#define BLACK_BRUSH          4
#define DKGRAY_BRUSH         3
#define GRAY_BRUSH           2
#define HOLLOW_BRUSH         5
#define LTGRAY_BRUSH         1
#define NULL_BRUSH           5
#define WHITE_BRUSH          0


************************** ExtFloodFill() style flags *************************

#define FLOODFILLBORDER      0
#define FLOODFILLSURFACE     1


************************** GetBkMode() background modes ***********************

#define TRANSPARENT          1
#define OPAQUE               2


*********************** GetSysColor() display elements ************************

#define COLOR_ACTIVEBORDER        10
#define COLOR_ACTIVECAPTION        2
#define COLOR_APPWORKSPACE        12
#define COLOR_BACKGROUND           1
#define COLOR_BTNFACE             15
#define COLOR_BTNSHADOW           16
#define COLOR_BTNTEXT             18
#define COLOR_CAPTIONTEXT          9
#define COLOR_GRAYTEXT            17
#define COLOR_HIGHLIGHT           13
#define COLOR_HIGHLIGHTTEXT       14
#define COLOR_INACTIVEBORDER      11
#define COLOR_INACTIVECAPTION      3
#define COLOR_MENU                 4


#define COLOR_MENUTEXT             7
#define COLOR_SCROLLBAR            0
#define COLOR_WINDOW               5
#define COLOR_WINDOWFRAME          6
#define COLOR_WINDOWTEXT           8
#define COLOR_INACTIVECAPTIONTEXT 19
#define COLOR_BTNHIGHLIGHT        20


*************************** GetWindow() relationship flags ********************

#define GW_CHILD            5
#define GW_HWNDFIRST        0
#define GW_HWNDLAST         1
#define GW_HWNDNEXT         2
#define GW_HWNDPREV         3
#define GW_OWNER            4



******************** LoadBitmap() predefined Windows bitmaps ******************

#define OBM_CLOSE           32754
#define OBM_COMBO           32738
#define OBM_DNARROW         32752
#define OBM_DNARROWD        32742
#define OBM_LFARROW         32750
#define OBM_LFARROWD        32740
#define OBM_MNARROW         32739
#define OBM_REDUCE          32749
#define OBM_REDUCED         32746
#define OBM_RESTORE         32747
#define OBM_RESTORED        32744
#define OBM_RGARROW         32751
#define OBM_RGARROWD        32741
#define OBM_UPARROW         32753
#define OBM_UPARROWD        32743
#define OBM_ZOOM            32748
#define OBM_ZOOMD           32745
#define OBM_DNARROWI        32736
#define OBM_LFARROWI        32734
#define OBM_RGARROWI        32735
#define OBM_UPARROWI        32737

#define OBM_BTNCORNERS      32758
#define OBM_BTSIZE          32761
#define OBM_CHECK           32760
#define OBM_CHECKBOXES      32759
#define OBM_OLD_CLOSE       32767
#define OBM_OLD_DNARROW     32764
#define OBM_OLD_LFARROW     32762
#define OBM_OLD_REDUCE      32757
#define OBM_OLD_RESTORE     32755
#define OBM_OLD_RGARROW     32763
#define OBM_OLD_UPARROW     32765
#define OBM_OLD_ZOOM        32756
#define OBM_SIZE            32766

************************* LoadCursor() predefined Windows cursors *************

#define IDC_ARROW           32512
#define IDC_CROSS           32515
#define IDC_IBEAM           32513
#define IDC_ICON            32641
#define IDC_SIZE            32640
#define IDC_SIZENESW        32643
#define IDC_SIZENS          32645
#define IDC_SIZENWSE        32642
#define IDC_SIZEWE          32644
#define IDC_UPARROW         32516
#define IDC_WAIT            32514

************************* LoadIcon() predefined Windows icons *****************

#define IDI_APPLICATION     32512
#define IDI_ASTERISK        32516
#define IDI_EXCLAMATION     32515
#define IDI_HAND            32513
#define IDI_QUESTION        32514

************************ MessageBox() Dialog types ****************************

#define MB_ABORTRETRYIGNORE htoi("0002")    &&* Message box contains Abort,
                                            &&  Retry, Ignore pushbuttons
#define MB_APPLMODAL        htoi("0000")    &&* User must respond to the message
                                            &&  box before continuing work in
                                            &&  the parent window.
#define MB_DEFBUTTON1       htoi("0000")    &&* The first button is the default
#define MB_DEFBUTTON2       htoi("0100")    &&* The second button is the default
#define MB_DEFBUTTON3       htoi("0200")    &&* The third button is the default
#define MB_ICONASTERISK     htoi("0040")    &&* Same as MB_ICONINFORMATION
#define MB_ICONEXCLAMATION  htoi("0030")    &&* Exclamation point icon appears
#define MB_ICONHAND         htoi("0010")    &&* Same as MB_ICONSTOP
#define MB_ICONINFORMATION  MB_ICONASTERISK &&* A lower case "I" icon apperas
#define MB_ICONQUESTION     htoi("0020")    &&* A question mark icon appears
#define MB_ICONSTOP         MB_ICONHAND     &&* A stop-sign icon appears
#define MB_OK               htoi("0000")    &&* OK pushbutton
#define MB_OKCANCEL         htoi("0001")    &&* OK and Cancel pushbuttons
#define MB_RETRYCANCEL      htoi("0005")    &&* Retry and Cancel pushbuttons
#define MB_SYSTEMMODAL      htoi("1000")    &&* All applications are suspended
                                            &&  until the user responds to the
                                            &&  message box
#define MB_TASKMODAL        htoi("2000")    &&* Same as APPL_MODAL except that
                                            &&  all the top-level windows
                                            &&  belonging to the current task
                                            &&  are disabled if the parent
                                            &&  window is not specified
#define MB_YESNO            htoi("0004")    &&* Yes and No pushbuttons
#define MB_YESNOCANCEL      htoi("0003")    &&* Yes, No, Cancel pushbuttons



******************* MessageBox() standard Dialog button IDs ******************
#define IDOK                1
#define IDCANCEL            2
#define IDABORT             3
#define IDRETRY             4
#define IDIGNORE            5
#define IDYES               6
#define IDNO                7


**************************** StretchBlt() modes *******************************

#define STRETCH_ANDSCANS        1
#define STRETCH_ORSCANS         2
#define STRETCH_DELETESCANS     3




*********************** SetWindowPos() and WINDOWPOS flags ********************

#define SWP_NOSIZE          1
#define SWP_NOMOVE          2
#define SWP_NOZORDER        4
#define SWP_NOREDRAW        8
#define SWP_NOACTIVATE      htoi("0010")
#define SWP_FRAMECHANGED    htoi("0020")
#define SWP_SHOWWINDOW      htoi("0040")
#define SWP_HIDEWINDOW      htoi("0080")
#define SWP_NOCOPYBITS      htoi("0100")
#define SWP_NOOWNERZORDER   htoi("0200")

#define SWP_DRAWFRAME       SWP_FRAMECHANGED
#define SWP_NOREPOSITION    SWP_NOOWNERZORDER

#define SWP_NOSENDCHANGING  htoi("0400")
#define SWP_DEFERERASE      htoi("2000")



******************** SetWindowPos() hwndInsertAfter field values ***************

#define HWND_TOP            0
#define HWND_BOTTOM         1
#define HWND_TOPMOST       -1
#define HWND_NOTOPMOST     -2


**************************** SetTextAlign() constants */ ***********************

#define TA_NOUPDATECP       0
#define TA_UPDATECP         1
#define TA_LEFT             0
#define TA_RIGHT            2
#define TA_CENTER           6
#define TA_TOP              0
#define TA_BOTTOM           8
#define TA_BASELINE         htoi("0018")



***************************** Clipboard Functions *****************************


extern  CLOGICAL  ChangeClipboardChain ( CHANDLE,CHANDLE )  USER
extern  CLOGICAL  CloseClipboard ( CVOID )  USER
extern  CINT      CountClipboardFormats ( CVOID )  USER
extern  CLOGICAL  EmptyClipboard ( CVOID )  USER
extern  CINT      EnumClipboardFormats ( CINT )  USER
extern  CHANDLE   GetClipboardData ( CINT )  USER
extern  CINT      GetClipboardFormatName ( CINT,CSTRING,CINT )  USER
extern  CHANDLE   GetClipboardOwner ( CVOID )  USER
extern  CHANDLE   GetClipboardViewer ( CVOID )  USER
extern  CHANDLE   GetOpenClipboardWindow ( CVOID )  USER
extern  CINT      GetPriorityClipboardFormat ( CPTR,CINT )  USER
extern  CLOGICAL  IsClipboardFormatAvailable ( CINT )  USER
extern  CLOGICAL  OpenClipboard ( CHANDLE )  USER
extern  CINT      RegisterClipboardFormat ( CSTRING )  USER
extern  CHANDLE   SetClipboardData ( CINT,CHANDLE )  USER
extern  CHANDLE   SetClipboardViewer ( CHANDLE )  USER


**************** SetClipboardData() system defined clipboard formats **********

#define CF_BITMAP            2
#define CF_DIB               8
#define CF_DIF               5
#define CF_DSPBITMAP        htoi("0082")
#define CF_DSPMETAFILEPICT  htoi("0083")
#define CF_DSPTEXT          htoi("0081")
#define CF_METAFILEPICT      3
#define CF_OEMTEXT           7
#define CF_OWNERDISPLAY     htoi("0080")
#define CF_PALETTE           9
#define CF_PENDATA          10
#define CF_RIFF             11
#define CF_SYLK              4
#define CF_TEXT              1
#define CF_TIFF              6
#define CF_WAVE             12

*** "Private" formats don't get GlobalFree()'d
#define CF_PRIVATEFIRST     htoi("0200")
#define CF_PRIVATELAST      htoi("02FF")

*** "GDIOBJ" formats do get DeleteObject()'d
#define CF_GDIOBJFIRST      htoi("0300")
#define CF_GDIOBJLAST       htoi("03FF")




************************** Miscellaneous Functions *****************************s

extern  CINT      AccessResource ( CHANDLE,CHANDLE )  KERNEL
extern  CWORD     AddAtom ( CSTRING ) KERNEL
extern  CINT      BuildCommDCB ( CPTR,CPTR ) USER
extern  CINT      CloseComm ( CHANDLE ) USER
extern  CVOID     CreateCaret ( CHANDLE,CHANDLE,CINT,CINT ) USER

extern  CWORD     DeleteAtom ( CWORD ) KERNEL
extern  CVOID     DestroyCaret ( CVOID ) USER
extern  CLOGICAL  ExitWindows ( CLONG,CINT )  USER
extern  CLOGICAL  ExitWindowsExec ( CSTRING,CSTRING )  USER
extern  CVOID     FatalAppExit ( CINT,CSTRING )  KERNEL
extern  CWORD     FindAtom ( CSTRING ) KERNEL
extern  CHANDLE   FindResource ( CHANDLE,CSTRING,CSTRING )  KERNEL
extern  CVOID     FreeLibrary ( CHANDLE )  KERNEL
extern  CLOGICAL  FreeModule( CHANDLE ) KERNEL
extern  CLOGICAL  FreeResource ( CHANDLE )  KERNEL
extern  CINT      GetCaretBlinkTime ( CVOID ) USER
extern  CINT      GetClassName ( CHANDLE,CSTRING,CINT )  USER
extern  CINT      GetCommState ( CINT,CPTR ) USER
extern  CHANDLE   GetCurrentTask ( CVOID )  KERNEL
extern  CLONG     GetCurrentTime ( CVOID )  USER
extern  CINT      GetDeviceCAPS ( CHANDLE,CINT )  GDI
extern  CINT      GetDriveType ( CINT ) KERNEL
extern  CSTRING   GetDosEnvironment ( CVOID )  KERNEL
extern  CINT      GetDoubleClickTime ( CVOID )  USER
extern  CLONG     GetFreeSpace ( CINT )  KERNEL
extern  CINT      GetFreeSystemResources ( CINT )  USER
extern  CLOGICAL  GetInputState ( CLOGICAL ) USER
extern  CINT      GetKbCodePage ( CVOID ) KEYBOARD
extern  CINT      GetKeyState ( CINT ) USER
extern  CVOID     GetKeyboardState ( CPTR ) USER
extern  CINT      GetKeyboardType ( CINT ) KEYBOARD
extern  CINT      GetModuleFileName ( CHANDLE,CSTRING,CINT ) KERNEL
extern  CHANDLE   GetModuleHandle ( CSTRING ) KERNEL
extern  CINT      GetModuleUsage ( CHANDLE) KERNEL
extern  CINT      GetNumTaskS ( CVOID )  KERNEL
extern  CINT      GetPrivateProfileInt ( CSTRING,CSTRING,CINT,CSTRING )  KERNEL
extern  CINT      GetPrivateProfileString ( CSTRING,CSTRING,CSTRING,CSTRING,CINT,CSTRING )  KERNEL
extern  CINT      GetProfileInt ( CSTRING,CSTRING,CINT )  KERNEL
extern  CINT      GetProfileString ( CSTRING,CSTRING,CSTRING,CSTRING,CINT )  KERNEL
extern  CINT      GetSystemDirectory ( CSTRING,CINT )  KERNEL
extern  CINT      GetSystemMetrics ( CINT )  USER
extern  CBYTE     GetTempDrive ( CWORD )  KERNEL
extern  CLONG     GetTickCount ( CVOID )  USER
extern  CLONG     GetTimerResolution ( CVOID )  USER
extern  CLONG     GetVersion ( CVOID )  KERNEL
extern  CINT      GetWindowsDirectory ( CSTRING,CINT )  KERNEL
extern  CLONG     GetWinFlags ( CVOID )  KERNEL
extern  CINT      GlobalAlloc ( CINT,CLONG ) KERNEL
extern  CLONG     GlobalLock ( CHANDLE ) KERNEL
extern  CINT      GlobalUnlock ( CHANDLE ) KERNEL
extern  CVOID     HideCaret( CHANDLE ) USER
extern  CVOID     hmemcpy ( CLONG,CPTR,CLONG ) KERNEL
extern  CLOGICAL  IsTask ( CHANDLE )  KERNEL
extern  CLOGICAL  IsWindow ( CHANDLE )  USER
extern  CLOGICAL  IsWindowEnabled ( CHANDLE )  USER
extern  CLOGICAL  IsWindowVisible ( CHANDLE )  USER
extern  CLOGICAL  IsZoomed ( CHANDLE )  USER
extern  CHANDLE   LoadLibrary ( CSTRING ) KERNEL
extern  CHANDLE   LoadModule ( CSTRING,CPTR )  KERNEL
extern  CHANDLE   LoadResource ( CHANDLE,CHANDLE )  KERNEL
extern  CINT      LoadString ( CHANDLE,CINT,CSTRING,CINT ) USER
extern  CHANDLE   OpenComm ( CSTRING,CINT,CINT ) USER
extern  CLOGICAL  PostAppMessage ( CHANDLE,CINT,CWORD,CLONG )  USER
extern  CLOGICAL  PeekMessage ( CPTR,CHANDLE,CINT,CINT,CINT )  USER
extern  CINT      ReadComm ( CHANDLE,CPTR,CINT ) USER
extern  CVOID     ReplyMessage ( CLONG )  USER
extern  CVOID     SetDoubleClickTime ( CINT )  USER
extern  CVOID     SetCaretBlinkTime ( CINT ) USER
extern  CVOID     SetCaretPos ( CINT,CINT ) USER
extern  CINT      SetCommState ( CPTR) USER
extern  CLONG     SendMessage ( CHANDLE,CINT,CWORD,CLONG )  USER
extern  CINT      SetHandleCount ( CINT )  KERNEL
extern  CVOID     SetKeyboardState ( CPTR ) USER
extern  CVOID     ShowCaret ( CHANDLE ) USER
extern  CLONG     SizeOFResource ( CHANDLE,CHANDLE )  KERNEL
extern  CWORD     SndPlaySound ( CPTR,CWORD ) MMSYSTEM
extern  CLOGICAL  SwapMouseButton ( CLOGICAL )  USER
extern  CLOGICAL  SystemParametersInfo ( CINT,CINT,CPTR,CINT )  USER
extern  CINT      WinExec ( CSTRING,CINT )  KERNEL
extern  CLOGICAL  WinHelp ( CHANDLE,CSTRING,CINT,CLONG )  USER
extern  CINT      WriteComm ( CHANDLE,CPTR,CINT ) USER
extern  CLOGICAL  WritePrivateProfileString ( CSTRING,CSTRING,CSTRING,CSTRING )  KERNEL
extern  CLOGICAL  WriteProfileString ( CSTRING,CSTRING,CSTRING )  KERNEL



*** Constant Miscellaneous Function Parameters
*******************************************************************************

**************************** ExitWindows() error codes ************************

#define EW_RESTARTWINDOWS   htoi("42")
#define EW_REBOOTSYSTEM     htoi("43")



************************** FindResource() resource types **********************

#define RT_ACCELERATOR      9
#define RT_BITMAP           2
#define RT_CURSOR           1
#define RT_DIALOG           5
#define RT_FONT             8
#define RT_FONTDIR          7
#define RT_GROUP_CURSOR     12
#define RT_GROUP_ICON       14
#define RT_ICON             3
#define RT_MENU             4
#define RT_RCDATA           10
#define RT_STRING           6



*********************** GetDeviceCaps() device information options ************

#define ASPECTX       40
#define ASPECTXY      44
#define ASPECTY       42
#define BITSPIXEL     12
#define CLIPCAPS      36
#define COLORRES     108
#define CURVECAPS     28
#define DRIVERVERSION 0
#define HORZRES       8
#define HORZSIZE      4
#define LINECAPS      30
#define LOGPIXELSX    88
#define LOGPIXELSY    90
#define NUMBRUSHES    16
#define NUMCOLORS     24
#define NUMFONTS      22
#define NUMMARKERS    20
#define NUMPENS       18
#define NUMRESERVED  106
#define PDEVICESIZE   26
#define PLANES        14
#define POLYGONALCAPS 32
#define RASTERCAPS    38
#define SIZEPALETTE  104
#define TECHNOLOGY    2
#define TEXTCAPS      34
#define VERTRES       10
#define VERTSIZE      6

************************* GetFreeSystemResources() resource types ***************

#define GFSR_SYSTEMRESOURCES   0
#define GFSR_GDIRESOURCES      1
#define GFSR_USERRESOURCES     2

***************************** GetKeyboardType types *****************************

#define GKT_TYPE               0       && Main kbd type
#define GKT_SUBTYPE            1       && Mfgr. subtype
#define GKT_NUMFUNCTION        2       && Number of FKeys

**************************** GetSystemMetrics() codes ***************************

#define SM_CXSCREEN          0
#define SM_CYSCREEN          1
#define SM_CXVSCROLL         2
#define SM_CYHSCROLL         3
#define SM_CYCAPTION         4
#define SM_CXBORDER          5
#define SM_CYBORDER          6
#define SM_CXDLGFRAME        7
#define SM_CYDLGFRAME        8
#define SM_CYVTHUMB          9
#define SM_CXHTHUMB          10
#define SM_CXICON            11
#define SM_CYICON            12
#define SM_CXCURSOR          13
#define SM_CYCURSOR          14
#define SM_CYMENU            15
#define SM_CXFULLSCREEN      16
#define SM_CYFULLSCREEN      17
#define SM_CYKANJIWINDOW     18
#define SM_MOUSEPRESENT      19
#define SM_CYVSCROLL         20
#define SM_CXHSCROLL         21
#define SM_DEBUG             22
#define SM_SWAPBUTTON        23
#define SM_RESERVED1         24
#define SM_RESERVED2         25
#define SM_RESERVED3         26
#define SM_RESERVED4         27
#define SM_CXMIN             28
#define SM_CYMIN             29
#define SM_CXSIZE            30
#define SM_CYSIZE            31
#define SM_CXFRAME           32
#define SM_CYFRAME           33
#define SM_CXMINTRACK        34
#define SM_CYMINTRACK        35

#define SM_CXDOUBLECLK       36
#define SM_CYDOUBLECLK       37
#define SM_CXICONSPACING     38
#define SM_CYICONSPACING     39
#define SM_MENUDROPALIGNMENT 40
#define SM_PENWINDOWS        41
#define SM_DBCSENABLED       42

#define SM_CMETRICS          43


******************* GetWinFlags() system/memory configurations ****************

#define WF_887          htoi("0400")
#define WF_CPU086       htoi("0040")
#define WF_CPU186       htoi("0080")
#define WF_CPU286       htoi("0002")
#define WF_CPU386       htoi("0004")
#define WF_CPU486       htoi("0008")
#define WF_ENHANCED     htoi("0020")
#define WF_LARGEFRAME   htoi("0100")
#define WF_PAGING       htoi("0800")
#define WF_PMODE        htoi("0001")
#define WF_SMALLFRAME   htoi("0200")
#define WF_STANDARD     htoi("0010")
#define WF_WIN286       htoi("0010")
#define WF_WIN386       htoi("0020")
#define WF_WLO          htoi("8000")



********************** ShellExecute() window display options ******************

#define SW_HIDE             0
#define SW_MAXIMIZE         3
#define SW_MINIMIZE         6
#define SW_NORMAL           1
#define SW_RESTORE          9
#define SW_SHOW             5
#define SW_SHOWMAXIMIZED    3
#define SW_SHOWMINIMIZED    2
#define SW_SHOWMINNOACTIVE  7
#define SW_SHOWNA           8
#define SW_SHOWNOACTIVATE   4
#define SW_SHOWNORMAL       1

***************** SystemParametersInfo() parameters to query/set **************

#define SPI_GETBEEP                 1
#define SPI_GETBORDER               5
#define SPI_GETFASTTASKSWITCH       35
#define SPI_GETGRIDGRANULARITY      18
#define SPI_GETICONTITLELOGFONT     31
#define SPI_GETICONTITLEWRAP        25
#define SPI_GETKEYBOARDDELAY        22
#define SPI_GETKEYBOARDSPEED        10
#define SPI_GETMENUDROPALIGNMENT    27
#define SPI_GETMOUSE                3
#define SPI_GETSCREENSAVEACTIVE     16
#define SPI_GETSCREENSAVETIMEOUT    14
#define SPI_ICONHORIZONTALSPACING   13
#define SPI_ICONVERTICALSPACING     24
#define SPI_LANGDRIVER              12
#define SPI_SETBEEP                 2
#define SPI_SETBORDER               6
#define SPI_SETDESKPATTERN          21
#define SPI_SETDESKWALLPAPER        20
#define SPI_SETDOUBLECLICKTIME      32
#define SPI_SETDOUBLECLKHEIGHT      30
#define SPI_SETDOUBLECLKWIDTH       29
#define SPI_SETFASTTASKSWITCH       36
#define SPI_SETGRIDGRANULARITY      19
#define SPI_SETICONTITLELOGFONT     34
#define SPI_SETICONTITLEWRAP        26
#define SPI_SETKEYBOARDDELAY        23
#define SPI_SETKEYBOARDSPEED        11
#define SPI_SETMENUDROPALIGNMENT    28
#define SPI_SETMOUSE                4
#define SPI_SETMOUSEBUTTONSWAP      33
#define SPI_SETSCREENSAVEACTIVE     17
#define SPI_SETSCREENSAVETIMEOUT    15

********************** WinHelp() requested help types *************************

#define HELP_COMMAND      htoi("0102")
#define HELP_CONTENTS     htoi("0003")
#define HELP_CONTEXT      htoi("0001")
#define HELP_CONTEXTPOPUP htoi("0008")
#define HELP_FORCEFILE    htoi("0009")
#define HELP_HELPONHELP   htoi("0004")
#define HELP_INDEX        htoi("0003")
#define HELP_KEY          htoi("0101")
#define HELP_MULTIKEY     htoi("0201")
#define HELP_PARTIALKEY   htoi("0105")
#define HELP_QUIT         htoi("0002")
#define HELP_SETCONTENTS  htoi("0005")
#define HELP_SETINDEX     htoi("0005")
#define HELP_SETWINPOS    htoi("0203")


******************* Windows Messages and related constants ********************

*** Button Messages
#define BM_GETCHECK              (WM_USER + 0)
#define BM_SETCHECK              (WM_USER + 1)
#define BM_GETSTATE              (WM_USER + 2)
#define BM_SETSTATE              (WM_USER + 3)
#define BM_SETSTYLE              (WM_USER + 4)

* User Button Notification Codes
#define BN_CLICKED               0
#define BN_PAINT                 1
#define BN_HILITE                2
#define BN_UNHILITE              3
#define BN_DISABLE               4
#define BN_DOUBLECLICKED         5


*** Combo Box Messages
#define CB_GETEDITSEL            (WM_USER + 0)
#define CB_LIMITTEXT             (WM_USER + 1)
#define CB_SETEDITSEL            (WM_USER + 2)
#define CB_ADDSTRING             (WM_USER + 3)
#define CB_DELETESTRING          (WM_USER + 4)
#define CB_DIR                   (WM_USER + 5)
#define CB_GETCOUNT              (WM_USER + 6)
#define CB_GETCURSEL             (WM_USER + 7)
#define CB_GETLBTEXT             (WM_USER + 8)
#define CB_GETLBTEXTLEN          (WM_USER + 9)
#define CB_INSERTSTRING          (WM_USER + 10)
#define CB_RESETCONTENT          (WM_USER + 11)
#define CB_FINDSTRING            (WM_USER + 12)
#define CB_SELECTSTRING          (WM_USER + 13)
#define CB_SETCURSEL             (WM_USER + 14)
#define CB_SHOWDROPDOWN          (WM_USER + 15)
#define CB_GETITEMDATA           (WM_USER + 16)
#define CB_SETITEMDATA           (WM_USER + 17)

* Combo Box messages below only apply if the Windows version is > 3.0
#define CB_GETDROPPEDCONTROLRECT (WM_USER + 18)
#define CB_SETITEMHEIGHT         (WM_USER + 19)
#define CB_GETITEMHEIGHT         (WM_USER + 20)
#define CB_SETEXTENDEDUI         (WM_USER + 21)
#define CB_GETEXTENDEDUI         (WM_USER + 22)
#define CB_GETDROPPEDSTATE       (WM_USER + 23)
#define CB_FINDSTRINGEXACT       (WM_USER + 24)

* Combo Box message return values
#define CB_OKAY                  0
#define CB_ERR                  -1
#define CB_ERRSPACE             -2


*** Dialog Messages
#define DM_GETDEFID              (WM_USER + 0)
#define DM_SETDEFID              (WM_USER + 1)


*** Edit Control Messages
#define EM_GETSEL                (WM_USER + 0)
#define EM_SETSEL                (WM_USER + 1)
#define EM_GETRECT               (WM_USER + 2)
#define EM_SETRECT               (WM_USER + 3)
#define EM_SETRECTNP             (WM_USER + 4)
#define EM_LINESCROLL            (WM_USER + 6)
#define EM_GETMODIFY             (WM_USER + 8)
#define EM_SETMODIFY             (WM_USER + 9)
#define EM_GETLINECOUNT          (WM_USER + 10)
#define EM_LINEINDEX             (WM_USER + 11)
#define EM_SETHANDLE             (WM_USER + 12)
#define EM_GETHANDLE             (WM_USER + 13)
#define EM_LINELENGTH            (WM_USER + 17)
#define EM_REPLACESEL            (WM_USER + 18)
#define EM_SETFONT               (WM_USER + 19) && NOT IMPLEMENTED: use WM_SETFONT
#define EM_GETLINE               (WM_USER + 20)
#define EM_LIMITTEXT             (WM_USER + 21)
#define EM_CANUNDO               (WM_USER + 22)
#define EM_UNDO                  (WM_USER + 23)
#define EM_FMTLINES              (WM_USER + 24)
#define EM_LINEFROMCHAR          (WM_USER + 25)
#define EM_SETTABSTOPS           (WM_USER + 27)
#define EM_SETPASSWORDCHAR       (WM_USER + 28)
#define EM_EMPTYUNDOBUFFER       (WM_USER + 29)

* Edit control messages below only apply if the Windows version is > 3.0
#define EM_GETFIRSTVISIBLELINE   (WM_USER + 30)
#define EM_SETREADONLY           (WM_USER + 31)
#define EM_SETWORDBREAKPROC      (WM_USER + 32)
#define EM_GETWORDBREAKPROC      (WM_USER + 33)
#define EM_GETPASSWORDCHAR       (WM_USER + 34)

* Edit control notification codes

#define EN_SETFOCUS              htoi("0100")
#define EN_KILLFOCUS             htoi("0200")
#define EN_CHANGE                htoi("0300")
#define EN_UPDATE                htoi("0400")
#define EN_ERRSPACE              htoi("0500")
#define EN_MAXTEXT               htoi("0501")
#define EN_HSCROLL               htoi("0601")
#define EN_VSCROLL               htoi("0602")


*** List Box Messages
#define LB_ADDSTRING             (WM_USER + 1)
#define LB_INSERTSTRING          (WM_USER + 2)
#define LB_DELETESTRING          (WM_USER + 3)
#define LB_RESETCONTENT          (WM_USER + 5)
#define LB_SETSEL                (WM_USER + 6)
#define LB_SETCURSEL             (WM_USER + 7)
#define LB_GETSEL                (WM_USER + 8)
#define LB_GETCURSEL             (WM_USER + 9)
#define LB_GETTEXT               (WM_USER + 10)
#define LB_GETTEXTLEN            (WM_USER + 11)
#define LB_GETCOUNT              (WM_USER + 12)
#define LB_SELECTSTRING          (WM_USER + 13)
#define LB_DIR                   (WM_USER + 14)
#define LB_GETTOPINDEX           (WM_USER + 15)
#define LB_FINDSTRING            (WM_USER + 16)
#define LB_GETSELCOUNT           (WM_USER + 17)
#define LB_GETSELITEMS           (WM_USER + 18)
#define LB_SETTABSTOPS           (WM_USER + 19)
#define LB_GETHORIZONTALEXTENT   (WM_USER + 20)
#define LB_SETHORIZONTALEXTENT   (WM_USER + 21)
#define LB_SETCOLUMNWIDTH        (WM_USER + 22)
#define LB_SETTOPINDEX           (WM_USER + 24)
#define LB_GETITEMRECT           (WM_USER + 25)
#define LB_GETITEMDATA           (WM_USER + 26)
#define LB_SETITEMDATA           (WM_USER + 27)
#define LB_SELITEMRANGE          (WM_USER + 28)
#define LB_SETCARETINDEX         (WM_USER + 31)
#define LB_GETCARETINDEX         (WM_USER + 32)

* List Box messages below only apply if the Windows version is > 3.0
#define LB_SETITEMHEIGHT         (WM_USER + 33)
#define LB_GETITEMHEIGHT         (WM_USER + 34)
#define LB_FINDSTRINGEXACT       (WM_USER + 35)

* List Box message return values
#define LB_OKAY                  0
#define LB_ERR                  -1
#define LB_ERRSPACE             -2

#define LB_CTLCODE               0

* List Box notification messages
#define WM_VKEYTOITEM            htoi("002E")
#define WM_CHARTOITEM            htoi("002F")


*** Static Control Mesages
#define STM_SETICON              (WM_USER + 0)
#define STM_GETICON              (WM_USER + 1)


*** System Messages
* Low system memory notification message
#define WM_COMPACTING            htoi("0041")

* Win.ini message
#define WM_WININICHANGE          htoi("001A")

* Color support
#define WM_SYSCOLORCHANGE        htoi("0015")


* Palette window messages
#define WM_QUERYNEWPALETTE       htoi("030F")
#define WM_PALETTEISCHANGING     htoi("0310")
#define WM_PALETTECHANGED        htoi("0311")

* Fonts support
#define WM_FONTCHANGE            htoi("001D")

* Spooler status notification message
#define WM_SPOOLERSTATUS         htoi("002A")

* Device mode settings change message
#define WM_DEVMODECHANGE         htoi("001B")

* System Time change message
#define WM_TIMECHANGE            htoi("001E")


*** Window Mesages
#define WM_NULL                  0
#define WM_USER                  htoi("0400")

#define WM_PENWINFIRST           htoi("0380")
#define WM_PENWINLAST            htoi("038F")
#define WM_COALESCE_FIRST        htoi("0390")
#define WM_COALESCE_LAST         htoi("039F")
#define WM_POWER                 htoi("0048")
#define WM_QUERYENDSESSION       htoi("0011")
#define WM_ENDSESSION            htoi("0016")
#define WM_QUIT                  htoi("0012")
#define WM_SYSTEMERROR           htoi("0017")
#define WM_CREATE                htoi("0001")
#define WM_NCCREATE              htoi("0081")
#define WM_DESTROY               htoi("0002")
#define WM_NCDESTROY             htoi("0082")
#define WM_SHOWWINDOW            htoi("0018")
#define WM_SETREDRAW             htoi("000B")
#define WM_ENABLE                htoi("000A")
#define WM_SETTEXT               htoi("000C")
#define WM_GETTEXT               htoi("000D")
#define WM_GETTEXTLENGTH         htoi("000E")
#define WM_WINDOWPOSCHANGING     htoi("0046")
#define WM_WINDOWPOSCHANGED      htoi("0047")
#define WM_MOVE                  htoi("0003")
#define WM_SIZE                  htoi("0005")
#define WM_QUERYOPEN             htoi("0013")
#define WM_CLOSE                 htoi("0010")
#define WM_GETMINMAXINFO         htoi("0024")
#define WM_PAINT                 htoi("000F")
#define WM_ERASEBKGND            htoi("0014")
#define WM_ICONERASEBKGND        htoi("0027")
#define WM_NCPAINT               htoi("0085")
#define WM_NCCALCSIZE            htoi("0083")
#define WM_NCHITTEST             htoi("0084")
#define WM_QUERYDRAGICON         htoi("0037")
#define WM_DROPFILES             htoi("0233")
#define WM_ACTIVATE              htoi("0006")
#define WM_ACTIVATEAPP           htoi("001C")
#define WM_NCACTIVATE            htoi("0086")
#define WM_SETFOCUS              htoi("0007")
#define WM_KILLFOCUS             htoi("0008")
#define WM_KEYDOWN               htoi("0100")
#define WM_KEYUP                 htoi("0101")
#define WM_CHAR                  htoi("0102")
#define WM_DEADCHAR              htoi("0103")
#define WM_SYSKEYDOWN            htoi("0104")
#define WM_SYSKEYUP              htoi("0105")
#define WM_SYSCHAR               htoi("0106")
#define WM_SYSDEADCHAR           htoi("0107")
#define WM_KEYFIRST              htoi("0100")
#define WM_KEYLAST               htoi("0108")
#define WM_MOUSEMOVE             htoi("0200")
#define WM_LBUTTONDOWN           htoi("0201")
#define WM_LBUTTONUP             htoi("0202")
#define WM_LBUTTONDBLCLK         htoi("0203")
#define WM_RBUTTONDOWN           htoi("0204")
#define WM_RBUTTONUP             htoi("0205")
#define WM_RBUTTONDBLCLK         htoi("0206")
#define WM_MBUTTONDOWN           htoi("0207")
#define WM_MBUTTONUP             htoi("0208")
#define WM_MBUTTONDBLCLK         htoi("0209")
#define WM_MOUSEFIRST            htoi("0200")
#define WM_MOUSELAST             htoi("0209")
#define WM_NCMOUSEMOVE           htoi("00A0")
#define WM_NCLBUTTONDOWN         htoi("00A1")
#define WM_NCLBUTTONUP           htoi("00A2")
#define WM_NCLBUTTONDBLCLK       htoi("00A3")
#define WM_NCRBUTTONDOWN         htoi("00A4")
#define WM_NCRBUTTONUP           htoi("00A5")
#define WM_NCRBUTTONDBLCLK       htoi("00A6")
#define WM_NCMBUTTONDOWN         htoi("00A7")
#define WM_NCMBUTTONUP           htoi("00A8")
#define WM_NCMBUTTONDBLCLK       htoi("00A9")
#define WM_MOUSEACTIVATE         htoi("0021")
#define WM_CANCELMODE            htoi("001F")
#define WM_TIMER                 htoi("0113")
#define WM_INITMENU              htoi("0116")
#define WM_INITMENUPOPUP         htoi("0117")
#define WM_MENUSELECT            htoi("011F")
#define WM_MENUCHAR              htoi("0120")
#define WM_COMMAND               htoi("0111")
#define WM_HSCROLL               htoi("0114")
#define WM_VSCROLL               htoi("0115")
#define WM_CUT                   htoi("0300")
#define WM_COPY                  htoi("0301")
#define WM_PASTE                 htoi("0302")
#define WM_CLEAR                 htoi("0303")
#define WM_UNDO                  htoi("0304")
#define WM_RENDERFORMAT          htoi("0305")
#define WM_RENDERALLFORMATS      htoi("0306")
#define WM_DESTROYCLIPBOARD      htoi("0307")
#define WM_DRAWCLIPBOARD         htoi("0308")
#define WM_PAINTCLIPBOARD        htoi("0309")
#define WM_SIZECLIPBOARD         htoi("030B")
#define WM_VSCROLLCLIPBOARD      htoi("030A")
#define WM_HSCROLLCLIPBOARD      htoi("030E")
#define WM_ASKCBFORMATNAME       htoi("030C")
#define WM_CHANGECBCHAIN         htoi("030D")
#define WM_SETCURSOR             htoi("0020")
#define WM_SYSCOMMAND            htoi("0112")
#define WM_MDICREATE             htoi("0220")
#define WM_MDIDESTROY            htoi("0221")
#define WM_MDIACTIVATE           htoi("0222")
#define WM_MDIRESTORE            htoi("0223")
#define WM_MDINEXT               htoi("0224")
#define WM_MDIMAXIMIZE           htoi("0225")
#define WM_MDITILE               htoi("0226")
#define WM_MDICASCADE            htoi("0227")
#define WM_MDIICONARRANGE        htoi("0228")
#define WM_MDIGETACTIVE          htoi("0229")
#define WM_MDISETMENU            htoi("0230")
#define WM_CHILDACTIVATE         htoi("0022")
#define WM_INITDIALOG            htoi("0110")
#define WM_NEXTDLGCTL            htoi("0028")
#define WM_PARENTNOTIFY          htoi("0210")
#define WM_ENTERIDLE             htoi("0121")
#define WM_GETDLGCODE            htoi("0087")
#define WM_CTLCOLOR              htoi("0019")
#define WM_SETFONT               htoi("0030")
#define WM_GETFONT               htoi("0031")
#define WM_DRAWITEM              htoi("002B")
#define WM_MEASUREITEM           htoi("002C")
#define WM_DELETEITEM            htoi("002D")
#define WM_COMPAREITEM           htoi("0039")
#define WM_QUEUESYNC             htoi("0023")
#define WM_COMMNOTIFY            htoi("0044")


****************************** End of Winapi.h ******************************

#endif
































































































