*******************************************************************************
*  FILE:         Tabbox.cc
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         1/94
*
*  UPDATED:      6/95
*
*  REVISION:     $Revision:   1.3  $
*
*  VERSION:      Visual dBASE
*
*  DESCRIPTION:  This files contains various Tabbox custom controls that can be
*                used in Visual dBASE forms.  Each control is contained in
*                a separate class.
*
*                Current Controls are:
*
*                   PageTabBox    -- Tabbox for keeping track of a forms' pages
*
*                   SearchTabBox  -- Tabbox for alphabetical searches
*
*  PARAMETERS:   None
*
*  CALLS:        None
*
*  USAGE:        When creating a form, select the "Set Up Custom Controls"
*                menu from the "File" menu.  Then select "Add" VBX control
*                from the "Set Up Custom Controls" dialog. Select this file
*                from the file selection dialog that comes up.
*                The controls in this file will be available on the "Custom"
*                page of the "Controls" window.
*
********************************************************************************

*******************************************************************************
*******************************************************************************
class PageTabBox(f,n) of TabBox(f,n) custom

*  CONTROL:      Page Tabbox
*
*  DESCRIPTION:  This control allows using tabs to switch between form
*                pages
*******************************************************************************

   this.PageNo = 0
   this.ColorNormal = "N/W"
   this.Visible = .F.                  && Invisible until dataSource is defined
   this.OnOpen = CLASS::PageTabBox_OnOpen
   this.OnSelChange = CLASS::PageTabBox_OnSelChange

   *** Protected properties
   protect pageNo, visible


   ****************************************************************************
   Procedure PageTabBox_OnOpen
   ****************************************************************************
   local i, pageCnt

   pageCnt = form.PageCount()
   this.promptAr = new array(pageCnt)     && Create array of prompts
   for i = 1 to pageCnt
      this.promptAr[i] = "Page " + ltrim(str(i))
   next i

   this.dataSource = "array this.promptAr"
   this.visible = .T.

   ****************************************************************************
   Procedure PageTabBox_OnSelChange
   ****************************************************************************

   if this.curSel <= form.PageCount()
      form.pageNo = this.curSel
   endif

endclass


*******************************************************************************
*******************************************************************************
class SearchTabBox(f,n) of TabBox(f,n) custom

*  CONTROL:      Letter Search Tabbox
*
*  DESCRIPTION:  This control allows SEEKing for the key value that starts
*                with the selected letter, or LOCATing the value of the
*                last selected control, which begins with the selected letter.
*******************************************************************************

   this.Height = 1
   this.Left = 0
   this.PageNo = 1
   this.Width = 125
   this.Anchor = 0            && So doesn't have to stay at the bottom
   this.ColorNormal = "N/W"
   this.Visible = .F.         && Invisible until dataSource assigned

   this.charField = .F.       && For storing name of a char field if no key
   this.tableHasCharField = .T.

   this.OnOpen = CLASS::SearchTabBox_OnOpen
   this.OnSelChange = CLASS::SearchTabBox_OnSelChange

   *** Protected properties
   protect charField, tableHasCharField


   ****************************************************************************
   Procedure SearchTabBox_OnOpen
   ****************************************************************************

   #define MAX_LETTERS 26
   local i

   this.promptAr = new array(MAX_LETTERS)
   for i = 1 to MAX_LETTERS
                                            && Capital letters, starting at "A"
      this.promptAr[i] = chr(asc("A") + i - 1)
   next i

   this.dataSource = "array this.promptAr"
   this.SearchTabBox_OnSelChange()          && Search for first key
   this.visible = .T.


   ****************************************************************************
   Procedure SearchTabBox_OnSelChange
   ****************************************************************************
   private saveExact, saveNear, saveRecNo, i, fCount, charField, foundCharField

   saveExact = set("exact")
   set exact off

   if .not. empty(key())                      && If table is indexed
      saveNear = set("near")
      set near on                             && If not found, go to nearest
      seek this.promptAr[this.curSel]         && match
      set near &saveNear
   else                                       && If table is not indexed
      if this.tableHasCharField .and. type("this.charField") = "L"
                                              && If don't have char field yet
         fCount = fCount()
         i = 1
         this.tableHasCharField = .F.
         do while .not. this.tableHasCharField .and. i <= fCount
                                              && Search until found char field
                                              && or got to last field
            this.tableHasCharField = (type("field(i)") == "C")
            i = i + 1
         enddo
         if this.tableHasCharField            && If a character field was found
            this.charField = field(i)         && Save the field name
         else
            * Will not look for char field next time
         endif
      endif
      if this.tableHasCharField
         charField = this.charField           && Temporary storage for macro
         saveRecNo = recno()
         locate for upper(&charField) = upper(this.promptAr[this.curSel])
         if .not. found()                     && If not found,
            goto saveRecNo                    && go to previous record
         endif
      endif
   endif

   set exact &saveExact

endclass


