*****************************************************************************
*  PROGRAM:      AVIPanel.cc
*
*  WRITTEN BY:   Borland Samples Group
*
*  DATE:         5/95
*
*  UPDATED:      6/95
*
*  REVISION:     $Revision:   1.1  $
*
*  VERSION:      Visual dBASE
*
*
*  DESCRIPTION:  This is a Custom Control file containing a Custom Class
*                derived from the built in PAINTBOX Class. The Custom Class,
*                "AVIPanel" is a display panel, along with all the necessary
*                methods, for displaying a Video for Windows AVI file. This
*                requires Microsoft's Video for Windows to be installed.
*
*  USAGE:        SET PROCEDURE TO AVIPANEL.CC ADDITIVE
*
*                NEW syntax:     f = NEW form()
*                                x = NEW AVIPanel(f,"VideoPanel")
*                                f.Open()
*                                f.VideoPanel.OpenAVI()
*                                f.VideoPanel.PlayAVI()
*
*                DEFINE syntax:  DEFINE FORM f
*                                DEFINE AVIPanel MyVideoPanel OF f
*                                OPEN FORM f
*
*                FORMS DESIGNER: Use "File | Set Up Custom Controls" menu to
*                                install the AVIPANEL.CC file, then select
*                                the AVIPANEL control "Custom" page of the
*                                Control Palette.
*
*                ONCE RUNNING:   Right click the black panel to see it run.
*
*                METHODS LIST:
*                             AVIPanel_OnOpen           && Sets up control
*                             AVIPanel_OnRightMouseUp   && Invokes Menu
*                             OpenAVI                   && Opens AVI file
*                             PlayAVI                   && Plays video file
*                             PauseAVI                  && Pauses AVI file
*                             RewindAVI                 && Rewinds AVI file
*                             StopAVI                   && Stops AVI file
*                             CloseAVI                  && Closes AVI file
*                             ResizeAVI(AVIWidth, AVIHeight) && Re-size's AVI
*                             MCIExec                   && Execute MCI string
*
*****************************************************************************


*****************************************************************************
*****************************************************************************
CLASS AVIPanel(FormObj,Name) OF PaintBox(FormObj,Name) Custom
*****************************************************************************

   protect VideoFile, ColorNormal

   this.Height = 7.09   && 120 Pixels (convert @ 16.93)
   this.Width = 26.83   && 160 Pixels (convert @ 5.96)
   this.Left = 8
   this.Top = 1.5
   this.ColorNormal = "W+/N"
   this.OnRightMouseUp = CLASS::AVIPanel_OnRightMouseUp
   this.PageNo = 1
   this.VideoFile = ""
   this.AVI_Clip = FUNIQUE()
   this.Size = "160 120"        && Initial AVI frame size in pixels
   this.OnOpen = CLASS::AVIPanel_ONOPEN
   this.OnClose = CLASS::CloseAVI


   ****************************************************************************
   Procedure AVIPanel_OnOpen

   * MCI execution function and SpeedMenu
   ****************************************************************************

   extern CINT MciExecute(CSTRING) MMSYSTEM.DLL && MultiMedia extensions
   if .not. type("this.Parent.AVIPanelMenu") = "O"
      new AVIPanelPopUp(this.Parent, "AVIPanelMenu")
   endif


   ****************************************************************************
   Procedure OpenAVI(VideoFileName)

   * Opens optionally named AVI file
   ****************************************************************************

   if len(this.VideoFile) > 0
      this.CloseAVI()
   endif
   if pcount() = 0
      this.VideoFile = GetFile("*.AVI", "Select a Video File (*.AVI)")
   else
      this.VideoFile = VideoFileName
   endif
   this.MCIStr = "OPEN " + this.VideoFile + ;
     " TYPE AVIVIDEO ALIAS " + this.AVI_Clip + " STYLE child PARENT" + STR(this.hWnd)
   this.MCIExec()
   this.MCIStr = "PUT " + this.AVI_Clip + " WINDOW AT 0 0 " + this.Size
   this.MCIExec()


   ****************************************************************************
   Procedure PlayAVI

   * Plays selected AVI
   ****************************************************************************

   this.MCIStr = "PLAY " + this.AVI_Clip
   this.MCIExec()


   ****************************************************************************
   Procedure PauseAVI

   * Pauses video display
   ****************************************************************************

   this.MCIStr = "PAUSE " + this.AVI_Clip
   this.MCIExec()


   ****************************************************************************
   Procedure RewindAVI

   * Rewinds current AVI to beginning
   ****************************************************************************
   local VideoToRewind

   VideoToRewind = this.VideoFile
   if len(this.VideoFile) > 0
      this.CloseAVI()
      this.VideoFile = VideoToRewind
      this.MCIStr = "OPEN " + this.VideoFile + ;
        " TYPE AVIVIDEO ALIAS " + this.AVI_Clip + " STYLE child PARENT" + STR(this.hWnd)
      this.MCIExec()
      this.MCIStr = "PUT " + this.AVI_Clip + " WINDOW AT 0 0 " + this.Size
      this.MCIExec()
   endif


   ****************************************************************************
   Procedure StopAVI

   * Stops playing current AVI
   ****************************************************************************

   this.MCIStr = "STOP " + this.AVI_Clip
   this.MCIExec()


   ****************************************************************************
   Procedure CloseAVI

   * Closes current AVI
   ****************************************************************************

   this.MCIStr = "CLOSE " + this.AVI_Clip
   this.MCIExec()
   this.VideoFile = ""


   ****************************************************************************
   Procedure ResizeAVI(AVIWidth, AVIHeight, ReSizeControl)

   * Resizes AVI file to in pixels, optionally resizes control the AVI
   * is displaying on via 3rd parameter (logical)
   ****************************************************************************

   if ReSizeControl
      this.Height = AVIHeight/16.93
      this.Width = AVIWidth/5.96
   endif
   AVIHeight = ltrim(rtrim(str(AVIHeight)))
   AVIWidth = ltrim(rtrim(str(AVIWidth)))
   this.Size = AVIWidth + " " + AVIHeight
   this.MCIStr = "PUT " + this.AVI_Clip + " WINDOW AT 0 0 " + this.Size
   this.MCIExec()


   ****************************************************************************
   Procedure MCIExec

   * Executes MCI command
   ****************************************************************************

   if len(this.VideoFile) > 0
      this.RetValue = MciExecute(this.MCIStr)
   endif


   ****************************************************************************
   Procedure AVIPanel_OnRightMouseUp(flags, col, row)

   * Invokes the SpeedMenu that has basic UI for control
   ****************************************************************************

   col = col + this.Left
   row = row + this.Top
   form.AVIPanelMenu.Top = row
   form.AVIPanelMenu.Left = col
   form.AVIPanelMenu.Active = this
   form.AVIPanelMenu.Open()

ENDCLASS


*******************************************************************************
*******************************************************************************
CLASS AVIPanelPopUp(FormObj, PopupName) OF POPUP(FormObj, PopupName)

* This is the CLASS definition for the AVI controls SpeedMenu
*******************************************************************************

   this.TrackRight = .T.
   this.Left = 0
   this.Top = 0

   DEFINE MENU OPEN_VIDEO OF THIS;
       PROPERTY;
         Text "Open Video",;
         OnClick CLASS::OPEN_VIDEO_ONCLICK

   DEFINE MENU Separator1 OF THIS;
       PROPERTY;
         Text "",;
         Separator .T.

   DEFINE MENU PLAY_VIDEO OF THIS;
       PROPERTY;
         Text "Play Video",;
         OnClick CLASS::PLAY_VIDEO_ONCLICK

   DEFINE MENU PAUSE_VIDEO OF THIS;
       PROPERTY;
         Text "Pause Video",;
         OnClick CLASS::PAUSE_VIDEO_ONCLICK

   DEFINE MENU STOP_VIDEO OF THIS;
       PROPERTY;
         Text "Stop Video",;
         OnClick CLASS::STOP_VIDEO_ONCLICK

   DEFINE MENU REWIND_VIDEO OF THIS;
       PROPERTY;
         Text "Rewind Video",;
         OnClick CLASS::REWIND_VIDEO_ONCLICK

   DEFINE MENU Separator2 OF THIS;
       PROPERTY;
         Text "",;
         Separator .T.

   DEFINE MENU CLOSE_VIDEO OF THIS;
       PROPERTY;
         Text "Close Video",;
         OnClick CLASS::CLOSE_VIDEO_ONCLICK


   ****************************************************************************
   Procedure OPEN_VIDEO_OnClick

   * Opens AVI
   ****************************************************************************

   form.AVIPanelMenu.Active.OpenAVI()


   ****************************************************************************
   Procedure PLAY_VIDEO_OnClick

   * Plays AVI
   ****************************************************************************

   form.AVIPanelMenu.Active.PlayAVI()


   ****************************************************************************
   Procedure PAUSE_VIDEO_OnClick

   * Pauses AVI
   ****************************************************************************

   form.AVIPanelMenu.Active.PauseAVI()


   ****************************************************************************
   Procedure STOP_VIDEO_OnClick

   * Stops AVI
   ****************************************************************************

   form.AVIPanelMenu.Active.StopAVI()


   ****************************************************************************
   Procedure REWIND_VIDEO_OnClick

   * Rewinds AVI
   ****************************************************************************

   form.AVIPanelMenu.Active.RewindAVI()


   ****************************************************************************
   Procedure CLOSE_VIDEO_OnClick

   * Closes AVI
   ****************************************************************************

   form.AVIPanelMenu.Active.CloseAVI()


ENDCLASS
