# makefile - Handy makefile for command-line use
#
# Usage:
#	nmake [options] [all|clean]
#
# Options:
#	WIN32=0		Build 16-bit version (default)
#	WIN32=1		Build 32-bit version
#	DEBUG=0		Build retail version
#	DEBUG=1		Build debug version (default)

!ifndef WIN32
WIN32=0
!endif

!ifndef DEBUG
DEBUG=1
!endif

!if "$(UNICODE)" != ""
!if "$(UNICODE)" != "0"
!error  Can't build ODBC Controls for UNICODE
!endif
!endif

!if "$(WIN32)" == "1" 
!if "$(DEBUG)" == "1"
all:
	nmake -f db32.mak CFG="Win32 ANSI Debug"
clean:
	if exist objd32\*.* rm -f objd32\*.*
!else
all:
	nmake -f db32.mak CFG="Win32 ANSI Release"
clean:
	if exist obj32\*.* rm -f obj32\*.*
!endif
!else
!if "$(DEBUG)" == "1"
all:
	nmake -f db.mak DEBUG=1
	if not exist objd16\*.* mkdir objd16
	-mv *.sbr *.pdb *.obj *.res *.exe *.dll objd16
clean:
	-rm *.sbr *.pdb *.obj *.res *.exe *.dll
	if exist objd16\*.* rm -f objd16\*.*
!else
all:
	nmake -f db.mak DEBUG=0
	if not exist obj16\*.* mkdir obj16
	-mv *.sbr *.pdb *.obj *.res *.exe *.dll obj16
clean:
	-rm *.sbr *.pdb *.obj *.res *.exe *.dll
	if exist obj16\*.* rm -f obj16\*.*
!endif
!endif

