// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1994 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and the
// Books Online documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdctl.h"

#pragma warning(disable:4103)
#include <initguid.h>
#include <olectlid.h>
#pragma warning(default:4103)

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#ifdef _WIN32

/////////////////////////////////////////////////////////////////////////////
// Control module's static data

#include <afximpl.h>

extern void AFXAPI _AfxSetCurrentModuleTlsIndex(DWORD);

DWORD _afxCtlTlsIndex = NULL_TLS;

struct _AFX_CTL_MODULE_STATICS
{
	AFX_MODULE_STATE sModuleData;	// Must be first!
	AFX_MODULE_STATE* psSavePrevious;

	_AFX_CTL_MODULE_STATICS();
	~_AFX_CTL_MODULE_STATICS();

	void* AFX_CDECL operator new(size_t nSize);
	void AFX_CDECL operator delete(void* p);
#ifdef _DEBUG
	void* AFX_CDECL operator new(size_t nSize, LPCSTR lpszFileName, int nLine);
#endif
};

_AFX_CTL_MODULE_STATICS::_AFX_CTL_MODULE_STATICS()
{
	psSavePrevious = NULL;
}

_AFX_CTL_MODULE_STATICS::~_AFX_CTL_MODULE_STATICS()
{
}

void* AFX_CDECL _AFX_CTL_MODULE_STATICS::operator new(size_t nSize)
{
	ASSERT(nSize == sizeof(_AFX_CTL_MODULE_STATICS));
	_AFX_CTL_MODULE_STATICS* pStatics =
		(_AFX_CTL_MODULE_STATICS*)LocalAlloc(LPTR, nSize);
	TlsSetValue(_afxCtlTlsIndex, pStatics);
	return pStatics;
}

void AFX_CDECL _AFX_CTL_MODULE_STATICS::operator delete(void* p)
{
	LocalFree(p);
	TlsSetValue(_afxCtlTlsIndex, NULL);
}

#ifdef _DEBUG
void* AFX_CDECL _AFX_CTL_MODULE_STATICS::operator new(
	size_t nSize, LPCSTR lpszFileName, int nLine)
{
	UNUSED lpszFileName;
	UNUSED nLine;

	return _AFX_CTL_MODULE_STATICS::operator new(nSize);
}
#endif // _DEBUG

#endif // _WIN32


#define new DEBUG_NEW


#ifndef _WIN32
extern HRESULT AfxDllGetClassObject(REFCLSID, REFIID, LPVOID FAR*);
extern HRESULT AfxDllCanUnloadNow(void);
#endif


/////////////////////////////////////////////////////////////////////////////
// DllGetClassObject

extern "C"
STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID FAR* ppv)
{
	AFX_MANAGE_STATE(_afxModuleAddrThis);

	return AfxDllGetClassObject(rclsid, riid, ppv);
}


/////////////////////////////////////////////////////////////////////////////
// DllCanUnloadNow

extern "C"
STDAPI DllCanUnloadNow(void)
{
	AFX_MANAGE_STATE(_afxModuleAddrThis);

	return AfxDllCanUnloadNow();
}


/////////////////////////////////////////////////////////////////////////////
// COleControlModule::InitInstance

IMPLEMENT_DYNAMIC(COleControlModule, CWinApp)
static COleControlModule* _pOleControlModule = NULL;

BOOL COleControlModule::InitInstance()
{
	_pOleControlModule = this;
	COleObjectFactory::RegisterAll();
	SetDialogBkColor();
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// COleControlModule::ExitInstance

#ifdef _WIN32

int COleControlModule::ExitInstance()
{
	COleObjectFactory::RevokeAll();
	return CWinApp::ExitInstance();
}

#else // !_WIN32

#pragma optimize("", off)
extern "C" void _fpmath(void);

int COleControlModule::ExitInstance()
{
	// Special code to prevent crash on NEC Windows 3.1
	double a = a + a;
	_asm
	{
		mov		bx, 2
		call	_fpmath
	}

	if (_AfxGetAppData()->appOleState != NULL)
		COleObjectFactory::RevokeAll();
	return CWinApp::ExitInstance();
}

#pragma optimize("", on)

#endif // !_WIN32


#ifdef _WIN32

/////////////////////////////////////////////////////////////////////////////
// Control module's static data

DWORD WINAPI _AfxTlsAlloc()
{
	DWORD dwResult = TlsAlloc();
	DWORD dwVersion = GetVersion();
	if ((dwVersion & 0x80000000) && (BYTE)dwVersion <= 3)
	{
		// avoid Win32s bug (0-2 are assumed to be reserved by Win32s)
		while (dwResult >= 0 && dwResult <= 2)
			dwResult = TlsAlloc();
	}
	return dwResult;
}

inline _AFX_CTL_MODULE_STATICS* _AfxGetCtlModuleStatics()
{
	ASSERT(_afxCtlTlsIndex != NULL_TLS);

	_AFX_CTL_MODULE_STATICS* pStatics =
		(_AFX_CTL_MODULE_STATICS*)TlsGetValue(_afxCtlTlsIndex);

	ASSERT(pStatics != NULL);
	return pStatics;
}

AFX_MODULE_STATE* AFXAPI AfxGetControlModuleContext()
{
	_AFX_CTL_MODULE_STATICS* pStatics = _AfxGetCtlModuleStatics();
	ASSERT(pStatics != NULL);
	return &pStatics->sModuleData;
}

static void _AfxSetPreviousState(AFX_MODULE_STATE* psPrev)
{
	_AFX_CTL_MODULE_STATICS* pStatics = _AfxGetCtlModuleStatics();
	pStatics->psSavePrevious = psPrev;
}

static AFX_MODULE_STATE* _AfxGetPreviousState()
{
	_AFX_CTL_MODULE_STATICS* pStatics = _AfxGetCtlModuleStatics();
	return pStatics->psSavePrevious;
}


/////////////////////////////////////////////////////////////////////////////
// RawDllMain for the control

// Note: need to initialize _pRawDllMain to RawDllMain so it gets called
extern "C" BOOL WINAPI RawDllMain(HINSTANCE, DWORD dwReason, LPVOID);
extern "C" BOOL (WINAPI* _pRawDllMain)(HINSTANCE, DWORD, LPVOID) = &RawDllMain;

extern "C" BOOL WINAPI RawDllMain(HINSTANCE, DWORD dwReason, LPVOID)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		// Initialize our slot for thread-local storage.
		if (_afxCtlTlsIndex == NULL_TLS)
			_afxCtlTlsIndex = _AfxTlsAlloc();

		// Initialize static data used by this control module.
		_AFX_CTL_MODULE_STATICS* pStatics = new _AFX_CTL_MODULE_STATICS;

		// Push the control's module data into the AppData for initialization.
		AFX_MODULE_STATE* pModuleData = _afxModuleAddrThis;
		pModuleData->m_pID = pModuleData;
		pModuleData->m_coreState.m_pFirstDLL =
			AfxGetBaseModuleContext()->m_coreState.m_pFirstDLL;
		_AfxSetPreviousState(AfxPushModuleContext(pModuleData));
		ASSERT(_AfxGetPreviousState() != NULL);

		// Prepare to initialize class factories.
		_AfxSetCurrentModuleTlsIndex(_afxCtlTlsIndex);
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		if (_afxCtlTlsIndex != NULL_TLS)
		{
			// Do a full copy pop of the control's context for the dtor.
			AfxPopModuleContext(_AfxGetPreviousState(), TRUE);

			// Free static data used by this control module.
			delete _AfxGetCtlModuleStatics();
		}
	}

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// DllMain for the control

static AFX_EXTENSION_MODULE controlDLL;

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		// Finished initializing class factories.
		_AfxSetCurrentModuleTlsIndex(NULL_TLS);

		CWinApp* pApp;

		// fail early if can't get app state or thread state
		if (AfxGetAppState() == NULL || AfxGetThreadState() == NULL)
			goto failure;       // Init Failed

		pApp = AfxGetApp();

		if (pApp == NULL)
		{
			pApp = _pOleControlModule;
			AfxGetAppState()->m_coreState.m_pCurrentWinApp = pApp;
		}

		TRACE0("Control Initializing!\n");

		ASSERT(_AfxGetPreviousState() != NULL); // RawDllMain not called!

		// Initialize DLL's instance(/module) not the app's
		if (!AfxWinInit(hInstance, NULL, &afxChNil, 0))
		{
			AfxWinTerm();
			goto failure;       // Init Failed
		}

		// initialize the single instance DLL
		if (pApp != NULL && !pApp->InitInstance())
		{
			pApp->ExitInstance();
			AfxWinTerm();
			goto failure;       // Init Failed
		}

		if (!AfxInitExtensionModule(controlDLL, hInstance))
		{
			pApp->ExitInstance();
			AfxWinTerm();
			goto failure;       // Init Failed
		}
		else
		{
			// wire up this DLL into the resource chain
			//  (In the Win32 version it is OK to create this in DllMain)
			CDynLinkLibrary* pDLL = new CDynLinkLibrary(controlDLL);
			pDLL->m_bSystem = TRUE;
		}

		// Pop initialized module data back into our global.
		AfxPopModuleContext(_AfxGetPreviousState(), TRUE);
		return 1;   // ok

failure:

		// Pop control's module data.
		AfxPopModuleContext(_AfxGetPreviousState(), TRUE);
		return 0;   // failed
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		TRACE0("Control Terminating!\n");

		// Push this control's context, and leave it there until all
		// destructors have happened.

		_AfxSetPreviousState(AfxPushModuleContext(_afxModuleAddrThis));
		ASSERT(_AfxGetPreviousState() != NULL);

		CWinApp* pApp = AfxGetApp();    // Push state before getting app.

#ifdef _DEBUG
		// Check for missing AfxLockTempMap calls
		if (AfxGetThreadState()->m_nTempMapLock != 0)
			TRACE1("Warning: Temp map lock count non-zero (%ld).\n",
				AfxGetThreadState()->m_nTempMapLock);
#endif

		if (pApp != NULL)
			pApp->ExitInstance();

		AFX_CORE_STATE* pCoreState = AfxGetCoreState();

		// free the DLL info blocks for this module.
		CDynLinkLibrary* pDLLNext;
		CDynLinkLibrary* pDLL = pCoreState->m_pFirstDLL;
		CDynLinkLibrary* pDLLEnd =
			AfxGetBaseModuleContext()->m_coreState.m_pFirstDLL;
		pCoreState->m_pFirstDLL = NULL;
		for (/*nothing*/; pDLL != pDLLEnd; pDLL = pDLLNext)
		{
			pDLLNext = pDLL->m_pNextDLL;    // save next pointer before delete
			delete pDLL;
		}

		// Terminate the library before destructors are called
		AfxWinTerm();
	}

	return 1;   // ok
}


/////////////////////////////////////////////////////////////////////////////
// Special cleanup for _AfxTlsAlloc storage

class _AFX_CTL_TLS_TERM
{
public:
	~_AFX_CTL_TLS_TERM()
	{
		if (_afxCtlTlsIndex != NULL_TLS)
		{
			// Do a full copy pop of the control's context for the dtor.
			AfxPopModuleContext(_AfxGetPreviousState(), TRUE);

			AFX_WIN_STATE* pWinState = AfxGetWinState();
			if (pWinState != NULL && pWinState->m_hDlgBkBrush != NULL)
			{
				TRACE0("Deleting pWinState->m_hDlgBkBrush\n");
				::DeleteObject(pWinState->m_hDlgBkBrush);
				pWinState->m_hDlgBkBrush = NULL;
			}

			TlsFree(_afxCtlTlsIndex);
			_afxCtlTlsIndex = NULL_TLS;
		}
	}
};

// force initialization early
#pragma warning(disable: 4074)
#pragma init_seg(compiler)
static const _AFX_CTL_TLS_TERM afxCtlTlsTerm;

/////////////////////////////////////////////////////////////////////////////
// NOTE: Do NOT place any new object allocations after this point.  If you
//  do they will be constructed before all other objects -- probably not
//  what you want!
/////////////////////////////////////////////////////////////////////////////


#else // ! _WIN32


/////////////////////////////////////////////////////////////////////////////
// Control module's static data

static AFX_MODULE_STATE NEAR g_sModuleData;
static AFX_MODULE_STATE* psSavePrevious = NULL;

AFX_MODULE_STATE* AFXAPI AfxGetControlModuleContext()
{
	return &g_sModuleData;
}

inline void _AfxSetPreviousState(AFX_MODULE_STATE* psPrev)
{
	psSavePrevious = psPrev;
}

inline AFX_MODULE_STATE* _AfxGetPreviousState()
{
	return psSavePrevious;
}


/////////////////////////////////////////////////////////////////////////////
// LibMain for the control

static AFX_EXTENSION_MODULE NEAR controlDLL = { NULL, NULL };

extern "C"
int CALLBACK LibMain(HINSTANCE hInstance, WORD, WORD, LPSTR lpszCmdLine)
{
	ASSERT(_AfxGetPreviousState() != NULL); // AFX_CTL_BOUNDARY not contructed!

	// Initialize DLL's instance(/module) not the app's
	if (!AfxWinInit(hInstance, NULL, lpszCmdLine, 0))
		goto failure;       // Init Failed

	// Initialize the single instance DLL
	if (AfxGetApp() != NULL && !AfxGetApp()->InitInstance())
	{
		AfxGetApp()->ExitInstance();
		goto failure;
	}

	// Shared initialization
	AfxInitExtensionModule(controlDLL, hInstance);
	ASSERT(_AfxGetAppData()->pFirstDLL != NULL);    // runtime should be first.
	new CDynLinkLibrary(controlDLL);   // will add to list

	// Pop initialized module data back into our global.
	AfxPopModuleContext(_AfxGetPreviousState(), TRUE);
	return 1;   // ok

failure:

	AfxWinTerm();

	// Pop control's module data.
	AfxPopModuleContext(_AfxGetPreviousState(), TRUE);
	return 0;   // failed
}


/////////////////////////////////////////////////////////////////////////////
// _WEP for the control
//      Called by the C-runtime's WEP before global destructors.

extern "C" int CALLBACK _WEP(int)
{
	// Push this control's context, and leave it there until all
	// destructors have happened.

	_AfxSetPreviousState(AfxPushModuleContext(_afxModuleAddrThis));
	ASSERT(_AfxGetPreviousState() != NULL);

	if (AfxGetApp() != NULL)
		AfxGetApp()->ExitInstance();

	// Now it is safe to cleanup the library.
	AfxWinTerm();

	return 0;
}


/////////////////////////////////////////////////////////////////////////////
//  AFX_CTL_BOUNDARY
//      This is the object that gets constructed first, and destructed last.
//      We make sure that the control is initialized correctly before any
//      other code is run, and also that its state stays loaded for complete
//      destruction.

class AFX_CTL_BOUNDARY
{
public:
	AFX_CTL_BOUNDARY();
	~AFX_CTL_BOUNDARY();

private:
	HINSTANCE m_hExplicit;
};

AFX_CTL_BOUNDARY::AFX_CTL_BOUNDARY()
{
	// Win16 has a bug that allows implicitly use DLLs to unload before the
	// user has unloaded fully.  So the boundary object explicitly references
	// the runtime DLL to keep it around for the life of the control.

#ifdef _DEBUG
	static TCHAR BASED_CODE szOleControlRuntimeLib[] = _T("OC25D.DLL");
#else
	static TCHAR BASED_CODE szOleControlRuntimeLib[] = _T("OC25.DLL");
#endif

	m_hExplicit = LoadLibrary(szOleControlRuntimeLib);

	// Push the control's module data into the AppData for initialization.
	AFX_MODULE_STATE* pModuleData = _afxModuleAddrThis;
	pModuleData->m_pID = pModuleData;
	pModuleData->pFirstDLL = AfxGetBaseModuleContext()->pFirstDLL;
	_AfxSetPreviousState(AfxPushModuleContext(pModuleData));
	ASSERT(_AfxGetPreviousState() != NULL);
}

AFX_CTL_BOUNDARY::~AFX_CTL_BOUNDARY()
{
	// Delete the dialog brush for this control.
	HBRUSH hbr = _AfxGetAppData()->appDlgBkBrush;
	if (hbr != NULL)
	{
		::DeleteObject(hbr);
		_AfxGetAppData()->appDlgBkBrush = NULL;
	}

	// Do a full copy pop of the control's context for the dtor.
	AfxPopModuleContext(_AfxGetPreviousState(), TRUE);

	// Free the DLL that was explicitly loaded by the ctor.
	ASSERT(m_hExplicit > HINSTANCE_ERROR);  // Control shouldn't load without DLL.
	FreeLibrary(m_hExplicit);
}

#pragma warning(disable: 4147)  // disable warning about using init_seg
#pragma warning(disable: 4073)  // disable warning about using init_seg
#pragma init_seg(lib)

static AFX_CTL_BOUNDARY NEAR afxOleControlBoundary; // Bounding ctor/dtor.

/////////////////////////////////////////////////////////////////////////////
// NOTE: Do NOT place any new object allocations after this point.  If you
//  do they will be constructed before all other objects -- probably not
//  what you want!
/////////////////////////////////////////////////////////////////////////////


#endif // ! _WIN32
