	page	,132
	title	fmsghdr       - far message handler and finder
;***
;fmsghdr.asm - far message handler and finder
;
;	Copyright (c) 1986-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Far message handler and finder.
;
;*******************************************************************************


?DF=	1			; this is special for c startup
include version.inc
?PLM=	1			; pascal calling conventions
.xlist
include cmacros.inc
include msdos.inc
include defsegs.inc
.list

CrtDefSegs <code, data>
CrtDefSegs <fmsg>

codeOFFSET equ	offset _TEXT:
fmsgOFFSET equ	offset FMGROUP:


sBegin	fhdr
assumes ds,data

	db	'<<FMSG>>'
stfmsg	label	byte

sEnd

SBegin	fpad
assumes ds,data

	dw	-1		; message padding marker

sEnd

sBegin	fepad
assumes ds,data

	db	-1

sEnd


sBegin	code
assumes cs,code
assumes ds,data

page
;***
;__FMSG_TEXT(messagenumber) - find message for given message number
;
;Purpose:
;	This routine returns a far pointer to the message associated with
;	messagenumber.	If the message does not exist, then a 0:0 is returned.
;
;Entry:
;	==PASCAL CALLING CONVENTIONS==
;	messagenumber	= WORD number of desired message
;
;Exit:
;	DX:AX	= pointer to message text or 0:0 if message doesn't exist
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	__FMSG_TEXT,<PUBLIC>,<ds,si,di>  ; pascal calling

parmW	msgt

cBegin
	mov	ax,FMGROUP
	mov	ds,ax		; ds = FMGROUP (force it always)
	push	ds
	pop	es
	mov	dx,msgt 	; dx = message number
	mov	si,fmsgOFFSET stfmsg ; start of far messages

tloop:
	lodsw			; ax = current message number
	cmp	ax,dx
	je	found		;   found it - return address
	inc	ax
	xchg	ax,si
	jz	found		;   at end and not found - return 0
	xchg	di,ax
	xor	ax,ax
	mov	cx,-1
	repne	scasb		; skip until 00
	mov	si,di
	jmp	tloop		; try next entry

found:
	xchg	ax,si
	cwd			; zero out dx in case NULL
	or	ax,ax
	jz	notfound
	mov	dx,ds		; remember segment selector
notfound:
cEnd

sEnd

	end
