
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program ScreenIO;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel;

procedure Sierpinski;
const
  N = 5;
var
  I, H, X, Y, X0, Y0 : integer;
  Sec : boolean;

procedure Plot;                        { Draw a line }
begin
  DrawLine(X, Y, X0, Y0);
  X0 := X;
  Y0 := Y;
end;

procedure B(I:integer); forward;       { Forward references for recursion }

procedure C(I:integer); forward;

procedure D(I:integer); forward;

procedure A(I : integer);              { First recursive procedure }
begin
  if I > 0 then
  begin
    A(I - 1);
    X := X + H;
    Y := Y - H;
    Plot;
    B(I - 1);
    X := X + 2 * H;
    Plot;
    D(I - 1);
    X := X + H;
    Y := Y + H;
    Plot;
    A(I - 1);
  end;
end; { A }

procedure B;                           { Second recursive procedure }
begin
  if I > 0 then
  begin
    B(I - 1);
    X := X - H;
    Y := Y - H;
    Plot;
    C(I - 1);
    Y := Y - 2 * H;
    Plot;
    A(I - 1);
    X := X + H;
    Y := Y - H;
    Plot;
    B(I - 1);
  end;
end; { B }

procedure C;                           { Third recursive procedure }
begin
  if I > 0 then
  begin
    C(I - 1);
    X := X - H;
    Y := Y + H;
    Plot;
    D(I - 1);
    X := X - 2 * H;
    Plot;
    B(I - 1);
    X := X - H;
    Y := Y - H;
    Plot;
    C(I - 1);
  end;
end; { C }

procedure D;                           { Last recursive procedure }
begin
  if I > 0 then
  begin
    D(I - 1);
    X := X + H;
    Y := Y + H;
    Plot;
    A(I - 1);
    Y := Y + 2 * H;
    Plot;
    C(I - 1);
    X := X - H;
    Y := Y + H;
    Plot;
    D(I - 1);
  end;
end; { D }

procedure DoIt;                        { Sierpinski main procedure }
begin
  I := 3;
  H := 16;
  X0 := 30;
  Y0 := 240;
  repeat
    I := I + 1;
    X0 := X0 - H;
    H := H div 2;
    Y0 := Y0 + H;
    X := X0;
    Y := Y0;
    A(I - 1);
    X := X + H;
    Y := Y - H;
    Plot;
    B(I - 1);
    X := X - H;
    Y := Y - H;
    Plot;
    C(I - 1);
    X := X - H;
    Y := Y + H;
    Plot;
    D(I - 1);
    X := X + H;
    Y := Y + H;
    Plot;
  until I = N;
end; { DoIt }

begin
  SetHeaderOn;
  DefineWorld(1, -3, -3, 258, 258);
  SelectWorld(1);
  SelectWindow(1);
  DrawBorder;
  DoIt;
end; { Sierpinski }

begin
  InitGraphic;                         { Initialize the graphics system }

  DefineHeader(1, 'DEMONSTRATE SCREEN SAVE AND READ TO/FROM DISK');

  SetHeaderOn;                         { Give it a header }

  Sierpinski;                          { Do the curve }

  SaveScreen('DEMO.PIC');              { Save the screen to disk }

  ClearScreen;                         { Clear the screen }

  Delay(1000);                         { Delay so that hard disk or RAM disk
                                         users can see the action }

  LoadScreen('DEMO.PIC');              { Retrieve it from disk }


  repeat until KeyPressed;             { Wait until a key is pressed }

  ClearScreen;

  LeaveGraphic;                        { Leave the graphics system }
end. { ScreenIO }
