
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program OnePolygon;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

procedure PolygonDem;
var
  N : integer;
  B, A : PlotArray;
  Ch : char;
  X1, X2 : integer;

procedure GenerateFunction(var A, B : PlotArray; N : integer);
{ Generate a sine polygon }
var
  I : integer;
  Delta : Float;
begin
  Delta := 2 * Pi / (N - 1);
  for I := 1 to N do
  begin
    A[I, 1] := (I - 1) * Delta - Pi;
    A[I, 2] := Sin(A[I, 1]);
  end;
end; { GenerateFunction }

begin
  ClearScreen;

  N := 30;
  GenerateFunction(A, B, N);               { Generate the polygon }

  DefineWindow(1, 0, 0, XMaxGlb, YMaxGlb);
  DefineHeader(1, 'SINE CURVE AS A POLYGON');    { Set up the screen }
  DefineWorld(1, -Pi, -1, Pi, 1);
  SelectWorld(1);
  SelectWindow(1);
  SetBackground(0);
  SetHeaderOn;
  DrawBorder;

  DrawAxis(8, -8, 0, 0, 0, 0, 0, 0, false);{ Draw the axes }

  DrawPolygon(A, 1, N, 0, 0, 0);           { Draw the polygon }
end; { PolygonDem }



begin
  InitGraphic;                             { Initialize the graphics system }

  PolygonDem;                              { Do the demo }

  repeat until KeyPressed;                 { Wait until a key is pressed }

  LeaveGraphic;                            { Leave the graphics system }
end. { OnePolygon }
