
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program MultipleWindows;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel;

var
  I : integer;

procedure DrawLines;
var
  I : integer;
begin
  for I := 1 to 20 do
    DrawLine(I * 50, 0, 1000 - I * 50, I * 50);
end; { DrawLines }

begin
  InitGraphic;               { Initialize the graphics system }


  DrawBorder;                { Draw a border around the drawing }
                             { area of the primary window }
                             { (the dimensions of the primary window }
                             { default to the screen dimensions) }

  DefineWindow(1, Trunc(XMaxGlb / 10), Trunc(YMaxGlb / 10),
                  Trunc(XMaxGlb / 2), Trunc(YMaxGlb / 2));
                             { Define a window  one tenth of the way }
                             { in from the left and top edges, and half }
                             { way down from the right and bottom edges }

  DefineHeader(1, 'THIS IS A LARGER WORLD'); { Give it a header }

  DefineWorld(1, 0, 0, 2000, 2000); { Give it a larger world coordinate system }


  DefineWindow(2, Trunc(XMaxGlb / 3), Trunc(YMaxGlb / 3),
                  Trunc((XMaxGlb * 2) / 3), Trunc((YMaxGlb * 2) / 3) );
                             { Define a window  one third of the way }
                             { in from the left and top edges, and }
                             { from the right and bottom edges }

  DefineHeader(2, 'THIS IS A CORRECT WORLD'); { Give it a header }

  DefineWorld(2, 0, 0, 1000, 1000); { Give it a correct world coordinate system }


  DefineWindow(3, Trunc(XMaxGlb / 2), Trunc(YMaxGlb / 2),
                  Trunc((XMaxGlb * 9) / 10), Trunc((YMaxGlb * 9) / 10));
                             { Define a window  one half of the way }
                             { in from the left and top edges, and half }
                             { way down from the right and bottom edges }

  DefineHeader(3, 'THIS IS A SMALLER WORLD'); { Give it a header }

  DefineWorld(3, 0, 0, 500, 500); { Give it a smaller world coordinate system }

  for I := 1 to 3 do
  begin
    SelectWindow(I);         { Select window }
    SetHeaderOn;             { Set the window header on }
    SelectWorld(I);          { Select a world coordinate system }
    SetBackground(0);        { Give the window a black background }
    DrawBorder;              { Draw a border around  the window }
    DrawLines;               { Draw lines }
  end;

  repeat until KeyPressed;   { Wait until a key is pressed }

  LeaveGraphic;              { Leave the graphics system }

end. { MultipleWindows }
