
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program MoveWindows;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

const
  Null = #0; { The Ascii null character }

var
  I : integer;
  Ch : char;

procedure DrawLines;
var
  I : integer;
begin
  for I := 1 to 20 do
    DrawLine(I * 50, 0, 1000 - I * 50, I * 50);
end; { DrawLines }


begin { MoveWindows }

  InitGraphic;               { Initialize the graphics system }


  DrawBorder;                { Draw a border around the drawing }
                             { area of the primary window }
                             { (the dimensions of the primary window }
                             { default to the screen dimensions) }

  DefineWindow(1, Trunc(XMaxGlb / 10), Trunc(YMaxGlb / 10),
                  Trunc(XMaxGlb / 2), Trunc(YMaxGlb / 2));
                             { Define a window  one tenth of the way }
                             { in from the left and top edges, and half }
                             { way down from the right and bottom edges }

  DefineHeader(1, 'THIS IS THE FIXED WINDOW'); { Give it a header }

  DefineWorld(1, 0, 0, 1000, 1000);   { Give it a world coordinate system }



  DefineWindow(2, Trunc(XMaxGlb / 2), Trunc(YMaxGlb / 2),
                  Trunc((XMaxGlb * 9) / 10), Trunc((YMaxGlb * 9) / 10));
                             { Define a window  one half of the way }
                             { in from the left and top edges, and half }
                             { way down from the right and bottom edges }

  DefineHeader(2, 'THIS IS THE MOVEABLE WINDOW'); { Give it a header }

  DefineWorld(2, 0, 0, 1000, 1000);   { Give it a world coordinate system }

  SelectWindow(1);           { Select fixed window }
  SetHeaderOn;
  SelectWorld(1);            { Select it's world }
  SetBackground(0);          { Give it a black background }
  DrawBorder;                { Draw a border around the window }
  DrawLines;                 { Draw lines in it }
  CopyScreen;                { Copy it to the virtual screen }

  SetBreakOff;               { Don't error when edge hit }
  SetMessageOff;

  SelectWindow(2);           { Select moveable window }
  SetHeaderOn;
  SelectWorld(2);            { Select it's world }
  SetBackground(0);          { Give it a black background }
  DrawBorder;                { Draw a border around the window }
  DrawLines;                 { Draw lines in it }

  repeat
    Ch := ReadKey;           { Read the keystroke }

    if (Ch = Null) and KeyPressed then { Test for an extended scan code  }
      Ch := ReadKey;
    case Ch of
      'H' : MoveVer(-4, true);   { Up arrow }
      'K' : MoveHor(-1, true);   { Left arrow }
      'M' : MoveHor(1, true);    { Right arrow }
      'P' : MoveVer(4, true);    { Down arrow }
    end;
  until Ch = ' ';            { Space character exits program }

  LeaveGraphic;              { Leave the graphics system }
end. { MoveWindows }
