
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program MovePolygon;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

var
  ArrowAngle : integer;
  Ch : char;
  Arrow : PlotArray;
  CurrX, CurrY, IncrX, IncrY, Size, Speed : Float;
  ArrowIncr : array[0..7, 1..2] of Float;

procedure MakeArrow;
begin
  Arrow[1, 1] := 0;                    { PlotArray init for the arrowhead }
  Arrow[1, 2] := 0;
  Arrow[2, 1] := Size;
  Arrow[2, 2] := -Size;
  Arrow[3, 1] := 0;
  Arrow[3, 2] := Size;
  Arrow[4, 1] := -Size;
  Arrow[4, 2] := -Size;
  Arrow[5, 1] := 0;
  Arrow[5, 2] := 0;
end; { MakeArrow }

procedure MakeMoveTable;
begin
  ArrowIncr[0, 1] := 0;                { Component velocities for radial moves }
  ArrowIncr[0, 2] := 1;
  ArrowIncr[1, 1] := -1;
  ArrowIncr[1, 2] := 1;
  ArrowIncr[2, 1] := -1;
  ArrowIncr[2, 2] := 0;
  ArrowIncr[3, 1] := -1;
  ArrowIncr[3, 2] := -1;
  ArrowIncr[4, 1] := 0;
  ArrowIncr[4, 2] := -1;
  ArrowIncr[5, 1] := 1;
  ArrowIncr[5, 2] := -1;
  ArrowIncr[6, 1] := 1;
  ArrowIncr[6, 2] := 0;
  ArrowIncr[7, 1] := 1;
  ArrowIncr[7, 2] := 1;
end; { MakeMoveTable }

procedure MoveForward;                 { Routine to move polygon forward }
begin
  SetColorBlack;                       { Draw over old polygon to erase it }
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
  CurrX := CurrX + IncrX;              { Move to new position }
  CurrY := CurrY + IncrY;
  TranslatePolygon(Arrow, 5, IncrX, IncrY);
  SetColorWhite;                       { Draw polygon in new position }
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
end; { MoveForward }

procedure MoveBack;                    { Routine to move polygon back }
begin
  SetColorBlack;                       { Same as above }
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
  CurrX := CurrX - IncrX;
  CurrY := CurrY - IncrY;
  TranslatePolygon(Arrow, 5, -IncrX, -IncrY);
  SetColorWhite;
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
end; { MoveBack }

procedure TurnLeft;                    { Rotate polygon counter-clockwise }
begin
  SetColorBlack;                       { Erase old polygon }
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
  RotatePolygon(Arrow, 5, 45);         { Rotate it 45 degrees }
  ArrowAngle := ArrowAngle + 1;
  if ArrowAngle > 7 then
    ArrowAngle := 0;
  IncrX := Speed * ArrowIncr[ArrowAngle, 1];  { Get new velocity }
  Incry := Speed * ArrowIncr[ArrowAngle, 2];
  SetColorWhite;                       { Draw rotated polygon }
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
end; { TurnLeft }

procedure TurnRight;                   { Rotate polygon clockwise }
begin
  SetColorBlack;                       { Same as above }
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
  RotatePolygon(Arrow, 5, -45);
  ArrowAngle := ArrowAngle - 1;
  if ArrowAngle < 0 then
    ArrowAngle := 7;
  IncrX := Speed * ArrowIncr[ArrowAngle, 1];
  Incry := Speed * ArrowIncr[ArrowAngle, 2];
  SetColorWhite;
  DrawPolygon(Arrow, 1, -5, 0, 0, 0);
end; { TurnRight }


begin
  InitGraphic;                         { Initialize the graphics system }

  DefineWindow(1, 0, 0, XMaxGlb, YMaxGlb);

  DefineWorld(1, -1000, -1000, 1000, 1000); { Give it a world coordinate system }

  SelectWorld(1);                      { Select its world }
  SelectWindow(1);                     { Select window }
  SetBackground(0);                    { Give it a black background }

  Size := 100;
  Speed := 30;
  CurrX := 0;
  CurrY := 0;
  ArrowAngle := 0;
  IncrX := 0;
  IncrY := Speed;

  MakeArrow;                           { Make the arrowhead }
  MakeMoveTable;                       { Make the move table }
  DrawPolygon(Arrow, 1, 5, 0, 0, 0);   { Draw it pointing up }

  repeat
    Ch := ReadKey;                     { Read the keystroke }

    if (Ch = #0) and KeyPressed then   { Test for an extended scan code  }
      Ch := ReadKey;                   { on either an IBM or Zenith Z100 }
    case Ch of
      'A', 'H' : MoveForward;          { Up arrow }
      'D', 'K' : TurnLeft;             { Left arrow }
      'C', 'M' : TurnRight;            { Right arrow }
      'B', 'P' : MoveBack;             { Down arrow }
    end;
  until Ch = ' ';                      { Space character exits program }

  LeaveGraphic;                        { Leave the graphics system }
end. { MovePolygon }
