
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program Interpolate;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

procedure SplineDem;
var
  X, Temp : Float;
  Dx, Dy, I, N, M, Lines, Scale : integer;
  X1, Y1, X2, Y2 : integer;
  B, A : PlotArray;

begin
  DefineWindow(1, 0, 0, XMaxGlb, YMaxGlb); { Define both windows as whole screen }
  DefineWindow(2, 0, 0, XMaxGlb, YMaxGlb);
  DefineWorld(1, 0, 0, 1000, 1000);    { Give a world to the screen }

  DefineHeader(2, 'A spline interpolation'); { Window where curves will go }
  SetHeaderOn;

  N := 12;                             { Fill polygon array }
  for I := 1 to N do
  begin
    A[I, 1] := I - 1;
    A[I, 2] := random - 0.5;
  end;

  M := 50;                             { Generate spline with 50 points }
  Spline(A, N, A[2, 1], A[N - 1, 1], B, M);
  FindWorld(2, B, M, 1, 1.08);         { Make world 2 the right size }

  SelectWindow(2);                     { Select it and draw border }
  DrawBorder;

  Dx := -8;                            { Draw axis inset from window edge }
  Dy := 7;
  X1 := 3;
  Y1 := 5;
  X2 := 25;
  Y2 := 10;
  Lines := 0;
  Scale := 0;

  SetLineStyle(1);                     { Draw initial curve as dotted line }
  DrawAxis(Dx, Dy, X1, Y1, X2, Y2, Lines, Scale, false);
  DrawPolygon(A, 2, N - 1, 7, 2, 0);   { Don't draw the endpoints }

  SetLineStyle(0);                     { Draw interpolated curve as solid line }
  ResetAxis;
  DrawPolygon(B, 1, -M, 0, 0, 0);      { Spline is not good on endpoints }

  SelectWorld(1);                      { Select outside window }
  SelectWindow(1);

  DrawTextW(730, 400, 1, ^['7@2   The data');    { Print legend }
  DrawTextW(730, 500, 1, '..  The initial polygon');
  DrawTextW(730, 600, 1, '__  The interpolated values');
end; { SplineDem }

begin
  InitGraphic;                         { Initialize the graphics system }

  SplineDem;                           { Do the demo }

  repeat until KeyPressed;             { Wait until a key is pressed }

  LeaveGraphic;                        { Leave the graphics system }
end. { Interpolate }
