
{           Copyright (c) 1985, 87 by Borland International, Inc.            }

program FindWorldDemo;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

procedure FindWorldDem;
var
  X : Float;
  Dx, Dy, I, N, Lines, Scale : integer;
  X1, Y1, X2, Y2 : integer;
  B, A : PlotArray;

begin
  DefineWindow(1, 0, 0, XMaxGlb, YMaxGlb); { Define windows as whole screen }
  DefineWindow(2, 0, 0, XMaxGlb, YMaxGlb);
  DefineWorld(1, 0, 0, 1000, 1000);        { Give a world to the screen }

  DefineHeader(2, 'A FOUND WORLD');        { Window where curve will go }
  SelectWindow(2);
  SetHeaderOn;

  N := 10;                                 { Fill polygon array }
  for I := 1 to N do
  begin
    A[I, 1] := I - 1;
    A[I, 2] := random - 0.5;
  end;

  FindWorld(2, A, N, 1, 1.08);             { Make world 2 the right size }

  SelectWindow(2);                         { Select it and draw border }
  DrawBorder;

  Dx := -8;                                { Draw axis inset from window edge }
  Dy := 7;
  X1 := 3;
  Y1 := 5;
  X2 := 25;
  Y2 := 10;
  Lines := 0;
  Scale := 0;

  SetLineStyle(0);                         { Draw curve as solid line }
  DrawAxis(Dx, Dy, X1, Y1, X2, Y2, Lines, Scale, false);
  DrawPolygon(A, 1, N, 7, 2, 0);

  SelectWorld(1);                          { Select outside window }
  SelectWindow(1);

  DrawTextW(730, 450, 1, ^['7@2   The data');  { Print legend }
  DrawTextW(730, 550, 1, '--  The curve');
end; { FindWorldDem }

begin
  InitGraphic;                             { Initialize the graphics system }

  FindWorldDem;                            { Do the demo }

  repeat until KeyPressed;                 { Wait until a key is pressed }

  LeaveGraphic;                            { Leave the graphics system }
end. { FindWorldDemo }

