(********************************************************************)
(*                         GRAPHIX TOOLBOX 4.0                      *)
(*       Copyright (c) 1985, 87 by  Borland International, Inc.     *)
(*                                                                  *)
(*                        Demonstration program                     *)
(********************************************************************)

program TurboGraphicsDemo;

{$I Float.inc}  { Determines what type Float means. }

uses
  Dos, Crt, GDriver, GKernel, GWindow, GShell;

procedure Delay(N : Float);
var
  I : Float;
  J : integer;
  Ch : char;
  Quit : boolean;

begin
  I := 0;
  Ch := ' ';
  repeat
    I := I + 1;
    Quit := false;
    if KeyPressed then
    begin
      Ch := ReadKey;
      Quit := (Ch = ^C);
      if (Ch = '') and KeyPressed then
      begin
        Ch := ReadKey;
        Quit := (Ch = 'O');
        Ch := ' ';
      end;
    end;
    if Quit then
    begin
      LeaveGraphic;
      Halt;
    end;
  until (Ch = ^M) or (I >= N);
end; { Delay }

procedure WaitReturn(N : Float);
begin
  Write('Hit RETURN to continue');
  Delay(N);
end; { WaitReturn }

procedure ClearEol(I : integer);
begin
  GotoXY(1, I);
  Write('                                                                               ');
end; { ClearEol }

procedure Msg(S : WrkString);
begin
  ClearEol(25);
  GotoXY(1, 25);
  Write(S);
  Delay(750);
end; { Msg }

procedure SelectIBM;
begin
  SelectWorld(2);
  SelectWindow(10);
end; { SelectIBM }

procedure DefineWindowIBM(I, X1, Y1, X2, Y2 : integer);
begin
  DefineWindow(I, Trunc(X1 / 79 * XMaxGlb + 0.001), Trunc(Y1 / 199 * YMaxGlb + 0.001),
                  Trunc(X2 / 79 * XMaxGlb + 0.5), Trunc(Y2 / 199 * YMaxGlb + 0.5));
end; { DefineWindow }

procedure MoveHorIBM(Delta : integer; Fill : boolean);
var
  D : integer;
begin
  D := Trunc(abs(Delta) / 79 * XMaxGlb + 0.001);
  if Delta < 0 then
    D := -D;
  MoveHor(D, Fill);
end; { MoveHorIBM }

procedure MoveVerIBM(Delta : integer; Fill : boolean);
var
  D : integer;
begin
  D := Trunc(abs(Delta) / 199 * YMaxGlb + 0.001);
  if Delta < 0 then
    D := -D;
  MoveVer(D, Fill);
end; { MoveVerIBM }

{----------------------------------------------------------------------------}

procedure Intro;
var
  I : integer;
begin
  SetHeaderOff;
  DefineWindowIBM(1, 5, 40, 25, 80);
  DefineWindowIBM(2, 16, 55, 43, 95);
  DefineWindowIBM(4, 15, 60, 43, 135);
  SelectWindow(1);
  DrawBorder;
  SelectIBM;
  DrawTextW(52, 144, 5, 'TURBO');
  StoreWindow(1);
  Delay(500);
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  SelectIBM;
  DrawTextW(140, 129, 5, 'GRAPHIX');
  StoreWindow(2);
  Delay(500);
  for I := 1 to 4 do
  begin
    RestoreWindow(1, 0, 0);
    Delay(800);
    RestoreWindow(2, 0, 0);
    Delay(800);
  end;
  for I := 1 to 8 do
  begin
    RestoreWindow(1, Trunc(3 * I * XMaxGlb / 79), Trunc(9 * I * YMaxGlb / 199));
    Delay(500);
    RestoreWindow(2, Trunc(3 * I * XMaxGlb / 79), Trunc(9 * I * YMaxGlb / 199));
    Delay(500);
  end;
  Delay(500);
  SelectWindow(4);
  StoreWindow(4);
  SetBackground(0);
  DrawBorder;
  GotoXY(18, 10);
  WriteLn('GRAPHICS for TURBO PASCAL');
  for I := 2 to 40 do
  begin
    DrawLine(I * 8, 139, 639 - I * 8, 9);
    DrawLine(639 - I * 8, 139, I * 8, 9);
  end;
  Delay(2500);
  RestoreWindow(4, 0, 0);
  InvertScreen;
  SelectScreen(2);
  ClearScreen;
  InvertScreen;
  SetColorBlack;
  SelectIBM;
  DrawTextW(40, 124, 3, 'By');
  DrawTextW(40, 59, 4, 'BORLAND INTERNATIONAL');
  CopyScreen;
  SelectScreen(1);
  Delay(5000);
  DefineWindowIBM(1, 1, 125, 35, 168);
  StoreWindow(1);
  DefineWindowIBM(2, 36, 125, 78, 168);
  StoreWindow(2);
  for I := 1 to Trunc(34 * XMaxGlb / 79) do
  begin
    SelectWindow(1);
    MoveHor(1, false);
    ReDefineWindow(1, X1RefGlb, Y1RefGlb, X2RefGlb - 1, Y2RefGlb);
    SelectWindow(2);
    MoveHor(-1, false);
    ReDefineWindow(2, X1RefGlb + 1, Y1RefGlb, X2RefGlb, Y2RefGlb);
  end;
  SetColorWhite;
  DrawTextW(X1RefGlb - 56, Y1RefGlb + 96, 4, '_');
  SetColorBlack;
  Delay(1000);
  RestoreWindow(1, 0, 0);
  RestoreWindow(2, 0, 0);
  GotoXY(1, 25);
  ClrEOL;
  GotoXY(17, 25);
  Write('Copyright (C) 1985 Borland International, Inc.');
  Delay(3000);
  SetColorWhite;
  SetHeaderOn;
end; { Intro }

{----------------------------------------------------------------------------}

procedure Simple;
var
  I, J, Rnd : integer;
  Rad : Float;
  Ch : char;

procedure DrawPoints;
var
  I : integer;
begin
  SetBackground(0);
  DrawBorder;
  for I := 1 to 250 do
    DrawPoint(Random(640), Random(200));
end; { DrawPoints }

procedure DrawLines;
var
  I : integer;
begin
  SetBackground(0);
  DrawBorder;
  for I := 1 to 20 do
    DrawLine(I * 31, 199, 640 - I * 31, 199 - I * 10);
end; { DrawLines }

procedure DrawSquares;
var
  I : integer;
begin
  SetBackground(0);
  DrawBorder;
  for I := 1 to 15 do
    DrawSquare(320 - I * 20, 100 - I * 6, 320 + I * 20, 100 + I * 6, false);
end; { DrawSquares }

procedure DrawCircles;
var
  I : integer;
  AspectLoc : Float;
begin
  SetBackground(0);
  DrawBorder;
  Rad := 0.8;
  AspectLoc := GetAspect;
  SetAspect(1 / 4.5);
  for I := 1 to 15 do
  begin
    DrawCircle(320, 100, Rad);
    SetAspect((1 + I) / 4.5);
    Rad := Rad - 0.05;
  end;
  SetAspect(AspectLoc);
end; { DrawCircles }

procedure DrawPie1;
var
  A : PieArray;
  I : integer;
begin
  SetBackground(0);
  DrawBorder;
  for I := 1 to 5 do
  begin
    A[I].Area := Random + 0.35;
    A[I].Text := '';
  end;
  A[2].Area := -A[2].Area;
  DrawCartPie(320, 100, 500, 100, 1, 1, A, 5, 0, 1);
end; { DrawPie1 }

procedure HatchIt;
var
  I, Temp, X1, X2, Y1, Y2 : integer;
begin
  SetBackground(0);
  DrawBorder;
  for I := 1 to 5 do
  begin
    X1 := 100 + Random(500);
    X2 := 100 + Random(500);
    Y1 := 30 + Random(160);
    Y2 := 30 + Random(160);
    if X1 > X2 then
    begin
      Temp := X1;
      X1 := X2;
      X2 := Temp;
    end;
    if Y1 < Y2 then
    begin
      Temp := Y1;
      Y1 := Y2;
      Y2 := Temp;
    end;
    DrawSquare(X1, Y1, X2, Y2, false);
    hatch(X1, Y1, X2, Y2, Random(6) + 5);
  end;
end; { HatchIt }

begin { Simple }
  ClearScreen;
  SetHeaderOn;
  DefineWindowIBM(1, 0, 0, 79, 185);
  DefineHeader(1, 'The simple graphics procedures');
  SelectWindow(1);
  SetBackground(90);
  DrawBorder;
  CopyScreen;
  DefineWindowIBM(2, 28, 60, 49, 140);
  SelectWindow(2);
  Msg('  Drawing points   :   DrawPoint');
  DrawPoints;
  MoveVerIBM(-44, true);
  MoveHorIBM(-26, true);
  Delay(1000);
  DefineWindowIBM(3, 28, 60, 49, 140);
  SelectWindow(3);
  Msg('  Drawing Lines   :   DrawLine');
  DrawLines;
  MoveVerIBM(-44, true);
  CopyScreen;
  Delay(1000);
  DefineWindowIBM(4, 28, 60, 49, 140);
  SelectWindow(4);
  Msg('  Drawing squares   :   DrawSquare');
  DrawSquares;
  MoveVerIBM(-44, true);
  MoveHorIBM(26, true);
  Delay(1000);
  DefineWindowIBM(5, 28, 60, 49, 140);
  SelectWindow(5);
  Msg('  Drawing circles   :   DrawCircle');
  DrawCircles;
  MoveVerIBM(40, true);
  MoveHorIBM(26, true);
  Delay(1000);
  DefineWindowIBM(6, 28, 60, 49, 140);
  SelectWindow(6);
  Msg('  Drawing circle segments   :   DrawCircleSegment');
  DrawPie1;
  MoveVerIBM(40, true);
  CopyScreen;
  Delay(1000);
  DefineWindowIBM(7, 28, 60, 49, 140);
  SelectWindow(7);
  Msg('  Hatched squares   :   hatch');
  HatchIt;
  MoveVerIBM(40, true);
  MoveHorIBM(-26, true);
  Delay(1000);
  ClearEol(25);
  for I := 1 to 5 do
  begin
    SelectWindow(2);
    InvertWindow;
    for J := 3 to 7 do
    begin
      SelectWindow(J);
      InvertWindow;
      SelectWindow(J - 1);
      InvertWindow;
    end;
    SelectWindow(7);
    InvertWindow;
  end;
  Msg('              Hit RETURN to continue');
  for I := 2 to 7 do
  begin
    SelectWindow(I);
    InvertWindow;
  end;
  I := 0;
  Ch := ' ';
  repeat
    Rnd := Random(6) + 1;
    SelectWindow(Rnd + 1);
    case Rnd of
      1 : DrawPoints;
      2 : DrawLines;
      3 : DrawSquares;
      4 : DrawCircles;
      5 : DrawPie1;
      6 : HatchIt;
    end;
    InvertWindow;
    I := I + 1;
    if KeyPressed then
      Ch := ReadKey;
  until (Ch = ^M) or (I = 30);
end; { Simple }

{----------------------------------------------------------------------------}

procedure WindowDemo;
var
  Row, Column, I : integer;

procedure WriteSlow(S : WrkString);
var
  I : integer;
begin
  Row := Row + 1;
  GotoXY(17, 5);
  Write(Row:2);
  GotoXY(8, 6 + Row);
  for I := 1 to Length(S) do
  begin
    Write(S[I]);
    GotoXY(28, 5);
    Write(Column + I:2);
    GotoXY(8 + I, 6 + Row);
    Delay(10 + Random(100));
  end;
end; { WriteSlow }

begin { WindowDemo }
  ClearScreen;
  SetHeaderOn;
  DefineWindowIBM(1, 0, 0, 79, 190);
  DefineHeader(1, 'Using several windows on one screen');
  SelectWindow(1);
  SetBackground(24);
  DrawBorder;
  DefineWindowIBM(2, 4, 16, 55, 140);
  DefineHeader(2, 'Example:  Editing');
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  Column := 0; Row := 0;
  GotoXY(11, 5); Write('Line      Column     file : A:TEST.TXT');
  GotoXY(8, 6);  Write('L----#----#----#----#----#----#----#----#----R');
  GotoXY(8, 7); WriteSlow ('This is a demonstration of the use of');
  GotoXY(8, 8); WriteSlow ('windows within the TURBO GRAPHIX system.  A');
  GotoXY(8, 9); WriteSlow ('window is any defined part of the screen.');
  GotoXY(8, 10); WriteSlow('All further graphics commands refer to that');
  GotoXY(8, 11); WriteSlow('window.  Those parts of the diagram that lie');
  GotoXY(8, 12); WriteSlow('outside the window are not drawn.  Scaling of');
  GotoXY(8, 13); WriteSlow('the diagram is also done by TURBO GRAPHIX,');
  GotoXY(8, 14); WriteSlow('allowing you to draw in natural coordinates.');
  GotoXY(19, 16);
  StoreWindow(2);
  WaitReturn(60000.0);
  DefineWindowIBM(3, 25, 30, 78, 180);
  DefineHeader(3, 'Example:  Chart calculation');
  SelectWindow(3);
  SetBackground(0);
  DrawBorder;
  GotoXY(28, 7);
  Write('        1        2        3        4        5');
  for I := 1 to 12 do
  begin
    GotoXY(28, 7 + I);
    Write(I:2);
  end;
  GotoXY(28, 20); Write('Command ? _________________________________________');
  GotoXY(28, 22); Write('working : sales.clc        free : 85 kByte = 92.3 %');
  GotoXY(40, 9); Write(' S A L E S - M O D E L  1984');
  GotoXY(40, 10); Write(' ===============================');
  GotoXY(32, 12); Write('Production costs     :   1456.35');
  GotoXY(32, 13); Write('Personnel costs      :    145.23');
  GotoXY(32, 14); Write('Sales tax            :    524.12');
  GotoXY(32, 15); Write('--------------------------------');
  GotoXY(32, 16); Write('Subtotal             :   2125.70');
  GotoXY(32, 18); Write('Sold                 :       145');
  Delay(4000);
  GotoXY(39, 20);
  WaitReturn(15000);
  DefineWindowIBM(4, 12, 60, 68, 164);
  DefineHeader(4, 'Example:  Graphics');
  SelectWindow(4);
  SetBackground(0);
  DrawBorder;
  for I := 1 to 85 do
    DrawLine(20 + I * 7, 30, 630 - I * 7, 170);
  GotoXY(29, 20);
  CopyScreen;
  WaitReturn(15000);
  RestoreWindow(2, Trunc(16 * XMaxGlb / 79), Trunc(32 * YMaxGlb / 199));
  SelectWindow(2);
  Delay(2000);
  MoveHorIBM(-16, true);
  MoveVerIBM(-32, true);
  for I := 1 to 11 do
  begin
    GotoXY(8, 6 + I);
    Write('                                              ');
  end;
  Row := 0;
  Column := 0;
  GotoXY(8, 7); WriteSlow('Besides defining the window you can also move');
  GotoXY(8, 8); WriteSlow('it around on the screen.  You can slide');
  GotoXY(8, 9); WriteSlow('windows over other windows or put several of');
  GotoXY(8, 10); WriteSlow('them on top of each other.  A window can');
  GotoXY(8, 11); WriteSlow('also be put into a window memory and be');
  GotoXY(8, 12); WriteSlow('brought back onto the screen as the need');
  GotoXY(8, 13); WriteSlow('arises.  The size of the window memory is');
  GotoXY(8, 14); WriteSlow('limited only by the size of the main memory.');
  GotoXY(19, 16);
  WaitReturn(60000.0);
end; { WindowDemo }

{----------------------------------------------------------------------------}
procedure Sier;
const
  N = 4;
var
  I, H, X, Y, X0, Y0 : integer;
  Sec : boolean;

procedure Plot;
begin
  if Sec then
    SetColorWhite
  else
    SetColorBlack;
  DrawLine(X, Y, X0, Y0);
  DrawLine(X + 256, Y + 256, X0 + 256, Y0 + 256);
  if Sec then
    SetColorBlack
  else
    SetColorWhite;
  DrawLine(X + 256, Y, X0 + 256, Y0);
  DrawLine(X, Y + 256, X0, Y0 + 256);
  X0 := X;
  Y0 := Y;
end; { Plot }

procedure B(I:integer); forward;

procedure C(I:integer); forward;

procedure D(I:integer); forward;

procedure A(I:integer);
begin
  if I > 0 then
  begin
    A(I - 1);
    X := X + H;
    Y := Y - H;
    Plot;
    B(I - 1);
    X := X + 2 * H;
    Plot;
    D(I - 1);
    X := X + H;
    Y := Y + H;
    Plot;
    A(I - 1);
  end;
end; { A }

procedure B;
begin
  if I > 0 then
  begin
    B(I - 1);
    X := X - H;
    Y := Y - H;
    Plot;
    C(I - 1);
    Y := Y - 2 * H;
    Plot;
    A(I - 1);
    X := X + H;
    Y := Y - H;
    Plot;
    B(I - 1);
  end;
end; { B }

procedure C;
begin
  if I > 0 then
  begin
    C(I - 1);
    X := X - H;
    Y := Y + H;
    Plot;
    D(I - 1);
    X := X - 2 * H;
    Plot;
    B(I - 1);
    X := X - H;
    Y := Y - H;
    Plot;
    C(I - 1);
  end;
end; { C }

procedure D;
begin
  if I > 0 then
  begin
    D(I - 1);
    X := X + H;
    Y := Y + H;
    Plot;
    A(I - 1);
    Y := Y + 2 * H;
    Plot;
    C(I - 1);
    X := X - H;
    Y := Y + H;
    Plot;
    D(I - 1);
  end;
end; { D }

procedure DoIt;
begin
  I := 3;
  H := 16;
  X0 := 30;
  Y0 := 240;
  repeat
    I := I + 1;
    X0 := X0 - H;
    H := H div 2;
    Y0 := Y0 + H;
    X := X0;
    Y := Y0;
    A(I - 1);
    X := X + H;
    Y := Y - H;
    Plot;
    B(I - 1);
    X := X - H;
    Y := Y - H;
    Plot;
    C(I - 1);
    X := X - H;
    Y := Y + H;
    Plot;
    D(I - 1);
    X := X + H;
    Y := Y + H;
    Plot;
  until I = N;
end; { DoIt }

begin  { Sier }
  SetHeaderOn;
  DefineWorld(1, -3, -3, 514, 514);
  SelectWorld(1);
  DefineWindowIBM(2, 0, 0, 39, 99);
  SelectWindow(2);
  InvertWindow;
  DefineWindowIBM(2, 40, 100, 79, 190);
  SelectWindow(2);
  InvertWindow;
  DefineWindowIBM(1, 0, 0, 79, 190);
  DefineHeader(1, 'A Sierpinski curve');
  SelectWindow(1);
  DrawBorder;
  GotoXY(1, 25);
  Write('     The whole screen is the actual window');
  Sec := false;
  DoIt;
  GotoXY(57, 25);
  WaitReturn(15000);
  DefineWindowIBM(1, 20, 40, 59, 159);
  SelectWindow(1);
  SetBackground(0);
  DrawBorder;
  DefineWindowIBM(2, 40, 40, 59, 99);
  SelectWindow(2);
  InvertWindow;
  DefineWindowIBM(2, 20, 100, 39, 159);
  SelectWindow(2);
  InvertWindow;
  SelectWindow(1);
  ClearEol(25);
  GotoXY(1, 25);
  Write('      The same drawing operations in a smaller window');
  Sec := true;
  DoIt;
  GotoXY(57, 25);
  WaitReturn(15000);
  ClearEol(25);
  GotoXY(1, 25);
  Write('   The screen is saved with the SaveScreen procedure, ...');
  SaveScreen('TEST.PIC');
  Delay(1000);
  ClearScreen;
  Delay(1000);
  LoadScreen('TEST.PIC');
  ClearEol(25);
  GotoXY(1, 25);
  Write('     ... and brought up again.');
  GotoXY(57, 25);
  WaitReturn(15000);
  DefineWorld(1, 0, 0, 639, 199);
  SelectWorld(1);
  SelectWindow(1);
  SetColorWhite;
end; { Sier }

{----------------------------------------------------------------------------}

procedure PieDem;
var
  Sum : Float;
  I, J, N : integer;
  A : PieArray;

begin
  ClearScreen;
  SetColorWhite;
  DefineWindowIBM(1, 0, 0, 79, 185);
  DefineWindowIBM(2, 20, 20, 77, 180);
  DefineWindowIBM(3, 28, 60, 59, 150);
  DefineWindowIBM(4, 28, 60, 59, 140);
  DefineWindowIBM(5, 28, 60, 59, 140);
  DefineWindowIBM(6, 28, 60, 59, 140);
  DefineHeader(1, 'Applications of pie charts');
  DefineHeader(2, 'Sales volume');
  DefineHeader(3, 'With text');
  DefineHeader(4, 'With text');
  DefineHeader(5, 'With text and numbers');
  DefineHeader(6, 'No text');
  A[1].Area := 25;
  A[1].Text := 'JAN. ';
  A[2].Area := 17.5;
  A[2].Text := 'FEB. ';
  A[3].Area := 9.6;
  A[3].Text := 'MAR. ';
  A[4].Area := 21;
  A[4].Text := 'APR. ';
  A[5].Area := 35;
  A[5].Text := 'MAY  ';
  N := 5;
  Sum := 0;
  for I := 1 to N do
  begin
    A[I].Area := A[I].Area + 5.35;
    Sum := Sum + A[I].Area;
  end;
  SelectWindow(1);
  DrawBorder;
  GotoXY(24, 5);
  WriteLn('Sales  1985');
  GotoXY(5, 8);
  Write('Amounts in $ (X 1,000,000)');
  GotoXY(40, 8);
  Write('Amounts in percent');
  for I := 1 to N do
  begin
    GotoXY(11, 9 + I);
    WriteLn(A[I].Text, '  ', A[I].Area:3:2, '                            ',
            A[I].Area / Sum * 100:3:2);
  end;
  Msg('  Drawing on the second screen in the background :  SelectScreen');
  SelectScreen(2);
  ClearScreen;
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  A[1].Area := -A[1].Area;
  DrawCartPie(300, 100, 390, 73, 1.05, 1.5, A, N, 2, 2);
  ResetWindowStack;
  StoreWindow(2);
  SelectScreen(1);
  RestoreWindow(2, 0, 0);
  Delay(15000);
  CopyScreen;
  Msg('  Variations of the Pie Chart diagram  :  DrawCartPie');
  SetColorBlack;
  SelectWindow(3);
  SetBackground(255);
  DrawBorder;
  A[4].Area := -A[4].Area;
  DrawCartPie(320, 100, 437, 73, 1.05, 1.6, A, N, 1, 1);
  A[4].Area := -A[4].Area;
  MoveVerIBM(-32, true);
  MoveHorIBM(-26, true);
  CopyScreen;
  Delay(1000);
  SelectWindow(4);
  SetBackground(255);
  DrawBorder;
  DrawCartPie(320, 100, 437, 73, 0.75, 1.5, A, N, 1, 1);
  MoveVerIBM(-44, true);
  MoveHorIBM(19, true);
  Delay(1000);
  CopyScreen;
  SelectWindow(5);
  SetBackground(255);
  DrawBorder;
  DrawCartPie(320, 100, 437, 100, 0.7, 1.4, A, N, 2, 1);
  MoveVerIBM(30, true);
  MoveHorIBM(-18, true);
  Delay(1000);
  SelectWindow(6);
  SetBackground(255);
  DrawBorder;
  DrawCartPie(320, 100, 482, 73, 1, 1.5, A, N, 0, 1);
  Delay(1000);
  Delay(15000);
  RestoreWindow(2, 0, 0);
  Delay(15000);
  SetColorWhite;
end; { PieDem }

{----------------------------------------------------------------------------}

procedure SplineDem;
var
  X, Temp : Float;
  M, Dx, Dy, I, J, N, Lines, Scale : integer;
  X1, Y1, X2, Y2 : integer;
  B, A : PlotArray;
begin
  ClearScreen;
  SetColorWhite;
  GotoXY(50, 25);
  Write('one moment please ....');
  Dx := -8;
  Dy := 7;
  X1 := 3;
  Y1 := 5;
  X2 := 25;
  Y2 := 10;
  Lines := 0;
  Scale := 0;
  N := 12;
  M := 50;
  X := -49;
  DefineWindowIBM(1, 0, 0, 79, 185);
  DefineWindowIBM(2, 30, 20, 70, 164);
  DefineHeader(1, 'A Spline interpolation');
  DefineHeader(2, 'A variation of the diagram');
  X := -49;
  for I := 1 to N do
  begin
    A[I, 1] := I - 1;
    A[I, 2] := Random - 0.5;
    X := X + 7;
  end;
  Spline(A, N, A[2, 1], A[N - 1, 1], B, M);
  FindWorld(1, B, M, 1, 1.08);
  SelectWindow(1);
  ClearEol(25);
  GotoXY(10, 25);
  Write('The given data');
  FindWorld(1, B, M, 1, 1.08);
  SelectWindow(1);
  DrawBorder;
  DrawAxis(Dx, Dy, X1, Y1, X2, Y2, Lines, Scale, false);
  SetLineStyle(1);
  DrawPolygon(A, 2, N - 1, 7, 2, 0);
  SetLineStyle(0);
  SelectIBM;
  DrawTextW(470, 129, 1, ^['7@2   The data');
  DrawTextW(470, 109, 1, '--  The interpolated values');
  GotoXY(50, 25);
  SelectWorld(1);
  SelectWindow(1);
  WaitReturn(15000);
  ClearEol(25);
  GotoXY(10, 25);
  Write('The interpolating Spline function');
  ResetAxis;
  DrawPolygon(B, 1, -M, 0, 0, 0);
  CopyScreen;
  GotoXY(50, 25);
  WaitReturn(15000);
  ClearEol(25);
  GotoXY(10, 25);
  Write('Vertical coordinates exchanged');
  with World[1] do     { Flip the found World vertically }
  begin
    Temp := Y1;
    Y1 := Y2;
    Y2 := Temp;
  end;
  SelectWorld(1);
  SelectWindow(2);
  SetBackground(255);
  SetColorBlack;
  DrawBorder;
  DrawAxis(abs(Dx), abs(Dy), 0, 0, 0, 0, 0, 0, false);
  DrawPolygon(A, 2, N - 1, -2, 2, -1);
  ResetAxis;
  DrawPolygon(B, 1, -M, 0, 0, 0);
  SetColorWhite;
  GotoXY(50, 25);
  WaitReturn(15000);
  ClearEol(25);
  GotoXY(10, 25);
  Write('Moving a window');
  MoveVerIBM(-15, true);
  MoveHorIBM(-30, true);
  MoveVerIBM(35, true);
  MoveHorIBM(35, true);
  MoveVerIBM(-5, true);
  MoveHorIBM(-5, true);
  GotoXY(50, 25);
  WaitReturn(15000);
  ClearEol(25);
  GotoXY(10, 25);
  Write('Inverting a window');
  InvertWindow;
  SetColorWhite;
  GotoXY(50, 25);
  WaitReturn(15000);
  SelectScreen(2);
  ClearEol(25);
  GotoXY(10, 25);
  Write('The reconstruction of the first figure');
  CopyScreen;
  SelectScreen(1);
  GotoXY(50, 25);
  WaitReturn(15000);
end; { SplineDem }

{----------------------------------------------------------------------------}

procedure PolygonDem;
var
  N : integer;
  B, A : PlotArray;
  X1, X2 : integer;

procedure GenerateFunction(var A, B : PlotArray; N : integer);
var
  I : integer;
  Delta : Float;
begin
  Delta := 2 * Pi / (N - 1);
  for I := 1 to N do
  begin
    A[I, 1] := (I - 1) * Delta - Pi;
    B[I, 1] := A[I, 1];
    B[I, 2] := Exp(-abs(A[I, 1]));
    A[I, 2] := Sin(A[I, 1]) * Exp(-abs(A[I, 1]) * 0.1);
  end;
end; { GenerateFunction }

begin { PolygonDem }
  ClearScreen;
  SetColorWhite;
  N := 30;
  GotoXY(50, 25);
  Write('one moment please ....');
  GenerateFunction(A, B, N);
  ClearScreen;
  DefineWorld(1, -Pi, 1, Pi, -1);
  SelectWorld(1);
  Msg('The example function in world coordinates  [-Pi,Pi] : DrawPolygon');
  DefineWindowIBM(1, 0, 0, 39, 95);
  DefineHeader(1, 'The example function');
  SelectWindow(1);
  DrawBorder;
  DrawPolygon(A, 1, N, 0, 0, 0);
  Delay(15000);
  Msg('Procedures used : DrawAxis , DrawPolygon');
  DefineWindowIBM(2, 20, 40, 79, 185);
  DefineHeader(2, 'Example function with axes');
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  DrawAxis(8, -8, 0, 0, 0, 0, 0, 0, false);
  DrawPolygon(A, 1, N, 0, 0, 0);
  Delay(15000);
  Msg('Greatest axis density : DrawAxis , DrawPolygon');
  DefineWindowIBM(2, 8, 15, 70, 170);
  DefineHeader(2, 'Example function with axes');
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  DrawAxis(9, -9, 0, 0, 0, 0, 1, 1, false);
  DrawPolygon(A, 1, N, 0, 0, 0);
  Delay(15000);
  Msg('The example function displayed through dots : DrawPolygon');
  DefineWindowIBM(1, 0, 0, 39, 95);
  DefineHeader(1, 'The example function');
  SelectWindow(1);
  SetBackground(0);
  DrawBorder;
  DrawPolygon(A, 1, N, 9, 1, 0);
  Delay(15000);
  Msg('The example function drawn with circles : DrawPolygon');
  DrawPolygon(A, 1, N, -8, 3, 0);
  Delay(15000);
  Msg('The example function connected by Lines : SetLinestyle , DrawPolygon');
  SetLinestyle(1);
  DrawPolygon(A, 1, N, 0, 0, 0);
  SetLinestyle(0);
  Delay(15000);
  Msg('The display of several functions by repeated calls of DrawPolygon');
  DefineWindowIBM(2, 20, 40, 79, 185);
  DefineHeader(2, 'Two functions displayed with axes');
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  DrawAxis(8, -8, 0, 0, 0, 0, 0, 0, false);
  DrawPolygon(A, 1, N, -1, 4, 0);
  Delay(15000);
  Msg('The points of the first function connected with Lines : DrawPolygon');
  DrawAxis(0, 0, 0, 0, 0, 0, 0, 0, false);
  DrawPolygon(A, 1, N, 0, 0, 0);
  Delay(15000);
  Msg('The points of the second function in the same coordinate system');
  DrawAxis(0, 0, 0, 0, 0, 0, 0, 0, false);
  DrawPolygon(B, 1, N, -4, 2, 0);
  Delay(15000);
  Msg('The points of the second function connected by Lines : DrawPolygon');
  DrawAxis(0, 0, 0, 0, 0, 0, 0, 0, false);
  SetLinestyle(1);
  DrawPolygon(B, 1, N, 0, 0, 0);
  SetLinestyle(0);
  Delay(15000);
  Msg('Lettering the axes with the greatest density : DrawAxis , DrawPolygon');
  DefineWindowIBM(2, 8, 15, 70, 170);
  DefineHeader(2, 'Marking the points');
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  DrawAxis(8, -8, 0, 0, 0, 0, 0, 1, false);
  DrawPolygon(A, 1, N, -2, 3, 0);
  Delay(15000);
  DrawAxis(0, 0, 0, 0, 0, 0, -1, -1, false);
  DrawPolygon(A, 1, N, 9, 1, -1);
  Delay(15000);
  DrawAxis(0, 0, 0, 0, 0, 0, -1, -1, false);
  SetLinestyle(2);
  DrawPolygon(A, 1, N, 0, 0, 0);
  SetLinestyle(0);
  Delay(15000);
end; { PolygonDem }

{----------------------------------------------------------------------------}

procedure HistoDem;
var
  I, N : integer;
  A : PlotArray;
  R, Temp : Float;

begin
  GotoXY(50, 25);
  Write('one moment please ....');
  N := 50;
  R := abs(N / 2);
  for I := 0 to abs(N - 1) do
  begin
    A[I + 1, 1] := I - R;
    A[I + 1, 2] := Sin(A[I + 1, 1] / 10) *
                   Exp(-abs(A[I + 1, 1]) * 0.01) + Random * 0.1;
  end;
  ClearScreen;
  SetColorWhite;
  DefineWindowIBM(1, 0, 0, 79, 185);
  DefineWindowIBM(2, 20, 20, 75, 175);
  DefineWindowIBM(3, 5, 35, 60, 170);
  DefineWindowIBM(4, 10, 50, 55, 165);
  DefineHeader(1, 'A bar chart in the absolute value mode');
  DefineHeader(2, 'A bar chart in the normal mode');
  DefineHeader(3, 'A bar chart in the normal mode with hatching');
  DefineHeader(4, 'A bar chart with axes');
  Msg('Displaying the amounts : DrawHistogram');
  FindWorld(1, A, N, 1.1, 1.1);
  SelectWorld(1);
  SelectWindow(1);
  DrawBorder;
  DrawHistogram(A, N, false, 5);
  Delay(15000);
  Msg('Displaying the positive and negative values : DrawHistogram');
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  DrawHistogram(A, -N, false, 5);
  Delay(15000);
  Msg('The density of the cross hatch can be adjusted : DrawHistogram');
  SelectWindow(3);
  SetBackground(0);
  DrawBorder;
  DrawHistogram(A, -N, true, 4);
  Delay(15000);
  Msg('The density of the axes is adjustable : DrawAxis , DrawHistogram');
  SelectWindow(4);
  SetBackground(0);
  DrawBorder;
  DrawAxis(7, -7, 0, 0, 0, 0, 0, 0, true);
  DrawHistogram(A, -N, true, 2);
  Delay(15000);
end; { HistoDem }

{----------------------------------------------------------------------------}

procedure FlowChartDem;
var
  X1, Y1, X2, Y2, I, Count : integer;

procedure DrawArrowHor(X1, Y1, X2, Y2 : integer);
begin
  DrawLine(X1, Y1, X2, Y2);
  if X2 > X1 then
    begin
      DrawLine(X2 - 4, Y2 - 2, X2, Y2);
      DrawLine(X2 - 4, Y2 + 2, X2, Y2);
    end
  else
    begin
      DrawLine(X2 + 5, Y2 - 2, X2, Y2);
      DrawLine(X2 + 5, Y2 + 2, X2, Y2);
    end;
end; { DrawArrowHor }

procedure DrawArrowVer(X1, Y1, X2, Y2 : integer);
begin
  DrawLine(X1, Y1, X2, Y2);
  if Y2 > Y1 then
    begin
      DrawLine(X2 - 2, Y2 - 3, X2, Y2);
      DrawLine(X2 + 2, Y2 - 3, X2, Y2);
    end
  else
    begin
      DrawLine(X2 - 2, Y2 + 3, X2, Y2);
      DrawLine(X2 + 2, Y2 + 3, X2, Y2);
    end;
end; { DrawArrowVer }

procedure Blink(Count, Time : integer);
var
  I : integer;
begin
  for I := 1 to Count do
  begin
    Delay(Time);
    InvertWindow;
  end;
end; { Blink }

begin { FlowChartDem }
  DefineWindowIBM(1, 0, 0, 79, 185);
  DefineWindowIBM(2, 12, 20, 25, 40);
  DefineWindowIBM(3, 15, 55, 22, 75);
  DefineWindowIBM(4, 11, 110, 26, 130);
  DefineWindowIBM(5, 47, 90, 56, 110);
  DefineHeader(1, 'A flow chart');
  SetColorWhite;
  SetHeaderOn;
  SelectWindow(1);
  DrawBorder;
  SetHeaderOff;
  SelectWindow(2);
  DrawBorder;
  SelectIBM;
  DrawTextW(125, 172, 2, 'Start');
  DrawArrowVer(151, 159, 151, 144);
  SelectWindow(3);
  DrawBorder;
  SelectIBM;
  DrawTextW(136, 136, 2, 'I=1');
  DrawArrowVer(151, 124, 151, 89);
  SelectWindow(4);
  DrawBorder;
  SelectIBM;
  DrawTextW(108, 81, 2, 'if I<=5');
  DrawLine(215, 79, 417, 79);
  DrawArrowVer(417, 79, 417, 89);
  DrawArrowVer(151, 69, 151, 44);
  SelectIBM;
  DrawTextW(300, 89, 2, 'YES');
  DrawTextW(160, 62, 2, 'NO');
  SelectWindow(5);
  DrawBorder;
  SelectIBM;
  DrawTextW(390, 101, 2, 'I=I+1');
  DrawLine(417, 119, 417, 109);
  DrawArrowHor(417, 119, 151, 119);
  DrawCircle(151, 34, 0.25);
  DrawTextW(137, 36, 2, 'end');
  SetHeaderOn;
  CopyScreen;
  ClearEol(25);
  GotoXY(27, 25);
  DefineWindowIBM(2, 15, 21, 22, 39);
  SelectWindow(2);
  SetBackground(0);
  DrawBorder;
  InvertWindow;
  Delay(1000);
  InvertWindow;
  MoveVerIBM(35, true);
  SelectIBM;
  DrawTextW(139, 136, 2, 'I=1');
  SelectWindow(2);
  Blink(30, 50);
  MoveVerIBM(55, true);
  for Count := 2 to 6 do
  begin
    Delay(500);
    MoveHorIBM(33, true);
    MoveVerIBM(-20, true);
    SetBackground(0);
    DrawBorder;
    SelectIBM;
    DrawTextW(400, 101, 2, 'I=' + Chr(48 + Count));
    SelectWindow(2);
    Blink(30, 50);
    MoveVerIBM(-20, true);
    MoveHorIBM(-33, true);
    MoveVerIBM(40, true);
  end;
  InvertWindow;
  Delay(1000);
  MoveVerIBM(46, true);
  Blink(30, 50);
  MoveHorIBM(45, true);
  MoveVerIBM(-136, true);
  MoveHorIBM(-45, true);
  SetHeaderOn;
end; { FlowChartDem }

{----------------------------------------------------------------------------}

procedure BezierDem;

procedure ClearToEol;
{ Procedure to clear to end of line }
var
  I : integer;
begin
  for I := 1 to 80 do
    Write(' ');
end; { ClearToEol }

procedure ReadInput(var S : WrkString);
const
  Cr = #13;
  Bs = #8;
var
  Count : integer;
  Ch    : char;
begin
  Count := 0;
  S := '';
  repeat
    Ch := ReadKey;
    case Ch of
      Bs : begin
             if Count > 0 then
             begin
               Write(Ch);
               ClrEol;
               Delete(S, Length(S), 1);
               Dec(Count);
             end;
           end;
    else
      if Ch <> Cr then
      begin
        Write(Ch);
        S := S + Ch;
        Count := Count + 1;
      end;
    end;
  until Ch = Cr;
end; { ReadInput }

procedure BeziDemo;

var
  Result, I, MaxControlPoints, MaxIntPoints : integer;
  DummyX, DummyY : Float;
  A, B : PlotArray;
  Break : boolean;
  DummyS, Temp2, Temp : WrkString;

begin
  MaxControlPoints := 7;               { Initialize everything }
  MaxIntPoints := 15;

  A[1, 1] := 1;   A[2, 1] := 1.5; A[3, 1] := 2;   A[4, 1] := 2.5;
  A[5, 1] := 3;   A[6, 1] := 4;   A[7, 1] := 5;   A[1, 2] := 2;
  A[2, 2] := 1.5; A[3, 2] := 1;   A[4, 2] := 2.5; A[5, 2] := 4;
  A[6, 2] := 4.5; A[7, 2] := 5;

  ClearScreen;                         { Set up screen }
  SetColorWhite;
  DefineWorld(1, 0, 0, 6.33, 7.0);     { Set world so rulers are good }
  SelectWorld(1);
  DefineWindow(1, 0, 0, XMaxGlb, 17 * YMaxGlb div 20);
  SelectWindow(1);
  SetBackground(0);
  DefineHeader(1, 'A demonstration of modeling and graphic design');
  DrawBorder;
  DrawAxis(7, -7, 0, 0, 0, 0, -1, -1, false);

  Break := false;                      { Init exit flag }

  repeat
    SetLinestyle(1);                   { Draw polygon between points }
    ResetAxis;
    DrawPolygon(A, 1, MaxControlPoints, 4, 2, 0);

    Bezier(A, MaxControlPoints, B, MaxIntPoints);  { Do bezier operation }

    SetLinestyle(0);                   { Plot it }
    ResetAxis;
    DrawPolygon(B, 1, MaxIntPoints, 0, 0, 0);

    repeat
      GotoXY(1, 24);                   { Clear out old text }
      ClearToEol;
      GotoXY(1, 25);
      ClearToEol;
      GotoXY(1, 23);
      ClearToEol;
      GotoXY(1, 23);                   { Get point to change }
      Write('Enter the number of the point to change (0 to quit) :  ');
      GotoXY(55, 23);
      ReadInput(Temp);
      Val(Temp, I, Result);
    until I in [0..MaxControlPoints];

    if I > 0 then
      begin
        repeat
          GotoXY(1, 24);               { Get new values for x and y }
          Write('Old position : [', A[I,1]:4:2, ',', A[I,2]:4:2, ']');
          GotoXY(40, 24);
          Write('   New position  x:  ');
          GotoXY(60, 24);
          ReadInput(DummyS);
          while DummyS[1] = ' ' do
            Delete(DummyS, 1, 1);
          Temp := DummyS;
          GotoXY(40, 25);
          Write('   New position  y:  ');
          GotoXY(60, 25);
          ReadInput(DummyS);
          while DummyS[1] = ' ' do
            Delete(DummyS, 1, 1);
          Temp2 := DummyS;
          Val(Temp, DummyX, Result);
          Val(Temp2, DummyY, Result);
        until ((DummyX >= X1WldGlb) and (DummyX <= X2WldGlb)) and
              ((DummyY >= Y1WldGlb) and (DummyY <= Y2WldGlb));

        SetLinestyle(1);               { Erase old curve }
        SetColorBlack;
        ResetAxis;
        DrawPolygon(A, 1, MaxControlPoints, 4, 2, 0);
        SetLinestyle(0);
        ResetAxis;
        DrawPolygon(B, 1, MaxIntPoints, 0, 0, 0);
        A[I, 1] := DummyX;
        A[I, 2] := DummyY;
        SetColorWhite;
      end
    else
      Break := true;
  until Break;
end; { BeziDemo }

begin
  BeziDemo;
end; { BezierDem }

{----------------------------------------------------------------------------}

function MenuChoice(OldChoice : integer) : integer;
const
  Null    = #0;
  Cr      = #13;
  Bs      = #8;
  CtrlC   = #3;
  Esc     = #27;
  Prompt : string[6] = '==>   ';
  Title = 'TURBO GRAPHIX TOOLBOX demonstration';
  N = 9;
  MenuItems : array [0..9] of string[35] = ('Exit this demonstration',
                                            'The use of windows',
                                            'The simple graphic commands',
                                            'Application: Sierpinski curves',
                                            'Pie charts',
                                            'Splines',
                                            'Polygonal presentation',
                                            'Bar charts',
                                            'Application: A flow chart',
                                            'Drawing and design');

var
  X, Y, I : integer;
  J : word;
  Ch : char;
  Quit : boolean;

begin
  OldChoice := OldChoice + 1;
  if OldChoice > N - 1 then
     OldChoice := 1;
  X := 40 - Length(Title) div 2;
  GotoXY(X, 1);
  Write(Title);
  GotoXY(8, 24);
  Write('Select item with SPACE / BACKSPACE or a number, then hit RETURN');
  Y := 8 - N div 2;
  X := 20;
  for I := 0 to N do
  begin
    GotoXY(X - 4, Y + I * 2);
    Write(I:1, ' -- ', MenuItems[I]);
  end;
  I := OldChoice;
  GotoXY(X - 10, Y + I * 2);
  Write(Prompt, I:1, ' -- ', MenuItems[I]);
  GotoXY(62, Y + I * 2);
  Write('<==');

  J := 0;
  Ch := '#';
  Quit := FALSE;
  while (Ch <> Cr) do
  begin
    Ch := '#';

    if KeyPressed then
    begin                 { Read a keystroke! }
      Ch := ReadKey;
      J := 0;
    end;

    case Ch of
      Bs         : begin
                     GotoXY(X - 10, Y + I * 2);
                     Write('      ');
                     GotoXY(62, Y + I * 2);
                     Write('   ');
                     I := I - 1;
                     if I = -1 then
                       I := N;
                     GotoXY(X - 10, Y + I * 2);
                     Write(Prompt, I:1, ' -- ', MenuItems[I]);
                     GotoXY(62, Y + I * 2);
                     Write('<==');
                   end;

      ' '        : begin
                     GotoXY(X - 10, Y + I * 2);
                     Write('      ');
                     GotoXY(62, Y + I * 2);
                     Write('   ');
                     I := I + 1;
                     if I > N then
                       I := 0;
                     GotoXY(X - 10, Y + I * 2);
                     Write(Prompt, I:1, ' -- ', MenuItems[I]);
                     GotoXY(62, Y + I * 2);
                     Write('<==');
                   end;

      '0'..'9'   : begin
                     if (Ord(Ch) - 48) <> I then
                     begin
                       GotoXY(X - 10, Y + I * 2);
                       Write('      ');
                       GotoXY(62, Y + I * 2);
                       Write('   ');
                       I := Ord(Ch) - 48;
                       GotoXY(X - 10, Y + I * 2);
                       Write(Prompt, I:1, ' -- ', MenuItems[I]);
                       GotoXY(62, Y + I * 2);
                       Write('<==');
                     end;
                   end;

      Esc, CtrlC : begin
                     LeaveGraphic;
                     Halt;
                   end;

      Null       : begin
                     if KeyPressed then
                     begin
                       Ch := ReadKey;
                       if Ch = 'O' then    { The End key was hit! }
                       begin
                         LeaveGraphic;
                         Halt;
                       end;
                     end;
                   end;
    end; { case }
    J := J + 1;
    if J > 32767 then
      Ch := Cr;
  end; { while Ch <> Cr do }

  MenuChoice := I;
end; { MenuChoice }

procedure Dummy2;
begin
end; { Dummy2 }

procedure SimpleInfo;
begin
  GotoXY(20, 5);
  WriteLn('The simple drawing commands');
  GotoXY(10, 10); Write('The simple drawing commands make it possible for the user to');
  GotoXY(10, 11); Write('realize graphic presentations according to his own mental image.');
  GotoXY(10, 12); Write('These commands refer to the window in use.  Thus drawing is');
  GotoXY(10, 13); Write('normally only possible within this window.  If parts of the');
  GotoXY(10, 14); Write('diagram go beyond the window limits, they are not shown.  To');
  GotoXY(10, 15); Write('provide greater flexibility, this feature can be turned off.');
  GotoXY(10, 16); Write('The scaling of the diagram is also accomplished by TURBO GRAPHIX.');
  GotoXY(10, 17); Write('Therefore it is possible to draw in any desired coordinate system');
  GotoXY(10, 18); Write('without requiring complicated calculations.  A separate');
  GotoXY(10, 19); Write('Coordinate System can be appointed to every window that is');
  GotoXY(10, 20); Write('defined.');
  GotoXY(31, 25);
  WaitReturn(60000.0);
  Simple;
end; { SimpleInfo }

procedure WindowDemoInfo;
begin
  GotoXY(20, 5);
  WriteLn('The Use of Windows');
  GotoXY(10, 8); Write('Within the TURBO Graphix System there can be as many graphic');
  GotoXY(10, 9); Write('windows displayed as one wants.  After their definition such');
  GotoXY(10, 10); Write('windows represent the actual drawing sheet.  All graphic');
  GotoXY(10, 11); Write('operations which would normally be carried out with the whole');
  GotoXY(10, 12); Write('screen, can be undertaken in one or several windows in exactly');
  GotoXY(10, 13); Write('the same manner.  Thus different operations can be displayed on');
  GotoXY(10, 14); Write('one screen in a simple and clear manner.');
  GotoXY(10, 16); Write('Through simple commands windows can be moved on the screen and');
  GotoXY(10, 17); Write('can be printed out in any desired position.  Every window can be');
  GotoXY(10, 18); Write('stored in a window memory that is independent from the screen and');
  GotoXY(10, 19); Write('can quickly be restored again into any part of the screen.  The');
  GotoXY(10, 20); Write('size of that memory is limited only by the existing main memory.');
  GotoXY(31, 25);
  WaitReturn(60000.0);
  WindowDemo;
end; { WindowDemoInfo }

procedure SplineInfo;
begin
  GotoXY(20, 5); WriteLn('The use of Spline functions');
  GotoXY(10, 10); Write('procedure : Spline(parameter);');
  GotoXY(10, 13); Write('The Spline procedure serves to create smooth curves.');
  GotoXY(10, 14); Write('You give a number of columns, choose the starting and ending');
  GotoXY(10, 15); Write('points of the interpolation, the number of points between start');
  GotoXY(10, 16); Write('and end, call up Spline, and then draw the points with the help');
  GotoXY(10, 17); Write('of the DrawPolygon procedure.');
  GotoXY(10, 19); Write('In the following example the data (*) will be presented first,');
  GotoXY(10, 20); Write('then the created Spline function (50 points) will be plotted');
  GotoXY(10, 21); Write('(drawn line).');
  GotoXY(20, 25);
  WaitReturn(60000.0);
  SplineDem;
end; { SplineInfo }

procedure PieInfo;
begin
  GotoXY(20, 5); WriteLn('The use of Pie-Charts');
  GotoXY(10, 8); Write('procedure : DrawCartPie or DrawPolarPie(parameter);');
  GotoXY(10, 10); Write('The DrawPie procedures are used to create pie charts.  To create');
  GotoXY(10, 11); Write('a pie chart you give the coordinates of the center of the circle,');
  GotoXY(10, 12); Write('the number of the exploded segments to be drawn, the total number');
  GotoXY(10, 13); Write('of segments, a numerical field and the descriptive text.  If you');
  GotoXY(10, 14); Write('wish, text and numbers can be displayed together or seperately.');
  GotoXY(10, 16); Write('The following example first lists the basic data of the diagram');
  GotoXY(10, 17); Write('At the same time, a pie chart is drawn on the second screen in');
  GotoXY(10, 18); Write('the background and then copied onto the first screen.  Following');
  GotoXY(10, 19); Write('that are several variations of the same DrawPie operation.');
  GotoXY(20, 25);
  WaitReturn(60000.0);
  PieDem;
end; { PieInfo }

procedure BezierInfo;
begin
  GotoXY(10, 5); WriteLn('Using the BEZIER function to draw');
  GotoXY(3, 8); Write('procedure : Bezier(parameter);');
  GotoXY(3, 10); Write('The bezier procedure creates smooth two dimensional objects from');
  GotoXY(3, 11); Write('points given by the user.  It can also be used to make curves of');
  GotoXY(3, 12); Write('large curvature and to fit unfavorable polynomials.');
  GotoXY(3, 13); Write('The following example will draw 7 points (light squares) and');
  GotoXY(3, 14); Write('their respective BEZIER function (drawn line).  You can change');
  GotoXY(3, 15); Write('the position of individual points by entering the number of the');
  GotoXY(3, 16); Write('point to be changed (1 through 7) and the New coordinates.  The');
  GotoXY(3, 17); Write('bezier procedure then creates the respective BEZIER function.');
  GotoXY(3, 19); Write('You can leave this module by typing RETURN to the point number');
  GotoXY(3, 20); Write('question.');
  GotoXY(20, 25);
  WaitReturn(60000.0);
  BezierDem;
end; { BezierInfo }

procedure PolygonInfo;
begin
  GotoXY(10, 5); WriteLn('Possibilities of polygonal diagrams');
  GotoXY(3, 8); Write('Command : DrawPolygon(parameter);');
  GotoXY(3, 10); Write('The command DrawPolygon is used for the drawing of polygons.  The');
  GotoXY(3, 11); Write('procedure DrawPolygon connects the vertices of a polygon through');
  GotoXY(3, 12); Write('different types of lines, marks the corner points through');
  GotoXY(3, 13); Write('different symbols, such as stars, squares, cross-bars etc.,');
  GotoXY(3, 14); Write('creates bars and much more.  Through repeated drawing in the same');
  GotoXY(3, 15); Write('window, as many polygons as you like can be plotted over');
  GotoXY(3, 16); Write('each other.  All diagrams can be drawn with or without the');
  GotoXY(3, 17); Write('coordinates or text.');
  GotoXY(3, 19); Write('The following examples were all created with the DrawPolygon');
  GotoXY(3, 20); Write('command varying the parameter.  Through the DrawAxis command a');
  GotoXY(3, 21); Write('presentation of the axes including text is possible.');
  GotoXY(3, 23); Write('Use the RETURN key to move within this demonstration module.');
  GotoXY(20, 25);
  WaitReturn(60000.0);
  PolygonDem;
end; { PolygonInfo }

var
  Choice : integer;

begin { TurboGraphicsDemo }
  CheckBreak := false;
  InitGraphic;
  SetBreakOn;
  SetMessageOn;
  SetHeaderOn;
  DefineWorld(2, 0, 199, 639, 0);
  DefineWindow(10, 0, 0, XMaxGlb, YMaxGlb);
  Intro;
  Choice := 0;
  repeat
    ClearScreen;
    ResetWindowStack;
    ResetWindows;
    ResetWorlds;
    DefineWorld(2, 0, 199, 639, 0);
    DefineWindow(10, 0, 0, XMaxGlb, YMaxGlb);
    SelectWorld(2);
    SelectWindow(10);
    SetAspect(1.0);
    Choice := MenuChoice(Choice);
    ClearScreen;
    case Choice of
      1 : WindowDemoInfo;
      2 : SimpleInfo;
      3 : Sier;
      4 : PieInfo;
      5 : SplineInfo;
      6 : PolygonInfo;
      7 : HistoDem;
      8 : FlowChartDem;
      9 : BezierInfo;
    end;
  until Choice = 0;
  LeaveGraphic;
end. { TurboGraphicsDemo }
