;********************************************************************
;*                         GRAPHIX TOOLBOX 4.0                      *
;*       Copyright (c) 1985, 87 by  Borland International, Inc.     *
;*                                                                  *
;*    Externals for IBM Color/Graphics Adapter device driver        *
;********************************************************************

DATA     SEGMENT  WORD PUBLIC
         EXTRN    ScreenGlb:DWORD, GrafBase:WORD, RamScreenGlb:BYTE
         EXTRN    XTextGlb:BYTE, YTextGlb:BYTE, ColorGlb:BYTE, Font:BYTE
DATA     ENDS

HardwareGrafBase  EQU 0B800H          ;Segment of graphics screen buffer
ScreenSizeGlb     EQU 8191            ;The size of the screen in words

CODE     SEGMENT  BYTE PUBLIC

         ASSUME   CS:CODE, DS:DATA

         PUBLIC   DC, DP, SwapScreen, InvertScreen  ;Public routines

; procedure DC(C : byte);
; var
;   X, Y, I : integer;
; begin
;   X := XTextGlb-1;
;   Y := (YTextGlb-1) shl 3
;   for I := 0 to 7 do
;     Mem[GrafBase:BaseAddress(Y+I) + X] := Font[C][I];
; end; { DC }

CPtr              EQU     BYTE PTR [BP+6]

DC                PROC FAR

         PUSH     BP              ;Save BP
         MOV      BP,SP           ;Set up stack frame
         MOV      BL,CPtr         ;BL := C
         MOV      BH,0
         SHL      BX,1
         SHL      BX,1
         SHL      BX,1
         ADD      BX, OFFSET Font ;BX := Addr(Font[C])
         MOV      DL,[XTextGlb]
         MOV      DH,0
         MOV      DI,DX           ;DI := XTextGlb
         DEC      DI              ;DI := XTextGlb - 1
         MOV      DL,[YTextGlb]
         DEC      DX              ;DX := YTextGlb - 1
         SHL      DX,1
         SHL      DX,1
         SHL      DX,1            ;DX := (YTextGlb - 1) shl 3
         MOV      AX,[GrafBase]
         MOV      ES,AX           ;ES := GrafBase
         MOV      CH,8            ;Loop 8 times
Loop:    MOV      CL,0DH
         MOV      AX,DX
         AND      AX,1
         SHL      AX,CL
         MOV      SI,AX
         MOV      AX,DX
         AND      AX,0FFFEH
         MOV      CL,3
         SHL      AX,CL
         ADD      SI,AX
         DEC      CL
         SHL      AX,CL
         ADD      SI,AX           ;SI := BaseAddress(Y+I)
         ADD      SI,DI           ;SI := BaseAddress(Y+I) + X
         MOV      AL,[BX]         ;AL := Font[C][I]
         MOV   ES:[SI],AL         ;Write piece of char to mem
         INC      BX              ;Increment font offset
         INC      DX              ;Increment scan line
         DEC      CH              ;Decrement loop counter
         JNZ      Loop            ;If CH not zero then jump to loop:
         POP      BP              ;Restore BP
         RET      2               ;Remove parameter and return

DC                ENDP

; procedure DP(X, Y : integer);
; var
;   I : integer;
; begin
;   I := BaseAddress(Y) + X shr 3;
;   if ColorGlb = 255 then
;     Mem[GrafBase:I] := Mem[GrafBase:I] or 128 shr (X and 7)
;   else
;     Mem[GrafBase:I] := Mem[GrafBase:I] and ($FF7F shr (X and 7));
; end; { DP }

XPtr              EQU     WORD PTR [BP+8]
YPtr              EQU     WORD PTR [BP+6]

DP                PROC FAR

         PUSH     BP                       ;Save BP
         MOV      BP,SP                    ;Set up stack frame
         MOV      AX,0001
         MOV      BX,YPtr                  ;BX := Y
         AND      AX,BX
         MOV      CL,0DH
         SHL      AX,CL
         AND      BX,0FFFEH
         MOV      CL,03
         SHL      BX,CL
         ADD      AX,BX
         MOV      CL,02
         SHL      BX,CL
         ADD      AX,BX                    ;AX := BaseAddress(Y)
         MOV      BX,XPtr                  ;BX := X
         MOV      DX,BX
         MOV      CL,03
         SHR      BX,CL                    ;BX := X shr 3
         ADD      BX,AX                    ;BX := BaseAddress(Y) + (X shr 3)
         MOV      CL,DL
         AND      CL,07                    ;CL := X and 7
         MOV      DL,80H                   ;DL := 128
         SHR      DL,CL                    ;DL := 128 shr (X and 7)
         MOV      ES,[GrafBase]            ;ES := base of graphics screen
         CMP      BYTE PTR [ColorGlb],0FFH ;Is ColorGlb = 255 ?
         JNZ      AndBit
         OR    ES:[BX],DL                  ;YES : OR the bit onto the screen
         JMP      Done
AndBit:  NOT      DL                       ;NO  : Invert the bits in DL
         AND   ES:[BX],DL                  ;      AND the bit onto the screen
Done:    POP      BP                       ;Restore BP
         RET      4                        ;Remove parameters and return

DP                ENDP

; procedure SwapScreen;
; { Exchanges the contents the of the displayed }
; { screen with the contents of the RAM screen  }
; const
;   HardwareGrafBase = $B800;
; var
;   ScanLine,
;   LineBase,
;   RamScrSeg  : word;
;   LineBuffer : array[0..XMaxGlb] of byte;
; begin
;   if RamScreenGlb then
;   begin
;     RamScrSeg := Seg(ScreenGlb^);
;     for ScanLine := 0 to YMaxGlb do
;     begin
;       LineBase := BaseAddress(Scanline);
;       Move(Mem[HardwareGrafBase:LineBase], LineBuffer, XMaxGlb+1);
;       Move(Mem[RamScrSeg:LineBase], Mem[HardwareGrafBase:LineBase], XMaxGlb+1);
;       Move(LineBuffer, Mem[RamScrSeg:LineBase], XMaxGlb+1);
;     end;
;   end;
; end; { SwapScreen }

SwapScreen          PROC FAR

           PUSH     BP                     ;Save BP
           MOV      BP,SP                  ;Set up stack frame
           MOV      AL,RamScreenGlb        ;Load boolean into AL
           XOR      AH,AH                  ;AH <- 0
           OR       AX,AX
           JZ       JumpOut                ;Exit if boolean is false
           LES      DI,[ScreenGlb]         ;ES <- Seg(ScreenGlb^)
           PUSH     DS                     ;Save DS
           MOV      AX,HardwareGrafBase    ;
           MOV      DS,AX                  ;DS <- Seg of hardware screen
           MOV      CX,ScreenSizeGlb       ;CX <- Size of screen in words
           XOR      BX,BX                  ;BX <- word offset of zero
SwapWords: MOV      AX,[BX]                ;AX <- word from hardware screen
           XCHG     AX,ES:[BX]             ;AX <-> soft screen
           MOV      [BX],AX                ;Hardware screen <- AX
           INC      BX
           INC      BX                     ;Increment word offset by 2
           LOOP     SwapWords              ;Swap next byte
           POP      DS                     ;Restore DS
JumpOut:   POP      BP                     ;Restore BP
           RET                             ;Return

SwapScreen        ENDP

; procedure InvertScreen;
; { Invert the contents of screen memory }
; var
;   Offset : word;
; begin
;   for Offset := 0 to (8191 shl 1)+1 do
;     Mem[GrafBase:Offset] := Not(Mem[GrafBase:Offset]);
; end; { InvertScreen }

InvertScreen      PROC FAR

         PUSH     BP                  ;Save BP
         MOV      BP,SP               ;Set up stack frame
         PUSH     DS                  ;Save data segment
         MOV      AX,[GrafBase]
         MOV      DS,AX               ;DS := base address of graphics screen
         MOV      CX,ScreenSizeGlb    ;CX := Size of screen in words
         XOR      BX,BX               ;Zero out BX
InvWrd:  NOT      WORD PTR [BX]       ;Invert word at DS:BX
         INC      BX
         INC      BX                  ;Increment to next word
         Loop     InvWrd
         POP      DS                  ;Restore data segment
         POP      BP                  ;Restore BP
         RET                          ;Return

InvertScreen      ENDP

CODE     ENDS
         END








