/* @(#) somx/os2main.c 2.5 1/20/94 10:29:48 [5/15/94 17:59:22] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/********************************************************************************
 *       Main program that drives the Replication Test object (REPTestObj)      *
 *                          (FOR OS/2)                                          *
 ********************************************************************************/

#define INCL_DOS
#define INCL_ERRORS                      /* include os2 errors */
#define INCL_DOSPROCESS                  /* include thread/process headers */
#define INCL_DOSSEMAPHORES               /* include semaphore headers */
#include <os2.h>                         /* base OS2 header */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <eventmsk.h>
#include <eman.h>
#include <testobj.h>                     /* test object header */
#include <somr.h>                        /* replication framework header */

#define MAX_SEMAPHORES  2
#define USER_INPUT_SEM  0

/***************************************************************************
 *                        FUNCTION PROTOTYPES                              *
/***************************************************************************/

int  main(void);
void print_menu(void);
char up_menu(void);
void print_error(long i);
long set_object(void);
void check_events(void);
long get_object(void);

/***************************************************************************/


HMTX keyboard_sem;                     /* mutex (mutual exclusion) semaphore */
ULONG sem_attr;                        /* Semaphore attributes */

#define ERR_USER_INPUT 0
#define ERR_NO_OBJECT  1               /* index to errlist for no object */
#define ERR_OBJ_EXISTS 2

#define ERR_MAX_ERRORS 5

static char *errlist[ERR_MAX_ERRORS] = {
       "\n\n           !!!!!!! Error Input. Please Retry  !!!!!!!  \n\n",
       "\n\n  !!!! Please select (N) before performing this operation !!!!\n\n",
       "\n\n  !!!! Object has already been created. Select \"S\" or \"G\" !!!!\n\n",
};


long value_logging = 0;    /* 0 for operation logging and 1 for value logging. */
                           /* Test Object needs this defined */


static SEMRECORD sem_list[MAX_SEMAPHORES];

static BOOL object_created = FALSE;

SOMAny *App_eman;
SOMR reptd;                               /* Pointer to replicated object */
Environment *Ev;                          /* Environment pointer */
static REPTestObj curr_object;            /* Pointer to test object */
static char   object_data[80] = "\0";     /* data to go into the REPTestObj */

/*------------------------- print_menu ----------------------------*/

void print_menu()
{
  printf("\n        ********** REPLICATED OBJECT MENU *************\n\n");
  printf("              Set the State of an Object (S)\n");
  printf("              Get the State of an Object (G)\n");
  printf("              Create a New Test Object   (N)\n");
  printf("              Perform RepblUnInit        (U)\n");
  printf("              Perform RepblInit          (I)\n");
  printf("              Quit Replication           (Q)\n\n");
  printf("              PLEASE ENTER YOUR SELECTION:\n");
}

/*---------------------------- up_menu ----------------------------*/

char up_menu()                  /* Returns User input character */
{
char x[200];
    scanf("%1s",x);        /* Scan for a single character string */
    x[1] = '\0';
    fflush(0);
    return(x[0]);           /* Return the character */
}

/*--------------------------- print_error -------------------------*/

void print_error(long i)     /* Prints the error[i] from a list. */
{
    printf("%s",errlist[i]);
}


/*--------------------------- set_object --------------------------*/

long set_object()           /* Set the state of an object */
{

    printf("Enter a data string for the object.\n");
    printf("(No delimiters or white space, please.) :\n");
    while ( scanf("%s", object_data) < 0 )
    {
        printf("\nError in input: Try again:\n");
    }
    fflush(0);
    return (_somrTestSetData(curr_object, Ev, object_data));
}


/*--------------------------- get_object --------------------------*/

/* Get the value of the current object */
long get_object()
{

    printf(" The data of the object is %s \n", _somrTestGetData(curr_object, Ev) );
    return(0);
}


/*------------------------- check_events --------------------------*/

/* This is the SOM event manager loop.  It runs in its own thread. */

void check_events()
{
   while (1) {                                /* Do forever */
      DosSleep(500);                          /* 500 milliseconds */

      /* Wait on and take the mutual exclusion semaphore. */
      while (DosRequestMutexSem(keyboard_sem, SEM_INDEFINITE_WAIT) != 0);

      /* When control is obtained, process events. */
      _someProcessEvent(App_eman, Ev, EMProcessTimerEvent | EMProcessSinkEvent);

      /* Release the semaphore. */
      DosReleaseMutexSem(keyboard_sem);
   }
}

/*------------------------------ MAIN ---------------------------------*/

int main()
{
    unsigned char Selection;        /* User Selected Character */
    TID ThreadId;                   /* Returned Thread ID */
    long rc;
    ULONG semattr = 0;

    /* Create a shared mutual exclusion semaphore */
    semattr = DC_SEM_SHARED;

    if ((rc = DosCreateMutexSem((PSZ) NULL, (PHMTX)&keyboard_sem, semattr, 0)) != 0) {
       printf("Error Allocating shared semaphore: rc = %d \n",rc);
       exit(1);
    }

    reptd = SOMRNew();                  /* Create a new Replicated object */
    App_eman = SOMEEManNew();
    Ev = somGetGlobalEnvironment();

    print_menu();

    /* Create a new thread for function check_events with stacksize 300000 */

    if ((rc = DosCreateThread(&ThreadId, (PFNTHREAD)check_events, 0, 0, 300000)) != 0){
        printf("Return code from thread create is %d\n", rc);
        DosExit(EXIT_PROCESS, 0);
    }

    while (1) {     /* Do  Forever */

        Selection  = toupper(up_menu());  /* Obtain User input in uppercase */

        /* Wait on and take mutual exclusion Semaphore */
        while  (DosRequestMutexSem(keyboard_sem, SEM_INDEFINITE_WAIT) != 0);

        switch (Selection) {
             case 'S':
                    set_object();
                    break;
             case 'G':
                    get_object();
                    break;
             case 'N' :
                    curr_object = REPTestObjNew();
                    if (curr_object == NULL)
		         somPrintf("Object creation failed\n");
                    break;
             case 'U' :
                    _somrPerformRepblUnInit(curr_object, Ev);
                    break;
             case 'I' :
                    _somrPerformRepblInit(curr_object, Ev);
                    break;
             case 'Q' :
                    _somFree(curr_object);
                    exit(1);
                    break;
             default:
                    print_error(ERR_USER_INPUT);
                    break;
              }  /* end switch */

        print_menu();
        DosReleaseMutexSem(keyboard_sem);

    } /* endwhile */

    return(0);

}

